/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class PhantomSpawner
implements CustomSpawner {
    private int nextTick;

    @Override
    public void tick(ServerLevel p_64576_, boolean p_64577_, boolean p_64578_) {
        if (!p_64577_) {
            return;
        }
        if (!p_64576_.getGameRules().getBoolean(GameRules.RULE_DOINSOMNIA)) {
            return;
        }
        RandomSource $$3 = p_64576_.random;
        --this.nextTick;
        if (this.nextTick > 0) {
            return;
        }
        this.nextTick += (60 + $$3.nextInt(60)) * 20;
        if (p_64576_.getSkyDarken() < 5 && p_64576_.dimensionType().hasSkyLight()) {
            return;
        }
        for (ServerPlayer $$4 : p_64576_.players()) {
            FluidState $$12;
            BlockState $$11;
            BlockPos $$10;
            DifficultyInstance $$6;
            if ($$4.isSpectator()) continue;
            BlockPos $$5 = $$4.blockPosition();
            if (p_64576_.dimensionType().hasSkyLight() && ($$5.getY() < p_64576_.getSeaLevel() || !p_64576_.canSeeSky($$5)) || !($$6 = p_64576_.getCurrentDifficultyAt($$5)).isHarderThan($$3.nextFloat() * 3.0f)) continue;
            ServerStatsCounter $$7 = $$4.getStats();
            int $$8 = Mth.clamp($$7.getValue(Stats.CUSTOM.get(Stats.TIME_SINCE_REST)), 1, Integer.MAX_VALUE);
            int $$9 = 24000;
            if ($$3.nextInt($$8) < 72000 || !NaturalSpawner.isValidEmptySpawnBlock(p_64576_, $$10 = $$5.above(20 + $$3.nextInt(15)).east(-10 + $$3.nextInt(21)).south(-10 + $$3.nextInt(21)), $$11 = p_64576_.getBlockState($$10), $$12 = p_64576_.getFluidState($$10), EntityType.PHANTOM)) continue;
            SpawnGroupData $$13 = null;
            int $$14 = 1 + $$3.nextInt($$6.getDifficulty().getId() + 1);
            for (int $$15 = 0; $$15 < $$14; ++$$15) {
                Phantom $$16 = EntityType.PHANTOM.create(p_64576_, EntitySpawnReason.NATURAL);
                if ($$16 == null) continue;
                $$16.snapTo($$10, 0.0f, 0.0f);
                $$13 = $$16.finalizeSpawn(p_64576_, $$6, EntitySpawnReason.NATURAL, $$13);
                p_64576_.addFreshEntityWithPassengers($$16);
            }
        }
    }
}

