/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class AttachedToLogsDecorator
extends TreeDecorator {
    public static final MapCodec<AttachedToLogsDecorator> CODEC = RecordCodecBuilder.mapCodec(p_409864_ -> p_409864_.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(p_410879_ -> Float.valueOf(p_410879_.probability)), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(p_410021_ -> p_410021_.blockProvider), (App)ExtraCodecs.nonEmptyList(Direction.CODEC.listOf()).fieldOf("directions").forGetter(p_410225_ -> p_410225_.directions)).apply((Applicative)p_409864_, AttachedToLogsDecorator::new));
    private final float probability;
    private final BlockStateProvider blockProvider;
    private final List<Direction> directions;

    public AttachedToLogsDecorator(float p_410363_, BlockStateProvider p_410551_, List<Direction> p_409683_) {
        this.probability = p_410363_;
        this.blockProvider = p_410551_;
        this.directions = p_409683_;
    }

    @Override
    public void place(TreeDecorator.Context p_410494_) {
        RandomSource $$1 = p_410494_.random();
        for (BlockPos $$2 : Util.shuffledCopy(p_410494_.logs(), $$1)) {
            Direction $$3 = Util.getRandom(this.directions, $$1);
            BlockPos $$4 = $$2.relative($$3);
            if (!($$1.nextFloat() <= this.probability) || !p_410494_.isAir($$4)) continue;
            p_410494_.setBlock($$4, this.blockProvider.getState($$1, $$4));
        }
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.ATTACHED_TO_LOGS;
    }
}

