/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class PlaceOnGroundDecorator
extends TreeDecorator {
    public static final MapCodec<PlaceOnGroundDecorator> CODEC = RecordCodecBuilder.mapCodec(p_393837_ -> p_393837_.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("tries").orElse((Object)128).forGetter(p_393560_ -> p_393560_.tries), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("radius").orElse((Object)2).forGetter(p_394200_ -> p_394200_.radius), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("height").orElse((Object)1).forGetter(p_394044_ -> p_394044_.height), (App)BlockStateProvider.CODEC.fieldOf("block_state_provider").forGetter(p_393973_ -> p_393973_.blockStateProvider)).apply((Applicative)p_393837_, PlaceOnGroundDecorator::new));
    private final int tries;
    private final int radius;
    private final int height;
    private final BlockStateProvider blockStateProvider;

    public PlaceOnGroundDecorator(int p_394466_, int p_393573_, int p_394015_, BlockStateProvider p_394034_) {
        this.tries = p_394466_;
        this.radius = p_393573_;
        this.height = p_394015_;
        this.blockStateProvider = p_394034_;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.PLACE_ON_GROUND;
    }

    @Override
    public void place(TreeDecorator.Context p_394461_) {
        List<BlockPos> $$1 = TreeFeature.getLowestTrunkOrRootOfTree(p_394461_);
        if ($$1.isEmpty()) {
            return;
        }
        BlockPos $$2 = $$1.getFirst();
        int $$3 = $$2.getY();
        int $$4 = $$2.getX();
        int $$5 = $$2.getX();
        int $$6 = $$2.getZ();
        int $$7 = $$2.getZ();
        for (BlockPos $$8 : $$1) {
            if ($$8.getY() != $$3) continue;
            $$4 = Math.min($$4, $$8.getX());
            $$5 = Math.max($$5, $$8.getX());
            $$6 = Math.min($$6, $$8.getZ());
            $$7 = Math.max($$7, $$8.getZ());
        }
        RandomSource $$9 = p_394461_.random();
        BoundingBox $$10 = new BoundingBox($$4, $$3, $$6, $$5, $$3, $$7).inflatedBy(this.radius, this.height, this.radius);
        BlockPos.MutableBlockPos $$11 = new BlockPos.MutableBlockPos();
        for (int $$12 = 0; $$12 < this.tries; ++$$12) {
            $$11.set($$9.nextIntBetweenInclusive($$10.minX(), $$10.maxX()), $$9.nextIntBetweenInclusive($$10.minY(), $$10.maxY()), $$9.nextIntBetweenInclusive($$10.minZ(), $$10.maxZ()));
            this.attemptToPlaceBlockAbove(p_394461_, $$11);
        }
    }

    private void attemptToPlaceBlockAbove(TreeDecorator.Context p_399497_, BlockPos p_399541_) {
        BlockPos $$2 = p_399541_.above();
        if (p_399497_.level().isStateAtPosition($$2, p_399461_ -> p_399461_.isAir() || p_399461_.is(Blocks.VINE)) && p_399497_.checkBlock(p_399541_, BlockBehaviour.BlockStateBase::isSolidRender)) {
            p_399497_.setBlock($$2, this.blockStateProvider.getState(p_399497_.random(), $$2));
        }
    }
}

