/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.OceanRuinPieces;

public class OceanRuinStructure
extends Structure {
    public static final MapCodec<OceanRuinStructure> CODEC = RecordCodecBuilder.mapCodec(p_229075_ -> p_229075_.group(OceanRuinStructure.settingsCodec(p_229075_), (App)Type.CODEC.fieldOf("biome_temp").forGetter(p_229079_ -> p_229079_.biomeTemp), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("large_probability").forGetter(p_229077_ -> Float.valueOf(p_229077_.largeProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("cluster_probability").forGetter(p_229073_ -> Float.valueOf(p_229073_.clusterProbability))).apply((Applicative)p_229075_, OceanRuinStructure::new));
    public final Type biomeTemp;
    public final float largeProbability;
    public final float clusterProbability;

    public OceanRuinStructure(Structure.StructureSettings p_229060_, Type p_229061_, float p_229062_, float p_229063_) {
        super(p_229060_);
        this.biomeTemp = p_229061_;
        this.largeProbability = p_229062_;
        this.clusterProbability = p_229063_;
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext p_229065_) {
        return OceanRuinStructure.onTopOfChunkCenter(p_229065_, Heightmap.Types.OCEAN_FLOOR_WG, p_229068_ -> this.generatePieces((StructurePiecesBuilder)p_229068_, p_229065_));
    }

    private void generatePieces(StructurePiecesBuilder p_229070_, Structure.GenerationContext p_229071_) {
        BlockPos $$2 = new BlockPos(p_229071_.chunkPos().getMinBlockX(), 90, p_229071_.chunkPos().getMinBlockZ());
        Rotation $$3 = Rotation.getRandom(p_229071_.random());
        OceanRuinPieces.addPieces(p_229071_.structureTemplateManager(), $$2, $$3, p_229070_, p_229071_.random(), this);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.OCEAN_RUIN;
    }

    public static enum Type implements StringRepresentable
    {
        WARM("warm"),
        COLD("cold");

        public static final Codec<Type> CODEC;
        @Deprecated
        public static final Codec<Type> LEGACY_CODEC;
        private final String name;

        private Type(String p_229090_) {
            this.name = p_229090_;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            LEGACY_CODEC = ExtraCodecs.legacyEnum(Type::valueOf);
        }
    }
}

