/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.slf4j.Logger;

public class DimensionDataStorage
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final SavedData.Context context;
    private final Map<SavedDataType<?>, Optional<SavedData>> cache = new HashMap();
    private final DataFixer fixerUpper;
    private final HolderLookup.Provider registries;
    private final Path dataFolder;
    private CompletableFuture<?> pendingWriteFuture = CompletableFuture.completedFuture(null);

    public DimensionDataStorage(SavedData.Context p_401422_, Path p_362421_, DataFixer p_78150_, HolderLookup.Provider p_324180_) {
        this.context = p_401422_;
        this.fixerUpper = p_78150_;
        this.dataFolder = p_362421_;
        this.registries = p_324180_;
    }

    private Path getDataFile(String p_78157_) {
        return this.dataFolder.resolve(p_78157_ + ".dat");
    }

    public <T extends SavedData> T computeIfAbsent(SavedDataType<T> p_401394_) {
        T $$1 = this.get(p_401394_);
        if ($$1 != null) {
            return $$1;
        }
        SavedData $$2 = (SavedData)p_401394_.constructor().apply(this.context);
        this.set(p_401394_, $$2);
        return (T)$$2;
    }

    @Nullable
    public <T extends SavedData> T get(SavedDataType<T> p_401285_) {
        Optional<SavedData> $$1 = this.cache.get(p_401285_);
        if ($$1 == null) {
            $$1 = Optional.ofNullable(this.readSavedData(p_401285_));
            this.cache.put(p_401285_, $$1);
        }
        return (T)((SavedData)$$1.orElse(null));
    }

    @Nullable
    private <T extends SavedData> T readSavedData(SavedDataType<T> p_401056_) {
        try {
            Path $$1 = this.getDataFile(p_401056_.id());
            if (Files.exists($$1, new LinkOption[0])) {
                CompoundTag $$2 = this.readTagFromDisk(p_401056_.id(), p_401056_.dataFixType(), SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                RegistryOps<Tag> $$3 = this.registries.createSerializationContext(NbtOps.INSTANCE);
                return (T)((SavedData)p_401056_.codec().apply(this.context).parse($$3, (Object)$$2.get("data")).resultOrPartial(p_400985_ -> LOGGER.error("Failed to parse saved data for '{}': {}", (Object)p_401056_, p_400985_)).orElse(null));
            }
        }
        catch (Exception $$4) {
            LOGGER.error("Error loading saved data: {}", p_401056_, (Object)$$4);
        }
        return null;
    }

    public <T extends SavedData> void set(SavedDataType<T> p_401359_, T p_164857_) {
        this.cache.put(p_401359_, Optional.of(p_164857_));
        p_164857_.setDirty();
    }

    /*
     * WARNING - void declaration
     */
    public CompoundTag readTagFromDisk(String p_78159_, DataFixTypes p_295038_, int p_78160_) throws IOException {
        try (InputStream $$3 = Files.newInputStream(this.getDataFile(p_78159_), new OpenOption[0]);){
            CompoundTag compoundTag;
            try (PushbackInputStream $$4 = new PushbackInputStream(new FastBufferedInputStream($$3), 2);){
                void $$8;
                if (this.isGzip($$4)) {
                    CompoundTag $$5 = NbtIo.readCompressed($$4, NbtAccounter.unlimitedHeap());
                } else {
                    try (DataInputStream $$6 = new DataInputStream($$4);){
                        CompoundTag $$7 = NbtIo.read($$6);
                    }
                }
                int $$9 = NbtUtils.getDataVersion((CompoundTag)$$8, 1343);
                compoundTag = p_295038_.update(this.fixerUpper, (CompoundTag)$$8, $$9, p_78160_);
            }
            return compoundTag;
        }
    }

    private boolean isGzip(PushbackInputStream p_78155_) throws IOException {
        int $$4;
        byte[] $$1 = new byte[2];
        boolean $$2 = false;
        int $$3 = p_78155_.read($$1, 0, 2);
        if ($$3 == 2 && ($$4 = ($$1[1] & 0xFF) << 8 | $$1[0] & 0xFF) == 35615) {
            $$2 = true;
        }
        if ($$3 != 0) {
            p_78155_.unread($$1, 0, $$3);
        }
        return $$2;
    }

    public CompletableFuture<?> scheduleSave() {
        Map<SavedDataType<?>, CompoundTag> $$0 = this.collectDirtyTagsToSave();
        if ($$0.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        int $$1 = Util.maxAllowedExecutorThreads();
        int $$2 = $$0.size();
        this.pendingWriteFuture = $$2 > $$1 ? this.pendingWriteFuture.thenCompose(p_400982_ -> {
            ArrayList<CompletableFuture<Void>> $$4 = new ArrayList<CompletableFuture<Void>>($$1);
            int $$5 = Mth.positiveCeilDiv($$2, $$1);
            for (List $$6 : Iterables.partition($$0.entrySet(), (int)$$5)) {
                $$4.add(CompletableFuture.runAsync(() -> {
                    for (Map.Entry $$1 : $$6) {
                        this.tryWrite((SavedDataType)$$1.getKey(), (CompoundTag)$$1.getValue());
                    }
                }, Util.ioPool()));
            }
            return CompletableFuture.allOf((CompletableFuture[])$$4.toArray(CompletableFuture[]::new));
        }) : this.pendingWriteFuture.thenCompose(p_400974_ -> CompletableFuture.allOf((CompletableFuture[])$$0.entrySet().stream().map(p_400983_ -> CompletableFuture.runAsync(() -> this.tryWrite((SavedDataType)p_400983_.getKey(), (CompoundTag)p_400983_.getValue()), Util.ioPool())).toArray(CompletableFuture[]::new)));
        return this.pendingWriteFuture;
    }

    private Map<SavedDataType<?>, CompoundTag> collectDirtyTagsToSave() {
        Object2ObjectArrayMap $$0 = new Object2ObjectArrayMap();
        RegistryOps<Tag> $$1 = this.registries.createSerializationContext(NbtOps.INSTANCE);
        this.cache.forEach((arg_0, arg_1) -> this.lambda$collectDirtyTagsToSave$9((Map)$$0, $$1, arg_0, arg_1));
        return $$0;
    }

    private <T extends SavedData> CompoundTag encodeUnchecked(SavedDataType<T> p_401078_, SavedData p_401244_, RegistryOps<Tag> p_401357_) {
        Codec<T> $$3 = p_401078_.codec().apply(this.context);
        CompoundTag $$4 = new CompoundTag();
        $$4.put("data", (Tag)$$3.encodeStart(p_401357_, (Object)p_401244_).getOrThrow());
        NbtUtils.addCurrentDataVersion($$4);
        return $$4;
    }

    private void tryWrite(SavedDataType<?> p_401021_, CompoundTag p_390657_) {
        Path $$2 = this.getDataFile(p_401021_.id());
        try {
            NbtIo.writeCompressed(p_390657_, $$2);
        }
        catch (IOException $$3) {
            LOGGER.error("Could not save data to {}", (Object)$$2.getFileName(), (Object)$$3);
        }
    }

    public void saveAndJoin() {
        this.scheduleSave().join();
    }

    @Override
    public void close() {
        this.saveAndJoin();
    }

    private /* synthetic */ void lambda$collectDirtyTagsToSave$9(Map p_400969_, RegistryOps p_400970_, SavedDataType p_400971_, Optional p_400972_) {
        p_400972_.filter(SavedData::isDirty).ifPresent(p_400978_ -> {
            p_400969_.put(p_400971_, this.encodeUnchecked(p_400971_, (SavedData)p_400978_, p_400970_));
            p_400978_.setDirty(false);
        });
    }
}

