/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class SetNameFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<SetNameFunction> CODEC = RecordCodecBuilder.mapCodec(p_338152_ -> SetNameFunction.commonFields(p_338152_).and(p_338152_.group((App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(p_298144_ -> p_298144_.name), (App)LootContext.EntityTarget.CODEC.optionalFieldOf("entity").forGetter(p_298153_ -> p_298153_.resolutionContext), (App)Target.CODEC.optionalFieldOf("target", (Object)Target.CUSTOM_NAME).forGetter(p_338153_ -> p_338153_.target))).apply((Applicative)p_338152_, SetNameFunction::new));
    private final Optional<Component> name;
    private final Optional<LootContext.EntityTarget> resolutionContext;
    private final Target target;

    private SetNameFunction(List<LootItemCondition> p_299241_, Optional<Component> p_298804_, Optional<LootContext.EntityTarget> p_298545_, Target p_338830_) {
        super(p_299241_);
        this.name = p_298804_;
        this.resolutionContext = p_298545_;
        this.target = p_338830_;
    }

    public LootItemFunctionType<SetNameFunction> getType() {
        return LootItemFunctions.SET_NAME;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.resolutionContext.map(p_380908_ -> Set.of(p_380908_.getParam())).orElse(Set.of());
    }

    public static UnaryOperator<Component> createResolver(LootContext p_81140_, @Nullable LootContext.EntityTarget p_81141_) {
        Entity $$2;
        if (p_81141_ != null && ($$2 = p_81140_.getOptionalParameter(p_81141_.getParam())) != null) {
            CommandSourceStack $$3 = $$2.createCommandSourceStackForNameResolution(p_81140_.getLevel()).withPermission(2);
            return p_81147_ -> {
                try {
                    return ComponentUtils.updateForEntity($$3, p_81147_, $$2, 0);
                }
                catch (CommandSyntaxException $$3) {
                    LOGGER.warn("Failed to resolve text component", (Throwable)$$3);
                    return p_81147_;
                }
            };
        }
        return p_81152_ -> p_81152_;
    }

    @Override
    public ItemStack run(ItemStack p_81137_, LootContext p_81138_) {
        this.name.ifPresent(p_338163_ -> p_81137_.set(this.target.component(), (Component)SetNameFunction.createResolver(p_81138_, this.resolutionContext.orElse(null)).apply((Component)p_338163_)));
        return p_81137_;
    }

    public static LootItemConditionalFunction.Builder<?> setName(Component p_165460_, Target p_338546_) {
        return SetNameFunction.simpleBuilder(p_338156_ -> new SetNameFunction((List<LootItemCondition>)p_338156_, Optional.of(p_165460_), Optional.empty(), p_338546_));
    }

    public static LootItemConditionalFunction.Builder<?> setName(Component p_165458_, Target p_338818_, LootContext.EntityTarget p_338518_) {
        return SetNameFunction.simpleBuilder(p_338160_ -> new SetNameFunction((List<LootItemCondition>)p_338160_, Optional.of(p_165458_), Optional.of(p_338518_), p_338818_));
    }

    public static enum Target implements StringRepresentable
    {
        CUSTOM_NAME("custom_name"),
        ITEM_NAME("item_name");

        public static final Codec<Target> CODEC;
        private final String name;

        private Target(String p_338794_) {
            this.name = p_338794_;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public DataComponentType<Component> component() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> DataComponents.ITEM_NAME;
                case 0 -> DataComponents.CUSTOM_NAME;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(Target::values);
        }
    }
}

