/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerScores;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class Scoreboard {
    public static final String HIDDEN_SCORE_PREFIX = "#";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Object2ObjectMap<String, Objective> objectivesByName = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Reference2ObjectMap<ObjectiveCriteria, List<Objective>> objectivesByCriteria = new Reference2ObjectOpenHashMap();
    private final Map<String, PlayerScores> playerScores = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Map<DisplaySlot, Objective> displayObjectives = new EnumMap<DisplaySlot, Objective>(DisplaySlot.class);
    private final Object2ObjectMap<String, PlayerTeam> teamsByName = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, PlayerTeam> teamsByPlayer = new Object2ObjectOpenHashMap();

    @Nullable
    public Objective getObjective(@Nullable String p_83478_) {
        return (Objective)this.objectivesByName.get((Object)p_83478_);
    }

    public Objective addObjective(String p_83437_, ObjectiveCriteria p_83438_, Component p_83439_, ObjectiveCriteria.RenderType p_83440_, boolean p_313815_, @Nullable NumberFormat p_313909_) {
        if (this.objectivesByName.containsKey((Object)p_83437_)) {
            throw new IllegalArgumentException("An objective with the name '" + p_83437_ + "' already exists!");
        }
        Objective $$6 = new Objective(this, p_83437_, p_83438_, p_83439_, p_83440_, p_313815_, p_313909_);
        ((List)this.objectivesByCriteria.computeIfAbsent((Object)p_83438_, p_314722_ -> Lists.newArrayList())).add($$6);
        this.objectivesByName.put((Object)p_83437_, (Object)$$6);
        this.onObjectiveAdded($$6);
        return $$6;
    }

    public final void forAllObjectives(ObjectiveCriteria p_83428_, ScoreHolder p_313805_, Consumer<ScoreAccess> p_83430_) {
        ((List)this.objectivesByCriteria.getOrDefault((Object)p_83428_, Collections.emptyList())).forEach(p_313676_ -> p_83430_.accept(this.getOrCreatePlayerScore(p_313805_, (Objective)p_313676_, true)));
    }

    private PlayerScores getOrCreatePlayerInfo(String p_313892_) {
        return this.playerScores.computeIfAbsent(p_313892_, p_313683_ -> new PlayerScores());
    }

    public ScoreAccess getOrCreatePlayerScore(ScoreHolder p_313714_, Objective p_313948_) {
        return this.getOrCreatePlayerScore(p_313714_, p_313948_, false);
    }

    public ScoreAccess getOrCreatePlayerScore(final ScoreHolder p_313717_, final Objective p_83473_, boolean p_313939_) {
        final boolean $$3 = p_313939_ || !p_83473_.getCriteria().isReadOnly();
        PlayerScores $$4 = this.getOrCreatePlayerInfo(p_313717_.getScoreboardName());
        final MutableBoolean $$5 = new MutableBoolean();
        final Score $$6 = $$4.getOrCreate(p_83473_, p_313682_ -> $$5.setTrue());
        return new ScoreAccess(){

            @Override
            public int get() {
                return $$6.value();
            }

            @Override
            public void set(int p_313831_) {
                Component $$2;
                if (!$$3) {
                    throw new IllegalStateException("Cannot modify read-only score");
                }
                boolean $$1 = $$5.isTrue();
                if (p_83473_.displayAutoUpdate() && ($$2 = p_313717_.getDisplayName()) != null && !$$2.equals($$6.display())) {
                    $$6.display($$2);
                    $$1 = true;
                }
                if (p_313831_ != $$6.value()) {
                    $$6.value(p_313831_);
                    $$1 = true;
                }
                if ($$1) {
                    this.sendScoreToPlayers();
                }
            }

            @Override
            @Nullable
            public Component display() {
                return $$6.display();
            }

            @Override
            public void display(@Nullable Component p_313826_) {
                if ($$5.isTrue() || !Objects.equals(p_313826_, $$6.display())) {
                    $$6.display(p_313826_);
                    this.sendScoreToPlayers();
                }
            }

            @Override
            public void numberFormatOverride(@Nullable NumberFormat p_313875_) {
                $$6.numberFormat(p_313875_);
                this.sendScoreToPlayers();
            }

            @Override
            public boolean locked() {
                return $$6.isLocked();
            }

            @Override
            public void unlock() {
                this.setLocked(false);
            }

            @Override
            public void lock() {
                this.setLocked(true);
            }

            private void setLocked(boolean p_313822_) {
                $$6.setLocked(p_313822_);
                if ($$5.isTrue()) {
                    this.sendScoreToPlayers();
                }
                Scoreboard.this.onScoreLockChanged(p_313717_, p_83473_);
            }

            private void sendScoreToPlayers() {
                Scoreboard.this.onScoreChanged(p_313717_, p_83473_, $$6);
                $$5.setFalse();
            }
        };
    }

    @Nullable
    public ReadOnlyScoreInfo getPlayerScoreInfo(ScoreHolder p_313711_, Objective p_313813_) {
        PlayerScores $$2 = this.playerScores.get(p_313711_.getScoreboardName());
        if ($$2 != null) {
            return $$2.get(p_313813_);
        }
        return null;
    }

    public Collection<PlayerScoreEntry> listPlayerScores(Objective p_313802_) {
        ArrayList<PlayerScoreEntry> $$1 = new ArrayList<PlayerScoreEntry>();
        this.playerScores.forEach((p_313669_, p_313670_) -> {
            Score $$4 = p_313670_.get(p_313802_);
            if ($$4 != null) {
                $$1.add(new PlayerScoreEntry((String)p_313669_, $$4.value(), $$4.display(), $$4.numberFormat()));
            }
        });
        return $$1;
    }

    public Collection<Objective> getObjectives() {
        return this.objectivesByName.values();
    }

    public Collection<String> getObjectiveNames() {
        return this.objectivesByName.keySet();
    }

    public Collection<ScoreHolder> getTrackedPlayers() {
        return this.playerScores.keySet().stream().map(ScoreHolder::forNameOnly).toList();
    }

    public void resetAllPlayerScores(ScoreHolder p_313823_) {
        PlayerScores $$1 = this.playerScores.remove(p_313823_.getScoreboardName());
        if ($$1 != null) {
            this.onPlayerRemoved(p_313823_);
        }
    }

    public void resetSinglePlayerScore(ScoreHolder p_313783_, Objective p_313928_) {
        PlayerScores $$2 = this.playerScores.get(p_313783_.getScoreboardName());
        if ($$2 != null) {
            boolean $$3 = $$2.remove(p_313928_);
            if (!$$2.hasScores()) {
                PlayerScores $$4 = this.playerScores.remove(p_313783_.getScoreboardName());
                if ($$4 != null) {
                    this.onPlayerRemoved(p_313783_);
                }
            } else if ($$3) {
                this.onPlayerScoreRemoved(p_313783_, p_313928_);
            }
        }
    }

    public Object2IntMap<Objective> listPlayerScores(ScoreHolder p_313893_) {
        PlayerScores $$1 = this.playerScores.get(p_313893_.getScoreboardName());
        return $$1 != null ? $$1.listScores() : Object2IntMaps.emptyMap();
    }

    public void removeObjective(Objective p_83503_) {
        this.objectivesByName.remove((Object)p_83503_.getName());
        for (DisplaySlot $$1 : DisplaySlot.values()) {
            if (this.getDisplayObjective($$1) != p_83503_) continue;
            this.setDisplayObjective($$1, null);
        }
        List $$2 = (List)this.objectivesByCriteria.get((Object)p_83503_.getCriteria());
        if ($$2 != null) {
            $$2.remove(p_83503_);
        }
        for (PlayerScores $$3 : this.playerScores.values()) {
            $$3.remove(p_83503_);
        }
        this.onObjectiveRemoved(p_83503_);
    }

    public void setDisplayObjective(DisplaySlot p_296205_, @Nullable Objective p_83419_) {
        this.displayObjectives.put(p_296205_, p_83419_);
    }

    @Nullable
    public Objective getDisplayObjective(DisplaySlot p_295165_) {
        return this.displayObjectives.get(p_295165_);
    }

    @Nullable
    public PlayerTeam getPlayerTeam(String p_83490_) {
        return (PlayerTeam)this.teamsByName.get((Object)p_83490_);
    }

    public PlayerTeam addPlayerTeam(String p_83493_) {
        PlayerTeam $$1 = this.getPlayerTeam(p_83493_);
        if ($$1 != null) {
            LOGGER.warn("Requested creation of existing team '{}'", (Object)p_83493_);
            return $$1;
        }
        $$1 = new PlayerTeam(this, p_83493_);
        this.teamsByName.put((Object)p_83493_, (Object)$$1);
        this.onTeamAdded($$1);
        return $$1;
    }

    public void removePlayerTeam(PlayerTeam p_83476_) {
        this.teamsByName.remove((Object)p_83476_.getName());
        for (String $$1 : p_83476_.getPlayers()) {
            this.teamsByPlayer.remove((Object)$$1);
        }
        this.onTeamRemoved(p_83476_);
    }

    public boolean addPlayerToTeam(String p_83434_, PlayerTeam p_83435_) {
        if (this.getPlayersTeam(p_83434_) != null) {
            this.removePlayerFromTeam(p_83434_);
        }
        this.teamsByPlayer.put((Object)p_83434_, (Object)p_83435_);
        return p_83435_.getPlayers().add(p_83434_);
    }

    public boolean removePlayerFromTeam(String p_83496_) {
        PlayerTeam $$1 = this.getPlayersTeam(p_83496_);
        if ($$1 != null) {
            this.removePlayerFromTeam(p_83496_, $$1);
            return true;
        }
        return false;
    }

    public void removePlayerFromTeam(String p_83464_, PlayerTeam p_83465_) {
        if (this.getPlayersTeam(p_83464_) != p_83465_) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + p_83465_.getName() + "'.");
        }
        this.teamsByPlayer.remove((Object)p_83464_);
        p_83465_.getPlayers().remove(p_83464_);
    }

    public Collection<String> getTeamNames() {
        return this.teamsByName.keySet();
    }

    public Collection<PlayerTeam> getPlayerTeams() {
        return this.teamsByName.values();
    }

    @Nullable
    public PlayerTeam getPlayersTeam(String p_83501_) {
        return (PlayerTeam)this.teamsByPlayer.get((Object)p_83501_);
    }

    public void onObjectiveAdded(Objective p_83422_) {
    }

    public void onObjectiveChanged(Objective p_83455_) {
    }

    public void onObjectiveRemoved(Objective p_83467_) {
    }

    protected void onScoreChanged(ScoreHolder p_313729_, Objective p_313930_, Score p_83424_) {
    }

    protected void onScoreLockChanged(ScoreHolder p_313727_, Objective p_313708_) {
    }

    public void onPlayerRemoved(ScoreHolder p_313917_) {
    }

    public void onPlayerScoreRemoved(ScoreHolder p_313899_, Objective p_83433_) {
    }

    public void onTeamAdded(PlayerTeam p_83423_) {
    }

    public void onTeamChanged(PlayerTeam p_83456_) {
    }

    public void onTeamRemoved(PlayerTeam p_83468_) {
    }

    public void entityRemoved(Entity p_83421_) {
        if (p_83421_ instanceof Player || p_83421_.isAlive()) {
            return;
        }
        this.resetAllPlayerScores(p_83421_);
        this.removePlayerFromTeam(p_83421_.getScoreboardName());
    }

    protected List<PackedScore> packPlayerScores() {
        return this.playerScores.entrySet().stream().flatMap(p_400991_ -> {
            String $$1 = (String)p_400991_.getKey();
            return ((PlayerScores)p_400991_.getValue()).listRawScores().entrySet().stream().map(p_400993_ -> new PackedScore($$1, ((Objective)p_400993_.getKey()).getName(), (Score)p_400993_.getValue()));
        }).toList();
    }

    protected void loadPlayerScore(PackedScore p_401360_) {
        Objective $$1 = this.getObjective(p_401360_.objective);
        if ($$1 == null) {
            LOGGER.error("Unknown objective {} for name {}, ignoring", (Object)p_401360_.objective, (Object)p_401360_.owner);
            return;
        }
        this.getOrCreatePlayerInfo(p_401360_.owner).setScore($$1, p_401360_.score);
    }

    protected void loadPlayerTeam(PlayerTeam.Packed p_401125_) {
        PlayerTeam $$1 = this.addPlayerTeam(p_401125_.name());
        p_401125_.displayName().ifPresent($$1::setDisplayName);
        p_401125_.color().ifPresent($$1::setColor);
        $$1.setAllowFriendlyFire(p_401125_.allowFriendlyFire());
        $$1.setSeeFriendlyInvisibles(p_401125_.seeFriendlyInvisibles());
        $$1.setPlayerPrefix(p_401125_.memberNamePrefix());
        $$1.setPlayerSuffix(p_401125_.memberNameSuffix());
        $$1.setNameTagVisibility(p_401125_.nameTagVisibility());
        $$1.setDeathMessageVisibility(p_401125_.deathMessageVisibility());
        $$1.setCollisionRule(p_401125_.collisionRule());
        for (String $$2 : p_401125_.players()) {
            this.addPlayerToTeam($$2, $$1);
        }
    }

    protected void loadObjective(Objective.Packed p_401060_) {
        this.addObjective(p_401060_.name(), p_401060_.criteria(), p_401060_.displayName(), p_401060_.renderType(), p_401060_.displayAutoUpdate(), p_401060_.numberFormat().orElse(null));
    }

    public record PackedScore(String owner, String objective, Score score) {
        public static final Codec<PackedScore> CODEC = RecordCodecBuilder.create(p_401229_ -> p_401229_.group((App)Codec.STRING.fieldOf("Name").forGetter(PackedScore::owner), (App)Codec.STRING.fieldOf("Objective").forGetter(PackedScore::objective), (App)Score.MAP_CODEC.forGetter(PackedScore::score)).apply((Applicative)p_401229_, PackedScore::new));
    }
}

