/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public abstract class Team {
    public boolean isAlliedTo(@Nullable Team p_83537_) {
        if (p_83537_ == null) {
            return false;
        }
        return this == p_83537_;
    }

    public abstract String getName();

    public abstract MutableComponent getFormattedName(Component var1);

    public abstract boolean canSeeFriendlyInvisibles();

    public abstract boolean isAllowFriendlyFire();

    public abstract Visibility getNameTagVisibility();

    public abstract ChatFormatting getColor();

    public abstract Collection<String> getPlayers();

    public abstract Visibility getDeathMessageVisibility();

    public abstract CollisionRule getCollisionRule();

    public static enum CollisionRule implements StringRepresentable
    {
        ALWAYS("always", 0),
        NEVER("never", 1),
        PUSH_OTHER_TEAMS("pushOtherTeams", 2),
        PUSH_OWN_TEAM("pushOwnTeam", 3);

        public static final Codec<CollisionRule> CODEC;
        private static final IntFunction<CollisionRule> BY_ID;
        public static final StreamCodec<ByteBuf, CollisionRule> STREAM_CODEC;
        public final String name;
        public final int id;

        private CollisionRule(String p_83551_, int p_83552_) {
            this.name = p_83551_;
            this.id = p_83552_;
        }

        public Component getDisplayName() {
            return Component.translatable("team.collision." + this.name);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(CollisionRule::values);
            BY_ID = ByIdMap.continuous(p_400997_ -> p_400997_.id, CollisionRule.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, p_400996_ -> p_400996_.id);
        }
    }

    public static enum Visibility implements StringRepresentable
    {
        ALWAYS("always", 0),
        NEVER("never", 1),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams", 2),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam", 3);

        public static final Codec<Visibility> CODEC;
        private static final IntFunction<Visibility> BY_ID;
        public static final StreamCodec<ByteBuf, Visibility> STREAM_CODEC;
        public final String name;
        public final int id;

        private Visibility(String p_83575_, int p_83576_) {
            this.name = p_83575_;
            this.id = p_83576_;
        }

        public Component getDisplayName() {
            return Component.translatable("team.visibility." + this.name);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Visibility::values);
            BY_ID = ByIdMap.continuous(p_400998_ -> p_400998_.id, Visibility.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, p_400999_ -> p_400999_.id);
        }
    }
}

