/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformTargetLabel;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import cpw.mods.modlauncher.api.TargetType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jetbrains.annotations.VisibleForTesting;

public class TransformationServiceDecorator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ITransformationService service;
    private boolean isValid;

    @VisibleForTesting
    public TransformationServiceDecorator(ITransformationService service) {
        this.service = service;
    }

    void onLoad(IEnvironment env, Set<String> otherServices) {
        try {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = this.service::name;
            LOGGER.debug(LogMarkers.MODLAUNCHER, "Loading service {}", supplierArray);
            this.service.onLoad(env, otherServices);
            this.isValid = true;
            Supplier[] supplierArray2 = new Supplier[1];
            supplierArray2[0] = this.service::name;
            LOGGER.debug(LogMarkers.MODLAUNCHER, "Loaded service {}", supplierArray2);
        }
        catch (IncompatibleEnvironmentException e) {
            LOGGER.error(LogMarkers.MODLAUNCHER, "Service failed to load {}", (Object)this.service.name(), (Object)e);
            this.isValid = false;
        }
    }

    boolean isValid() {
        return this.isValid;
    }

    void onInitialize(IEnvironment environment) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.service::name;
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Initializing transformation service {}", supplierArray);
        this.service.initialize(environment);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = this.service::name;
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Initialized transformation service {}", supplierArray2);
    }

    public void gatherTransformers(TransformStore transformStore) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.service::name;
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Initializing transformers for transformation service {}", supplierArray);
        List<ITransformer<?>> transformers = this.service.transformers();
        Objects.requireNonNull(transformers, "The transformers list should not be null");
        transformers.forEach(xform -> {
            TargetType targetType = xform.getTargetType();
            Objects.requireNonNull(targetType, "Transformer type must not be null");
            Set targets = xform.targets();
            if (!targets.isEmpty()) {
                Map<TargetType, List<TransformTargetLabel>> targetTypeListMap = targets.stream().map(TransformTargetLabel::new).collect(Collectors.groupingBy(TransformTargetLabel::getTargetType));
                if (targetTypeListMap.keySet().size() > 1 || !targetTypeListMap.containsKey(targetType)) {
                    LOGGER.error(LogMarkers.MODLAUNCHER, "Invalid target {} for transformer {}", targetType, xform);
                    throw new IllegalArgumentException("The transformer contains invalid targets");
                }
                targetTypeListMap.values().stream().flatMap(Collection::stream).forEach(target -> transformStore.addTransformer((TransformTargetLabel)target, xform, this.service));
            }
        });
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = this.service::name;
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Initialized transformers for transformation service {}", supplierArray2);
    }

    ITransformationService getService() {
        return this.service;
    }

    List<ITransformationService.Resource> runScan(Environment environment) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.service::name;
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Beginning scan trigger - transformation service {}", supplierArray);
        List<ITransformationService.Resource> scanResults = this.service.beginScanning(environment);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = this.service::name;
        LOGGER.debug(LogMarkers.MODLAUNCHER, "End scan trigger - transformation service {}", supplierArray2);
        return scanResults;
    }

    public List<ITransformationService.Resource> onCompleteScan(IModuleLayerManager moduleLayerManager) {
        return this.service.completeScan(moduleLayerManager);
    }
}

