/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.neoforged.fml.earlydisplay.ColourScheme;
import net.neoforged.fml.earlydisplay.EarlyFramebuffer;
import net.neoforged.fml.earlydisplay.ElementShader;
import net.neoforged.fml.earlydisplay.GlDebug;
import net.neoforged.fml.earlydisplay.GlState;
import net.neoforged.fml.earlydisplay.PerformanceInfo;
import net.neoforged.fml.earlydisplay.RenderElement;
import net.neoforged.fml.earlydisplay.STBHelper;
import net.neoforged.fml.earlydisplay.SimpleBufferBuilder;
import net.neoforged.fml.earlydisplay.SimpleFont;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforgespi.earlywindow.ImmediateWindowProvider;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayWindow
implements ImmediateWindowProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"EARLYDISPLAY");
    private final AtomicBoolean animationTimerTrigger = new AtomicBoolean(true);
    private final ProgressMeter mainProgress;
    private ColourScheme colourScheme;
    private ElementShader elementShader;
    private RenderElement.DisplayContext context;
    private List<RenderElement> elements;
    private int framecount;
    private EarlyFramebuffer framebuffer;
    private ScheduledFuture<?> windowTick;
    private ScheduledFuture<?> initializationFuture;
    private PerformanceInfo performanceInfo;
    private ScheduledFuture<?> performanceTick;
    private long window;
    private ScheduledExecutorService renderScheduler;
    private int fbWidth;
    private int fbHeight;
    private int fbScale;
    private int winWidth;
    private int winHeight;
    private int winX;
    private int winY;
    private final Semaphore renderLock = new Semaphore(1);
    private boolean maximized;
    private SimpleFont font;
    private Runnable repaintTick = () -> {};
    private static final long MINFRAMETIME = TimeUnit.MILLISECONDS.toNanos(10L);
    private long nextFrameTime = 0L;
    private static final String ERROR_URL = "https://links.neoforged.net/early-display-errors";
    private final ReentrantLock crashLock = new ReentrantLock();

    public DisplayWindow() {
        this.mainProgress = StartupNotificationManager.addProgressBar((String)"EARLY", (int)0);
    }

    public String name() {
        return "fmlearlywindow";
    }

    public Runnable initialize(String[] arguments) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec mcversionopt = parser.accepts("fml.mcVersion").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec forgeversionopt = parser.accepts("fml.neoForgeVersion").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec widthopt = parser.accepts("width").withRequiredArg().ofType(Integer.class).defaultsTo((Object)FMLConfig.getIntConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_WIDTH), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec heightopt = parser.accepts("height").withRequiredArg().ofType(Integer.class).defaultsTo((Object)FMLConfig.getIntConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_HEIGHT), (Object[])new Integer[0]);
        OptionSpecBuilder maximizedopt = parser.accepts("earlywindow.maximized");
        parser.allowsUnrecognizedOptions();
        OptionSet parsed = parser.parse(arguments);
        this.winWidth = (Integer)parsed.valueOf((OptionSpec)widthopt);
        this.winHeight = (Integer)parsed.valueOf((OptionSpec)heightopt);
        FMLConfig.updateConfig((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_WIDTH, (Object)this.winWidth);
        FMLConfig.updateConfig((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_HEIGHT, (Object)this.winHeight);
        this.fbScale = FMLConfig.getIntConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_FBSCALE);
        if (System.getenv("FML_EARLY_WINDOW_DARK") != null) {
            this.colourScheme = ColourScheme.BLACK;
        } else {
            try {
                List<String> optionLines = Files.readAllLines(FMLPaths.GAMEDIR.get().resolve(Paths.get("options.txt", new String[0])));
                Map<String, String> options = optionLines.stream().map(l -> l.split(":")).filter(a -> ((String[])a).length == 2).collect(Collectors.toMap(a -> a[0], a -> a[1]));
                boolean colourScheme = Boolean.parseBoolean(options.getOrDefault("darkMojangStudiosBackground", "false"));
                this.colourScheme = colourScheme ? ColourScheme.BLACK : ColourScheme.RED;
            }
            catch (IOException ioe) {
                this.colourScheme = ColourScheme.RED;
            }
        }
        this.maximized = parsed.has((OptionSpec)maximizedopt) || FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_MAXIMIZED);
        String forgeVersion = (String)parsed.valueOf((OptionSpec)forgeversionopt);
        StartupNotificationManager.modLoaderConsumer().ifPresent(c -> c.accept("NeoForge loading " + forgeVersion));
        this.performanceInfo = new PerformanceInfo();
        return this.start((String)parsed.valueOf((OptionSpec)mcversionopt), forgeVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderThreadFunc() {
        if (!this.renderLock.tryAcquire()) {
            return;
        }
        try {
            long nt = System.nanoTime();
            if (nt < this.nextFrameTime) {
                return;
            }
            this.nextFrameTime = nt + MINFRAMETIME;
            GLFW.glfwMakeContextCurrent((long)this.window);
            GlState.readFromOpenGL();
            GlState.StateSnapshot backup = GlState.createSnapshot();
            this.framebuffer.activate();
            GlState.viewport(0, 0, this.context.scaledWidth(), this.context.scaledHeight());
            this.context.elementShader().activate();
            this.context.elementShader().updateScreenSizeUniform(this.context.scaledWidth(), this.context.scaledHeight());
            GlState.clearColor(this.colourScheme.background().redf(), this.colourScheme.background().greenf(), this.colourScheme.background().bluef(), 1.0f);
            this.paintFramebuffer();
            this.context.elementShader().clear();
            this.framebuffer.deactivate();
            GlState.viewport(0, 0, this.fbWidth, this.fbHeight);
            this.framebuffer.draw(this.fbWidth, this.fbHeight);
            GLFW.glfwSwapBuffers((long)this.window);
            GlState.applySnapshot(backup);
        }
        catch (Throwable t) {
            LOGGER.error("BARF", t);
        }
        finally {
            if (this.windowTick != null) {
                GLFW.glfwMakeContextCurrent((long)0L);
            }
            this.renderLock.release();
        }
    }

    private void initRender(@Nullable String mcVersion, String forgeVersion) {
        GLFW.glfwMakeContextCurrent((long)this.window);
        GLFW.glfwSwapInterval((int)1);
        GLCapabilities capabilities = GL.createCapabilities();
        GlState.readFromOpenGL();
        GlDebug.setCapabilities(capabilities);
        LOGGER.info("GL info: {} GL version {}, {}", new Object[]{GL32C.glGetString((int)7937), GL32C.glGetString((int)7938), GL32C.glGetString((int)7936)});
        this.elementShader = new ElementShader();
        try {
            this.elementShader.init();
        }
        catch (Throwable t) {
            LOGGER.error("Crash during shader initialization", t);
            this.crashElegantly("An error occurred initializing shaders.");
        }
        GlState.clearColor(this.colourScheme.background().redf(), this.colourScheme.background().greenf(), this.colourScheme.background().bluef(), 1.0f);
        this.context = new RenderElement.DisplayContext(854, 480, this.fbScale, this.elementShader, this.colourScheme, this.performanceInfo);
        this.framebuffer = new EarlyFramebuffer(this.context);
        try {
            this.font = new SimpleFont("Monocraft.ttf", this.fbScale, 200000);
        }
        catch (Throwable t) {
            LOGGER.error("Crash during font initialization", t);
            this.crashElegantly("An error occurred initializing a font for rendering. " + t.getMessage());
        }
        this.elements = new ArrayList<RenderElement>(Arrays.asList(RenderElement.fox(this.font), RenderElement.logMessageOverlay(this.font), RenderElement.forgeVersionOverlay(this.font, mcVersion + "-" + forgeVersion.split("-")[0]), RenderElement.performanceBar(this.font), RenderElement.progressBars(this.font)));
        Calendar date = Calendar.getInstance();
        if (FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_SQUIR) || date.get(2) == 3 && date.get(5) == 1) {
            this.elements.add(0, RenderElement.squir());
        }
        GlState.enableBlend(true);
        GlState.blendFuncSeparate(770, 771, 770, 771);
        GLFW.glfwMakeContextCurrent((long)0L);
        this.windowTick = this.renderScheduler.scheduleAtFixedRate(this::renderThreadFunc, 50L, 50L, TimeUnit.MILLISECONDS);
        this.performanceTick = this.renderScheduler.scheduleAtFixedRate(this.performanceInfo::update, 0L, 500L, TimeUnit.MILLISECONDS);
        this.renderScheduler.scheduleAtFixedRate(() -> this.animationTimerTrigger.set(true), 1L, 50L, TimeUnit.MILLISECONDS);
    }

    void paintFramebuffer() {
        GL32C.glClear((int)16640);
        GlState.enableBlend(true);
        GlState.blendFuncSeparate(770, 771, 1, 771);
        this.elements.removeIf(element -> !element.render(this.context, this.framecount));
        if (this.animationTimerTrigger.compareAndSet(true, false)) {
            ++this.framecount;
        }
    }

    public void renderToFramebuffer() {
        GlDebug.pushGroup("update EarlyDisplay framebuffer");
        GlState.readFromOpenGL();
        GlState.StateSnapshot backup = GlState.createSnapshot();
        GlState.viewport(0, 0, this.context.scaledWidth(), this.context.scaledHeight());
        this.framebuffer.activate();
        GlState.clearColor(this.colourScheme.background().redf(), this.colourScheme.background().greenf(), this.colourScheme.background().bluef(), 1.0f);
        this.elementShader.activate();
        this.elementShader.updateScreenSizeUniform(this.context.scaledWidth(), this.context.scaledHeight());
        this.paintFramebuffer();
        this.elementShader.clear();
        this.framebuffer.deactivate();
        GlState.applySnapshot(backup);
        GlDebug.popGroup();
    }

    public Runnable start(@Nullable String mcVersion, String forgeVersion) {
        this.renderScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            return thread;
        });
        this.initWindow(mcVersion);
        this.initializationFuture = this.renderScheduler.schedule(() -> this.initRender(mcVersion, forgeVersion), 1L, TimeUnit.MILLISECONDS);
        return this::periodicTick;
    }

    private void crashElegantly(String errorDetails) {
        this.crashLock.lock();
        StringBuilder msgBuilder = new StringBuilder(2000);
        msgBuilder.append("Failed to initialize the mod loading system and display.\n");
        msgBuilder.append("\n\n");
        msgBuilder.append("Failure details:\n");
        msgBuilder.append(errorDetails);
        msgBuilder.append("\n\n");
        msgBuilder.append("If you click yes, we will try and open https://links.neoforged.net/early-display-errors in your default browser");
        LOGGER.error("ERROR DISPLAY\n{}", (Object)msgBuilder);
        Thread thread = new Thread(() -> {
            boolean res = TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft: NeoForge", (CharSequence)msgBuilder.toString(), (CharSequence)"yesno", (CharSequence)"error", (boolean)false);
            if (res) {
                try {
                    Desktop.getDesktop().browse(URI.create(ERROR_URL));
                }
                catch (IOException ioe) {
                    TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft: NeoForge", (CharSequence)"Sadly, we couldn't open your browser.\nVisit https://links.neoforged.net/early-display-errors", (CharSequence)"ok", (CharSequence)"error", (boolean)false);
                }
            }
        }, "crash-report");
        thread.setDaemon(true);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(1);
    }

    public void initWindow(@Nullable String mcVersion) {
        long primaryMonitor;
        long glfwInitBegin = System.nanoTime();
        if (!GLFW.glfwInit()) {
            this.crashElegantly("We are unable to initialize the graphics system.\nglfwInit failed.\n");
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        long glfwInitEnd = System.nanoTime();
        if ((double)(glfwInitEnd - glfwInitBegin) > 1.0E9) {
            LOGGER.error("WARNING : glfwInit took {} seconds to start.", (Object)((double)(glfwInitEnd - glfwInitBegin) / 1.0E9));
        }
        DisplayWindow.getLastGlfwError().ifPresent(error -> LOGGER.error("Suppressing Last GLFW error: {}", error));
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139266, (int)3);
        GLFW.glfwWindowHint((int)139267, (int)2);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)139270, (int)1);
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)1);
        if (mcVersion != null) {
            String vanillaWindowTitle = "Minecraft* " + mcVersion;
            GLFW.glfwWindowHintString((int)147457, (CharSequence)vanillaWindowTitle);
            GLFW.glfwWindowHintString((int)147458, (CharSequence)vanillaWindowTitle);
        }
        if (FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.DEBUG_OPENGL)) {
            LOGGER.info("Requesting the creation of an OpenGL debug context");
            GLFW.glfwWindowHint((int)139271, (int)1);
        }
        if ((primaryMonitor = GLFW.glfwGetPrimaryMonitor()) == 0L) {
            LOGGER.error("Failed to find a primary monitor - this means LWJGL isn't working properly");
            this.crashElegantly("Failed to locate a primary monitor.\nglfwGetPrimaryMonitor failed.\n");
            throw new IllegalStateException("Can't find a primary monitor");
        }
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)primaryMonitor);
        if (vidmode == null) {
            LOGGER.error("Failed to get the current display video mode.");
            this.crashElegantly("Failed to get current display resolution.\nglfwGetVideoMode failed.\n");
            throw new IllegalStateException("Can't get a resolution");
        }
        AtomicBoolean successfulWindow = new AtomicBoolean(false);
        ScheduledFuture<?> windowFailFuture = this.renderScheduler.schedule(() -> {
            if (!successfulWindow.get()) {
                this.crashElegantly("Timed out trying to setup the Game Window.");
            }
        }, 30L, TimeUnit.SECONDS);
        this.window = GLFW.glfwCreateWindow((int)this.winWidth, (int)this.winHeight, (CharSequence)"Minecraft: NeoForge Loading...", (long)0L, (long)0L);
        String creationError = DisplayWindow.getLastGlfwError().orElse("unknown error");
        if (this.window == 0L) {
            LOGGER.error("Failed to create window: {}", (Object)creationError);
            this.crashElegantly("Failed to create a window:\n" + creationError);
            throw new IllegalStateException("Failed to create a window");
        }
        successfulWindow.set(true);
        if (!windowFailFuture.cancel(true)) {
            throw new IllegalStateException("We died but didn't somehow?");
        }
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetMonitorPos((long)primaryMonitor, (int[])x, (int[])y);
        int monitorX = x[0];
        int monitorY = y[0];
        if (this.maximized) {
            GLFW.glfwMaximizeWindow((long)this.window);
        }
        GLFW.glfwGetWindowSize((long)this.window, (int[])x, (int[])y);
        this.winWidth = x[0];
        this.winHeight = y[0];
        GLFW.glfwSetWindowPos((long)this.window, (int)((vidmode.width() - this.winWidth) / 2 + monitorX), (int)((vidmode.height() - this.winHeight) / 2 + monitorY));
        int[] channels = new int[1];
        try (GLFWImage.Buffer glfwImgBuffer = GLFWImage.malloc((int)1);
             GLFWImage glfwImages = GLFWImage.malloc();){
            ByteBuffer imgBuffer = STBHelper.loadImageFromClasspath("neoforged_icon.png", 20000, x, y, channels);
            glfwImgBuffer.put((Struct)glfwImages.set(x[0], y[0], imgBuffer));
            glfwImgBuffer.flip();
            GLFW.glfwSetWindowIcon((long)this.window, (GLFWImage.Buffer)glfwImgBuffer);
            STBImage.stbi_image_free((ByteBuffer)imgBuffer);
        }
        catch (NullPointerException e) {
            LOGGER.error("Failed to load NeoForged icon");
        }
        DisplayWindow.getLastGlfwError().ifPresent(error -> LOGGER.warn("Failed to set window icon: {}", error));
        GLFW.glfwSetFramebufferSizeCallback((long)this.window, this::fbResize);
        GLFW.glfwSetWindowPosCallback((long)this.window, this::winMove);
        GLFW.glfwSetWindowSizeCallback((long)this.window, this::winResize);
        GLFW.glfwShowWindow((long)this.window);
        GLFW.glfwGetWindowPos((long)this.window, (int[])x, (int[])y);
        DisplayWindow.getLastGlfwError().ifPresent(error -> LOGGER.warn("Failed to show and position window: {}", error));
        this.winX = x[0];
        this.winY = y[0];
        GLFW.glfwGetFramebufferSize((long)this.window, (int[])x, (int[])y);
        this.fbWidth = x[0];
        this.fbHeight = y[0];
        GLFW.glfwPollEvents();
    }

    private void winResize(long window, int width, int height) {
        if (window == this.window && width != 0 && height != 0) {
            this.winWidth = width;
            this.winHeight = height;
        }
    }

    private void fbResize(long window, int width, int height) {
        if (window == this.window && width != 0 && height != 0) {
            this.fbWidth = width;
            this.fbHeight = height;
        }
    }

    private void winMove(long window, int x, int y) {
        if (window == this.window) {
            this.winX = x;
            this.winY = y;
        }
    }

    private static Optional<String> getLastGlfwError() {
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            int error = GLFW.glfwGetError((PointerBuffer)pointerbuffer);
            if (error != 0) {
                String description;
                long pDescription = pointerbuffer.get();
                String string = description = pDescription == 0L ? null : MemoryUtil.memUTF8((long)pDescription);
                if (description != null) {
                    Optional<String> optional = Optional.of(String.format(Locale.ROOT, "[0x%X] %s", error, description));
                    return optional;
                }
                Optional<String> optional = Optional.of(String.format(Locale.ROOT, "[0x%X]", error));
                return optional;
            }
        }
        return Optional.empty();
    }

    public long takeOverGlfwWindow() {
        try {
            this.initializationFuture.get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            Thread.dumpStack();
            this.crashElegantly("We seem to be having trouble initializing the window, waited for 30 seconds");
        }
        this.updateProgress("Initializing Game Graphics");
        while (!this.windowTick.isDone()) {
            this.windowTick.cancel(false);
        }
        try {
            if (!this.renderLock.tryAcquire(5L, TimeUnit.SECONDS)) {
                this.crashElegantly("We seem to be having trouble handing off the window, tried for 5 seconds");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.renderLock.release();
        GLFW.glfwMakeContextCurrent((long)this.window);
        GLFW.glfwSwapInterval((int)0);
        GLFW.glfwSetFramebufferSizeCallback((long)this.window, null).free();
        GLFW.glfwSetWindowPosCallback((long)this.window, null).free();
        GLFW.glfwSetWindowSizeCallback((long)this.window, null).free();
        this.repaintTick = this::renderThreadFunc;
        this.windowTick = null;
        return this.window;
    }

    public void updateModuleReads(ModuleLayer layer) {
    }

    public int getFramebufferTextureId() {
        return this.framebuffer.getTexture();
    }

    public RenderElement.DisplayContext context() {
        return this.context;
    }

    public void periodicTick() {
        GLFW.glfwPollEvents();
        this.repaintTick.run();
    }

    public void updateProgress(String label) {
        this.mainProgress.label(label);
    }

    public void completeProgress() {
        this.mainProgress.complete();
    }

    public void addMojangTexture(int textureId) {
        this.elements.add(0, RenderElement.mojang(textureId, this.framecount));
    }

    public void close() {
        this.renderScheduler.shutdown();
        this.framebuffer.close();
        this.context.elementShader().close();
        SimpleBufferBuilder.destroy();
    }

    public void crash(String message) {
        this.crashElegantly(message);
    }
}

