/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay;

import net.neoforged.fml.loading.FMLConfig;
import org.lwjgl.opengl.EXTDebugLabel;
import org.lwjgl.opengl.EXTDebugMarker;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.KHRDebug;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GlDebug {
    private static final Logger LOG = LoggerFactory.getLogger(GlDebug.class);
    private static LabelMode labelMode = LabelMode.DISABLED;
    private static GroupMode groupMode = GroupMode.DISABLED;
    private static int maxLabelLength;

    private GlDebug() {
    }

    public static void setCapabilities(GLCapabilities capabilities) {
        if (!FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.DEBUG_OPENGL)) {
            return;
        }
        if (capabilities.GL_KHR_debug) {
            labelMode = LabelMode.CORE;
            groupMode = GroupMode.CORE;
            maxLabelLength = GL32C.glGetInteger((int)33512);
        } else {
            maxLabelLength = 256;
            if (capabilities.GL_EXT_debug_label) {
                labelMode = LabelMode.EXTENSION;
            }
            if (capabilities.GL_EXT_debug_marker) {
                groupMode = GroupMode.EXTENSION;
            }
        }
        if (capabilities.GL_KHR_debug) {
            KHRDebug.glDebugMessageCallback(GlDebug::khrDebugMessage, (long)0L);
            GL32C.glEnable((int)33346);
            GL32C.glEnable((int)37600);
        }
    }

    private static void khrDebugMessage(int source, int type, int id, int severity, int length, long message, long userParam) {
        String sourceText = switch (source) {
            case 33350 -> "API";
            case 33351 -> "WINDOW_SYSTEM";
            case 33352 -> "SHADER_COMPILER";
            case 33353 -> "THIRD_PARTY";
            case 33354 -> "APPLICATION";
            case 33355 -> "OTHER";
            default -> "UNKNOWN";
        };
        String typeText = switch (type) {
            case 33356 -> "ERROR";
            case 33357 -> "DEPRECATED_BEHAVIOR";
            case 33358 -> "UNDEFINED_BEHAVIOR";
            case 33359 -> "PORTABILITY";
            case 33360 -> "PERFORMANCE";
            case 33384 -> "MARKER";
            case 33385 -> "PUSH_GROUP";
            case 33386 -> "POP_GROUP";
            case 33361 -> "OTHER";
            default -> "UNKNOWN";
        };
        String severityText = switch (severity) {
            case 37190 -> "HIGH";
            case 37191 -> "MEDIUM";
            case 37192 -> "LOW";
            case 33387 -> "NOTIFICATION";
            default -> "UNKNOWN";
        };
        String messageText = GLDebugMessageCallback.getMessage((int)length, (long)message);
        if (severity == 37190) {
            LOG.error("OpenGL message from {} of type {}: {}", new Object[]{sourceText, typeText, messageText});
        } else if (severity == 37191) {
            LOG.warn("OpenGL message from {} of type {}: {}", new Object[]{sourceText, typeText, messageText});
        } else {
            LOG.debug("OpenGL message from {} of type {} and severity {}: {}", new Object[]{sourceText, typeText, severityText, messageText});
        }
    }

    public static void pushGroup(String group) {
        switch (groupMode.ordinal()) {
            case 1: {
                KHRDebug.glPushDebugGroup((int)33354, (int)0, (CharSequence)GlDebug.truncate(group));
                break;
            }
            case 2: {
                EXTDebugMarker.glPushGroupMarkerEXT((CharSequence)group);
            }
        }
    }

    public static void popGroup() {
        switch (groupMode.ordinal()) {
            case 1: {
                KHRDebug.glPopDebugGroup();
                break;
            }
            case 2: {
                EXTDebugMarker.glPopGroupMarkerEXT();
            }
        }
    }

    public static void labelBuffer(int id, String label) {
        switch (labelMode.ordinal()) {
            case 1: {
                KHRDebug.glObjectLabel((int)33504, (int)id, (CharSequence)GlDebug.truncate(label));
                break;
            }
            case 2: {
                EXTDebugLabel.glLabelObjectEXT((int)37201, (int)id, (CharSequence)GlDebug.truncate(label));
            }
        }
    }

    public static void labelTexture(int id, String label) {
        switch (labelMode.ordinal()) {
            case 1: {
                KHRDebug.glObjectLabel((int)5890, (int)id, (CharSequence)GlDebug.truncate(label));
                break;
            }
            case 2: {
                EXTDebugLabel.glLabelObjectEXT((int)5890, (int)id, (CharSequence)GlDebug.truncate(label));
            }
        }
    }

    public static void labelFramebuffer(int id, String label) {
        switch (labelMode.ordinal()) {
            case 1: {
                KHRDebug.glObjectLabel((int)36160, (int)id, (CharSequence)GlDebug.truncate(label));
                break;
            }
            case 2: {
                EXTDebugLabel.glLabelObjectEXT((int)36160, (int)id, (CharSequence)GlDebug.truncate(label));
            }
        }
    }

    public static void labelShader(int id, String label) {
        switch (labelMode.ordinal()) {
            case 1: {
                KHRDebug.glObjectLabel((int)33505, (int)id, (CharSequence)GlDebug.truncate(label));
                break;
            }
            case 2: {
                EXTDebugLabel.glLabelObjectEXT((int)35648, (int)id, (CharSequence)GlDebug.truncate(label));
            }
        }
    }

    public static void labelProgram(int id, String label) {
        switch (labelMode.ordinal()) {
            case 1: {
                KHRDebug.glObjectLabel((int)33506, (int)id, (CharSequence)GlDebug.truncate(label));
                break;
            }
            case 2: {
                EXTDebugLabel.glLabelObjectEXT((int)35648, (int)id, (CharSequence)GlDebug.truncate(label));
            }
        }
    }

    public static void labelVertexArray(int id, String label) {
        switch (labelMode.ordinal()) {
            case 1: {
                KHRDebug.glObjectLabel((int)32884, (int)id, (CharSequence)GlDebug.truncate(label));
                break;
            }
            case 2: {
                EXTDebugLabel.glLabelObjectEXT((int)37204, (int)id, (CharSequence)GlDebug.truncate(label));
            }
        }
    }

    private static CharSequence truncate(String label) {
        if (label.length() > maxLabelLength) {
            return label.substring(0, maxLabelLength - 3) + "...";
        }
        return label;
    }

    private static enum LabelMode {
        DISABLED,
        CORE,
        EXTENSION;

    }

    private static enum GroupMode {
        DISABLED,
        CORE,
        EXTENSION;

    }
}

