/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay;

import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL32C;

final class GlState {
    private static int viewportX;
    private static int viewportY;
    private static int viewportWidth;
    private static int viewportHeight;
    private static float clearColorRed;
    private static float clearColorGreen;
    private static float clearColorBlue;
    private static float clearColorAlpha;
    private static boolean blendEnabled;
    private static int blendSrcRGB;
    private static int blendDstRGB;
    private static int blendSrcAlpha;
    private static int blendDstAlpha;
    private static int currentProgram;
    private static int boundTexture2D;
    private static int activeTextureUnit;
    private static int boundVertexArray;
    private static int boundDrawFramebuffer;
    private static int boundReadFramebuffer;
    private static int boundElementArrayBuffer;
    private static int boundArrayBuffer;

    private GlState() {
    }

    public static void readFromOpenGL() {
        int[] viewport = new int[4];
        GL32C.glGetIntegerv((int)2978, (int[])viewport);
        viewportX = viewport[0];
        viewportY = viewport[1];
        viewportWidth = viewport[2];
        viewportHeight = viewport[3];
        float[] clearColor = new float[4];
        GL32C.glGetFloatv((int)3106, (float[])clearColor);
        clearColorRed = clearColor[0];
        clearColorGreen = clearColor[1];
        clearColorBlue = clearColor[2];
        clearColorAlpha = clearColor[3];
        blendEnabled = GL32C.glIsEnabled((int)3042);
        blendSrcRGB = GL32C.glGetInteger((int)32969);
        blendDstRGB = GL32C.glGetInteger((int)32968);
        blendSrcAlpha = GL32C.glGetInteger((int)32971);
        blendDstAlpha = GL32C.glGetInteger((int)32970);
        currentProgram = GL32C.glGetInteger((int)35725);
        activeTextureUnit = 33984 + GL32C.glGetInteger((int)34016) - 33984;
        boundTexture2D = GL32C.glGetInteger((int)32873);
        boundVertexArray = GL32C.glGetInteger((int)34229);
        boundDrawFramebuffer = GL32C.glGetInteger((int)36006);
        boundReadFramebuffer = GL32C.glGetInteger((int)36010);
        boundElementArrayBuffer = GL32C.glGetInteger((int)34965);
        boundArrayBuffer = GL32C.glGetInteger((int)34964);
    }

    public static void viewport(int x, int y, int width, int height) {
        if (x != viewportX || y != viewportY || width != viewportWidth || height != viewportHeight) {
            GL32C.glViewport((int)x, (int)y, (int)width, (int)height);
            viewportX = x;
            viewportY = y;
            viewportWidth = width;
            viewportHeight = height;
        }
    }

    public static void clearColor(float red, float green, float blue, float alpha) {
        if (red != clearColorRed || green != clearColorGreen || blue != clearColorBlue || alpha != clearColorAlpha) {
            GL32C.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
            clearColorRed = red;
            clearColorGreen = green;
            clearColorBlue = blue;
            clearColorAlpha = alpha;
        }
    }

    public static void enableBlend(boolean enabled) {
        if (enabled != blendEnabled) {
            if (enabled) {
                GL32C.glEnable((int)3042);
            } else {
                GL32C.glDisable((int)3042);
            }
            blendEnabled = enabled;
        }
    }

    public static void blendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        if (srcRGB != blendSrcRGB || dstRGB != blendDstRGB || srcAlpha != blendSrcAlpha || dstAlpha != blendDstAlpha) {
            GL32C.glBlendFuncSeparate((int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
            blendSrcRGB = srcRGB;
            blendDstRGB = dstRGB;
            blendSrcAlpha = srcAlpha;
            blendDstAlpha = dstAlpha;
        }
    }

    public static void useProgram(int program) {
        if (program != currentProgram) {
            GL32C.glUseProgram((int)program);
            currentProgram = program;
        }
    }

    public static void activeTexture(int textureUnit) {
        if (textureUnit != activeTextureUnit) {
            GL32C.glActiveTexture((int)textureUnit);
            activeTextureUnit = textureUnit;
        }
    }

    public static void bindTexture2D(int textureId) {
        if (textureId != boundTexture2D) {
            GL32C.glBindTexture((int)3553, (int)textureId);
            boundTexture2D = textureId;
        }
    }

    public static void bindVertexArray(int vaoId) {
        if (vaoId != boundVertexArray) {
            GL32C.glBindVertexArray((int)vaoId);
            boundVertexArray = vaoId;
        }
    }

    public static void bindFramebuffer(int framebufferId) {
        if (framebufferId != boundDrawFramebuffer || framebufferId != boundReadFramebuffer) {
            GL32C.glBindFramebuffer((int)36160, (int)framebufferId);
            boundDrawFramebuffer = framebufferId;
            boundReadFramebuffer = framebufferId;
        }
    }

    public static void bindDrawFramebuffer(int framebufferId) {
        if (framebufferId != boundDrawFramebuffer) {
            GL32C.glBindFramebuffer((int)36009, (int)framebufferId);
            boundDrawFramebuffer = framebufferId;
        }
    }

    public static void bindReadFramebuffer(int framebufferId) {
        if (framebufferId != boundReadFramebuffer) {
            GL32C.glBindFramebuffer((int)36008, (int)framebufferId);
            boundReadFramebuffer = framebufferId;
        }
    }

    public static void bindElementArrayBuffer(int bufferId) {
        if (bufferId != boundElementArrayBuffer) {
            GL32C.glBindBuffer((int)34963, (int)bufferId);
            boundElementArrayBuffer = bufferId;
        }
    }

    public static void bindArrayBuffer(int bufferId) {
        if (bufferId != boundArrayBuffer) {
            GL32C.glBindBuffer((int)34962, (int)bufferId);
            boundArrayBuffer = bufferId;
        }
    }

    public static StateSnapshot createSnapshot() {
        return new StateSnapshot(viewportX, viewportY, viewportWidth, viewportHeight, clearColorRed, clearColorGreen, clearColorBlue, clearColorAlpha, blendEnabled, blendSrcRGB, blendDstRGB, blendSrcAlpha, blendDstAlpha, currentProgram, boundTexture2D, activeTextureUnit, boundVertexArray, boundDrawFramebuffer, boundReadFramebuffer, boundElementArrayBuffer, boundArrayBuffer);
    }

    public static void applySnapshot(StateSnapshot snapshot) {
        GlState.viewport(snapshot.viewportX, snapshot.viewportY, snapshot.viewportWidth, snapshot.viewportHeight);
        GlState.clearColor(snapshot.clearColorRed, snapshot.clearColorGreen, snapshot.clearColorBlue, snapshot.clearColorAlpha);
        GlState.enableBlend(snapshot.blendEnabled);
        GlState.blendFuncSeparate(snapshot.blendSrcRGB, snapshot.blendDstRGB, snapshot.blendSrcAlpha, snapshot.blendDstAlpha);
        if (GL20C.glIsProgram((int)snapshot.currentProgram)) {
            GlState.useProgram(snapshot.currentProgram);
        } else {
            GlState.useProgram(0);
        }
        GlState.activeTexture(snapshot.activeTextureUnit);
        GlState.bindTexture2D(snapshot.boundTexture2D);
        GlState.bindVertexArray(snapshot.boundVertexArray);
        if (snapshot.boundDrawFramebuffer == snapshot.boundReadFramebuffer) {
            GlState.bindFramebuffer(snapshot.boundDrawFramebuffer);
        } else {
            GlState.bindDrawFramebuffer(snapshot.boundDrawFramebuffer);
            GlState.bindReadFramebuffer(snapshot.boundReadFramebuffer);
        }
        GlState.bindElementArrayBuffer(snapshot.boundElementArrayBuffer);
        GlState.bindArrayBuffer(snapshot.boundArrayBuffer);
    }

    public record StateSnapshot(int viewportX, int viewportY, int viewportWidth, int viewportHeight, float clearColorRed, float clearColorGreen, float clearColorBlue, float clearColorAlpha, boolean blendEnabled, int blendSrcRGB, int blendDstRGB, int blendSrcAlpha, int blendDstAlpha, int currentProgram, int boundTexture2D, int activeTextureUnit, int boundVertexArray, int boundDrawFramebuffer, int boundReadFramebuffer, int boundElementArrayBuffer, int boundArrayBuffer) {
    }
}

