/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlStateManager;
import java.util.Set;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GLCapabilities;

@OnlyIn(value=Dist.CLIENT)
public abstract class DirectStateAccess {
    public static DirectStateAccess create(GLCapabilities p_412632_, Set<String> p_412533_) {
        if (p_412632_.GL_ARB_direct_state_access && GlDevice.USE_GL_ARB_direct_state_access) {
            p_412533_.add("GL_ARB_direct_state_access");
            return new Core();
        }
        return new Emulated();
    }

    abstract int createFrameBufferObject();

    abstract void bindFrameBufferTextures(int var1, int var2, int var3, int var4, int var5, boolean var6);

    public void bindFrameBufferTextures(int p_412046_, int p_412388_, int p_412116_, int p_412536_, int p_412779_) {
        this.bindFrameBufferTextures(p_412046_, p_412388_, p_412116_, p_412536_, p_412779_, false);
    }

    abstract void blitFrameBuffers(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    @OnlyIn(value=Dist.CLIENT)
    static class Core
    extends DirectStateAccess {
        Core() {
        }

        @Override
        public int createFrameBufferObject() {
            return ARBDirectStateAccess.glCreateFramebuffers();
        }

        @Override
        public void bindFrameBufferTextures(int p_412474_, int p_412101_, int p_412181_, int p_412742_, int p_412591_, boolean useStencil) {
            ARBDirectStateAccess.glNamedFramebufferTexture((int)p_412474_, (int)36064, (int)p_412101_, (int)p_412742_);
            int depthAttachment = useStencil ? 33306 : 36096;
            ARBDirectStateAccess.glNamedFramebufferTexture((int)p_412474_, (int)depthAttachment, (int)p_412181_, (int)p_412742_);
            if (p_412591_ != 0) {
                GlStateManager._glBindFramebuffer(p_412591_, p_412474_);
            }
        }

        @Override
        public void blitFrameBuffers(int p_412346_, int p_412174_, int p_412752_, int p_412365_, int p_412477_, int p_412615_, int p_412700_, int p_412178_, int p_412260_, int p_412584_, int p_412685_, int p_412482_) {
            ARBDirectStateAccess.glBlitNamedFramebuffer((int)p_412346_, (int)p_412174_, (int)p_412752_, (int)p_412365_, (int)p_412477_, (int)p_412615_, (int)p_412700_, (int)p_412178_, (int)p_412260_, (int)p_412584_, (int)p_412685_, (int)p_412482_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Emulated
    extends DirectStateAccess {
        Emulated() {
        }

        @Override
        public int createFrameBufferObject() {
            return GlStateManager.glGenFramebuffers();
        }

        @Override
        public void bindFrameBufferTextures(int p_412192_, int p_412614_, int p_412332_, int p_412295_, int p_412775_, boolean useStencil) {
            int i = p_412775_ == 0 ? 36009 : p_412775_;
            int j = GlStateManager.getFrameBuffer(i);
            GlStateManager._glBindFramebuffer(i, p_412192_);
            GlStateManager._glFramebufferTexture2D(i, 36064, 3553, p_412614_, p_412295_);
            int depthAttachment = useStencil ? 33306 : 36096;
            GlStateManager._glFramebufferTexture2D(i, depthAttachment, 3553, p_412332_, p_412295_);
            if (p_412775_ == 0) {
                GlStateManager._glBindFramebuffer(i, j);
            }
        }

        @Override
        public void blitFrameBuffers(int p_412705_, int p_412256_, int p_412077_, int p_412762_, int p_412738_, int p_412701_, int p_412455_, int p_412525_, int p_412252_, int p_412684_, int p_412520_, int p_412585_) {
            int i = GlStateManager.getFrameBuffer(36008);
            int j = GlStateManager.getFrameBuffer(36009);
            GlStateManager._glBindFramebuffer(36008, p_412705_);
            GlStateManager._glBindFramebuffer(36009, p_412256_);
            GlStateManager._glBlitFrameBuffer(p_412077_, p_412762_, p_412738_, p_412701_, p_412455_, p_412525_, p_412252_, p_412684_, p_412520_, p_412585_);
            GlStateManager._glBindFramebuffer(36008, i);
            GlStateManager._glBindFramebuffer(36009, j);
        }
    }
}

