/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.opengl.GlBuffer;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPass;
import com.mojang.blaze3d.opengl.GlRenderPipeline;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.opengl.Uniform;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ARGB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.stencil.StencilPerFaceTest;
import net.neoforged.neoforge.client.stencil.StencilTest;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class GlCommandEncoder
implements CommandEncoder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final GlDevice device;
    private final int readFbo;
    private final int drawFbo;
    @Nullable
    private RenderPipeline lastPipeline;
    private boolean inRenderPass;
    @Nullable
    private GlProgram lastProgram;

    protected GlCommandEncoder(GlDevice p_410479_) {
        this.device = p_410479_;
        this.readFbo = p_410479_.directStateAccess().createFrameBufferObject();
        this.drawFbo = p_410479_.directStateAccess().createFrameBufferObject();
    }

    @Override
    public RenderPass createRenderPass(GpuTexture p_410119_, OptionalInt p_410192_) {
        return this.createRenderPass(p_410119_, p_410192_, null, OptionalDouble.empty());
    }

    @Override
    public RenderPass createRenderPass(GpuTexture p_410864_, OptionalInt p_410460_, @Nullable GpuTexture p_410445_, OptionalDouble p_409874_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before creating a new one!");
        }
        if (p_409874_.isPresent() && p_410445_ == null) {
            LOGGER.warn("Depth clear value was provided but no depth texture is being used");
        }
        if (p_410864_.isClosed()) {
            throw new IllegalStateException("Color texture is closed");
        }
        if (p_410445_ != null && p_410445_.isClosed()) {
            throw new IllegalStateException("Depth texture is closed");
        }
        this.inRenderPass = true;
        int i = ((GlTexture)p_410864_).getFbo(this.device.directStateAccess(), p_410445_);
        GlStateManager._glBindFramebuffer(36160, i);
        int j = 0;
        if (p_410460_.isPresent()) {
            int k = p_410460_.getAsInt();
            GL11.glClearColor((float)ARGB.redFloat((int)k), (float)ARGB.greenFloat((int)k), (float)ARGB.blueFloat((int)k), (float)ARGB.alphaFloat((int)k));
            j |= 0x4000;
        }
        if (p_410445_ != null && p_409874_.isPresent()) {
            GL11.glClearDepth((double)p_409874_.getAsDouble());
            j |= 0x100;
        }
        if (j != 0) {
            GlStateManager._disableScissorTest();
            GlStateManager._depthMask(true);
            GlStateManager._colorMask(true, true, true, true);
            GlStateManager._clear(j);
        }
        GlStateManager._viewport(0, 0, p_410864_.getWidth(0), p_410864_.getHeight(0));
        this.lastPipeline = null;
        return new GlRenderPass(this, p_410445_ != null);
    }

    @Override
    public void clearColorTexture(GpuTexture p_410228_, int p_410646_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before creating a new one!");
        }
        if (!p_410228_.getFormat().hasColorAspect()) {
            throw new IllegalStateException("Trying to clear a non-color texture as color");
        }
        if (p_410228_.isClosed()) {
            throw new IllegalStateException("Color texture is closed");
        }
        this.device.directStateAccess().bindFrameBufferTextures(this.drawFbo, ((GlTexture)p_410228_).id, 0, 0, 36160);
        GL11.glClearColor((float)ARGB.redFloat((int)p_410646_), (float)ARGB.greenFloat((int)p_410646_), (float)ARGB.blueFloat((int)p_410646_), (float)ARGB.alphaFloat((int)p_410646_));
        GlStateManager._disableScissorTest();
        GlStateManager._colorMask(true, true, true, true);
        GlStateManager._clear(16384);
        GlStateManager._glFramebufferTexture2D(36160, 36064, 3553, 0, 0);
        GlStateManager._glBindFramebuffer(36160, 0);
    }

    @Override
    public void clearColorAndDepthTextures(GpuTexture p_410863_, int p_410603_, GpuTexture p_409616_, double p_410193_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before creating a new one!");
        }
        if (!p_410863_.getFormat().hasColorAspect()) {
            throw new IllegalStateException("Trying to clear a non-color texture as color");
        }
        if (!p_409616_.getFormat().hasDepthAspect()) {
            throw new IllegalStateException("Trying to clear a non-depth texture as depth");
        }
        if (p_410863_.isClosed()) {
            throw new IllegalStateException("Color texture is closed");
        }
        if (p_409616_.isClosed()) {
            throw new IllegalStateException("Depth texture is closed");
        }
        int i = ((GlTexture)p_410863_).getFbo(this.device.directStateAccess(), p_409616_);
        GlStateManager._glBindFramebuffer(36160, i);
        GlStateManager._disableScissorTest();
        GL11.glClearDepth((double)p_410193_);
        GL11.glClearColor((float)ARGB.redFloat((int)p_410603_), (float)ARGB.greenFloat((int)p_410603_), (float)ARGB.blueFloat((int)p_410603_), (float)ARGB.alphaFloat((int)p_410603_));
        GlStateManager._depthMask(true);
        GlStateManager._colorMask(true, true, true, true);
        GlStateManager._clear(16640);
        GlStateManager._glBindFramebuffer(36160, 0);
    }

    @Override
    public void clearDepthTexture(GpuTexture p_410548_, double p_410067_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before creating a new one!");
        }
        if (!p_410548_.getFormat().hasDepthAspect()) {
            throw new IllegalStateException("Trying to clear a non-depth texture as depth");
        }
        if (p_410548_.isClosed()) {
            throw new IllegalStateException("Depth texture is closed");
        }
        boolean hasStencil = p_410548_.getFormat().hasStencilAspect();
        this.device.directStateAccess().bindFrameBufferTextures(this.drawFbo, 0, ((GlTexture)p_410548_).id, 0, 36160, hasStencil);
        GL11.glDrawBuffer((int)0);
        GL11.glClearDepth((double)p_410067_);
        GlStateManager._depthMask(true);
        GlStateManager._disableScissorTest();
        GlStateManager._clear(256);
        GL11.glDrawBuffer((int)36064);
        GlStateManager._glFramebufferTexture2D(36160, 36096, 3553, 0, 0);
        GlStateManager._glBindFramebuffer(36160, 0);
    }

    @Override
    public void clearStencilTexture(GpuTexture texture, int value) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before creating a new one!");
        }
        if (!texture.getFormat().hasStencilAspect()) {
            throw new IllegalStateException("Trying to clear stencil in a texture that has no stencil component!");
        }
        this.device.directStateAccess().bindFrameBufferTextures(this.drawFbo, 0, ((GlTexture)texture).id, 0, 36160, true);
        GL11.glDrawBuffer((int)0);
        GL11.glClearStencil((int)value);
        GlStateManager._depthMask(true);
        GlStateManager._clear(1024);
        GL11.glDrawBuffer((int)36064);
        GlStateManager._glBindFramebuffer(36160, 0);
    }

    @Override
    public void writeToBuffer(GpuBuffer p_409838_, ByteBuffer p_410689_, int p_409997_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        GlBuffer glbuffer = (GlBuffer)p_409838_;
        if (glbuffer.closed) {
            throw new IllegalStateException("Buffer already closed");
        }
        if (!glbuffer.usage().isWritable()) {
            throw new IllegalStateException("Buffer is not writable");
        }
        int i = p_410689_.remaining();
        if (i + p_409997_ > glbuffer.size) {
            throw new IllegalArgumentException("Cannot write more data than this buffer can hold (attempting to write " + i + " bytes at offset " + p_409997_ + " to " + glbuffer.size + " size buffer)");
        }
        GlStateManager._glBindBuffer(GlConst.toGl(glbuffer.type()), glbuffer.handle);
        if (glbuffer.initialized) {
            GlStateManager._glBufferSubData(GlConst.toGl(glbuffer.type()), p_409997_, p_410689_);
        } else if (p_409997_ == 0 && i == glbuffer.size) {
            GlStateManager._glBufferData(GlConst.toGl(glbuffer.type()), p_410689_, GlConst.toGl(glbuffer.usage()));
            GlBuffer.MEMORY_POOl.malloc((long)glbuffer.handle, glbuffer.size);
            glbuffer.initialized = true;
            this.device.debugLabels().applyLabel(glbuffer);
        } else {
            GlStateManager._glBufferData(GlConst.toGl(glbuffer.type()), glbuffer.size, GlConst.toGl(glbuffer.usage()));
            GlStateManager._glBufferSubData(GlConst.toGl(glbuffer.type()), p_409997_, p_410689_);
            GlBuffer.MEMORY_POOl.malloc((long)glbuffer.handle, glbuffer.size);
            glbuffer.initialized = true;
            this.device.debugLabels().applyLabel(glbuffer);
        }
    }

    @Override
    public GpuBuffer.ReadView readBuffer(GpuBuffer p_409899_) {
        return this.readBuffer(p_409899_, 0, p_409899_.size());
    }

    @Override
    public GpuBuffer.ReadView readBuffer(GpuBuffer p_409613_, int p_410634_, int p_410639_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        GlBuffer glbuffer = (GlBuffer)p_409613_;
        if (glbuffer.closed) {
            throw new IllegalStateException("Buffer already closed");
        }
        if (!glbuffer.usage().isReadable()) {
            throw new IllegalStateException("Buffer is not readable");
        }
        if (p_410634_ + p_410639_ > glbuffer.size) {
            throw new IllegalArgumentException("Cannot read more data than this buffer can hold (attempting to read " + p_410639_ + " bytes at offset " + p_410634_ + " from " + glbuffer.size + " size buffer)");
        }
        GlStateManager.clearGlErrors();
        GlStateManager._glBindBuffer(GlConst.toGl(glbuffer.type()), glbuffer.handle);
        ByteBuffer bytebuffer = GlStateManager._glMapBufferRange(GlConst.toGl(glbuffer.type()), p_410634_, p_410639_, 1);
        if (bytebuffer == null) {
            throw new IllegalStateException("Can't read buffer, opengl error " + GlStateManager._getError());
        }
        return new GlBuffer.ReadView(GlConst.toGl(glbuffer.type()), bytebuffer);
    }

    @Override
    public void writeToTexture(GpuTexture p_409824_, NativeImage p_410255_) {
        int i = p_409824_.getWidth(0);
        int j = p_409824_.getHeight(0);
        if (p_410255_.getWidth() != i || p_410255_.getHeight() != j) {
            throw new IllegalArgumentException("Cannot replace texture of size " + i + "x" + j + " with image of size " + p_410255_.getWidth() + "x" + p_410255_.getHeight());
        }
        if (p_409824_.isClosed()) {
            throw new IllegalStateException("Destination texture is closed");
        }
        this.writeToTexture(p_409824_, p_410255_, 0, 0, 0, i, j, 0, 0);
    }

    @Override
    public void writeToTexture(GpuTexture p_409608_, NativeImage p_410355_, int p_410252_, int p_410814_, int p_410606_, int p_410618_, int p_410484_, int p_410120_, int p_410042_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        if (p_410252_ >= 0 && p_410252_ < p_409608_.getMipLevels()) {
            if (p_410120_ + p_410618_ > p_410355_.getWidth() || p_410042_ + p_410484_ > p_410355_.getHeight()) {
                throw new IllegalArgumentException("Copy source (" + p_410355_.getWidth() + "x" + p_410355_.getHeight() + ") is not large enough to read a rectangle of " + p_410618_ + "x" + p_410484_ + " from " + p_410120_ + "x" + p_410042_);
            }
            if (p_410814_ + p_410618_ > p_409608_.getWidth(p_410252_) || p_410606_ + p_410484_ > p_409608_.getHeight(p_410252_)) {
                throw new IllegalArgumentException("Dest texture (" + p_410618_ + "x" + p_410484_ + ") is not large enough to write a rectangle of " + p_410618_ + "x" + p_410484_ + " at " + p_410814_ + "x" + p_410606_ + " (at mip level " + p_410252_ + ")");
            }
            if (p_409608_.isClosed()) {
                throw new IllegalStateException("Destination texture is closed");
            }
        } else {
            throw new IllegalArgumentException("Invalid mipLevel " + p_410252_ + ", must be >= 0 and < " + p_409608_.getMipLevels());
        }
        GlStateManager._bindTexture(((GlTexture)p_409608_).id);
        GlStateManager._pixelStore(3314, p_410355_.getWidth());
        GlStateManager._pixelStore(3316, p_410120_);
        GlStateManager._pixelStore(3315, p_410042_);
        GlStateManager._pixelStore(3317, p_410355_.format().components());
        GlStateManager._texSubImage2D(3553, p_410252_, p_410814_, p_410606_, p_410618_, p_410484_, GlConst.toGl(p_410355_.format()), 5121, p_410355_.getPointer());
    }

    @Override
    public void writeToTexture(GpuTexture p_410473_, IntBuffer p_410298_, NativeImage.Format p_409943_, int p_410132_, int p_409948_, int p_410810_, int p_409825_, int p_410770_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        if (p_410132_ >= 0 && p_410132_ < p_410473_.getMipLevels()) {
            if (p_409825_ * p_410770_ > p_410298_.remaining()) {
                throw new IllegalArgumentException("Copy would overrun the source buffer (remaining length of " + p_410298_.remaining() + ", but copy is " + p_409825_ + "x" + p_410770_ + ")");
            }
            if (p_409948_ + p_409825_ > p_410473_.getWidth(p_410132_) || p_410810_ + p_410770_ > p_410473_.getHeight(p_410132_)) {
                throw new IllegalArgumentException("Dest texture (" + p_410473_.getWidth(p_410132_) + "x" + p_410473_.getHeight(p_410132_) + ") is not large enough to write a rectangle of " + p_409825_ + "x" + p_410770_ + " at " + p_409948_ + "x" + p_410810_);
            }
            if (p_410473_.isClosed()) {
                throw new IllegalStateException("Destination texture is closed");
            }
        } else {
            throw new IllegalArgumentException("Invalid mipLevel, must be >= 0 and < " + p_410473_.getMipLevels());
        }
        GlStateManager._bindTexture(((GlTexture)p_410473_).id);
        GlStateManager._pixelStore(3314, p_409825_);
        GlStateManager._pixelStore(3316, 0);
        GlStateManager._pixelStore(3315, 0);
        GlStateManager._pixelStore(3317, p_409943_.components());
        GlStateManager._texSubImage2D(3553, p_410132_, p_409948_, p_410810_, p_409825_, p_410770_, GlConst.toGl(p_409943_), 5121, p_410298_);
    }

    @Override
    public void copyTextureToBuffer(GpuTexture p_410088_, GpuBuffer p_409674_, int p_410546_, Runnable p_410567_, int p_410125_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        this.copyTextureToBuffer(p_410088_, p_409674_, p_410546_, p_410567_, p_410125_, 0, 0, p_410088_.getWidth(p_410125_), p_410088_.getHeight(p_410125_));
    }

    @Override
    public void copyTextureToBuffer(GpuTexture p_410781_, GpuBuffer p_410413_, int p_410080_, Runnable p_410081_, int p_410819_, int p_409841_, int p_409880_, int p_409853_, int p_410558_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        if (p_410819_ >= 0 && p_410819_ < p_410781_.getMipLevels()) {
            if (p_410781_.getWidth(p_410819_) * p_410781_.getHeight(p_410819_) * p_410781_.getFormat().pixelSize() + p_410080_ > p_410413_.size()) {
                throw new IllegalArgumentException("Buffer of size " + p_410413_.size() + " is not large enough to hold " + p_409853_ + "x" + p_410558_ + " pixels (" + p_410781_.getFormat().pixelSize() + " bytes each) starting from offset " + p_410080_);
            }
            if (p_410413_.type() != BufferType.PIXEL_PACK) {
                throw new IllegalArgumentException("Buffer of type " + String.valueOf(p_410413_.type()) + " cannot be used to retrieve a texture");
            }
            if (p_409841_ + p_409853_ > p_410781_.getWidth(p_410819_) || p_409880_ + p_410558_ > p_410781_.getHeight(p_410819_)) {
                throw new IllegalArgumentException("Copy source texture (" + p_410781_.getWidth(p_410819_) + "x" + p_410781_.getHeight(p_410819_) + ") is not large enough to read a rectangle of " + p_409853_ + "x" + p_410558_ + " from " + p_409841_ + "," + p_409880_);
            }
            if (p_410781_.isClosed()) {
                throw new IllegalStateException("Source texture is closed");
            }
            if (p_410413_.isClosed()) {
                throw new IllegalStateException("Destination buffer is closed");
            }
            GlStateManager.clearGlErrors();
            this.device.directStateAccess().bindFrameBufferTextures(this.readFbo, ((GlTexture)p_410781_).glId(), 0, p_410819_, 36008);
            GlStateManager._glBindBuffer(GlConst.toGl(p_410413_.type()), ((GlBuffer)p_410413_).handle);
            GlStateManager._pixelStore(3330, p_409853_);
            GlStateManager._readPixels(p_409841_, p_409880_, p_409853_, p_410558_, GlConst.toGlExternalId(p_410781_.getFormat()), GlConst.toGlType(p_410781_.getFormat()), p_410080_);
            RenderSystem.queueFencedTask(p_410081_);
            GlStateManager._glFramebufferTexture2D(36008, 36064, 3553, 0, p_410819_);
            GlStateManager._glBindFramebuffer(36008, 0);
            GlStateManager._glBindBuffer(GlConst.toGl(p_410413_.type()), 0);
            int i = GlStateManager._getError();
            if (i != 0) {
                throw new IllegalStateException("Couldn't perform copyTobuffer for texture " + p_410781_.getLabel() + ": GL error " + i);
            }
        } else {
            throw new IllegalArgumentException("Invalid mipLevel " + p_410819_ + ", must be >= 0 and < " + p_410781_.getMipLevels());
        }
    }

    @Override
    public void copyTextureToTexture(GpuTexture p_410700_, GpuTexture p_410735_, int p_410458_, int p_409803_, int p_410236_, int p_410552_, int p_410677_, int p_409870_, int p_409949_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        if (p_410458_ >= 0 && p_410458_ < p_410700_.getMipLevels() && p_410458_ < p_410735_.getMipLevels()) {
            if (p_409803_ + p_409870_ > p_410735_.getWidth(p_410458_) || p_410236_ + p_409949_ > p_410735_.getHeight(p_410458_)) {
                throw new IllegalArgumentException("Dest texture (" + p_410735_.getWidth(p_410458_) + "x" + p_410735_.getHeight(p_410458_) + ") is not large enough to write a rectangle of " + p_409870_ + "x" + p_409949_ + " at " + p_409803_ + "x" + p_410236_);
            }
            if (p_410552_ + p_409870_ > p_410700_.getWidth(p_410458_) || p_410677_ + p_409949_ > p_410700_.getHeight(p_410458_)) {
                throw new IllegalArgumentException("Source texture (" + p_410700_.getWidth(p_410458_) + "x" + p_410700_.getHeight(p_410458_) + ") is not large enough to read a rectangle of " + p_409870_ + "x" + p_409949_ + " at " + p_410552_ + "x" + p_410677_);
            }
            if (p_410700_.isClosed()) {
                throw new IllegalStateException("Source texture is closed");
            }
            if (p_410735_.isClosed()) {
                throw new IllegalStateException("Destination texture is closed");
            }
            GlStateManager.clearGlErrors();
            GlStateManager._disableScissorTest();
            boolean flag = p_410700_.getFormat().hasDepthAspect();
            int i = ((GlTexture)p_410700_).glId();
            int j = ((GlTexture)p_410735_).glId();
            boolean hasStencil = p_410700_.getFormat().hasStencilAspect();
            this.device.directStateAccess().bindFrameBufferTextures(this.readFbo, flag ? 0 : i, flag ? i : 0, 0, 0, hasStencil);
            this.device.directStateAccess().bindFrameBufferTextures(this.drawFbo, flag ? 0 : j, flag ? j : 0, 0, 0, hasStencil);
            int bufferMask = 0;
            if (p_410700_.getFormat().hasColorAspect()) {
                bufferMask |= 0x4000;
            }
            if (p_410700_.getFormat().hasDepthAspect()) {
                bufferMask |= 0x100;
            }
            if (p_410700_.getFormat().hasStencilAspect()) {
                bufferMask |= 0x400;
            }
            this.device.directStateAccess().blitFrameBuffers(this.readFbo, this.drawFbo, p_410552_, p_410677_, p_409870_, p_409949_, p_409803_, p_410236_, p_409870_, p_409949_, bufferMask, 9728);
            int k = GlStateManager._getError();
            if (k != 0) {
                throw new IllegalStateException("Couldn't perform copyToTexture for texture " + p_410700_.getLabel() + " to " + p_410735_.getLabel() + ": GL error " + k);
            }
        } else {
            throw new IllegalArgumentException("Invalid mipLevel " + p_410458_ + ", must be >= 0 and < " + p_410700_.getMipLevels() + " and < " + p_410735_.getMipLevels());
        }
    }

    @Override
    public void presentTexture(GpuTexture p_410222_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        if (!p_410222_.getFormat().hasColorAspect()) {
            throw new IllegalStateException("Cannot present a non-color texture!");
        }
        GlStateManager._disableScissorTest();
        GlStateManager._viewport(0, 0, p_410222_.getWidth(0), p_410222_.getHeight(0));
        GlStateManager._depthMask(true);
        GlStateManager._colorMask(true, true, true, true);
        this.device.directStateAccess().bindFrameBufferTextures(this.drawFbo, ((GlTexture)p_410222_).glId(), 0, 0, 0);
        this.device.directStateAccess().blitFrameBuffers(this.drawFbo, 0, 0, 0, p_410222_.getWidth(0), p_410222_.getHeight(0), 0, 0, p_410222_.getWidth(0), p_410222_.getHeight(0), 16384, 9728);
    }

    protected void executeDrawMultiple(GlRenderPass p_410685_, Collection<RenderPass.Draw> p_410004_, @Nullable GpuBuffer p_412703_, @Nullable VertexFormat.IndexType p_412751_) {
        if (this.trySetup(p_410685_)) {
            if (p_412751_ == null) {
                p_412751_ = VertexFormat.IndexType.SHORT;
            }
            for (RenderPass.Draw renderpass$draw : p_410004_) {
                Consumer<RenderPass.UniformUploader> consumer;
                VertexFormat.IndexType vertexformat$indextype = renderpass$draw.indexType() == null ? p_412751_ : renderpass$draw.indexType();
                p_410685_.setIndexBuffer(renderpass$draw.indexBuffer() == null ? p_412703_ : renderpass$draw.indexBuffer(), vertexformat$indextype);
                p_410685_.setVertexBuffer(renderpass$draw.slot(), renderpass$draw.vertexBuffer());
                if (GlRenderPass.VALIDATION) {
                    if (p_410685_.indexBuffer == null) {
                        throw new IllegalStateException("Missing index buffer");
                    }
                    if (p_410685_.indexBuffer.isClosed()) {
                        throw new IllegalStateException("Index buffer has been closed!");
                    }
                    if (p_410685_.vertexBuffers[0] == null) {
                        throw new IllegalStateException("Missing vertex buffer at slot 0");
                    }
                    if (p_410685_.vertexBuffers[0].isClosed()) {
                        throw new IllegalStateException("Vertex buffer at slot 0 has been closed!");
                    }
                }
                if ((consumer = renderpass$draw.uniformUploaderConsumer()) != null) {
                    consumer.accept((p_410696_, p_410178_) -> {
                        Uniform uniform = p_410685_.pipeline.program().getUniform(p_410696_);
                        if (uniform != null) {
                            uniform.set(p_410178_);
                            uniform.upload();
                        }
                    });
                }
                this.drawFromBuffers(p_410685_, renderpass$draw.firstIndex(), renderpass$draw.indexCount(), vertexformat$indextype, p_410685_.pipeline);
            }
        }
    }

    protected void executeDraw(GlRenderPass p_410011_, int p_410073_, int p_410287_, @Nullable VertexFormat.IndexType p_410766_) {
        if (this.trySetup(p_410011_)) {
            if (GlRenderPass.VALIDATION) {
                if (p_410766_ != null) {
                    if (p_410011_.indexBuffer == null) {
                        throw new IllegalStateException("Missing index buffer");
                    }
                    if (p_410011_.indexBuffer.isClosed()) {
                        throw new IllegalStateException("Index buffer has been closed!");
                    }
                }
                if (p_410011_.vertexBuffers[0] == null) {
                    throw new IllegalStateException("Missing vertex buffer at slot 0");
                }
                if (p_410011_.vertexBuffers[0].isClosed()) {
                    throw new IllegalStateException("Vertex buffer at slot 0 has been closed!");
                }
            }
            this.drawFromBuffers(p_410011_, p_410073_, p_410287_, p_410766_, p_410011_.pipeline);
        }
    }

    private void drawFromBuffers(GlRenderPass p_410461_, int p_410115_, int p_410829_, @Nullable VertexFormat.IndexType p_410615_, GlRenderPipeline p_409678_) {
        this.device.vertexArrayCache().bindVertexArray(p_409678_.info().getVertexFormat(), (GlBuffer)p_410461_.vertexBuffers[0]);
        if (p_410615_ != null) {
            GlStateManager._glBindBuffer(34963, ((GlBuffer)p_410461_.indexBuffer).handle);
            GlStateManager._drawElements(GlConst.toGl(p_409678_.info().getVertexFormatMode()), p_410829_, GlConst.toGl(p_410615_), (long)p_410115_ * (long)p_410615_.bytes);
        } else {
            GlStateManager._drawArrays(GlConst.toGl(p_409678_.info().getVertexFormatMode()), p_410115_, p_410829_);
        }
    }

    private boolean trySetup(GlRenderPass p_410853_) {
        boolean flag;
        if (GlRenderPass.VALIDATION) {
            if (p_410853_.pipeline == null) {
                throw new IllegalStateException("Can't draw without a render pipeline");
            }
            if (p_410853_.pipeline.program() == GlProgram.INVALID_PROGRAM) {
                throw new IllegalStateException("Pipeline contains invalid shader program");
            }
            for (RenderPipeline.UniformDescription renderpipeline$uniformdescription : p_410853_.pipeline.info().getUniforms()) {
                Object object = p_410853_.uniforms.get(renderpipeline$uniformdescription.name());
                if (object != null || GlProgram.BUILT_IN_UNIFORMS.contains(renderpipeline$uniformdescription.name())) continue;
                throw new IllegalStateException("Missing uniform " + renderpipeline$uniformdescription.name() + " (should be " + String.valueOf(renderpipeline$uniformdescription.type()) + ")");
            }
            for (String s1 : p_410853_.pipeline.program().getSamplers()) {
                if (!p_410853_.samplers.containsKey(s1)) {
                    throw new IllegalStateException("Missing sampler " + s1);
                }
                if (!p_410853_.samplers.get(s1).isClosed()) continue;
                throw new IllegalStateException("Sampler " + s1 + " has been closed!");
            }
            if (p_410853_.pipeline.info().wantsDepthTexture() && !p_410853_.hasDepthTexture()) {
                LOGGER.warn("Render pipeline {} wants a depth texture but none was provided - this is probably a bug", (Object)p_410853_.pipeline.info().getLocation());
            }
        } else if (p_410853_.pipeline == null || p_410853_.pipeline.program() == GlProgram.INVALID_PROGRAM) {
            return false;
        }
        RenderPipeline renderpipeline = p_410853_.pipeline.info();
        GlProgram glprogram = p_410853_.pipeline.program();
        for (Uniform uniform : glprogram.getUniforms()) {
            if (!p_410853_.dirtyUniforms.contains(uniform.getName())) continue;
            Object object1 = p_410853_.uniforms.get(uniform.getName());
            if (object1 instanceof int[]) {
                glprogram.safeGetUniform(uniform.getName()).set((int[])object1);
                continue;
            }
            if (object1 instanceof float[]) {
                glprogram.safeGetUniform(uniform.getName()).set((float[])object1);
                continue;
            }
            if (object1 == null) continue;
            throw new IllegalStateException("Unknown uniform type - expected " + String.valueOf(uniform.getType()) + ", found " + String.valueOf(object1));
        }
        p_410853_.dirtyUniforms.clear();
        this.applyPipelineState(renderpipeline);
        boolean bl = flag = this.lastProgram != glprogram;
        if (flag) {
            GlStateManager._glUseProgram(glprogram.getProgramId());
            this.lastProgram = glprogram;
        }
        IntList intlist = glprogram.getSamplerLocations();
        for (int j = 0; j < glprogram.getSamplers().size(); ++j) {
            String s = (String)glprogram.getSamplers().get(j);
            GlTexture gltexture = (GlTexture)p_410853_.samplers.get(s);
            if (gltexture == null) continue;
            if (flag || p_410853_.dirtySamplers.contains(s)) {
                int i = intlist.getInt(j);
                Uniform.uploadInteger((int)i, (int)j);
                GlStateManager._activeTexture(33984 + j);
            }
            GlStateManager._bindTexture(gltexture.glId());
            gltexture.flushModeChanges();
        }
        Window window = Minecraft.getInstance() == null ? null : Minecraft.getInstance().getWindow();
        glprogram.setDefaultUniforms(renderpipeline.getVertexFormatMode(), RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), window == null ? 0.0f : (float)window.getWidth(), window == null ? 0.0f : (float)window.getHeight());
        for (Uniform uniform1 : glprogram.getUniforms()) {
            uniform1.upload();
        }
        if (p_410853_.scissorState.isEnabled()) {
            GlStateManager._enableScissorTest();
            GlStateManager._scissorBox(p_410853_.scissorState.getX(), p_410853_.scissorState.getY(), p_410853_.scissorState.getWidth(), p_410853_.scissorState.getHeight());
        } else {
            GlStateManager._disableScissorTest();
        }
        StencilTest stencilTest = p_410853_.stencilTest;
        if (stencilTest != null) {
            GlStateManager._enableStencilTest();
            StencilPerFaceTest front = stencilTest.front();
            StencilPerFaceTest back = stencilTest.back();
            if (front.equals((Object)back)) {
                GlStateManager._stencilFunc(GlConst.toGl(front.compare()), stencilTest.referenceValue(), stencilTest.readMask());
                GlStateManager._stencilOp(GlConst.toGl(front.fail()), GlConst.toGl(front.depthFail()), GlConst.toGl(front.pass()));
            } else {
                GlStateManager._stencilFuncFront(GlConst.toGl(front.compare()), stencilTest.referenceValue(), stencilTest.readMask());
                GlStateManager._stencilFuncBack(GlConst.toGl(back.compare()), stencilTest.referenceValue(), stencilTest.readMask());
                GlStateManager._stencilOpFront(GlConst.toGl(front.fail()), GlConst.toGl(front.depthFail()), GlConst.toGl(front.pass()));
                GlStateManager._stencilOpBack(GlConst.toGl(back.fail()), GlConst.toGl(back.depthFail()), GlConst.toGl(back.pass()));
            }
            GlStateManager._stencilMask(stencilTest.writeMask());
        } else {
            GlStateManager._disableStencilTest();
        }
        return true;
    }

    private void applyPipelineState(RenderPipeline p_410655_) {
        if (this.lastPipeline != p_410655_) {
            this.lastPipeline = p_410655_;
            if (p_410655_.getDepthTestFunction() != DepthTestFunction.NO_DEPTH_TEST) {
                GlStateManager._enableDepthTest();
                GlStateManager._depthFunc(GlConst.toGl(p_410655_.getDepthTestFunction()));
            } else {
                GlStateManager._disableDepthTest();
            }
            if (p_410655_.isCull()) {
                GlStateManager._enableCull();
            } else {
                GlStateManager._disableCull();
            }
            if (p_410655_.getBlendFunction().isPresent()) {
                GlStateManager._enableBlend();
                BlendFunction blendfunction = p_410655_.getBlendFunction().get();
                GlStateManager._blendFuncSeparate(GlConst.toGl(blendfunction.sourceColor()), GlConst.toGl(blendfunction.destColor()), GlConst.toGl(blendfunction.sourceAlpha()), GlConst.toGl(blendfunction.destAlpha()));
            } else {
                GlStateManager._disableBlend();
            }
            GlStateManager._polygonMode(1032, GlConst.toGl(p_410655_.getPolygonMode()));
            GlStateManager._depthMask(p_410655_.isWriteDepth());
            GlStateManager._colorMask(p_410655_.isWriteColor(), p_410655_.isWriteColor(), p_410655_.isWriteColor(), p_410655_.isWriteAlpha());
            if (p_410655_.getDepthBiasConstant() == 0.0f && p_410655_.getDepthBiasScaleFactor() == 0.0f) {
                GlStateManager._disablePolygonOffset();
            } else {
                GlStateManager._polygonOffset(p_410655_.getDepthBiasScaleFactor(), p_410655_.getDepthBiasConstant());
                GlStateManager._enablePolygonOffset();
            }
            switch (p_410655_.getColorLogic()) {
                case NONE: {
                    GlStateManager._disableColorLogicOp();
                    break;
                }
                case OR_REVERSE: {
                    GlStateManager._enableColorLogicOp();
                    GlStateManager._logicOp(5387);
                }
            }
        }
    }

    public void finishRenderPass() {
        this.inRenderPass = false;
        GlStateManager._glBindFramebuffer(36160, 0);
    }

    protected GlDevice getDevice() {
        return this.device;
    }
}

