/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.mojang.blaze3d.GpuOutOfMemoryException;
import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.opengl.DirectStateAccess;
import com.mojang.blaze3d.opengl.GlBuffer;
import com.mojang.blaze3d.opengl.GlCommandEncoder;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlDebug;
import com.mojang.blaze3d.opengl.GlDebugLabel;
import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPipeline;
import com.mojang.blaze3d.opengl.GlShaderModule;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.opengl.VertexArrayCache;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.ShaderType;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ShaderDefines;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class GlDevice
implements GpuDevice {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static boolean USE_GL_ARB_vertex_attrib_binding = true;
    protected static boolean USE_GL_KHR_debug = true;
    protected static boolean USE_GL_EXT_debug_label = true;
    protected static boolean USE_GL_ARB_debug_output = true;
    protected static boolean USE_GL_ARB_direct_state_access = true;
    private final CommandEncoder encoder;
    @Nullable
    private final GlDebug debugLog;
    private final GlDebugLabel debugLabels;
    private final int maxSupportedTextureSize;
    private final DirectStateAccess directStateAccess;
    private final BiFunction<ResourceLocation, ShaderType, String> defaultShaderSource;
    private final Map<RenderPipeline, GlRenderPipeline> pipelineCache = new IdentityHashMap<RenderPipeline, GlRenderPipeline>();
    private final Map<ShaderCompilationKey, GlShaderModule> shaderCache = new HashMap<ShaderCompilationKey, GlShaderModule>();
    private final VertexArrayCache vertexArrayCache;
    private final Set<String> enabledExtensions = new HashSet<String>();

    public GlDevice(long p_410629_, int p_410525_, boolean p_409747_, BiFunction<ResourceLocation, ShaderType, String> p_410292_, boolean p_410647_) {
        GLFW.glfwMakeContextCurrent((long)p_410629_);
        GLCapabilities glcapabilities = GL.createCapabilities();
        int i = GlDevice.getMaxSupportedTextureSize();
        GLFW.glfwSetWindowSizeLimits((long)p_410629_, (int)-1, (int)-1, (int)i, (int)i);
        this.debugLog = GlDebug.enableDebugCallback((int)p_410525_, (boolean)p_409747_, this.enabledExtensions);
        this.debugLabels = GlDebugLabel.create((GLCapabilities)glcapabilities, (boolean)p_410647_, this.enabledExtensions);
        this.vertexArrayCache = VertexArrayCache.create((GLCapabilities)glcapabilities, (GlDebugLabel)this.debugLabels, this.enabledExtensions);
        this.directStateAccess = DirectStateAccess.create(glcapabilities, this.enabledExtensions);
        this.maxSupportedTextureSize = i;
        this.defaultShaderSource = p_410292_;
        this.encoder = new GlCommandEncoder(this);
    }

    public GlDebugLabel debugLabels() {
        return this.debugLabels;
    }

    public CommandEncoder createCommandEncoder() {
        return this.encoder;
    }

    public GpuTexture createTexture(@Nullable Supplier<String> p_410823_, TextureFormat p_409632_, int p_410064_, int p_410837_, int p_410395_) {
        return this.createTexture(this.debugLabels.exists() && p_410823_ != null ? p_410823_.get() : null, p_409632_, p_410064_, p_410837_, p_410395_);
    }

    public GpuTexture createTexture(@Nullable String p_409908_, TextureFormat p_410264_, int p_410354_, int p_410141_, int p_410230_) {
        if (p_410230_ < 1) {
            throw new IllegalArgumentException("mipLevels must be at least 1");
        }
        GlStateManager.clearGlErrors();
        int i = GlStateManager._genTexture();
        if (p_409908_ == null) {
            p_409908_ = String.valueOf(i);
        }
        GlStateManager._bindTexture(i);
        GlStateManager._texParameter(3553, 33085, p_410230_ - 1);
        GlStateManager._texParameter(3553, 33082, 0);
        GlStateManager._texParameter(3553, 33083, p_410230_ - 1);
        if (p_410264_.hasDepthAspect()) {
            GlStateManager._texParameter(3553, 34892, 0);
        }
        for (int j = 0; j < p_410230_; ++j) {
            GlStateManager._texImage2D(3553, j, GlConst.toGlInternalId(p_410264_), p_410354_ >> j, p_410141_ >> j, 0, GlConst.toGlExternalId(p_410264_), GlConst.toGlType(p_410264_), null);
        }
        int k = GlStateManager._getError();
        if (k == 1285) {
            throw new GpuOutOfMemoryException("Could not allocate texture of " + p_410354_ + "x" + p_410141_ + " for " + p_409908_);
        }
        if (k != 0) {
            throw new IllegalStateException("OpenGL error " + k);
        }
        GlTexture gltexture = new GlTexture(p_409908_, p_410264_, p_410354_, p_410141_, p_410230_, i);
        this.debugLabels.applyLabel(gltexture);
        return gltexture;
    }

    public GpuTexture createExternalTexture(@Nullable String label, int nativeId) {
        int nextWidth;
        int previousBinding = GL11.glGetInteger((int)32873);
        GL11.glBindTexture((int)3553, (int)nativeId);
        TextureFormat format = null;
        int internalFormat = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4099);
        for (TextureFormat candidate : TextureFormat.values()) {
            if (GlConst.toGlInternalId(candidate) != internalFormat && GlConst.toGlExternalId(candidate) != internalFormat) continue;
            format = candidate;
            break;
        }
        if (format == null) {
            GL11.glBindTexture((int)3553, (int)previousBinding);
            throw new IllegalArgumentException("Couldn't find a matching vanilla TextureFormat for OpenGL internal format id " + internalFormat);
        }
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int mipLevels = 1;
        int mipWidth = width;
        while (mipWidth > 1 && (nextWidth = GL11.glGetTexLevelParameteri((int)3553, (int)mipLevels, (int)4096)) != 0) {
            ++mipLevels;
            mipWidth = nextWidth;
        }
        GL11.glBindTexture((int)3553, (int)previousBinding);
        return this.createExternalTexture(label, format, width, height, mipLevels, nativeId);
    }

    public GpuTexture createExternalTexture(@Nullable String label, TextureFormat format, int width, int height, int mipLevels, int nativeId) {
        if (label == null) {
            label = String.valueOf(nativeId);
        }
        GlTexture gltexture = new GlTexture(label, format, width, height, mipLevels, nativeId, true);
        this.debugLabels.applyLabel(gltexture);
        return gltexture;
    }

    public GpuBuffer createBuffer(@Nullable Supplier<String> p_409705_, BufferType p_409714_, BufferUsage p_409894_, int p_410348_) {
        if (p_410348_ <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than zero");
        }
        return new GlBuffer(this.debugLabels, p_409705_, p_409714_, p_409894_, p_410348_, GlStateManager._glGenBuffers());
    }

    public GpuBuffer createBuffer(@Nullable Supplier<String> p_410492_, BufferType p_410400_, BufferUsage p_409641_, ByteBuffer p_410794_) {
        if (!p_410794_.hasRemaining()) {
            throw new IllegalArgumentException("Buffer source must not be empty");
        }
        GlBuffer glbuffer = new GlBuffer(this.debugLabels, p_410492_, p_410400_, p_409641_, p_410794_.remaining(), GlStateManager._glGenBuffers());
        this.encoder.writeToBuffer((GpuBuffer)glbuffer, p_410794_, 0);
        return glbuffer;
    }

    public String getImplementationInformation() {
        return GLFW.glfwGetCurrentContext() == 0L ? "NO CONTEXT" : GlStateManager._getString(7937) + " GL version " + GlStateManager._getString(7938) + ", " + GlStateManager._getString(7936);
    }

    public List<String> getLastDebugMessages() {
        return this.debugLog == null ? Collections.emptyList() : this.debugLog.getLastOpenGlDebugMessages();
    }

    public boolean isDebuggingEnabled() {
        return this.debugLog != null;
    }

    public String getRenderer() {
        return GlStateManager._getString(7937);
    }

    public String getVendor() {
        return GlStateManager._getString(7936);
    }

    public String getBackendName() {
        return "OpenGL";
    }

    public String getVersion() {
        return GlStateManager._getString(7938);
    }

    private static int getMaxSupportedTextureSize() {
        int i = GlStateManager._getInteger(3379);
        for (int j = Math.max(32768, i); j >= 1024; j >>= 1) {
            GlStateManager._texImage2D(32868, 0, 6408, j, j, 0, 6408, 5121, null);
            int k = GlStateManager._getTexLevelParameter(32868, 0, 4096);
            if (k == 0) continue;
            return j;
        }
        int l = Math.max(i, 1024);
        LOGGER.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)l);
        return l;
    }

    public int getMaxTextureSize() {
        return this.maxSupportedTextureSize;
    }

    public void clearPipelineCache() {
        for (GlRenderPipeline glrenderpipeline : this.pipelineCache.values()) {
            if (glrenderpipeline.program() == GlProgram.INVALID_PROGRAM) continue;
            glrenderpipeline.program().close();
        }
        this.pipelineCache.clear();
        for (GlShaderModule glshadermodule : this.shaderCache.values()) {
            if (glshadermodule == GlShaderModule.INVALID_SHADER) continue;
            glshadermodule.close();
        }
        this.shaderCache.clear();
    }

    public List<String> getEnabledExtensions() {
        return new ArrayList<String>(this.enabledExtensions);
    }

    public void close() {
        this.clearPipelineCache();
    }

    public DirectStateAccess directStateAccess() {
        return this.directStateAccess;
    }

    protected GlRenderPipeline getOrCompilePipeline(RenderPipeline p_410397_) {
        return this.pipelineCache.computeIfAbsent(p_410397_, p_410866_ -> this.compilePipeline(p_410397_, this.defaultShaderSource));
    }

    protected GlShaderModule getOrCompileShader(ResourceLocation p_410881_, ShaderType p_409876_, ShaderDefines p_410398_, BiFunction<ResourceLocation, ShaderType, String> p_410158_) {
        ShaderCompilationKey gldevice$shadercompilationkey = new ShaderCompilationKey(p_410881_, p_409876_, p_410398_);
        return this.shaderCache.computeIfAbsent(gldevice$shadercompilationkey, p_410725_ -> this.compileShader(gldevice$shadercompilationkey, p_410158_));
    }

    public GlRenderPipeline precompilePipeline(RenderPipeline p_410489_, @Nullable BiFunction<ResourceLocation, ShaderType, String> p_410134_) {
        BiFunction<ResourceLocation, ShaderType, String> bifunction = p_410134_ == null ? this.defaultShaderSource : p_410134_;
        return this.pipelineCache.computeIfAbsent(p_410489_, p_410619_ -> this.compilePipeline(p_410489_, bifunction));
    }

    private GlShaderModule compileShader(ShaderCompilationKey p_410649_, BiFunction<ResourceLocation, ShaderType, String> p_409708_) {
        String s = p_409708_.apply(p_410649_.id, p_410649_.type);
        if (s == null) {
            LOGGER.error("Couldn't find source for {} shader ({})", (Object)p_410649_.type, (Object)p_410649_.id);
            return GlShaderModule.INVALID_SHADER;
        }
        String s1 = GlslPreprocessor.injectDefines((String)s, (ShaderDefines)p_410649_.defines);
        int i = GlStateManager.glCreateShader(GlConst.toGl(p_410649_.type));
        GlStateManager.glShaderSource(i, s1);
        GlStateManager.glCompileShader(i);
        if (GlStateManager.glGetShaderi(i, 35713) == 0) {
            String s2 = StringUtils.trim((String)GlStateManager.glGetShaderInfoLog(i, 32768));
            LOGGER.error("Couldn't compile {} shader ({}): {}", new Object[]{p_410649_.type.getName(), p_410649_.id, s2});
            return GlShaderModule.INVALID_SHADER;
        }
        GlShaderModule glshadermodule = new GlShaderModule(i, p_410649_.id, p_410649_.type);
        this.debugLabels.applyLabel(glshadermodule);
        return glshadermodule;
    }

    private GlRenderPipeline compilePipeline(RenderPipeline p_409588_, BiFunction<ResourceLocation, ShaderType, String> p_410709_) {
        GlProgram glprogram;
        GlShaderModule glshadermodule = this.getOrCompileShader(p_409588_.getVertexShader(), ShaderType.VERTEX, p_409588_.getShaderDefines(), p_410709_);
        GlShaderModule glshadermodule1 = this.getOrCompileShader(p_409588_.getFragmentShader(), ShaderType.FRAGMENT, p_409588_.getShaderDefines(), p_410709_);
        if (glshadermodule == GlShaderModule.INVALID_SHADER) {
            LOGGER.error("Couldn't compile pipeline {}: vertex shader {} was invalid", (Object)p_409588_.getLocation(), (Object)p_409588_.getVertexShader());
            return new GlRenderPipeline(p_409588_, GlProgram.INVALID_PROGRAM);
        }
        if (glshadermodule1 == GlShaderModule.INVALID_SHADER) {
            LOGGER.error("Couldn't compile pipeline {}: fragment shader {} was invalid", (Object)p_409588_.getLocation(), (Object)p_409588_.getFragmentShader());
            return new GlRenderPipeline(p_409588_, GlProgram.INVALID_PROGRAM);
        }
        try {
            glprogram = GlProgram.link((GlShaderModule)glshadermodule, (GlShaderModule)glshadermodule1, (VertexFormat)p_409588_.getVertexFormat(), (String)p_409588_.getLocation().toString());
        }
        catch (ShaderManager.CompilationException shadermanager$compilationexception) {
            LOGGER.error("Couldn't compile program for pipeline {}: {}", (Object)p_409588_.getLocation(), (Object)shadermanager$compilationexception);
            return new GlRenderPipeline(p_409588_, GlProgram.INVALID_PROGRAM);
        }
        glprogram.setupUniforms(p_409588_.getUniforms(), p_409588_.getSamplers());
        this.debugLabels.applyLabel(glprogram);
        return new GlRenderPipeline(p_409588_, glprogram);
    }

    public VertexArrayCache vertexArrayCache() {
        return this.vertexArrayCache;
    }

    @OnlyIn(value=Dist.CLIENT)
    record ShaderCompilationKey(ResourceLocation id, ShaderType type, ShaderDefines defines) {
        @Override
        public String toString() {
            String s = String.valueOf(this.id) + " (" + String.valueOf(this.type) + ")";
            return !this.defines.isEmpty() ? s + " with " + String.valueOf(this.defines) : s;
        }
    }
}

