/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.opengl.GlCommandEncoder;
import com.mojang.blaze3d.opengl.GlRenderPipeline;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.systems.ScissorState;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.stencil.StencilTest;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class GlRenderPass
implements RenderPass {
    protected static final int MAX_VERTEX_BUFFERS = 1;
    public static final boolean VALIDATION = SharedConstants.IS_RUNNING_IN_IDE && !Boolean.getBoolean("neoforge.disableGlValidation");
    private final GlCommandEncoder encoder;
    private final boolean hasDepthTexture;
    private boolean closed;
    @Nullable
    protected GlRenderPipeline pipeline;
    protected final GpuBuffer[] vertexBuffers = new GpuBuffer[1];
    @Nullable
    protected GpuBuffer indexBuffer;
    protected VertexFormat.IndexType indexType = VertexFormat.IndexType.INT;
    protected final ScissorState scissorState = new ScissorState();
    protected final HashMap<String, Object> uniforms = new HashMap();
    protected final HashMap<String, GpuTexture> samplers = new HashMap();
    protected final Set<String> dirtyUniforms = new HashSet<String>();
    protected final Set<String> dirtySamplers = new HashSet<String>();
    @Nullable
    protected StencilTest stencilTest;

    public GlRenderPass(GlCommandEncoder p_409888_, boolean p_410304_) {
        this.encoder = p_409888_;
        this.hasDepthTexture = p_410304_;
    }

    public boolean hasDepthTexture() {
        return this.hasDepthTexture;
    }

    @Override
    public void setPipeline(RenderPipeline p_409823_) {
        p_409823_ = RenderSystem.applyPipelineModifiers(p_409823_);
        if (this.pipeline == null || this.pipeline.info() != p_409823_) {
            this.dirtyUniforms.addAll(this.uniforms.keySet());
            this.dirtySamplers.addAll(this.samplers.keySet());
        }
        this.pipeline = this.encoder.getDevice().getOrCompilePipeline(p_409823_);
    }

    @Override
    public void bindSampler(String p_410267_, GpuTexture p_410320_) {
        this.samplers.put(p_410267_, p_410320_);
        this.dirtySamplers.add(p_410267_);
    }

    @Override
    public void setUniform(String p_410095_, int ... p_410374_) {
        this.uniforms.put(p_410095_, p_410374_);
        this.dirtyUniforms.add(p_410095_);
    }

    @Override
    public void setUniform(String p_409689_, float ... p_410360_) {
        this.uniforms.put(p_409689_, p_410360_);
        this.dirtyUniforms.add(p_409689_);
    }

    @Override
    public void setUniform(String p_410717_, Matrix4f p_409843_) {
        this.uniforms.put(p_410717_, p_409843_.get(new float[16]));
        this.dirtyUniforms.add(p_410717_);
    }

    @Override
    public void enableScissor(ScissorState p_409626_) {
        this.scissorState.copyFrom(p_409626_);
    }

    @Override
    public void enableScissor(int p_409849_, int p_410447_, int p_410110_, int p_410679_) {
        this.scissorState.enable(p_409849_, p_410447_, p_410110_, p_410679_);
    }

    @Override
    public void disableScissor() {
        this.scissorState.disable();
    }

    @Override
    public void enableStencilTest(StencilTest stencilTest) {
        this.stencilTest = stencilTest;
    }

    @Override
    public void disableStencilTest() {
        this.stencilTest = null;
    }

    @Override
    public void setVertexBuffer(int p_410797_, GpuBuffer p_410501_) {
        if (p_410797_ < 0 || p_410797_ >= 1) {
            throw new IllegalArgumentException("Vertex buffer slot is out of range: " + p_410797_);
        }
        this.vertexBuffers[p_410797_] = p_410501_;
    }

    @Override
    public void setIndexBuffer(@Nullable GpuBuffer p_410828_, VertexFormat.IndexType p_410040_) {
        this.indexBuffer = p_410828_;
        this.indexType = p_410040_;
    }

    @Override
    public void drawIndexed(int p_410452_, int p_410034_) {
        if (this.closed) {
            throw new IllegalStateException("Can't use a closed render pass");
        }
        this.encoder.executeDraw(this, p_410452_, p_410034_, this.indexType);
    }

    @Override
    public void drawMultipleIndexed(Collection<RenderPass.Draw> p_410499_, @Nullable GpuBuffer p_412214_, @Nullable VertexFormat.IndexType p_412273_) {
        if (this.closed) {
            throw new IllegalStateException("Can't use a closed render pass");
        }
        this.encoder.executeDrawMultiple(this, p_410499_, p_412214_, p_412273_);
    }

    @Override
    public void draw(int p_410870_, int p_410463_) {
        if (this.closed) {
            throw new IllegalStateException("Can't use a closed render pass");
        }
        this.encoder.executeDraw(this, p_410870_, p_410463_, null);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.encoder.finishRenderPass();
        }
    }
}

