/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.mojang.blaze3d.opengl.DirectStateAccess;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import javax.annotation.Nullable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlTexture
extends GpuTexture {
    protected final int id;
    private final Int2IntMap fboCache = new Int2IntOpenHashMap();
    protected boolean closed;
    protected boolean modesDirty = true;
    protected final boolean external;

    protected GlTexture(String p_410238_, TextureFormat p_410416_, int p_409690_, int p_409866_, int p_410468_, int p_409791_) {
        this(p_410238_, p_410416_, p_409690_, p_409866_, p_410468_, p_409791_, false);
    }

    protected GlTexture(String p_410238_, TextureFormat p_410416_, int p_409690_, int p_409866_, int p_410468_, int p_409791_, boolean external) {
        super(p_410238_, p_410416_, p_409690_, p_409866_, p_410468_);
        this.id = p_409791_;
        this.external = external;
    }

    public void close() {
        if (!this.closed && !this.external) {
            this.closed = true;
            GlStateManager._deleteTexture(this.id);
            IntIterator intIterator = this.fboCache.values().iterator();
            while (intIterator.hasNext()) {
                int i = (Integer)intIterator.next();
                GlStateManager._glDeleteFramebuffers(i);
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getFbo(DirectStateAccess p_412345_, @Nullable GpuTexture p_410364_) {
        int i = p_410364_ == null ? 0 : ((GlTexture)p_410364_).id;
        boolean useStencil = p_410364_ != null && p_410364_.getFormat().hasStencilAspect();
        return this.fboCache.computeIfAbsent(i, p_411998_ -> {
            int j = p_412345_.createFrameBufferObject();
            p_412345_.bindFrameBufferTextures(j, this.id, i, 0, 0, useStencil);
            return j;
        });
    }

    public void flushModeChanges() {
        if (this.modesDirty) {
            GlStateManager._texParameter(3553, 10242, GlConst.toGl(this.addressModeU));
            GlStateManager._texParameter(3553, 10243, GlConst.toGl(this.addressModeV));
            switch (this.minFilter) {
                case NEAREST: {
                    GlStateManager._texParameter(3553, 10241, this.useMipmaps ? 9986 : 9728);
                    break;
                }
                case LINEAR: {
                    GlStateManager._texParameter(3553, 10241, this.useMipmaps ? 9987 : 9729);
                }
            }
            switch (this.magFilter) {
                case NEAREST: {
                    GlStateManager._texParameter(3553, 10240, 9728);
                    break;
                }
                case LINEAR: {
                    GlStateManager._texParameter(3553, 10240, 9729);
                }
            }
            this.modesDirty = false;
        }
    }

    public int glId() {
        return this.id;
    }

    public void setAddressMode(AddressMode p_409820_, AddressMode p_409765_) {
        super.setAddressMode(p_409820_, p_409765_);
        this.modesDirty = true;
    }

    public void setTextureFilter(FilterMode p_410846_, FilterMode p_409662_, boolean p_410630_) {
        super.setTextureFilter(p_410846_, p_409662_, p_410630_);
        this.modesDirty = true;
    }
}

