/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.pipeline;

import com.mojang.blaze3d.DontObfuscate;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.LogicOp;
import com.mojang.blaze3d.platform.PolygonMode;
import com.mojang.blaze3d.shaders.UniformType;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.ShaderDefines;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@DontObfuscate
public class RenderPipeline {
    private final ResourceLocation location;
    private final ResourceLocation vertexShader;
    private final ResourceLocation fragmentShader;
    private final ShaderDefines shaderDefines;
    private final List<String> samplers;
    private final List<UniformDescription> uniforms;
    private final DepthTestFunction depthTestFunction;
    private final PolygonMode polygonMode;
    private final boolean cull;
    private final LogicOp colorLogic;
    private final Optional<BlendFunction> blendFunction;
    private final boolean writeColor;
    private final boolean writeAlpha;
    private final boolean writeDepth;
    private final VertexFormat vertexFormat;
    private final VertexFormat.Mode vertexFormatMode;
    private final float depthBiasScaleFactor;
    private final float depthBiasConstant;

    protected RenderPipeline(ResourceLocation p_405403_, ResourceLocation p_405389_, ResourceLocation p_404945_, ShaderDefines p_405426_, List<String> p_405334_, List<UniformDescription> p_404693_, Optional<BlendFunction> p_404667_, DepthTestFunction p_410224_, PolygonMode p_409822_, boolean p_404907_, boolean p_405688_, boolean p_405411_, boolean p_405477_, LogicOp p_410051_, VertexFormat p_405109_, VertexFormat.Mode p_404708_, float p_410755_, float p_409999_) {
        this.location = p_405403_;
        this.vertexShader = p_405389_;
        this.fragmentShader = p_404945_;
        this.shaderDefines = p_405426_;
        this.samplers = p_405334_;
        this.uniforms = p_404693_;
        this.depthTestFunction = p_410224_;
        this.polygonMode = p_409822_;
        this.cull = p_404907_;
        this.blendFunction = p_404667_;
        this.writeColor = p_405688_;
        this.writeAlpha = p_405411_;
        this.writeDepth = p_405477_;
        this.colorLogic = p_410051_;
        this.vertexFormat = p_405109_;
        this.vertexFormatMode = p_404708_;
        this.depthBiasScaleFactor = p_410755_;
        this.depthBiasConstant = p_409999_;
    }

    public String toString() {
        return this.location.toString();
    }

    public DepthTestFunction getDepthTestFunction() {
        return this.depthTestFunction;
    }

    public PolygonMode getPolygonMode() {
        return this.polygonMode;
    }

    public boolean isCull() {
        return this.cull;
    }

    public LogicOp getColorLogic() {
        return this.colorLogic;
    }

    public Optional<BlendFunction> getBlendFunction() {
        return this.blendFunction;
    }

    public boolean isWriteColor() {
        return this.writeColor;
    }

    public boolean isWriteAlpha() {
        return this.writeAlpha;
    }

    public boolean isWriteDepth() {
        return this.writeDepth;
    }

    public float getDepthBiasScaleFactor() {
        return this.depthBiasScaleFactor;
    }

    public float getDepthBiasConstant() {
        return this.depthBiasConstant;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    public VertexFormat.Mode getVertexFormatMode() {
        return this.vertexFormatMode;
    }

    public ResourceLocation getVertexShader() {
        return this.vertexShader;
    }

    public ResourceLocation getFragmentShader() {
        return this.fragmentShader;
    }

    public ShaderDefines getShaderDefines() {
        return this.shaderDefines;
    }

    public List<String> getSamplers() {
        return this.samplers;
    }

    public List<UniformDescription> getUniforms() {
        return this.uniforms;
    }

    public boolean wantsDepthTexture() {
        return this.depthTestFunction != DepthTestFunction.NO_DEPTH_TEST || this.depthBiasConstant != 0.0f || this.depthBiasScaleFactor != 0.0f || this.writeDepth;
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.location = Optional.of(this.location);
        builder.fragmentShader = Optional.of(this.fragmentShader);
        builder.vertexShader = Optional.of(this.vertexShader);
        if (!this.shaderDefines.isEmpty()) {
            ShaderDefines.Builder defBuilder = ShaderDefines.builder();
            for (Map.Entry entry : this.shaderDefines.values().entrySet()) {
                defBuilder.define((String)entry.getKey(), (String)entry.getValue());
            }
            for (String flag : this.shaderDefines.flags()) {
                defBuilder.define(flag);
            }
            builder.definesBuilder = Optional.of(defBuilder);
        }
        if (!this.samplers.isEmpty()) {
            builder.samplers = Optional.of(new ArrayList<String>(this.samplers));
        }
        if (!this.uniforms.isEmpty()) {
            builder.uniforms = Optional.of(new ArrayList<UniformDescription>(this.uniforms));
        }
        builder.depthTestFunction = Optional.of(this.depthTestFunction);
        builder.polygonMode = Optional.of(this.polygonMode);
        builder.cull = Optional.of(this.cull);
        builder.writeColor = Optional.of(this.writeColor);
        builder.writeAlpha = Optional.of(this.writeAlpha);
        builder.writeDepth = Optional.of(this.writeDepth);
        builder.colorLogic = Optional.of(this.colorLogic);
        builder.blendFunction = this.blendFunction;
        builder.vertexFormat = Optional.of(this.vertexFormat);
        builder.vertexFormatMode = Optional.of(this.vertexFormatMode);
        builder.depthBiasScaleFactor = this.depthBiasScaleFactor;
        builder.depthBiasConstant = this.depthBiasConstant;
        return builder;
    }

    public static Builder builder(Snippet ... p_405781_) {
        Builder renderpipeline$builder = new Builder();
        for (Snippet renderpipeline$snippet : p_405781_) {
            renderpipeline$builder.withSnippet(renderpipeline$snippet);
        }
        return renderpipeline$builder;
    }

    @OnlyIn(value=Dist.CLIENT)
    @DontObfuscate
    public static class Builder {
        private Optional<ResourceLocation> location = Optional.empty();
        private Optional<ResourceLocation> fragmentShader = Optional.empty();
        private Optional<ResourceLocation> vertexShader = Optional.empty();
        private Optional<ShaderDefines.Builder> definesBuilder = Optional.empty();
        private Optional<List<String>> samplers = Optional.empty();
        private Optional<List<UniformDescription>> uniforms = Optional.empty();
        private Optional<DepthTestFunction> depthTestFunction = Optional.empty();
        private Optional<PolygonMode> polygonMode = Optional.empty();
        private Optional<Boolean> cull = Optional.empty();
        private Optional<Boolean> writeColor = Optional.empty();
        private Optional<Boolean> writeAlpha = Optional.empty();
        private Optional<Boolean> writeDepth = Optional.empty();
        private Optional<LogicOp> colorLogic = Optional.empty();
        private Optional<BlendFunction> blendFunction = Optional.empty();
        private Optional<VertexFormat> vertexFormat = Optional.empty();
        private Optional<VertexFormat.Mode> vertexFormatMode = Optional.empty();
        private float depthBiasScaleFactor;
        private float depthBiasConstant;

        Builder() {
        }

        public Builder withLocation(String p_405348_) {
            this.location = Optional.of(ResourceLocation.withDefaultNamespace(p_405348_));
            return this;
        }

        public Builder withLocation(ResourceLocation p_405313_) {
            this.location = Optional.of(p_405313_);
            return this;
        }

        public Builder withFragmentShader(String p_405346_) {
            this.fragmentShader = Optional.of(ResourceLocation.withDefaultNamespace(p_405346_));
            return this;
        }

        public Builder withFragmentShader(ResourceLocation p_405443_) {
            this.fragmentShader = Optional.of(p_405443_);
            return this;
        }

        public Builder withVertexShader(String p_405325_) {
            this.vertexShader = Optional.of(ResourceLocation.withDefaultNamespace(p_405325_));
            return this;
        }

        public Builder withVertexShader(ResourceLocation p_405143_) {
            this.vertexShader = Optional.of(p_405143_);
            return this;
        }

        public Builder withShaderDefine(String p_405063_) {
            if (this.definesBuilder.isEmpty()) {
                this.definesBuilder = Optional.of(ShaderDefines.builder());
            }
            this.definesBuilder.get().define(p_405063_);
            return this;
        }

        public Builder withShaderDefine(String p_405578_, int p_404886_) {
            if (this.definesBuilder.isEmpty()) {
                this.definesBuilder = Optional.of(ShaderDefines.builder());
            }
            this.definesBuilder.get().define(p_405578_, p_404886_);
            return this;
        }

        public Builder withShaderDefine(String p_405342_, float p_404699_) {
            if (this.definesBuilder.isEmpty()) {
                this.definesBuilder = Optional.of(ShaderDefines.builder());
            }
            this.definesBuilder.get().define(p_405342_, p_404699_);
            return this;
        }

        public Builder withSampler(String p_405103_) {
            if (this.samplers.isEmpty()) {
                this.samplers = Optional.of(new ArrayList());
            }
            this.samplers.get().add(p_405103_);
            return this;
        }

        public Builder withUniform(String p_405111_, UniformType p_410370_) {
            if (this.uniforms.isEmpty()) {
                this.uniforms = Optional.of(new ArrayList());
            }
            this.uniforms.get().add(new UniformDescription(p_405111_, p_410370_));
            return this;
        }

        public Builder withDepthTestFunction(DepthTestFunction p_410838_) {
            this.depthTestFunction = Optional.of(p_410838_);
            return this;
        }

        public Builder withPolygonMode(PolygonMode p_410375_) {
            this.polygonMode = Optional.of(p_410375_);
            return this;
        }

        public Builder withCull(boolean p_404683_) {
            this.cull = Optional.of(p_404683_);
            return this;
        }

        public Builder withBlend(BlendFunction p_404892_) {
            this.blendFunction = Optional.of(p_404892_);
            return this;
        }

        public Builder withoutBlend() {
            this.blendFunction = Optional.empty();
            return this;
        }

        public Builder withColorWrite(boolean p_405003_) {
            this.writeColor = Optional.of(p_405003_);
            this.writeAlpha = Optional.of(p_405003_);
            return this;
        }

        public Builder withColorWrite(boolean p_405874_, boolean p_405301_) {
            this.writeColor = Optional.of(p_405874_);
            this.writeAlpha = Optional.of(p_405301_);
            return this;
        }

        public Builder withDepthWrite(boolean p_405817_) {
            this.writeDepth = Optional.of(p_405817_);
            return this;
        }

        public Builder withColorLogic(LogicOp p_410366_) {
            this.colorLogic = Optional.of(p_410366_);
            return this;
        }

        public Builder withVertexFormat(VertexFormat p_405022_, VertexFormat.Mode p_405878_) {
            this.vertexFormat = Optional.of(p_405022_);
            this.vertexFormatMode = Optional.of(p_405878_);
            return this;
        }

        public Builder withDepthBias(float p_410793_, float p_410207_) {
            this.depthBiasScaleFactor = p_410793_;
            this.depthBiasConstant = p_410207_;
            return this;
        }

        void withSnippet(Snippet p_405255_) {
            if (p_405255_.vertexShader.isPresent()) {
                this.vertexShader = p_405255_.vertexShader;
            }
            if (p_405255_.fragmentShader.isPresent()) {
                this.fragmentShader = p_405255_.fragmentShader;
            }
            if (p_405255_.shaderDefines.isPresent()) {
                if (this.definesBuilder.isEmpty()) {
                    this.definesBuilder = Optional.of(ShaderDefines.builder());
                }
                ShaderDefines shaderdefines = p_405255_.shaderDefines.get();
                for (Map.Entry entry : shaderdefines.values().entrySet()) {
                    this.definesBuilder.get().define((String)entry.getKey(), (String)entry.getValue());
                }
                for (String s : shaderdefines.flags()) {
                    this.definesBuilder.get().define(s);
                }
            }
            p_405255_.samplers.ifPresent(p_405714_ -> {
                if (this.samplers.isPresent()) {
                    this.samplers.get().addAll((Collection<String>)p_405714_);
                } else {
                    this.samplers = Optional.of(new ArrayList(p_405714_));
                }
            });
            p_405255_.uniforms.ifPresent(p_405104_ -> {
                if (this.uniforms.isPresent()) {
                    this.uniforms.get().addAll((Collection<UniformDescription>)p_405104_);
                } else {
                    this.uniforms = Optional.of(new ArrayList(p_405104_));
                }
            });
            if (p_405255_.depthTestFunction.isPresent()) {
                this.depthTestFunction = p_405255_.depthTestFunction;
            }
            if (p_405255_.cull.isPresent()) {
                this.cull = p_405255_.cull;
            }
            if (p_405255_.writeColor.isPresent()) {
                this.writeColor = p_405255_.writeColor;
            }
            if (p_405255_.writeAlpha.isPresent()) {
                this.writeAlpha = p_405255_.writeAlpha;
            }
            if (p_405255_.writeDepth.isPresent()) {
                this.writeDepth = p_405255_.writeDepth;
            }
            if (p_405255_.colorLogic.isPresent()) {
                this.colorLogic = p_405255_.colorLogic;
            }
            if (p_405255_.blendFunction.isPresent()) {
                this.blendFunction = p_405255_.blendFunction;
            }
            if (p_405255_.vertexFormat.isPresent()) {
                this.vertexFormat = p_405255_.vertexFormat;
            }
            if (p_405255_.vertexFormatMode.isPresent()) {
                this.vertexFormatMode = p_405255_.vertexFormatMode;
            }
        }

        public Snippet buildSnippet() {
            return new Snippet(this.vertexShader, this.fragmentShader, this.definesBuilder.map(ShaderDefines.Builder::build), this.samplers.map(Collections::unmodifiableList), this.uniforms.map(Collections::unmodifiableList), this.blendFunction, this.depthTestFunction, this.polygonMode, this.cull, this.writeColor, this.writeAlpha, this.writeDepth, this.colorLogic, this.vertexFormat, this.vertexFormatMode);
        }

        public RenderPipeline build() {
            if (this.location.isEmpty()) {
                throw new IllegalStateException("Missing location");
            }
            if (this.vertexShader.isEmpty()) {
                throw new IllegalStateException("Missing vertex shader");
            }
            if (this.fragmentShader.isEmpty()) {
                throw new IllegalStateException("Missing fragment shader");
            }
            if (this.vertexFormat.isEmpty()) {
                throw new IllegalStateException("Missing vertex buffer format");
            }
            if (this.vertexFormatMode.isEmpty()) {
                throw new IllegalStateException("Missing vertex mode");
            }
            return new RenderPipeline(this.location.get(), this.vertexShader.get(), this.fragmentShader.get(), this.definesBuilder.orElse(ShaderDefines.builder()).build(), List.copyOf(this.samplers.orElse(new ArrayList())), this.uniforms.orElse(Collections.emptyList()), this.blendFunction, this.depthTestFunction.orElse(DepthTestFunction.LEQUAL_DEPTH_TEST), this.polygonMode.orElse(PolygonMode.FILL), this.cull.orElse(true), this.writeColor.orElse(true), this.writeAlpha.orElse(true), this.writeDepth.orElse(true), this.colorLogic.orElse(LogicOp.NONE), this.vertexFormat.get(), this.vertexFormatMode.get(), this.depthBiasScaleFactor, this.depthBiasConstant);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @DontObfuscate
    public record Snippet(Optional<ResourceLocation> vertexShader, Optional<ResourceLocation> fragmentShader, Optional<ShaderDefines> shaderDefines, Optional<List<String>> samplers, Optional<List<UniformDescription>> uniforms, Optional<BlendFunction> blendFunction, Optional<DepthTestFunction> depthTestFunction, Optional<PolygonMode> polygonMode, Optional<Boolean> cull, Optional<Boolean> writeColor, Optional<Boolean> writeAlpha, Optional<Boolean> writeDepth, Optional<LogicOp> colorLogic, Optional<VertexFormat> vertexFormat, Optional<VertexFormat.Mode> vertexFormatMode) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @DontObfuscate
    public record UniformDescription(String name, UniformType type) {
    }
}

