/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.mojang.blaze3d.DontObfuscate;
import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.TracyFrameCapture;
import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuFence;
import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.shaders.ShaderType;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.ScissorState;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ArrayListDeque;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.pipeline.PipelineModifier;
import net.neoforged.neoforge.client.pipeline.PipelineModifierStack;
import net.neoforged.neoforge.client.stencil.StencilTest;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@DontObfuscate
public class RenderSystem {
    public static final ScissorState SCISSOR_STATE = new ScissorState();
    @Nullable
    public static StencilTest STENCIL_TEST = null;
    static final Logger LOGGER = LogUtils.getLogger();
    public static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    @Nullable
    private static Thread renderThread;
    @Nullable
    private static GpuDevice DEVICE;
    private static double lastDrawTime;
    private static final AutoStorageIndexBuffer sharedSequential;
    private static final AutoStorageIndexBuffer sharedSequentialQuad;
    private static final AutoStorageIndexBuffer sharedSequentialLines;
    private static Matrix4f projectionMatrix;
    private static Matrix4f savedProjectionMatrix;
    private static ProjectionType projectionType;
    private static ProjectionType savedProjectionType;
    private static final Matrix4fStack modelViewStack;
    private static Matrix4f textureMatrix;
    public static final int TEXTURE_COUNT = 12;
    private static final GpuTexture[] shaderTextures;
    private static final float[] shaderColor;
    private static float shaderGlintAlpha;
    private static FogParameters shaderFog;
    private static final Vector3f[] shaderLightDirections;
    private static float shaderGameTime;
    private static final Vector3f modelOffset;
    private static float shaderLineWidth;
    private static String apiDescription;
    private static final AtomicLong pollEventsWaitStart;
    private static final AtomicBoolean pollingEvents;
    @Nullable
    private static GpuBuffer QUAD_VERTEX_BUFFER;
    private static final ArrayListDeque<GpuAsyncTask> PENDING_FENCES;
    private static final PipelineModifierStack PIPELINE_MODIFIERS;

    public static void initRenderThread() {
        if (renderThread != null) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static void assertOnRenderThread() {
        if (!RenderSystem.isOnRenderThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    private static IllegalStateException constructThreadException() {
        return new IllegalStateException("Rendersystem called from wrong thread");
    }

    private static void pollEvents() {
        pollEventsWaitStart.set(Util.getMillis());
        pollingEvents.set(true);
        GLFW.glfwPollEvents();
        pollingEvents.set(false);
    }

    public static boolean isFrozenAtPollEvents() {
        return pollingEvents.get() && Util.getMillis() - pollEventsWaitStart.get() > 200L;
    }

    public static void flipFrame(long p_69496_, @Nullable TracyFrameCapture p_372841_) {
        RenderSystem.pollEvents();
        Tesselator.getInstance().clear();
        GLFW.glfwSwapBuffers((long)p_69496_);
        if (p_372841_ != null) {
            p_372841_.endFrame();
        }
        RenderSystem.pollEvents();
    }

    public static void limitDisplayFPS(int p_69831_) {
        double d0 = lastDrawTime + 1.0 / (double)p_69831_;
        double d1 = GLFW.glfwGetTime();
        while (d1 < d0) {
            GLFW.glfwWaitEventsTimeout((double)(d0 - d1));
            d1 = GLFW.glfwGetTime();
        }
        lastDrawTime = d1;
    }

    public static void enableScissor(int p_69489_, int p_69490_, int p_69491_, int p_69492_) {
        SCISSOR_STATE.enable(p_69489_, p_69490_, p_69491_, p_69492_);
    }

    public static void disableScissor() {
        SCISSOR_STATE.disable();
    }

    public static void enableStencil(StencilTest stencilTest) {
        STENCIL_TEST = stencilTest;
    }

    public static void disableStencil() {
        STENCIL_TEST = null;
    }

    public static void setShaderFog(FogParameters p_360454_) {
        RenderSystem.assertOnRenderThread();
        shaderFog = p_360454_;
    }

    public static FogParameters getShaderFog() {
        RenderSystem.assertOnRenderThread();
        return shaderFog;
    }

    public static void setShaderGlintAlpha(double p_268332_) {
        RenderSystem.setShaderGlintAlpha((float)p_268332_);
    }

    public static void setShaderGlintAlpha(float p_268329_) {
        RenderSystem.assertOnRenderThread();
        shaderGlintAlpha = p_268329_;
    }

    public static float getShaderGlintAlpha() {
        RenderSystem.assertOnRenderThread();
        return shaderGlintAlpha;
    }

    public static void setShaderLights(Vector3f p_254155_, Vector3f p_254006_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.shaderLightDirections[0] = p_254155_;
        RenderSystem.shaderLightDirections[1] = p_254006_;
    }

    public static Vector3f[] getShaderLights() {
        return shaderLightDirections;
    }

    public static void setShaderColor(float p_157430_, float p_157431_, float p_157432_, float p_157433_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.shaderColor[0] = p_157430_;
        RenderSystem.shaderColor[1] = p_157431_;
        RenderSystem.shaderColor[2] = p_157432_;
        RenderSystem.shaderColor[3] = p_157433_;
    }

    public static float[] getShaderColor() {
        RenderSystem.assertOnRenderThread();
        return shaderColor;
    }

    public static void lineWidth(float p_69833_) {
        RenderSystem.assertOnRenderThread();
        shaderLineWidth = p_69833_;
    }

    public static float getShaderLineWidth() {
        RenderSystem.assertOnRenderThread();
        return shaderLineWidth;
    }

    public static String getBackendDescription() {
        return String.format(Locale.ROOT, "LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        return apiDescription;
    }

    public static TimeSource.NanoTimeSource initBackendSystem() {
        return GLX._initGlfw()::getAsLong;
    }

    public static void initRenderer(long p_409720_, int p_69581_, boolean p_69582_, BiFunction<ResourceLocation, ShaderType, String> p_410113_, boolean p_410401_) {
        DEVICE = new GlDevice(p_409720_, p_69581_, p_69582_, p_410113_, p_410401_);
        apiDescription = RenderSystem.getDevice().getImplementationInformation();
        try (ByteBufferBuilder bytebufferbuilder = new ByteBufferBuilder(DefaultVertexFormat.POSITION.getVertexSize() * 4);){
            BufferBuilder bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
            bufferbuilder.addVertex(0.0f, 0.0f, 0.0f);
            bufferbuilder.addVertex(1.0f, 0.0f, 0.0f);
            bufferbuilder.addVertex(1.0f, 1.0f, 0.0f);
            bufferbuilder.addVertex(0.0f, 1.0f, 0.0f);
            try (MeshData meshdata = bufferbuilder.buildOrThrow();){
                QUAD_VERTEX_BUFFER = RenderSystem.getDevice().createBuffer(() -> "Quad", BufferType.VERTICES, BufferUsage.STATIC_WRITE, meshdata.vertexBuffer());
            }
        }
    }

    public static void setErrorCallback(GLFWErrorCallbackI p_69901_) {
        GLX._setGlfwErrorCallback((GLFWErrorCallbackI)p_69901_);
    }

    public static void setupDefaultState() {
        projectionMatrix.identity();
        savedProjectionMatrix.identity();
        modelViewStack.clear();
        textureMatrix.identity();
    }

    public static void setupOverlayColor(@Nullable GpuTexture p_404695_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.setShaderTexture(1, p_404695_);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertOnRenderThread();
        RenderSystem.setShaderTexture(1, null);
    }

    public static void setupLevelDiffuseLighting(Vector3f p_254489_, Vector3f p_254541_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.setShaderLights(p_254489_, p_254541_);
    }

    public static void setupGuiFlatDiffuseLighting(Vector3f p_254419_, Vector3f p_254483_) {
        RenderSystem.assertOnRenderThread();
        Matrix4f matrix4f = new Matrix4f().rotationY(-0.3926991f).rotateX(2.3561945f);
        RenderSystem.setShaderLights(matrix4f.transformDirection((Vector3fc)p_254419_, new Vector3f()), matrix4f.transformDirection((Vector3fc)p_254483_, new Vector3f()));
    }

    public static void setupGui3DDiffuseLighting(Vector3f p_253859_, Vector3f p_253890_) {
        RenderSystem.assertOnRenderThread();
        Matrix4f matrix4f = new Matrix4f().scaling(1.0f, -1.0f, 1.0f).rotateYXZ(1.0821041f, 3.2375858f, 0.0f).rotateYXZ(-0.3926991f, 2.3561945f, 0.0f);
        RenderSystem.setShaderLights(matrix4f.transformDirection((Vector3fc)p_253859_, new Vector3f()), matrix4f.transformDirection((Vector3fc)p_253890_, new Vector3f()));
    }

    public static void setShaderTexture(int p_157454_, @Nullable GpuTexture p_405442_) {
        RenderSystem.assertOnRenderThread();
        if (p_157454_ >= 0 && p_157454_ < shaderTextures.length) {
            RenderSystem.shaderTextures[p_157454_] = p_405442_;
        }
    }

    @Nullable
    public static GpuTexture getShaderTexture(int p_157204_) {
        RenderSystem.assertOnRenderThread();
        return p_157204_ >= 0 && p_157204_ < shaderTextures.length ? shaderTextures[p_157204_] : null;
    }

    public static void setProjectionMatrix(Matrix4f p_277884_, ProjectionType p_381637_) {
        RenderSystem.assertOnRenderThread();
        projectionMatrix = new Matrix4f((Matrix4fc)p_277884_);
        projectionType = p_381637_;
    }

    public static void setTextureMatrix(Matrix4f p_254081_) {
        RenderSystem.assertOnRenderThread();
        textureMatrix = new Matrix4f((Matrix4fc)p_254081_);
    }

    public static void resetTextureMatrix() {
        RenderSystem.assertOnRenderThread();
        textureMatrix.identity();
    }

    public static void backupProjectionMatrix() {
        RenderSystem.assertOnRenderThread();
        savedProjectionMatrix = projectionMatrix;
        savedProjectionType = projectionType;
    }

    public static void restoreProjectionMatrix() {
        RenderSystem.assertOnRenderThread();
        projectionMatrix = savedProjectionMatrix;
        projectionType = savedProjectionType;
    }

    public static Matrix4f getProjectionMatrix() {
        RenderSystem.assertOnRenderThread();
        return projectionMatrix;
    }

    public static Matrix4f getModelViewMatrix() {
        RenderSystem.assertOnRenderThread();
        return modelViewStack;
    }

    public static Matrix4fStack getModelViewStack() {
        RenderSystem.assertOnRenderThread();
        return modelViewStack;
    }

    public static Matrix4f getTextureMatrix() {
        RenderSystem.assertOnRenderThread();
        return textureMatrix;
    }

    public static AutoStorageIndexBuffer getSequentialBuffer(VertexFormat.Mode p_221942_) {
        RenderSystem.assertOnRenderThread();
        return switch (p_221942_) {
            case VertexFormat.Mode.QUADS -> sharedSequentialQuad;
            case VertexFormat.Mode.LINES -> sharedSequentialLines;
            default -> sharedSequential;
        };
    }

    public static void setShaderGameTime(long p_157448_, float p_157449_) {
        RenderSystem.assertOnRenderThread();
        shaderGameTime = ((float)(p_157448_ % 24000L) + p_157449_) / 24000.0f;
    }

    public static float getShaderGameTime() {
        RenderSystem.assertOnRenderThread();
        return shaderGameTime;
    }

    public static ProjectionType getProjectionType() {
        RenderSystem.assertOnRenderThread();
        return projectionType;
    }

    public static GpuBuffer getQuadVertexBuffer() {
        if (QUAD_VERTEX_BUFFER == null) {
            throw new IllegalStateException("Can't getQuadVertexBuffer() before renderer was initialized");
        }
        return QUAD_VERTEX_BUFFER;
    }

    public static void setModelOffset(float p_401762_, float p_401844_, float p_401774_) {
        RenderSystem.assertOnRenderThread();
        modelOffset.set(p_401762_, p_401844_, p_401774_);
    }

    public static void resetModelOffset() {
        RenderSystem.assertOnRenderThread();
        modelOffset.set(0.0f, 0.0f, 0.0f);
    }

    public static Vector3f getModelOffset() {
        RenderSystem.assertOnRenderThread();
        return modelOffset;
    }

    public static void queueFencedTask(Runnable p_406359_) {
        PENDING_FENCES.addLast((Object)new GpuAsyncTask(p_406359_, new GpuFence()));
    }

    public static void executePendingTasks() {
        GpuAsyncTask rendersystem$gpuasynctask = (GpuAsyncTask)PENDING_FENCES.peekFirst();
        while (rendersystem$gpuasynctask != null) {
            if (!rendersystem$gpuasynctask.fence.awaitCompletion(0L)) {
                return;
            }
            try {
                rendersystem$gpuasynctask.callback.run();
            }
            finally {
                rendersystem$gpuasynctask.fence.close();
            }
            PENDING_FENCES.removeFirst();
            rendersystem$gpuasynctask = (GpuAsyncTask)PENDING_FENCES.peekFirst();
        }
    }

    public static GpuDevice getDevice() {
        if (DEVICE == null) {
            throw new IllegalStateException("Can't getDevice() before it was initialized");
        }
        return DEVICE;
    }

    @Nullable
    public static GpuDevice tryGetDevice() {
        return DEVICE;
    }

    public static void pushPipelineModifier(ResourceKey<PipelineModifier> modifier) {
        PIPELINE_MODIFIERS.push(modifier);
    }

    public static void popPipelineModifier() {
        PIPELINE_MODIFIERS.pop();
    }

    public static void renderWithPipelineModifier(ResourceKey<PipelineModifier> modifier, Runnable renderTask) {
        PIPELINE_MODIFIERS.renderWithModifier(modifier, renderTask);
    }

    @ApiStatus.Internal
    public static RenderPipeline applyPipelineModifiers(RenderPipeline pipeline) {
        return PIPELINE_MODIFIERS.apply(pipeline);
    }

    @ApiStatus.Internal
    public static void ensurePipelineModifiersEmpty() {
        PIPELINE_MODIFIERS.ensureEmpty();
    }

    static {
        lastDrawTime = Double.MIN_VALUE;
        sharedSequential = new AutoStorageIndexBuffer(1, 1, java.util.function.IntConsumer::accept);
        sharedSequentialQuad = new AutoStorageIndexBuffer(4, 6, (p_403829_, p_403830_) -> {
            p_403829_.accept(p_403830_);
            p_403829_.accept(p_403830_ + 1);
            p_403829_.accept(p_403830_ + 2);
            p_403829_.accept(p_403830_ + 2);
            p_403829_.accept(p_403830_ + 3);
            p_403829_.accept(p_403830_);
        });
        sharedSequentialLines = new AutoStorageIndexBuffer(4, 6, (p_403827_, p_403828_) -> {
            p_403827_.accept(p_403828_);
            p_403827_.accept(p_403828_ + 1);
            p_403827_.accept(p_403828_ + 2);
            p_403827_.accept(p_403828_ + 3);
            p_403827_.accept(p_403828_ + 2);
            p_403827_.accept(p_403828_ + 1);
        });
        projectionMatrix = new Matrix4f();
        savedProjectionMatrix = new Matrix4f();
        projectionType = ProjectionType.PERSPECTIVE;
        savedProjectionType = ProjectionType.PERSPECTIVE;
        modelViewStack = new Matrix4fStack(16);
        textureMatrix = new Matrix4f();
        shaderTextures = new GpuTexture[12];
        shaderColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        shaderGlintAlpha = 1.0f;
        shaderFog = FogParameters.NO_FOG;
        shaderLightDirections = new Vector3f[2];
        modelOffset = new Vector3f();
        shaderLineWidth = 1.0f;
        apiDescription = "Unknown";
        pollEventsWaitStart = new AtomicLong();
        pollingEvents = new AtomicBoolean(false);
        PENDING_FENCES = new ArrayListDeque();
        PIPELINE_MODIFIERS = new PipelineModifierStack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class AutoStorageIndexBuffer {
        private final int vertexStride;
        private final int indexStride;
        private final IndexGenerator generator;
        @Nullable
        private GpuBuffer buffer;
        private VertexFormat.IndexType type = VertexFormat.IndexType.SHORT;
        private int indexCount;

        AutoStorageIndexBuffer(int p_157472_, int p_157473_, IndexGenerator p_157474_) {
            this.vertexStride = p_157472_;
            this.indexStride = p_157473_;
            this.generator = p_157474_;
        }

        public boolean hasStorage(int p_221945_) {
            return p_221945_ <= this.indexCount;
        }

        public GpuBuffer getBuffer(int p_410107_) {
            this.ensureStorage(p_410107_);
            return this.buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureStorage(int p_157477_) {
            if (!this.hasStorage(p_157477_)) {
                p_157477_ = Mth.roundToward((int)(p_157477_ * 2), (int)this.indexStride);
                LOGGER.debug("Growing IndexBuffer: Old limit {}, new limit {}.", (Object)this.indexCount, (Object)p_157477_);
                int i = p_157477_ / this.indexStride;
                int j = i * this.vertexStride;
                VertexFormat.IndexType vertexformat$indextype = VertexFormat.IndexType.least(j);
                int k = Mth.roundToward((int)(p_157477_ * vertexformat$indextype.bytes), (int)4);
                ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)k);
                try {
                    this.type = vertexformat$indextype;
                    IntConsumer intconsumer = this.intConsumer(bytebuffer);
                    for (int l = 0; l < p_157477_; l += this.indexStride) {
                        this.generator.accept(intconsumer, l * this.vertexStride / this.indexStride);
                    }
                    bytebuffer.flip();
                    if (this.buffer != null) {
                        this.buffer.close();
                    }
                    this.buffer = RenderSystem.getDevice().createBuffer(() -> "Auto Storage index buffer", BufferType.INDICES, BufferUsage.DYNAMIC_WRITE, bytebuffer);
                }
                finally {
                    MemoryUtil.memFree((Buffer)bytebuffer);
                }
                this.indexCount = p_157477_;
            }
        }

        private IntConsumer intConsumer(ByteBuffer p_157479_) {
            switch (this.type) {
                case SHORT: {
                    return p_157482_ -> p_157479_.putShort((short)p_157482_);
                }
            }
            return p_157479_::putInt;
        }

        public VertexFormat.IndexType type() {
            return this.type;
        }

        @OnlyIn(value=Dist.CLIENT)
        static interface IndexGenerator {
            public void accept(IntConsumer var1, int var2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record GpuAsyncTask(Runnable callback, GpuFence fence) {
    }
}

