/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.ScreenshotEvent;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Screenshot {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String SCREENSHOT_DIR = "screenshots";

    public static void grab(File p_92290_, RenderTarget p_92293_, Consumer<Component> p_92294_) {
        Screenshot.grab(p_92290_, null, p_92293_, p_92294_);
    }

    public static void grab(File p_92296_, @Nullable String p_92297_, RenderTarget p_92300_, Consumer<Component> p_92301_) {
        Screenshot.takeScreenshot(p_92300_, p_406180_ -> {
            File file1 = new File(p_92296_, SCREENSHOT_DIR);
            file1.mkdir();
            File file2 = p_92297_ == null ? Screenshot.getFile(file1) : new File(file1, p_92297_);
            ScreenshotEvent event = ClientHooks.onScreenshot((NativeImage)p_406180_, (File)file2);
            if (event.isCanceled()) {
                p_92301_.accept(event.getCancelMessage());
                return;
            }
            File target = event.getScreenshotFile();
            Util.ioPool().execute(() -> {
                try {
                    NativeImage $$4x = p_406180_;
                    try {
                        p_406180_.writeToFile(target);
                        if (event.getResultMessage() != null) {
                            p_92301_.accept(event.getResultMessage());
                        } else {
                            MutableComponent component = Component.literal((String)target.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_392495_ -> p_392495_.withClickEvent((ClickEvent)new ClickEvent.OpenFile(target.getAbsoluteFile())));
                            p_92301_.accept((Component)Component.translatable((String)"screenshot.success", (Object[])new Object[]{component}));
                        }
                    }
                    catch (Throwable throwable1) {
                        if (p_406180_ != null) {
                            try {
                                $$4x.close();
                            }
                            catch (Throwable throwable) {
                                throwable1.addSuppressed(throwable);
                            }
                        }
                        throw throwable1;
                    }
                    if (p_406180_ != null) {
                        p_406180_.close();
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Couldn't save screenshot", (Throwable)exception);
                    p_92301_.accept((Component)Component.translatable((String)"screenshot.failure", (Object[])new Object[]{exception.getMessage()}));
                }
            });
        });
    }

    public static void takeScreenshot(RenderTarget p_92282_, Consumer<NativeImage> p_406336_) {
        int i = p_92282_.width;
        int j = p_92282_.height;
        GpuTexture gputexture = p_92282_.getColorTexture();
        if (gputexture == null) {
            throw new IllegalStateException("Tried to capture screenshot of an incomplete framebuffer");
        }
        GpuBuffer gpubuffer = RenderSystem.getDevice().createBuffer(() -> "Screenshot buffer", BufferType.PIXEL_PACK, BufferUsage.STATIC_READ, i * j * gputexture.getFormat().pixelSize());
        CommandEncoder commandencoder = RenderSystem.getDevice().createCommandEncoder();
        RenderSystem.getDevice().createCommandEncoder().copyTextureToBuffer(gputexture, gpubuffer, 0, () -> {
            try (GpuBuffer.ReadView gpubuffer$readview = commandencoder.readBuffer(gpubuffer);){
                NativeImage nativeimage = new NativeImage(i, j, false);
                for (int k = 0; k < j; ++k) {
                    for (int l = 0; l < i; ++l) {
                        int i1 = gpubuffer$readview.data().getInt((l + k * i) * gputexture.getFormat().pixelSize());
                        nativeimage.setPixelABGR(l, j - k - 1, i1 | 0xFF000000);
                    }
                }
                p_406336_.accept(nativeimage);
            }
            gpubuffer.close();
        }, 0);
    }

    private static File getFile(File p_92288_) {
        String s = Util.getFilenameFormattedDateTime();
        int i = 1;
        File file1;
        while ((file1 = new File(p_92288_, s + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }
}

