/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.data;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.SuppressForbidden;
import net.minecraft.client.ClientBootstrap;
import net.minecraft.client.data.AtlasProvider;
import net.minecraft.client.data.models.EquipmentAssetProvider;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.resources.ClientPackSource;
import net.minecraft.client.resources.IndexedAssetSource;
import net.minecraft.data.DataGenerator;
import net.minecraft.obfuscate.DontObfuscate;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.data.loading.DatagenModLoader;

@OnlyIn(value=Dist.CLIENT)
public class Main {
    @DontObfuscate
    @SuppressForbidden(reason="System.out needed before bootstrap")
    public static void main(String[] p_388033_) throws IOException {
        SharedConstants.tryDetectVersion();
        OptionParser optionparser = new OptionParser();
        AbstractOptionSpec optionspec = optionparser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder optionspec1 = optionparser.accepts("client", "Include client generators");
        OptionSpecBuilder optionspec2 = optionparser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec optionspec3 = optionparser.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec existing = optionparser.accepts("existing", "Existing resource packs that generated resources can reference").withRequiredArg();
        ArgumentAcceptingOptionSpec mod = optionparser.accepts("mod", "A modid to dump").withRequiredArg().withValuesSeparatedBy(",");
        OptionSpecBuilder flat = optionparser.accepts("flat", "Do not append modid prefix to output directory when generating for multiple mods");
        ArgumentAcceptingOptionSpec assetIndex = optionparser.accepts("assetIndex").withRequiredArg();
        ArgumentAcceptingOptionSpec assetsDir = optionparser.accepts("assetsDir").withRequiredArg().ofType(File.class);
        OptionSpecBuilder validateSpec = optionparser.accepts("validate", "Validate inputs");
        OptionSet optionset = optionparser.parse(p_388033_);
        if (!optionset.has((OptionSpec)optionspec) && optionset.hasOptions()) {
            Path path = Paths.get((String)optionspec3.value(optionset), new String[0]);
            boolean flag = optionset.has((OptionSpec)optionspec2);
            boolean flag1 = flag || optionset.has((OptionSpec)optionspec1);
            List<Path> existingPacks = optionset.valuesOf((OptionSpec)existing).stream().map(x$0 -> Paths.get(x$0, new String[0])).toList();
            HashSet mods = new HashSet(optionset.valuesOf((OptionSpec)mod));
            boolean isFlat = mods.isEmpty() || optionset.has((OptionSpec)flat);
            boolean validate = optionset.has((OptionSpec)validateSpec);
            DataGenerator datagenerator = new DataGenerator(isFlat ? path : path.resolve("minecraft"), SharedConstants.getCurrentVersion(), true);
            if (mods.contains("minecraft") || mods.isEmpty()) {
                Main.addClientProviders(datagenerator, flag1);
            }
            File assetsDirValue = (File)optionset.valueOf((OptionSpec)assetsDir);
            String assetIndexValue = (String)optionset.valueOf((OptionSpec)assetIndex);
            DatagenModLoader.begin(mods, (Path)path, List.of(), existingPacks, (boolean)false, (boolean)false, (boolean)validate, (boolean)isFlat, () -> {
                ClientBootstrap.bootstrap();
                ClientHooks.initClientRegistries();
            }, GatherDataEvent.Client::new, (DataGenerator)datagenerator, packConsumer -> {
                if (assetsDirValue != null && assetIndexValue != null) {
                    packConsumer.accept(ClientPackSource.createVanillaPackSource((Path)IndexedAssetSource.createIndexFs((Path)assetsDirValue.toPath(), (String)assetIndexValue)));
                }
            });
        } else {
            optionparser.printHelpOn((OutputStream)System.out);
        }
    }

    public static void addClientProviders(DataGenerator p_388709_, boolean p_388751_) {
        DataGenerator.PackGenerator datagenerator$packgenerator = p_388709_.getVanillaPack(p_388751_);
        datagenerator$packgenerator.addProvider(ModelProvider::new);
        datagenerator$packgenerator.addProvider(EquipmentAssetProvider::new);
        datagenerator$packgenerator.addProvider(AtlasProvider::new);
    }
}

