/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.data.models;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EquipmentAssetProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;

    public EquipmentAssetProvider(PackOutput p_387559_) {
        this.pathProvider = p_387559_.createPathProvider(PackOutput.Target.RESOURCE_PACK, "equipment");
    }

    protected void registerModels(BiConsumer<ResourceKey<EquipmentAsset>, EquipmentClientInfo> output) {
        EquipmentAssetProvider.bootstrap(output);
    }

    private static void bootstrap(BiConsumer<ResourceKey<EquipmentAsset>, EquipmentClientInfo> p_387865_) {
        p_387865_.accept(EquipmentAssets.LEATHER, EquipmentClientInfo.builder().addHumanoidLayers(ResourceLocation.withDefaultNamespace("leather"), true).addHumanoidLayers(ResourceLocation.withDefaultNamespace("leather_overlay"), false).addLayers(EquipmentClientInfo.LayerType.HORSE_BODY, new EquipmentClientInfo.Layer[]{EquipmentClientInfo.Layer.leatherDyeable((ResourceLocation)ResourceLocation.withDefaultNamespace("leather"), (boolean)true)}).build());
        p_387865_.accept(EquipmentAssets.CHAINMAIL, EquipmentAssetProvider.onlyHumanoid("chainmail"));
        p_387865_.accept(EquipmentAssets.IRON, EquipmentAssetProvider.humanoidAndHorse("iron"));
        p_387865_.accept(EquipmentAssets.GOLD, EquipmentAssetProvider.humanoidAndHorse("gold"));
        p_387865_.accept(EquipmentAssets.DIAMOND, EquipmentAssetProvider.humanoidAndHorse("diamond"));
        p_387865_.accept(EquipmentAssets.TURTLE_SCUTE, EquipmentClientInfo.builder().addMainHumanoidLayer(ResourceLocation.withDefaultNamespace("turtle_scute"), false).build());
        p_387865_.accept(EquipmentAssets.NETHERITE, EquipmentAssetProvider.onlyHumanoid("netherite"));
        p_387865_.accept(EquipmentAssets.ARMADILLO_SCUTE, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.WOLF_BODY, new EquipmentClientInfo.Layer[]{EquipmentClientInfo.Layer.onlyIfDyed((ResourceLocation)ResourceLocation.withDefaultNamespace("armadillo_scute"), (boolean)false)}).addLayers(EquipmentClientInfo.LayerType.WOLF_BODY, new EquipmentClientInfo.Layer[]{EquipmentClientInfo.Layer.onlyIfDyed((ResourceLocation)ResourceLocation.withDefaultNamespace("armadillo_scute_overlay"), (boolean)true)}).build());
        p_387865_.accept(EquipmentAssets.ELYTRA, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.WINGS, new EquipmentClientInfo.Layer[]{new EquipmentClientInfo.Layer(ResourceLocation.withDefaultNamespace("elytra"), Optional.empty(), true)}).build());
        EquipmentClientInfo.Layer equipmentclientinfo$layer = new EquipmentClientInfo.Layer(ResourceLocation.withDefaultNamespace("saddle"));
        p_387865_.accept(EquipmentAssets.SADDLE, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.PIG_SADDLE, new EquipmentClientInfo.Layer[]{equipmentclientinfo$layer}).addLayers(EquipmentClientInfo.LayerType.STRIDER_SADDLE, new EquipmentClientInfo.Layer[]{equipmentclientinfo$layer}).addLayers(EquipmentClientInfo.LayerType.CAMEL_SADDLE, new EquipmentClientInfo.Layer[]{equipmentclientinfo$layer}).addLayers(EquipmentClientInfo.LayerType.HORSE_SADDLE, new EquipmentClientInfo.Layer[]{equipmentclientinfo$layer}).addLayers(EquipmentClientInfo.LayerType.DONKEY_SADDLE, new EquipmentClientInfo.Layer[]{equipmentclientinfo$layer}).addLayers(EquipmentClientInfo.LayerType.MULE_SADDLE, new EquipmentClientInfo.Layer[]{equipmentclientinfo$layer}).addLayers(EquipmentClientInfo.LayerType.SKELETON_HORSE_SADDLE, new EquipmentClientInfo.Layer[]{equipmentclientinfo$layer}).addLayers(EquipmentClientInfo.LayerType.ZOMBIE_HORSE_SADDLE, new EquipmentClientInfo.Layer[]{equipmentclientinfo$layer}).build());
        for (Map.Entry entry : EquipmentAssets.CARPETS.entrySet()) {
            DyeColor dyecolor = (DyeColor)((Object)entry.getKey());
            ResourceKey resourcekey = (ResourceKey)entry.getValue();
            p_387865_.accept(resourcekey, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.LLAMA_BODY, new EquipmentClientInfo.Layer[]{new EquipmentClientInfo.Layer(ResourceLocation.withDefaultNamespace(dyecolor.getSerializedName()))}).build());
        }
        p_387865_.accept(EquipmentAssets.TRADER_LLAMA, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.LLAMA_BODY, new EquipmentClientInfo.Layer[]{new EquipmentClientInfo.Layer(ResourceLocation.withDefaultNamespace("trader_llama"))}).build());
    }

    public static EquipmentClientInfo onlyHumanoid(String p_388505_) {
        return EquipmentClientInfo.builder().addHumanoidLayers(ResourceLocation.parse(p_388505_)).build();
    }

    public static EquipmentClientInfo humanoidAndHorse(String p_386720_) {
        return EquipmentClientInfo.builder().addHumanoidLayers(ResourceLocation.parse(p_386720_)).addLayers(EquipmentClientInfo.LayerType.HORSE_BODY, new EquipmentClientInfo.Layer[]{EquipmentClientInfo.Layer.leatherDyeable((ResourceLocation)ResourceLocation.parse(p_386720_), (boolean)false)}).build();
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_387304_) {
        HashMap map = new HashMap();
        this.registerModels((p_386976_, p_388942_) -> {
            if (map.putIfAbsent(p_386976_, p_388942_) != null) {
                throw new IllegalStateException("Tried to register equipment asset twice for id: " + String.valueOf(p_386976_));
            }
        });
        return DataProvider.saveAll(p_387304_, EquipmentClientInfo.CODEC, arg_0 -> ((PackOutput.PathProvider)this.pathProvider).json(arg_0), map);
    }

    @Override
    public String getName() {
        return "Equipment Asset Definitions";
    }
}

