/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.data.models.blockstates;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.blockstates.PropertyValueList;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.VariantMutator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.generators.blockstate.UnbakedMutator;

@OnlyIn(value=Dist.CLIENT)
public class MultiVariantGenerator
implements BlockModelDefinitionGenerator {
    private final Block block;
    private final List<Entry> entries;
    private final Set<Property<?>> seenProperties;

    MultiVariantGenerator(Block p_388671_, List<Entry> p_386519_, Set<Property<?>> p_405706_) {
        this.block = p_388671_;
        this.entries = p_386519_;
        this.seenProperties = p_405706_;
    }

    static Set<Property<?>> validateAndExpandProperties(Set<Property<?>> p_405585_, Block p_405741_, PropertyDispatch<?> p_405105_) {
        List<Property<?>> list = p_405105_.getDefinedProperties();
        list.forEach(p_403953_ -> {
            if (p_405741_.getStateDefinition().getProperty(p_403953_.getName()) != p_403953_) {
                throw new IllegalStateException("Property " + String.valueOf(p_403953_) + " is not defined for block " + String.valueOf(p_405741_));
            }
            if (p_405585_.contains(p_403953_)) {
                throw new IllegalStateException("Values of property " + String.valueOf(p_403953_) + " already defined for block " + String.valueOf(p_405741_));
            }
        });
        HashSet set = new HashSet(p_405585_);
        set.addAll(list);
        return set;
    }

    public MultiVariantGenerator with(PropertyDispatch<VariantMutator> p_388256_) {
        Set<Property<?>> set = MultiVariantGenerator.validateAndExpandProperties(this.seenProperties, this.block, p_388256_);
        List<Entry> list = this.entries.stream().flatMap(p_403955_ -> p_403955_.apply(p_388256_)).toList();
        return new MultiVariantGenerator(this.block, list, set);
    }

    public MultiVariantGenerator with(VariantMutator p_405854_) {
        List<Entry> list = this.entries.stream().flatMap(p_403950_ -> p_403950_.apply(p_405854_)).toList();
        return new MultiVariantGenerator(this.block, list, this.seenProperties);
    }

    public MultiVariantGenerator withUnbaked(PropertyDispatch<UnbakedMutator> dispatch) {
        Set<Property<?>> set = MultiVariantGenerator.validateAndExpandProperties(this.seenProperties, this.block, dispatch);
        List<Entry> list = this.entries.stream().flatMap(e -> e.applyToUnbaked(dispatch)).toList();
        return new MultiVariantGenerator(this.block, list, set);
    }

    public MultiVariantGenerator withUnbaked(UnbakedMutator dispatch) {
        List<Entry> list = this.entries.stream().flatMap(e -> e.applyToUnbaked(dispatch)).toList();
        return new MultiVariantGenerator(this.block, list, this.seenProperties);
    }

    public BlockModelDefinition create() {
        HashMap<String, BlockStateModel.Unbaked> map = new HashMap<String, BlockStateModel.Unbaked>();
        for (Entry multivariantgenerator$entry : this.entries) {
            map.put(multivariantgenerator$entry.properties.getKey(), multivariantgenerator$entry.variant.toUnbaked());
        }
        return new BlockModelDefinition(Optional.of(new BlockModelDefinition.SimpleModelSelectors(map)), Optional.empty());
    }

    public Block block() {
        return this.block;
    }

    public static Empty dispatch(Block p_405256_) {
        return new Empty(p_405256_);
    }

    public static MultiVariantGenerator dispatch(Block p_405526_, MultiVariant p_409935_) {
        return new MultiVariantGenerator(p_405526_, List.of(new Entry(PropertyValueList.EMPTY, p_409935_)), Set.of());
    }

    @OnlyIn(value=Dist.CLIENT)
    record Entry(PropertyValueList properties, MultiVariant variant) {
        public Stream<Entry> apply(PropertyDispatch<VariantMutator> p_404760_) {
            return p_404760_.getEntries().entrySet().stream().map(p_409007_ -> {
                PropertyValueList propertyvaluelist = this.properties.extend((PropertyValueList)p_409007_.getKey());
                MultiVariant multivariant = this.variant.with((VariantMutator)p_409007_.getValue());
                return new Entry(propertyvaluelist, multivariant);
            });
        }

        public Stream<Entry> apply(VariantMutator p_404774_) {
            return Stream.of(new Entry(this.properties, this.variant.with(p_404774_)));
        }

        public Stream<Entry> applyToUnbaked(PropertyDispatch<UnbakedMutator> dispatch) {
            return dispatch.getEntries().entrySet().stream().map(entry -> new Entry(this.properties.extend((PropertyValueList)entry.getKey()), this.variant.with((UnbakedMutator)entry.getValue())));
        }

        public Stream<Entry> applyToUnbaked(UnbakedMutator mutator) {
            return Stream.of(new Entry(this.properties, this.variant.with(mutator)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Empty {
        private final Block block;

        public Empty(Block p_404725_) {
            this.block = p_404725_;
        }

        public MultiVariantGenerator with(PropertyDispatch<MultiVariant> p_405221_) {
            Set<Property<?>> set = MultiVariantGenerator.validateAndExpandProperties(Set.of(), this.block, p_405221_);
            List<Entry> list = p_405221_.getEntries().entrySet().stream().map(p_409006_ -> new Entry((PropertyValueList)p_409006_.getKey(), (MultiVariant)p_409006_.getValue())).toList();
            return new MultiVariantGenerator(this.block, list, set);
        }
    }
}

