/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import com.mojang.blaze3d.platform.Lighting;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectsInInventory;
import net.minecraft.client.gui.screens.recipebook.CraftingRecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class InventoryScreen
extends AbstractRecipeBookScreen<InventoryMenu> {
    private float xMouse;
    private float yMouse;
    private boolean buttonClicked;
    private final EffectsInInventory effects;

    public InventoryScreen(Player p_98839_) {
        super((RecipeBookMenu)p_98839_.inventoryMenu, (RecipeBookComponent)new CraftingRecipeBookComponent((AbstractCraftingMenu)p_98839_.inventoryMenu), p_98839_.getInventory(), (Component)Component.translatable((String)"container.crafting"));
        this.titleLabelX = 97;
        this.effects = new EffectsInInventory((AbstractContainerScreen<?>)((Object)this));
    }

    public void containerTick() {
        super.containerTick();
        if (this.minecraft.player.hasInfiniteMaterials()) {
            this.minecraft.setScreen(new CreativeModeInventoryScreen(this.minecraft.player, this.minecraft.player.connection.enabledFeatures(), (Boolean)this.minecraft.options.operatorItemsTab().get()));
        }
    }

    protected void init() {
        if (this.minecraft.player.hasInfiniteMaterials()) {
            this.minecraft.setScreen(new CreativeModeInventoryScreen(this.minecraft.player, this.minecraft.player.connection.enabledFeatures(), (Boolean)this.minecraft.options.operatorItemsTab().get()));
        } else {
            super.init();
        }
    }

    protected ScreenPosition getRecipeBookButtonPosition() {
        return new ScreenPosition(this.leftPos + 104, this.height / 2 - 22);
    }

    protected void onRecipeBookButtonClick() {
        this.buttonClicked = true;
    }

    protected void renderLabels(GuiGraphics p_281654_, int p_283517_, int p_283464_) {
        p_281654_.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    public void render(GuiGraphics p_283246_, int p_98876_, int p_98877_, float p_98878_) {
        super.render(p_283246_, p_98876_, p_98877_, p_98878_);
        this.effects.render(p_283246_, p_98876_, p_98877_, p_98878_);
        this.xMouse = p_98876_;
        this.yMouse = p_98877_;
    }

    public boolean showsActiveEffects() {
        return this.effects.canSeeEffects();
    }

    protected boolean isBiggerResultSlot() {
        return false;
    }

    protected void renderBg(GuiGraphics p_281500_, float p_281299_, int p_283481_, int p_281831_) {
        int i = this.leftPos;
        int j = this.topPos;
        p_281500_.blit(RenderType::guiTextured, INVENTORY_LOCATION, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        InventoryScreen.renderEntityInInventoryFollowsMouse(p_281500_, i + 26, j + 8, i + 75, j + 78, 30, 0.0625f, this.xMouse, this.yMouse, this.minecraft.player);
    }

    public static void renderEntityInInventoryFollowsMouse(GuiGraphics p_282802_, int p_275688_, int p_275245_, int p_275535_, int p_294406_, int p_294663_, float p_275604_, float p_275546_, float p_295352_, LivingEntity p_275689_) {
        float f = (float)(p_275688_ + p_275535_) / 2.0f;
        float f1 = (float)(p_275245_ + p_294406_) / 2.0f;
        float f2 = (float)Math.atan((f - p_275546_) / 40.0f);
        float f3 = (float)Math.atan((f1 - p_295352_) / 40.0f);
        InventoryScreen.renderEntityInInventoryFollowsAngle(p_282802_, p_275688_, p_275245_, p_275535_, p_294406_, p_294663_, p_275604_, f2, f3, p_275689_);
    }

    public static void renderEntityInInventoryFollowsAngle(GuiGraphics p_282802_, int p_275688_, int p_275245_, int p_275535_, int p_294406_, int p_294663_, float p_275604_, float angleXComponent, float angleYComponent, LivingEntity p_275689_) {
        float f = (float)(p_275688_ + p_275535_) / 2.0f;
        float f1 = (float)(p_275245_ + p_294406_) / 2.0f;
        p_282802_.enableScissor(p_275688_, p_275245_, p_275535_, p_294406_);
        float f2 = angleXComponent;
        float f3 = angleYComponent;
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(f3 * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f4 = p_275689_.yBodyRot;
        float f5 = p_275689_.getYRot();
        float f6 = p_275689_.getXRot();
        float f7 = p_275689_.yHeadRotO;
        float f8 = p_275689_.yHeadRot;
        p_275689_.yBodyRot = 180.0f + f2 * 20.0f;
        p_275689_.setYRot(180.0f + f2 * 40.0f);
        p_275689_.setXRot(-f3 * 20.0f);
        p_275689_.yHeadRot = p_275689_.getYRot();
        p_275689_.yHeadRotO = p_275689_.getYRot();
        float f9 = p_275689_.getScale();
        Vector3f vector3f = new Vector3f(0.0f, p_275689_.getBbHeight() / 2.0f + p_275604_ * f9, 0.0f);
        float f10 = (float)p_294663_ / f9;
        InventoryScreen.renderEntityInInventory(p_282802_, f, f1, f10, vector3f, quaternionf, quaternionf1, p_275689_);
        p_275689_.yBodyRot = f4;
        p_275689_.setYRot(f5);
        p_275689_.setXRot(f6);
        p_275689_.yHeadRotO = f7;
        p_275689_.yHeadRot = f8;
        p_282802_.disableScissor();
    }

    public static void renderEntityInInventory(GuiGraphics p_282665_, float p_296361_, float p_294489_, float p_319934_, Vector3f p_295026_, Quaternionf p_281880_, @Nullable Quaternionf p_282882_, LivingEntity p_282466_) {
        p_282665_.pose().pushPose();
        p_282665_.pose().translate((double)p_296361_, (double)p_294489_, 50.0);
        p_282665_.pose().scale(p_319934_, p_319934_, -p_319934_);
        p_282665_.pose().translate(p_295026_.x, p_295026_.y, p_295026_.z);
        p_282665_.pose().mulPose((Quaternionfc)p_281880_);
        p_282665_.flush();
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        if (p_282882_ != null) {
            entityrenderdispatcher.overrideCameraOrientation(p_282882_.conjugate(new Quaternionf()).rotateY((float)Math.PI));
        }
        entityrenderdispatcher.setRenderShadow(false);
        p_282665_.drawSpecial(p_370280_ -> entityrenderdispatcher.render(p_282466_, 0.0, 0.0, 0.0, 1.0f, p_282665_.pose(), (MultiBufferSource)p_370280_, 0xF000F0));
        p_282665_.flush();
        entityrenderdispatcher.setRenderShadow(true);
        p_282665_.pose().popPose();
        Lighting.setupFor3DItems();
    }

    public boolean mouseReleased(double p_98893_, double p_98894_, int p_98895_) {
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.mouseReleased(p_98893_, p_98894_, p_98895_);
    }
}

