/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.SwitchGrid;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ExperimentsScreen
extends Screen {
    private static final Component TITLE = Component.translatable((String)"selectWorld.experiments");
    private static final Component INFO = Component.translatable((String)"selectWorld.experiments.info").withStyle(ChatFormatting.RED);
    private static final int MAIN_CONTENT_WIDTH = 310;
    private static final int SCROLL_AREA_MIN_HEIGHT = 130;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final Screen parent;
    private final PackRepository packRepository;
    private final Consumer<PackRepository> output;
    private final Object2BooleanMap<Pack> packs = new Object2BooleanLinkedOpenHashMap();
    @Nullable
    private ScrollArea scrollArea;

    public ExperimentsScreen(Screen p_270165_, PackRepository p_270308_, Consumer<PackRepository> p_270392_) {
        super(TITLE);
        this.parent = p_270165_;
        this.packRepository = p_270308_;
        this.output = p_270392_;
        for (Pack pack : p_270308_.getAvailablePacks()) {
            if (pack.getPackSource() != PackSource.FEATURE) continue;
            this.packs.put((Object)pack, p_270308_.getSelectedPacks().contains(pack));
        }
    }

    @Override
    protected void init() {
        this.layout.addTitleHeader(TITLE, this.font);
        LinearLayout linearlayout = (LinearLayout)this.layout.addToContents((LayoutElement)LinearLayout.vertical());
        linearlayout.addChild((LayoutElement)new MultiLineTextWidget(INFO, this.font).setMaxWidth(310), p_293611_ -> p_293611_.paddingBottom(15));
        SwitchGrid.Builder switchgrid$builder = SwitchGrid.builder((int)299).withInfoUnderneath(2, true).withRowSpacing(4);
        this.packs.forEach((p_270880_, p_270874_) -> switchgrid$builder.addSwitch(ExperimentsScreen.getHumanReadableTitle(p_270880_), () -> this.packs.getBoolean(p_270880_), p_270491_ -> this.packs.put(p_270880_, p_270491_.booleanValue())).withInfo(p_270880_.getDescription()));
        Layout layout = switchgrid$builder.build().layout();
        this.scrollArea = new ScrollArea(this, layout, 310, 130);
        linearlayout.addChild((LayoutElement)this.scrollArea);
        LinearLayout linearlayout1 = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        linearlayout1.addChild((LayoutElement)Button.builder(CommonComponents.GUI_DONE, p_270336_ -> this.onDone()).build());
        linearlayout1.addChild((LayoutElement)Button.builder(CommonComponents.GUI_CANCEL, p_274702_ -> this.onClose()).build());
        this.layout.visitWidgets(p_321381_ -> {
            AbstractWidget abstractwidget = this.addRenderableWidget(p_321381_);
        });
        this.repositionElements();
    }

    private static Component getHumanReadableTitle(Pack p_270861_) {
        String s = "dataPack." + p_270861_.getId() + ".name";
        return I18n.exists(s) ? Component.translatable((String)s) : p_270861_.getTitle();
    }

    @Override
    protected void repositionElements() {
        this.scrollArea.setHeight(130);
        this.layout.arrangeElements();
        int i = this.height - this.layout.getFooterHeight() - this.scrollArea.getRectangle().bottom();
        this.scrollArea.setHeight(this.scrollArea.getHeight() + i);
        this.scrollArea.refreshScrollAmount();
    }

    @Override
    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration((Component[])new Component[]{super.getNarrationMessage(), INFO});
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    private void onDone() {
        ArrayList<Pack> list = new ArrayList<Pack>(this.packRepository.getSelectedPacks());
        ArrayList list1 = new ArrayList();
        this.packs.forEach((p_270540_, p_270780_) -> {
            list.remove(p_270540_);
            if (p_270780_.booleanValue()) {
                list1.add(p_270540_);
            }
        });
        list.addAll(Lists.reverse(list1));
        this.packRepository.setSelected(list.stream().map(Pack::getId).toList());
        this.output.accept(this.packRepository);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ScrollArea
    extends AbstractContainerWidget {
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
        private final Layout layout;

        public ScrollArea(ExperimentsScreen this$0, Layout p_387711_, int p_388705_, int p_387334_) {
            super(0, 0, p_388705_, p_387334_, CommonComponents.EMPTY);
            this.layout = p_387711_;
            p_387711_.visitWidgets(this::addWidget);
        }

        public void addWidget(AbstractWidget p_388235_) {
            this.children.add(p_388235_);
        }

        protected int contentHeight() {
            return this.layout.getHeight();
        }

        protected double scrollRate() {
            return 10.0;
        }

        protected void renderWidget(GuiGraphics p_387127_, int p_388038_, int p_386932_, float p_388026_) {
            p_387127_.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
            p_387127_.pose().pushPose();
            p_387127_.pose().translate(0.0, -this.scrollAmount(), 0.0);
            p_386932_ = (int)((double)p_386932_ + this.scrollAmount());
            for (AbstractWidget abstractwidget : this.children) {
                abstractwidget.render(p_387127_, p_388038_, p_386932_, p_388026_);
            }
            p_387127_.pose().popPose();
            p_387127_.disableScissor();
            this.renderScrollbar(p_387127_);
        }

        protected void updateWidgetNarration(NarrationElementOutput p_388854_) {
        }

        public ScreenRectangle getBorderForArrowNavigation(ScreenDirection p_388582_) {
            return new ScreenRectangle(this.getX(), this.getY(), this.width, this.contentHeight());
        }

        public void setFocused(@Nullable GuiEventListener p_387564_) {
            super.setFocused(p_387564_);
            if (p_387564_ != null) {
                ScreenRectangle screenrectangle = this.getRectangle();
                ScreenRectangle screenrectangle1 = p_387564_.getRectangle();
                int i = (int)((double)screenrectangle1.top() - this.scrollAmount() - (double)screenrectangle.top());
                int j = (int)((double)screenrectangle1.bottom() - this.scrollAmount() - (double)screenrectangle.bottom());
                if (i < 0) {
                    this.setScrollAmount(this.scrollAmount() + (double)i - 14.0);
                } else if (j > 0) {
                    this.setScrollAmount(this.scrollAmount() + (double)j + 14.0);
                }
            }
        }

        public Optional<GuiEventListener> getChildAt(double p_94730_, double p_94731_) {
            return super.getChildAt(p_94730_, p_94731_ + this.scrollAmount());
        }

        public boolean mouseClicked(double p_313764_, double p_313832_, int p_313688_) {
            Optional<GuiEventListener> optional = this.getChildAt(p_313764_, p_313832_);
            if (optional.isEmpty()) {
                return false;
            }
            GuiEventListener guieventlistener = optional.get();
            if (guieventlistener.mouseClicked(p_313764_, p_313832_ + this.scrollAmount(), p_313688_)) {
                this.setFocused(guieventlistener);
                if (p_313688_ == 0) {
                    this.setDragging(true);
                }
            }
            return true;
        }

        public boolean mouseReleased(double p_313886_, double p_313935_, int p_313751_) {
            if (p_313751_ == 0 && this.isDragging()) {
                this.setDragging(false);
                if (this.getFocused() != null) {
                    return this.getFocused().mouseReleased(p_313886_, p_313935_ + this.scrollAmount(), p_313751_);
                }
            }
            return this.getChildAt(p_313886_, p_313935_).filter(p_94708_ -> p_94708_.mouseReleased(p_313886_, p_313935_ + this.scrollAmount(), p_313751_)).isPresent();
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        public void setX(int p_388848_) {
            super.setX(p_388848_);
            this.layout.setX(p_388848_);
            this.layout.arrangeElements();
        }

        public void setY(int p_387427_) {
            super.setY(p_387427_);
            this.layout.setY(p_387427_);
            this.layout.arrangeElements();
        }

        public Collection<? extends NarratableEntry> getNarratables() {
            return this.children;
        }
    }
}

