/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.KnownPacksManager;
import net.minecraft.client.multiplayer.RegistryDataCollector;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.PacketListener;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ClientConfigurationPacketListener;
import net.minecraft.network.protocol.configuration.ClientboundFinishConfigurationPacket;
import net.minecraft.network.protocol.configuration.ClientboundRegistryDataPacket;
import net.minecraft.network.protocol.configuration.ClientboundResetChatPacket;
import net.minecraft.network.protocol.configuration.ClientboundSelectKnownPacks;
import net.minecraft.network.protocol.configuration.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.configuration.ServerboundFinishConfigurationPacket;
import net.minecraft.network.protocol.configuration.ServerboundSelectKnownPacks;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.gui.ModMismatchDisconnectedScreen;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.ICommonPacketListener;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.network.payload.ModdedNetworkPayload;
import net.neoforged.neoforge.network.payload.ModdedNetworkQueryPayload;
import net.neoforged.neoforge.network.payload.ModdedNetworkSetupFailedPayload;
import net.neoforged.neoforge.network.registration.NetworkPayloadSetup;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientConfigurationPacketListenerImpl
extends ClientCommonPacketListenerImpl
implements ClientConfigurationPacketListener,
TickablePacketListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final GameProfile localGameProfile;
    private FeatureFlagSet enabledFeatures;
    private final RegistryAccess.Frozen receivedRegistries;
    private final RegistryDataCollector registryDataCollector = new RegistryDataCollector();
    @Nullable
    private KnownPacksManager knownPacks;
    @Nullable
    protected ChatComponent.State chatState;
    private ConnectionType connectionType = ConnectionType.OTHER;
    private boolean initializedConnection = false;
    private Map<ResourceLocation, Component> failureReasons = new HashMap<ResourceLocation, Component>();

    public ClientConfigurationPacketListenerImpl(Minecraft p_295262_, Connection p_296339_, CommonListenerCookie p_294706_) {
        super(p_295262_, p_296339_, p_294706_);
        this.localGameProfile = p_294706_.localGameProfile();
        this.receivedRegistries = p_294706_.receivedRegistries();
        this.enabledFeatures = p_294706_.enabledFeatures();
        this.chatState = p_294706_.chatState();
    }

    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }

    @Override
    protected void handleCustomPayload(CustomPacketPayload p_295411_) {
        this.handleUnknownCustomPayload(p_295411_);
    }

    private void handleUnknownCustomPayload(CustomPacketPayload p_296412_) {
        LOGGER.warn("Unknown custom packet payload: {}", (Object)p_296412_.type().id());
    }

    public void handleRegistryData(ClientboundRegistryDataPacket p_295757_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_295757_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.registryDataCollector.appendContents(p_295757_.registry(), p_295757_.entries());
    }

    @Override
    public void handleUpdateTags(ClientboundUpdateTagsPacket p_321623_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_321623_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.registryDataCollector.appendTags(p_321623_.getTags());
    }

    public void handleEnabledFeatures(ClientboundUpdateEnabledFeaturesPacket p_294410_) {
        this.enabledFeatures = FeatureFlags.REGISTRY.fromNames(p_294410_.features());
        if (this.connectionType.isOther()) {
            this.initializedConnection = true;
            NetworkRegistry.initializeOtherConnection((ClientConfigurationPacketListener)this);
        }
    }

    public void handleSelectKnownPacks(ClientboundSelectKnownPacks p_325965_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_325965_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        if (this.knownPacks == null) {
            this.knownPacks = new KnownPacksManager();
        }
        List<KnownPack> list = this.knownPacks.trySelectingPacks(p_325965_.knownPacks());
        this.send(new ServerboundSelectKnownPacks(list));
    }

    public void handleResetChat(ClientboundResetChatPacket p_338215_) {
        this.chatState = null;
    }

    private <T> T runWithResources(Function<ResourceProvider, T> p_325978_) {
        T object;
        if (this.knownPacks == null) {
            return p_325978_.apply(ResourceProvider.EMPTY);
        }
        try (CloseableResourceManager closeableresourcemanager = this.knownPacks.createResourceManager();){
            object = p_325978_.apply((ResourceProvider)closeableresourcemanager);
        }
        return object;
    }

    public void handleConfigurationFinished(ClientboundFinishConfigurationPacket p_294585_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_294585_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        RegistryAccess.Frozen registryaccess$frozen = this.runWithResources(p_359129_ -> this.registryDataCollector.collectGameRegistries(p_359129_, this.receivedRegistries, this.connection.isMemoryConnection()));
        this.connection.setupInboundProtocol(GameProtocols.CLIENTBOUND_TEMPLATE.bind(RegistryFriendlyByteBuf.decorator((RegistryAccess)registryaccess$frozen, this.connectionType)), new ClientPacketListener(this.minecraft, this.connection, new CommonListenerCookie(this.localGameProfile, this.telemetryManager, registryaccess$frozen, this.enabledFeatures, this.serverBrand, this.serverData, this.postDisconnectScreen, this.serverCookies, this.chatState, this.customReportDetails, this.serverLinks, this.connectionType)));
        NeoForge.EVENT_BUS.post((Event)new TagsUpdatedEvent((HolderLookup.Provider)registryaccess$frozen, true, this.connection.isMemoryConnection()));
        if (!this.initializedConnection && this.connectionType.isOther()) {
            NetworkRegistry.initializeOtherConnection((ClientConfigurationPacketListener)this);
        }
        NetworkRegistry.onConfigurationFinished((ICommonPacketListener)this);
        this.connection.send((Packet<?>)ServerboundFinishConfigurationPacket.INSTANCE);
        this.connection.setupOutboundProtocol(GameProtocols.SERVERBOUND_TEMPLATE.bind(RegistryFriendlyByteBuf.decorator((RegistryAccess)registryaccess$frozen, this.connectionType), (Object)new GameProtocols.Context(this){

            public boolean hasInfiniteMaterials() {
                return true;
            }
        }));
    }

    public void tick() {
        this.sendDeferredPackets();
    }

    @Override
    public void onDisconnect(DisconnectionDetails p_351005_) {
        super.onDisconnect(p_351005_);
        this.minecraft.clearDownloadedResourcePacks();
    }

    @Override
    public void handleCustomPayload(ClientboundCustomPayloadPacket packet) {
        if (packet.payload() instanceof ModdedNetworkQueryPayload) {
            this.connectionType = ConnectionType.NEOFORGE;
            NetworkRegistry.onNetworkQuery((ClientConfigurationPacketListener)this);
            return;
        }
        CustomPacketPayload customPacketPayload = packet.payload();
        if (customPacketPayload instanceof ModdedNetworkPayload) {
            ModdedNetworkPayload moddedNetworkPayload = (ModdedNetworkPayload)customPacketPayload;
            this.initializedConnection = true;
            NetworkRegistry.initializeNeoForgeConnection((ClientConfigurationPacketListener)this, (NetworkPayloadSetup)moddedNetworkPayload.setup());
            return;
        }
        customPacketPayload = packet.payload();
        if (customPacketPayload instanceof ModdedNetworkSetupFailedPayload) {
            ModdedNetworkSetupFailedPayload setupFailedPayload = (ModdedNetworkSetupFailedPayload)customPacketPayload;
            this.failureReasons = setupFailedPayload.failureReasons();
            return;
        }
        if (this.connectionType.isOther() && packet.payload() instanceof BrandPayload) {
            this.initializedConnection = true;
            NetworkRegistry.initializeOtherConnection((ClientConfigurationPacketListener)this);
        }
        super.handleCustomPayload(packet);
    }

    @Override
    protected Screen createDisconnectScreen(DisconnectionDetails p_350769_) {
        Screen superScreen = super.createDisconnectScreen(p_350769_);
        if (this.failureReasons.isEmpty()) {
            return superScreen;
        }
        return new ModMismatchDisconnectedScreen(superScreen, (Component)Component.translatable((String)"disconnect.lost"), this.failureReasons);
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }
}

