/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.resource.CrossFrameResourcePool;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.shaders.ShaderType;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.jtracy.TracyClient;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.Zone;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.Tags;
import org.apache.commons.io.IOUtils;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class GameRenderer
implements AutoCloseable {
    private static final ResourceLocation BLUR_POST_CHAIN_ID = ResourceLocation.withDefaultNamespace("blur");
    public static final int MAX_BLUR_RADIUS = 10;
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final float PROJECTION_Z_NEAR = 0.05f;
    private static final float GUI_Z_NEAR = 1000.0f;
    private static final float PORTAL_SPINNING_SPEED = 20.0f;
    private static final float NAUSEA_SPINNING_SPEED = 7.0f;
    private final Minecraft minecraft;
    private final ResourceManager resourceManager;
    private final RandomSource random = RandomSource.create();
    private float renderDistance;
    public final ItemInHandRenderer itemInHandRenderer;
    private final RenderBuffers renderBuffers;
    private float spinningEffectTime;
    private float spinningEffectSpeed;
    private float fovModifier;
    private float oldFovModifier;
    private float darkenWorldAmount;
    private float darkenWorldAmountO;
    private boolean renderHand = true;
    private boolean renderBlockOutline = true;
    private long lastScreenshotAttempt;
    private boolean hasWorldScreenshot;
    private long lastActiveTime = Util.getMillis();
    private final LightTexture lightTexture;
    private final OverlayTexture overlayTexture = new OverlayTexture();
    private boolean panoramicMode;
    private float zoom = 1.0f;
    private float zoomX;
    private float zoomY;
    public static final int ITEM_ACTIVATION_ANIMATION_LENGTH = 40;
    @Nullable
    private ItemStack itemActivationItem;
    private int itemActivationTicks;
    private float itemActivationOffX;
    private float itemActivationOffY;
    private final CrossFrameResourcePool resourcePool = new CrossFrameResourcePool(3);
    @Nullable
    private ResourceLocation postEffectId;
    private boolean effectActive;
    private final Camera mainCamera = new Camera();

    public GameRenderer(Minecraft p_234219_, ItemInHandRenderer p_234220_, ResourceManager p_234221_, RenderBuffers p_234222_) {
        this.minecraft = p_234219_;
        this.resourceManager = p_234221_;
        this.itemInHandRenderer = p_234220_;
        this.lightTexture = new LightTexture(this, p_234219_);
        this.renderBuffers = p_234222_;
    }

    @Override
    public void close() {
        this.lightTexture.close();
        this.overlayTexture.close();
        this.resourcePool.close();
    }

    public void setRenderHand(boolean p_172737_) {
        this.renderHand = p_172737_;
    }

    public void setRenderBlockOutline(boolean p_172776_) {
        this.renderBlockOutline = p_172776_;
    }

    public void setPanoramicMode(boolean p_172780_) {
        this.panoramicMode = p_172780_;
    }

    public boolean isPanoramicMode() {
        return this.panoramicMode;
    }

    public void clearPostEffect() {
        this.postEffectId = null;
    }

    public void togglePostEffect() {
        this.effectActive = !this.effectActive;
    }

    public void checkEntityPostEffect(@Nullable Entity p_109107_) {
        this.postEffectId = null;
        if (p_109107_ instanceof Creeper) {
            this.setPostEffect(ResourceLocation.withDefaultNamespace("creeper"));
        } else if (p_109107_ instanceof Spider) {
            this.setPostEffect(ResourceLocation.withDefaultNamespace("spider"));
        } else if (p_109107_ instanceof EnderMan) {
            this.setPostEffect(ResourceLocation.withDefaultNamespace("invert"));
        } else {
            ClientHooks.loadEntityShader((Entity)p_109107_, (GameRenderer)this);
        }
    }

    public void setPostEffect(ResourceLocation p_366413_) {
        this.postEffectId = p_366413_;
        this.effectActive = true;
    }

    public void processBlurEffect() {
        PostChain postchain;
        float f = this.minecraft.options.getMenuBackgroundBlurriness();
        if (!(f < 1.0f) && (postchain = this.minecraft.getShaderManager().getPostChain(BLUR_POST_CHAIN_ID, LevelTargetBundle.MAIN_TARGETS)) != null) {
            postchain.process(this.minecraft.getMainRenderTarget(), (GraphicsResourceAllocator)this.resourcePool, p_409027_ -> p_409027_.setUniform("Radius", f));
        }
    }

    public void preloadUiShader(ResourceProvider p_172723_) {
        GpuDevice gpudevice = RenderSystem.getDevice();
        BiFunction<ResourceLocation, ShaderType, String> bifunction = (p_409024_, p_409025_) -> {
            ResourceLocation resourcelocation = p_409025_.idConverter().idToFile((ResourceLocation)p_409024_);
            try {
                String s;
                try (BufferedReader reader = p_172723_.getResourceOrThrow(resourcelocation).openAsReader();){
                    s = IOUtils.toString((Reader)reader);
                }
                return s;
            }
            catch (IOException ioexception) {
                LOGGER.error("Coudln't preload {} shader {}: {}", new Object[]{p_409025_, p_409024_, ioexception});
                return null;
            }
        };
        gpudevice.precompilePipeline(RenderPipelines.GUI, bifunction);
        gpudevice.precompilePipeline(RenderPipelines.GUI_OVERLAY, bifunction);
        gpudevice.precompilePipeline(RenderPipelines.GUI_TEXTURED_OVERLAY, bifunction);
        if (TracyClient.isAvailable()) {
            gpudevice.precompilePipeline(RenderPipelines.TRACY_BLIT, bifunction);
        }
    }

    public void tick() {
        this.tickFov();
        this.lightTexture.tick();
        LocalPlayer localplayer = this.minecraft.player;
        if (this.minecraft.getCameraEntity() == null) {
            this.minecraft.setCameraEntity(localplayer);
        }
        this.mainCamera.tick();
        this.itemInHandRenderer.tick();
        float f = localplayer.portalEffectIntensity;
        float f1 = localplayer.getEffectBlendFactor(MobEffects.NAUSEA, 1.0f);
        if (!(f > 0.0f) && !(f1 > 0.0f)) {
            this.spinningEffectSpeed = 0.0f;
        } else {
            this.spinningEffectSpeed = (f * 20.0f + f1 * 7.0f) / (f + f1);
            this.spinningEffectTime += this.spinningEffectSpeed;
        }
        if (this.minecraft.level.tickRateManager().runsNormally()) {
            this.minecraft.levelRenderer.tickParticles(this.mainCamera);
            this.darkenWorldAmountO = this.darkenWorldAmount;
            if (this.minecraft.gui.getBossOverlay().shouldDarkenScreen()) {
                this.darkenWorldAmount += 0.05f;
                if (this.darkenWorldAmount > 1.0f) {
                    this.darkenWorldAmount = 1.0f;
                }
            } else if (this.darkenWorldAmount > 0.0f) {
                this.darkenWorldAmount -= 0.0125f;
            }
            if (this.itemActivationTicks > 0) {
                --this.itemActivationTicks;
                if (this.itemActivationTicks == 0) {
                    this.itemActivationItem = null;
                }
            }
        }
    }

    @Nullable
    public ResourceLocation currentPostEffect() {
        return this.postEffectId;
    }

    public void resize(int p_109098_, int p_109099_) {
        this.resourcePool.clear();
        this.minecraft.levelRenderer.resize(p_109098_, p_109099_);
    }

    public void pick(float p_109088_) {
        Entity entity = this.minecraft.getCameraEntity();
        if (entity != null && this.minecraft.level != null && this.minecraft.player != null) {
            Entity entity2;
            HitResult hitresult;
            Profiler.get().push("pick");
            double d0 = this.minecraft.player.blockInteractionRange();
            double d1 = this.minecraft.player.entityInteractionRange();
            this.minecraft.hitResult = hitresult = this.pick(entity, d0, d1, p_109088_);
            if (hitresult instanceof EntityHitResult) {
                EntityHitResult entityhitresult = (EntityHitResult)hitresult;
                entity2 = entityhitresult.getEntity();
            } else {
                entity2 = null;
            }
            this.minecraft.crosshairPickEntity = entity2;
            Profiler.get().pop();
        }
    }

    private HitResult pick(Entity p_320077_, double p_320517_, double p_320380_, float p_319901_) {
        double d0 = Math.max(p_320517_, p_320380_);
        double d1 = Mth.square((double)d0);
        Vec3 vec3 = p_320077_.getEyePosition(p_319901_);
        HitResult hitresult = p_320077_.pick(d0, p_319901_, false);
        double d2 = hitresult.getLocation().distanceToSqr(vec3);
        if (hitresult.getType() != HitResult.Type.MISS) {
            d1 = d2;
            d0 = Math.sqrt(d2);
        }
        Vec3 vec31 = p_320077_.getViewVector(p_319901_);
        Vec3 vec32 = vec3.add(vec31.x * d0, vec31.y * d0, vec31.z * d0);
        float f = 1.0f;
        AABB aabb = p_320077_.getBoundingBox().expandTowards(vec31.scale(d0)).inflate(1.0, 1.0, 1.0);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult(p_320077_, vec3, vec32, aabb, EntitySelector.CAN_BE_PICKED, d1);
        return entityhitresult != null && entityhitresult.getLocation().distanceToSqr(vec3) < d2 ? GameRenderer.filterHitResult((HitResult)entityhitresult, vec3, p_320380_) : GameRenderer.filterHitResult(hitresult, vec3, p_320517_);
    }

    private static HitResult filterHitResult(HitResult p_319875_, Vec3 p_320631_, double p_319892_) {
        Vec3 vec3 = p_319875_.getLocation();
        if (!vec3.closerThan((Position)p_320631_, p_319892_)) {
            Vec3 vec31 = p_319875_.getLocation();
            Direction direction = Direction.getApproximateNearest((double)(vec31.x - p_320631_.x), (double)(vec31.y - p_320631_.y), (double)(vec31.z - p_320631_.z));
            return BlockHitResult.miss((Vec3)vec31, (Direction)direction, (BlockPos)BlockPos.containing((Position)vec31));
        }
        return p_319875_;
    }

    private void tickFov() {
        float f;
        Entity entity = this.minecraft.getCameraEntity();
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)entity;
            Options options = this.minecraft.options;
            boolean flag = options.getCameraType().isFirstPerson();
            float f1 = ((Double)options.fovEffectScale().get()).floatValue();
            f = abstractclientplayer.getFieldOfViewModifier(flag, f1);
        } else {
            f = 1.0f;
        }
        this.oldFovModifier = this.fovModifier;
        this.fovModifier += (f - this.fovModifier) * 0.5f;
        this.fovModifier = Mth.clamp((float)this.fovModifier, (float)0.1f, (float)1.5f);
    }

    private float getFov(Camera p_109142_, float p_109143_, boolean p_109144_) {
        FogType fogtype;
        LivingEntity livingentity;
        Entity entity;
        if (this.panoramicMode) {
            return 90.0f;
        }
        float f = 70.0f;
        if (p_109144_) {
            f = ((Integer)this.minecraft.options.fov().get()).intValue();
            f *= Mth.lerp((float)p_109143_, (float)this.oldFovModifier, (float)this.fovModifier);
        }
        if ((entity = p_109142_.getEntity()) instanceof LivingEntity && (livingentity = (LivingEntity)entity).isDeadOrDying()) {
            float f1 = Math.min((float)livingentity.deathTime + p_109143_, 20.0f);
            f /= (1.0f - 500.0f / (f1 + 500.0f)) * 2.0f + 1.0f;
        }
        if ((fogtype = p_109142_.getFluidInCamera()) == FogType.LAVA || fogtype == FogType.WATER) {
            float f2 = ((Double)this.minecraft.options.fovEffectScale().get()).floatValue();
            f *= Mth.lerp((float)f2, (float)1.0f, (float)0.85714287f);
        }
        return ClientHooks.getFieldOfView((GameRenderer)this, (Camera)p_109142_, (float)p_109143_, (float)f, (boolean)p_109144_);
    }

    private void bobHurt(PoseStack p_109118_, float p_109119_) {
        Entity entity = this.minecraft.getCameraEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            float f2 = (float)livingentity.hurtTime - p_109119_;
            if (livingentity.isDeadOrDying()) {
                float f = Math.min((float)livingentity.deathTime + p_109119_, 20.0f);
                p_109118_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(40.0f - 8000.0f / (f + 200.0f)));
            }
            if (f2 < 0.0f) {
                return;
            }
            DamageSource lastSrc = livingentity.getLastDamageSource();
            if (lastSrc != null && lastSrc.is((TagKey<DamageType>)Tags.DamageTypes.NO_FLINCH)) {
                return;
            }
            f2 /= (float)livingentity.hurtDuration;
            f2 = Mth.sin((float)(f2 * f2 * f2 * f2 * (float)Math.PI));
            float f3 = livingentity.getHurtDir();
            p_109118_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-f3));
            float f1 = (float)((double)(-f2) * 14.0 * (Double)this.minecraft.options.damageTiltStrength().get());
            p_109118_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f1));
            p_109118_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f3));
        }
    }

    private void bobView(PoseStack p_109139_, float p_109140_) {
        Entity entity = this.minecraft.getCameraEntity();
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)entity;
            float f2 = abstractclientplayer.walkDist - abstractclientplayer.walkDistO;
            float $$5 = -(abstractclientplayer.walkDist + f2 * p_109140_);
            float $$6 = Mth.lerp((float)p_109140_, (float)abstractclientplayer.oBob, (float)abstractclientplayer.bob);
            p_109139_.translate(Mth.sin((float)($$5 * (float)Math.PI)) * $$6 * 0.5f, -Math.abs(Mth.cos((float)($$5 * (float)Math.PI)) * $$6), 0.0f);
            p_109139_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(Mth.sin((float)($$5 * (float)Math.PI)) * $$6 * 3.0f));
            p_109139_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(Math.abs(Mth.cos((float)($$5 * (float)Math.PI - 0.2f)) * $$6) * 5.0f));
        }
    }

    public void renderZoomed(float p_172719_, float p_172720_, float p_172721_) {
        this.zoom = p_172719_;
        this.zoomX = p_172720_;
        this.zoomY = p_172721_;
        this.setRenderBlockOutline(false);
        this.setRenderHand(false);
        this.renderLevel(DeltaTracker.ZERO);
        this.zoom = 1.0f;
    }

    private void renderItemInHand(Camera p_109122_, float p_109123_, Matrix4f p_333953_) {
        if (!this.panoramicMode) {
            boolean flag;
            Matrix4f matrix4f = this.getProjectionMatrix(this.getFov(p_109122_, p_109123_, false));
            RenderSystem.setProjectionMatrix(matrix4f, ProjectionType.PERSPECTIVE);
            PoseStack posestack = new PoseStack();
            posestack.pushPose();
            posestack.mulPose((Matrix4fc)p_333953_.invert(new Matrix4f()));
            Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
            matrix4fstack.pushMatrix().mul((Matrix4fc)p_333953_);
            this.bobHurt(posestack, p_109123_);
            if (((Boolean)this.minecraft.options.bobView().get()).booleanValue()) {
                this.bobView(posestack, p_109123_);
            }
            boolean bl = flag = this.minecraft.getCameraEntity() instanceof LivingEntity && ((LivingEntity)this.minecraft.getCameraEntity()).isSleeping();
            if (this.minecraft.options.getCameraType().isFirstPerson() && !flag && !this.minecraft.options.hideGui && this.minecraft.gameMode.getPlayerMode() != GameType.SPECTATOR) {
                this.lightTexture.turnOnLightLayer();
                this.itemInHandRenderer.renderHandsWithItems(p_109123_, posestack, this.renderBuffers.bufferSource(), this.minecraft.player, this.minecraft.getEntityRenderDispatcher().getPackedLightCoords(this.minecraft.player, p_109123_));
                this.lightTexture.turnOffLightLayer();
            }
            matrix4fstack.popMatrix();
            posestack.popPose();
            if (this.minecraft.options.getCameraType().isFirstPerson() && !flag) {
                MultiBufferSource.BufferSource multibuffersource$buffersource = this.renderBuffers.bufferSource();
                ScreenEffectRenderer.renderScreenEffect(this.minecraft, posestack, (MultiBufferSource)multibuffersource$buffersource);
                multibuffersource$buffersource.endBatch();
            }
        }
    }

    public Matrix4f getProjectionMatrix(float p_363849_) {
        Matrix4f matrix4f = new Matrix4f();
        if (this.zoom != 1.0f) {
            matrix4f.translate(this.zoomX, -this.zoomY, 0.0f);
            matrix4f.scale(this.zoom, this.zoom, 1.0f);
        }
        return matrix4f.perspective(p_363849_ * ((float)Math.PI / 180), (float)this.minecraft.getWindow().getWidth() / (float)this.minecraft.getWindow().getHeight(), 0.05f, this.getDepthFar());
    }

    public float getDepthFar() {
        return this.renderDistance * 4.0f;
    }

    public static float getNightVisionScale(LivingEntity p_109109_, float p_109110_) {
        MobEffectInstance mobeffectinstance = p_109109_.getEffect(MobEffects.NIGHT_VISION);
        return !mobeffectinstance.endsWithin(200) ? 1.0f : 0.7f + Mth.sin((float)(((float)mobeffectinstance.getDuration() - p_109110_) * (float)Math.PI * 0.2f)) * 0.3f;
    }

    public void render(DeltaTracker p_348648_, boolean p_109096_) {
        if (!(this.minecraft.isWindowActive() || !this.minecraft.options.pauseOnLostFocus || ((Boolean)this.minecraft.options.touchscreen().get()).booleanValue() && this.minecraft.mouseHandler.isRightPressed())) {
            if (Util.getMillis() - this.lastActiveTime > 500L) {
                this.minecraft.pauseGame(false);
            }
        } else {
            this.lastActiveTime = Util.getMillis();
        }
        if (!this.minecraft.noRender) {
            ProfilerFiller profilerfiller = Profiler.get();
            boolean flag = this.minecraft.isGameLoadFinished();
            int i = (int)this.minecraft.mouseHandler.getScaledXPos(this.minecraft.getWindow());
            int j = (int)this.minecraft.mouseHandler.getScaledYPos(this.minecraft.getWindow());
            if (flag && p_109096_ && this.minecraft.level != null) {
                profilerfiller.push("level");
                this.renderLevel(p_348648_);
                this.tryTakeScreenshotIfNeeded();
                this.minecraft.levelRenderer.doEntityOutline();
                if (this.postEffectId != null && this.effectActive) {
                    RenderSystem.resetTextureMatrix();
                    PostChain postchain = this.minecraft.getShaderManager().getPostChain(this.postEffectId, LevelTargetBundle.MAIN_TARGETS);
                    if (postchain != null) {
                        postchain.process(this.minecraft.getMainRenderTarget(), (GraphicsResourceAllocator)this.resourcePool, null);
                    }
                }
            }
            Window window = this.minecraft.getWindow();
            RenderTarget rendertarget = this.minecraft.getMainRenderTarget();
            RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(rendertarget.getDepthTexture(), 1.0);
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)window.getWidth() / window.getGuiScale()), (float)((double)window.getHeight() / window.getGuiScale()), 0.0f, 1000.0f, ClientHooks.getGuiFarPlane());
            RenderSystem.setProjectionMatrix(matrix4f, ProjectionType.ORTHOGRAPHIC);
            Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
            matrix4fstack.pushMatrix();
            matrix4fstack.translation(0.0f, 0.0f, 10000.0f - ClientHooks.getGuiFarPlane());
            Lighting.setupFor3DItems();
            GuiGraphics guigraphics = new GuiGraphics(this.minecraft, this.renderBuffers.bufferSource());
            if (flag && p_109096_ && this.minecraft.level != null) {
                profilerfiller.popPush("gui");
                if (!this.minecraft.options.hideGui) {
                    this.renderItemActivationAnimation(guigraphics, p_348648_.getGameTimeDeltaPartialTick(false));
                }
                this.minecraft.gui.render(guigraphics, p_348648_);
                guigraphics.flush();
                RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(rendertarget.getDepthTexture(), 1.0);
                profilerfiller.pop();
            }
            if (this.minecraft.getOverlay() != null) {
                try {
                    this.minecraft.getOverlay().render(guigraphics, i, j, p_348648_.getGameTimeDeltaTicks());
                }
                catch (Throwable throwable2) {
                    CrashReport crashreport = CrashReport.forThrowable(throwable2, "Rendering overlay");
                    CrashReportCategory crashreportcategory = crashreport.addCategory("Overlay render details");
                    crashreportcategory.setDetail("Overlay name", (CrashReportDetail<String>)((CrashReportDetail)() -> this.minecraft.getOverlay().getClass().getCanonicalName()));
                    throw new ReportedException(crashreport);
                }
            }
            if (flag && this.minecraft.screen != null) {
                try {
                    ClientHooks.drawScreen((Screen)this.minecraft.screen, (GuiGraphics)guigraphics, (int)i, (int)j, (float)p_348648_.getGameTimeDeltaTicks());
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport1 = CrashReport.forThrowable(throwable1, "Rendering screen");
                    CrashReportCategory crashreportcategory1 = crashreport1.addCategory("Screen render details");
                    crashreportcategory1.setDetail("Screen name", (CrashReportDetail<String>)((CrashReportDetail)() -> ((Object)((Object)this.minecraft.screen)).getClass().getCanonicalName()));
                    this.minecraft.mouseHandler.fillMousePositionDetails(crashreportcategory1, this.minecraft.getWindow());
                    throw new ReportedException(crashreport1);
                }
                try {
                    if (this.minecraft.screen != null) {
                        this.minecraft.screen.handleDelayedNarration();
                    }
                }
                catch (Throwable throwable) {
                    CrashReport crashreport2 = CrashReport.forThrowable(throwable, "Narrating screen");
                    CrashReportCategory crashreportcategory2 = crashreport2.addCategory("Screen details");
                    crashreportcategory2.setDetail("Screen name", (CrashReportDetail<String>)((CrashReportDetail)() -> ((Object)((Object)this.minecraft.screen)).getClass().getCanonicalName()));
                    throw new ReportedException(crashreport2);
                }
            }
            if (flag && p_109096_ && this.minecraft.level != null) {
                this.minecraft.gui.renderSavingIndicator(guigraphics, p_348648_);
            }
            if (flag) {
                try (Zone zone = profilerfiller.zone("toasts");){
                    this.minecraft.getToastManager().render(guigraphics);
                }
            }
            guigraphics.flush();
            matrix4fstack.popMatrix();
            this.resourcePool.endFrame();
        }
    }

    private void tryTakeScreenshotIfNeeded() {
        long i;
        if (!this.hasWorldScreenshot && this.minecraft.isLocalServer() && (i = Util.getMillis()) - this.lastScreenshotAttempt >= 1000L) {
            this.lastScreenshotAttempt = i;
            IntegratedServer integratedserver = this.minecraft.getSingleplayerServer();
            if (integratedserver != null && !integratedserver.isStopped()) {
                integratedserver.getWorldScreenshotFile().ifPresent(p_234239_ -> {
                    if (Files.isRegularFile(p_234239_, new LinkOption[0])) {
                        this.hasWorldScreenshot = true;
                    } else {
                        this.takeAutoScreenshot((Path)p_234239_);
                    }
                });
            }
        }
    }

    private void takeAutoScreenshot(Path p_182643_) {
        if (this.minecraft.levelRenderer.countRenderedSections() > 10 && this.minecraft.levelRenderer.hasRenderedAllSections()) {
            Screenshot.takeScreenshot(this.minecraft.getMainRenderTarget(), p_406191_ -> Util.ioPool().execute(() -> {
                int i = p_406191_.getWidth();
                int j = p_406191_.getHeight();
                int k = 0;
                int l = 0;
                if (i > j) {
                    k = (i - j) / 2;
                    i = j;
                } else {
                    l = (j - i) / 2;
                    j = i;
                }
                try (NativeImage nativeimage = new NativeImage(64, 64, false);){
                    p_406191_.resizeSubRectTo(k, l, i, j, nativeimage);
                    nativeimage.writeToFile(p_182643_);
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Couldn't save auto screenshot", (Throwable)ioexception);
                }
                finally {
                    p_406191_.close();
                }
            }));
        }
    }

    private boolean shouldRenderBlockOutline() {
        boolean flag;
        if (!this.renderBlockOutline) {
            return false;
        }
        Entity entity = this.minecraft.getCameraEntity();
        boolean bl = flag = entity instanceof Player && !this.minecraft.options.hideGui;
        if (flag && !((Player)entity).getAbilities().mayBuild) {
            ItemStack itemstack = ((LivingEntity)entity).getMainHandItem();
            HitResult hitresult = this.minecraft.hitResult;
            if (hitresult != null && hitresult.getType() == HitResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockHitResult)hitresult).getBlockPos();
                BlockState blockstate = this.minecraft.level.getBlockState(blockpos);
                if (this.minecraft.gameMode.getPlayerMode() == GameType.SPECTATOR) {
                    flag = blockstate.getMenuProvider(this.minecraft.level, blockpos) != null;
                } else {
                    BlockInWorld blockinworld = new BlockInWorld((LevelReader)((Object)this.minecraft.level), blockpos, false);
                    Registry registry = this.minecraft.level.registryAccess().lookupOrThrow(Registries.BLOCK);
                    flag = !itemstack.isEmpty() && (itemstack.canBreakBlockInAdventureMode(blockinworld) || itemstack.canPlaceOnBlockInAdventureMode(blockinworld));
                }
            }
        }
        return flag;
    }

    public void renderLevel(DeltaTracker p_348589_) {
        float f = p_348589_.getGameTimeDeltaPartialTick(true);
        LocalPlayer localplayer = this.minecraft.player;
        this.lightTexture.updateLightTexture(f);
        if (this.minecraft.getCameraEntity() == null) {
            this.minecraft.setCameraEntity(localplayer);
        }
        this.pick(f);
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("center");
        boolean flag = this.shouldRenderBlockOutline();
        profilerfiller.popPush("camera");
        Camera camera = this.mainCamera;
        LocalPlayer entity = this.minecraft.getCameraEntity() == null ? localplayer : this.minecraft.getCameraEntity();
        float f1 = this.minecraft.level.tickRateManager().isEntityFrozen((Entity)entity) ? 1.0f : f;
        camera.setup((BlockGetter)((Object)this.minecraft.level), entity, !this.minecraft.options.getCameraType().isFirstPerson(), this.minecraft.options.getCameraType().isMirrored(), f1);
        this.renderDistance = this.minecraft.options.getEffectiveRenderDistance() * 16;
        float f2 = this.getFov(camera, f, true);
        Matrix4f matrix4f = this.getProjectionMatrix(f2);
        PoseStack posestack = new PoseStack();
        this.bobHurt(posestack, camera.getPartialTickTime());
        if (((Boolean)this.minecraft.options.bobView().get()).booleanValue()) {
            this.bobView(posestack, camera.getPartialTickTime());
        }
        matrix4f.mul((Matrix4fc)posestack.last().pose());
        float f3 = ((Double)this.minecraft.options.screenEffectScale().get()).floatValue();
        float f4 = Mth.lerp((float)f, (float)localplayer.oPortalEffectIntensity, (float)localplayer.portalEffectIntensity);
        float f5 = localplayer.getEffectBlendFactor(MobEffects.NAUSEA, f);
        float f6 = Math.max(f4, f5) * (f3 * f3);
        if (f6 > 0.0f) {
            float f7 = 5.0f / (f6 * f6 + 5.0f) - f6 * 0.04f;
            f7 *= f7;
            Vector3f vector3f = new Vector3f(0.0f, Mth.SQRT_OF_TWO / 2.0f, Mth.SQRT_OF_TWO / 2.0f);
            float f8 = (this.spinningEffectTime + f * this.spinningEffectSpeed) * ((float)Math.PI / 180);
            matrix4f.rotate(f8, (Vector3fc)vector3f);
            matrix4f.scale(1.0f / f7, 1.0f, 1.0f);
            matrix4f.rotate(-f8, (Vector3fc)vector3f);
        }
        float f9 = Math.max(f2, (float)((Integer)this.minecraft.options.fov().get()).intValue());
        Matrix4f matrix4f2 = this.getProjectionMatrix(f9);
        RenderSystem.setProjectionMatrix(matrix4f, ProjectionType.PERSPECTIVE);
        Quaternionf quaternionf = camera.rotation().conjugate(new Quaternionf());
        Matrix4f matrix4f1 = new Matrix4f().rotation((Quaternionfc)quaternionf);
        this.minecraft.levelRenderer.prepareCullFrustum(camera.getPosition(), matrix4f1, matrix4f2);
        this.minecraft.levelRenderer.renderLevel((GraphicsResourceAllocator)this.resourcePool, p_348589_, flag, camera, this, matrix4f1, matrix4f);
        profilerfiller.popPush("neoforge_render_last");
        ClientHooks.dispatchRenderStage((RenderLevelStageEvent.Stage)RenderLevelStageEvent.Stage.AFTER_LEVEL, (Level)this.minecraft.level, (LevelRenderer)this.minecraft.levelRenderer, null, (Matrix4f)matrix4f1, (Matrix4f)matrix4f, (int)this.minecraft.levelRenderer.getTicks(), (Camera)camera, (Frustum)this.minecraft.levelRenderer.getFrustum());
        profilerfiller.popPush("hand");
        if (this.renderHand) {
            RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(this.minecraft.getMainRenderTarget().getDepthTexture(), 1.0);
            this.renderItemInHand(camera, f, matrix4f1);
        }
        profilerfiller.pop();
    }

    public void resetData() {
        this.itemActivationItem = null;
        this.minecraft.getMapTextureManager().resetData();
        this.mainCamera.reset();
        this.hasWorldScreenshot = false;
    }

    public void displayItemActivation(ItemStack p_109114_) {
        this.itemActivationItem = p_109114_;
        this.itemActivationTicks = 40;
        this.itemActivationOffX = this.random.nextFloat() * 2.0f - 1.0f;
        this.itemActivationOffY = this.random.nextFloat() * 2.0f - 1.0f;
    }

    private void renderItemActivationAnimation(GuiGraphics p_350868_, float p_109103_) {
        if (this.itemActivationItem != null && this.itemActivationTicks > 0) {
            int i = 40 - this.itemActivationTicks;
            float f = ((float)i + p_109103_) / 40.0f;
            float f1 = f * f;
            float f2 = f * f1;
            float f3 = 10.25f * f2 * f1 - 24.95f * f1 * f1 + 25.5f * f2 - 13.8f * f1 + 4.0f * f;
            float f4 = f3 * (float)Math.PI;
            float f5 = this.itemActivationOffX * (float)(p_350868_.guiWidth() / 4);
            float f6 = this.itemActivationOffY * (float)(p_350868_.guiHeight() / 4);
            PoseStack posestack = p_350868_.pose();
            posestack.pushPose();
            posestack.translate((float)(p_350868_.guiWidth() / 2) + f5 * Mth.abs((float)Mth.sin((float)(f4 * 2.0f))), (float)(p_350868_.guiHeight() / 2) + f6 * Mth.abs((float)Mth.sin((float)(f4 * 2.0f))), -50.0f);
            float f7 = 50.0f + 175.0f * Mth.sin((float)f4);
            posestack.scale(f7, -f7, f7);
            posestack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(900.0f * Mth.abs((float)Mth.sin((float)f4))));
            posestack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(6.0f * Mth.cos((float)(f * 8.0f))));
            posestack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(6.0f * Mth.cos((float)(f * 8.0f))));
            p_350868_.drawSpecial(p_370289_ -> this.minecraft.getItemRenderer().renderStatic(this.itemActivationItem, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, posestack, (MultiBufferSource)p_370289_, this.minecraft.level, 0));
            posestack.popPose();
        }
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public float getDarkenWorldAmount(float p_109132_) {
        return Mth.lerp((float)p_109132_, (float)this.darkenWorldAmountO, (float)this.darkenWorldAmount);
    }

    public float getRenderDistance() {
        return this.renderDistance;
    }

    public Camera getMainCamera() {
        return this.mainCamera;
    }

    public LightTexture lightTexture() {
        return this.lightTexture;
    }

    public OverlayTexture overlayTexture() {
        return this.overlayTexture;
    }
}

