/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.framegraph.FramePass;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.resource.RenderTargetDescriptor;
import com.mojang.blaze3d.resource.ResourceDescriptor;
import com.mojang.blaze3d.resource.ResourceHandle;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.PrioritizeChunkUpdates;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.CloudRenderer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionOcclusionGraph;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SkyRenderer;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.WeatherEffectRenderer;
import net.minecraft.client.renderer.WorldBorderRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.ARGB;
import net.minecraft.util.Brightness;
import net.minecraft.util.Mth;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.Zone;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.IRenderableSection;
import net.neoforged.neoforge.client.event.FrameGraphSetupEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class LevelRenderer
implements ResourceManagerReloadListener,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation TRANSPARENCY_POST_CHAIN_ID = ResourceLocation.withDefaultNamespace("transparency");
    private static final ResourceLocation ENTITY_OUTLINE_POST_CHAIN_ID = ResourceLocation.withDefaultNamespace("entity_outline");
    public static final int SECTION_SIZE = 16;
    public static final int HALF_SECTION_SIZE = 8;
    public static final int NEARBY_SECTION_DISTANCE_IN_BLOCKS = 32;
    private static final int MINIMUM_TRANSPARENT_SORT_COUNT = 15;
    private final Minecraft minecraft;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    private final RenderBuffers renderBuffers;
    private final SkyRenderer skyRenderer = new SkyRenderer();
    private final CloudRenderer cloudRenderer = new CloudRenderer();
    private final WorldBorderRenderer worldBorderRenderer = new WorldBorderRenderer();
    private final WeatherEffectRenderer weatherEffectRenderer = new WeatherEffectRenderer();
    @Nullable
    private ClientLevel level;
    private final SectionOcclusionGraph sectionOcclusionGraph = new SectionOcclusionGraph();
    private final ObjectArrayList<SectionRenderDispatcher.RenderSection> visibleSections = new ObjectArrayList(10000);
    private final ObjectArrayList<SectionRenderDispatcher.RenderSection> nearbyVisibleSections = new ObjectArrayList(50);
    private final Set<BlockEntity> globalBlockEntities = Sets.newHashSet();
    @Nullable
    private ViewArea viewArea;
    private int ticks;
    private final Int2ObjectMap<BlockDestructionProgress> destroyingBlocks = new Int2ObjectOpenHashMap();
    private final Long2ObjectMap<SortedSet<BlockDestructionProgress>> destructionProgress = new Long2ObjectOpenHashMap();
    @Nullable
    private RenderTarget entityOutlineTarget;
    private final LevelTargetBundle targets = new LevelTargetBundle();
    private int lastCameraSectionX = Integer.MIN_VALUE;
    private int lastCameraSectionY = Integer.MIN_VALUE;
    private int lastCameraSectionZ = Integer.MIN_VALUE;
    private double prevCamX = Double.MIN_VALUE;
    private double prevCamY = Double.MIN_VALUE;
    private double prevCamZ = Double.MIN_VALUE;
    private double prevCamRotX = Double.MIN_VALUE;
    private double prevCamRotY = Double.MIN_VALUE;
    @Nullable
    private SectionRenderDispatcher sectionRenderDispatcher;
    private int lastViewDistance = -1;
    private final List<Entity> visibleEntities = new ArrayList<Entity>();
    private int visibleEntityCount;
    private Frustum cullingFrustum;
    private boolean captureFrustum;
    @Nullable
    private Frustum capturedFrustum;
    @Nullable
    private BlockPos lastTranslucentSortBlockPos;
    private int translucencyResortIterationIndex;

    public LevelRenderer(Minecraft p_234245_, EntityRenderDispatcher p_234246_, BlockEntityRenderDispatcher p_234247_, RenderBuffers p_234248_) {
        this.minecraft = p_234245_;
        this.entityRenderDispatcher = p_234246_;
        this.blockEntityRenderDispatcher = p_234247_;
        this.renderBuffers = p_234248_;
    }

    public void tickParticles(Camera p_363405_) {
        this.weatherEffectRenderer.tickRainParticles(this.minecraft.level, p_363405_, this.ticks, (ParticleStatus)this.minecraft.options.particles().get());
    }

    @Override
    public void close() {
        if (this.entityOutlineTarget != null) {
            this.entityOutlineTarget.destroyBuffers();
        }
        this.skyRenderer.close();
        this.cloudRenderer.close();
    }

    public void onResourceManagerReload(ResourceManager p_109513_) {
        this.initOutline();
    }

    public void initOutline() {
        if (this.entityOutlineTarget != null) {
            this.entityOutlineTarget.destroyBuffers();
        }
        this.entityOutlineTarget = new TextureTarget("Entity Outline", this.minecraft.getWindow().getWidth(), this.minecraft.getWindow().getHeight(), true);
    }

    @Nullable
    private PostChain getTransparencyChain() {
        if (!Minecraft.useShaderTransparency()) {
            return null;
        }
        PostChain postchain = this.minecraft.getShaderManager().getPostChain(TRANSPARENCY_POST_CHAIN_ID, LevelTargetBundle.SORTING_TARGETS);
        if (postchain == null) {
            this.minecraft.options.graphicsMode().set((Object)GraphicsStatus.FANCY);
            this.minecraft.options.save();
        }
        return postchain;
    }

    public void doEntityOutline() {
        if (this.shouldShowEntityOutlines()) {
            this.entityOutlineTarget.blitAndBlendToTexture(this.minecraft.getMainRenderTarget().getColorTexture());
        }
    }

    public boolean shouldShowEntityOutlines() {
        return !this.minecraft.gameRenderer.isPanoramicMode() && this.entityOutlineTarget != null && this.minecraft.player != null;
    }

    public void setLevel(@Nullable ClientLevel p_109702_) {
        this.lastCameraSectionX = Integer.MIN_VALUE;
        this.lastCameraSectionY = Integer.MIN_VALUE;
        this.lastCameraSectionZ = Integer.MIN_VALUE;
        this.entityRenderDispatcher.setLevel(p_109702_);
        this.level = p_109702_;
        if (p_109702_ != null) {
            this.allChanged();
        } else {
            if (this.viewArea != null) {
                this.viewArea.releaseAllBuffers();
                this.viewArea = null;
            }
            if (this.sectionRenderDispatcher != null) {
                this.sectionRenderDispatcher.dispose();
            }
            this.sectionRenderDispatcher = null;
            this.globalBlockEntities.clear();
            this.sectionOcclusionGraph.waitAndReset(null);
            this.clearVisibleSections();
        }
    }

    private void clearVisibleSections() {
        this.visibleSections.clear();
        this.nearbyVisibleSections.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allChanged() {
        if (this.level != null) {
            this.level.clearTintCaches();
            if (this.sectionRenderDispatcher == null) {
                this.sectionRenderDispatcher = new SectionRenderDispatcher(this.level, this, Util.backgroundExecutor(), this.renderBuffers, this.minecraft.getBlockRenderer(), this.minecraft.getBlockEntityRenderDispatcher());
            } else {
                this.sectionRenderDispatcher.setLevel(this.level);
            }
            this.cloudRenderer.markForRebuild();
            ItemBlockRenderTypes.setFancy(Minecraft.useFancyGraphics());
            this.lastViewDistance = this.minecraft.options.getEffectiveRenderDistance();
            if (this.viewArea != null) {
                this.viewArea.releaseAllBuffers();
            }
            this.sectionRenderDispatcher.blockUntilClear();
            Set<BlockEntity> set = this.globalBlockEntities;
            synchronized (set) {
                this.globalBlockEntities.clear();
            }
            this.viewArea = new ViewArea(this.sectionRenderDispatcher, (Level)this.level, this.minecraft.options.getEffectiveRenderDistance(), this);
            this.sectionOcclusionGraph.waitAndReset(this.viewArea);
            this.clearVisibleSections();
            Camera camera = this.minecraft.gameRenderer.getMainCamera();
            this.viewArea.repositionCamera(SectionPos.of((Position)camera.getPosition()));
        }
    }

    public void resize(int p_109488_, int p_109489_) {
        this.needsUpdate();
        if (this.entityOutlineTarget != null) {
            this.entityOutlineTarget.resize(p_109488_, p_109489_);
        }
    }

    public String getSectionStatistics() {
        int i = this.viewArea.sections.length;
        int j = this.countRenderedSections();
        return String.format(Locale.ROOT, "C: %d/%d %sD: %d, %s", j, i, this.minecraft.smartCull ? "(s) " : "", this.lastViewDistance, this.sectionRenderDispatcher == null ? "null" : this.sectionRenderDispatcher.getStats());
    }

    public SectionRenderDispatcher getSectionRenderDispatcher() {
        return this.sectionRenderDispatcher;
    }

    public double getTotalSections() {
        return this.viewArea.sections.length;
    }

    public double getLastViewDistance() {
        return this.lastViewDistance;
    }

    public int countRenderedSections() {
        int i = 0;
        for (SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection : this.visibleSections) {
            if (!sectionrenderdispatcher$rendersection.getCompiled().hasRenderableLayers()) continue;
            ++i;
        }
        return i;
    }

    public String getEntityStatistics() {
        return "E: " + this.visibleEntityCount + "/" + this.level.getEntityCount() + ", SD: " + this.level.getServerSimulationDistance();
    }

    private void setupRender(Camera p_194339_, Frustum p_194340_, boolean p_194341_, boolean p_194342_) {
        Vec3 vec3 = p_194339_.getPosition();
        if (this.minecraft.options.getEffectiveRenderDistance() != this.lastViewDistance) {
            this.allChanged();
        }
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("camera");
        int i = SectionPos.posToSectionCoord((double)vec3.x());
        int j = SectionPos.posToSectionCoord((double)vec3.y());
        int k = SectionPos.posToSectionCoord((double)vec3.z());
        if (this.lastCameraSectionX != i || this.lastCameraSectionY != j || this.lastCameraSectionZ != k) {
            this.lastCameraSectionX = i;
            this.lastCameraSectionY = j;
            this.lastCameraSectionZ = k;
            this.viewArea.repositionCamera(SectionPos.of((Position)vec3));
            this.worldBorderRenderer.invalidate();
        }
        this.sectionRenderDispatcher.setCamera(vec3);
        profilerfiller.popPush("cull");
        double d0 = Math.floor(vec3.x / 8.0);
        double d1 = Math.floor(vec3.y / 8.0);
        double d2 = Math.floor(vec3.z / 8.0);
        if (d0 != this.prevCamX || d1 != this.prevCamY || d2 != this.prevCamZ) {
            this.sectionOcclusionGraph.invalidate();
        }
        this.prevCamX = d0;
        this.prevCamY = d1;
        this.prevCamZ = d2;
        profilerfiller.popPush("update");
        if (!p_194341_) {
            boolean flag = this.minecraft.smartCull;
            if (p_194342_ && this.level.getBlockState(p_194339_.getBlockPosition()).isSolidRender()) {
                flag = false;
            }
            profilerfiller.push("section_occlusion_graph");
            this.sectionOcclusionGraph.update(flag, p_194339_, p_194340_, this.visibleSections, this.level.getChunkSource().getLoadedEmptySections());
            profilerfiller.pop();
            double d3 = Math.floor(p_194339_.getXRot() / 2.0f);
            double d4 = Math.floor(p_194339_.getYRot() / 2.0f);
            if (this.sectionOcclusionGraph.consumeFrustumUpdate() || d3 != this.prevCamRotX || d4 != this.prevCamRotY) {
                this.applyFrustum(LevelRenderer.offsetFrustum(p_194340_));
                this.prevCamRotX = d3;
                this.prevCamRotY = d4;
            }
        }
        profilerfiller.pop();
    }

    public static Frustum offsetFrustum(Frustum p_296151_) {
        return new Frustum(p_296151_).offsetToFullyIncludeCameraCube(8);
    }

    private void applyFrustum(Frustum p_194355_) {
        if (!Minecraft.getInstance().isSameThread()) {
            throw new IllegalStateException("applyFrustum called from wrong thread: " + Thread.currentThread().getName());
        }
        Profiler.get().push("apply_frustum");
        this.clearVisibleSections();
        this.sectionOcclusionGraph.addSectionsInFrustum(p_194355_, this.visibleSections, this.nearbyVisibleSections);
        Profiler.get().pop();
    }

    public void addRecentlyCompiledSection(SectionRenderDispatcher.RenderSection p_295462_) {
        this.sectionOcclusionGraph.schedulePropagationFrom(p_295462_);
    }

    public void prepareCullFrustum(Vec3 p_253766_, Matrix4f p_254341_, Matrix4f p_323487_) {
        this.cullingFrustum = new Frustum(p_254341_, p_323487_);
        this.cullingFrustum.prepare(p_253766_.x(), p_253766_.y(), p_253766_.z());
    }

    public void renderLevel(GraphicsResourceAllocator p_361796_, DeltaTracker p_348530_, boolean p_109603_, Camera p_109604_, GameRenderer p_109605_, Matrix4f p_254120_, Matrix4f p_323920_) {
        float f2;
        float f = p_348530_.getGameTimeDeltaPartialTick(false);
        RenderSystem.setShaderGameTime(this.level.getGameTime(), f);
        this.blockEntityRenderDispatcher.prepare((Level)this.level, p_109604_, this.minecraft.hitResult);
        this.entityRenderDispatcher.prepare(this.level, p_109604_, this.minecraft.crosshairPickEntity);
        final ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.popPush("light_update_queue");
        this.level.pollLightUpdates();
        profilerfiller.popPush("light_updates");
        this.level.getChunkSource().getLightEngine().runLightUpdates();
        Vec3 vec3 = p_109604_.getPosition();
        double d0 = vec3.x();
        double d1 = vec3.y();
        double d2 = vec3.z();
        profilerfiller.popPush("culling");
        boolean flag = this.capturedFrustum != null;
        Frustum frustum = flag ? this.capturedFrustum : this.cullingFrustum;
        Profiler.get().popPush("captureFrustum");
        if (this.captureFrustum) {
            this.capturedFrustum = flag ? new Frustum(p_254120_, p_323920_) : frustum;
            this.capturedFrustum.prepare(d0, d1, d2);
            this.captureFrustum = false;
        }
        profilerfiller.popPush("fog");
        float f1 = p_109605_.getRenderDistance();
        boolean flag1 = this.minecraft.level.effects().isFoggyAt(Mth.floor((double)d0), Mth.floor((double)d1)) || this.minecraft.gui.getBossOverlay().shouldCreateWorldFog();
        Vector4f vector4f = FogRenderer.computeFogColor(p_109604_, f, this.minecraft.level, this.minecraft.options.getEffectiveRenderDistance(), p_109605_.getDarkenWorldAmount(f));
        FogParameters fogparameters = FogRenderer.setupFog(p_109604_, FogRenderer.FogMode.FOG_TERRAIN, vector4f, f1, flag1, f);
        FogParameters fogparameters1 = FogRenderer.setupFog(p_109604_, FogRenderer.FogMode.FOG_SKY, vector4f, f1, flag1, f);
        profilerfiller.popPush("cullEntities");
        boolean flag2 = this.collectVisibleEntities(p_109604_, frustum, this.visibleEntities);
        this.visibleEntityCount = this.visibleEntities.size();
        profilerfiller.popPush("terrain_setup");
        this.setupRender(p_109604_, frustum, flag, this.minecraft.player.isSpectator());
        profilerfiller.popPush("compile_sections");
        this.compileSections(p_109604_);
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        matrix4fstack.pushMatrix();
        matrix4fstack.mul((Matrix4fc)p_254120_);
        FrameGraphBuilder framegraphbuilder = new FrameGraphBuilder();
        this.targets.main = framegraphbuilder.importExternal("main", (Object)this.minecraft.getMainRenderTarget());
        int i = this.minecraft.getMainRenderTarget().width;
        int j = this.minecraft.getMainRenderTarget().height;
        RenderTargetDescriptor rendertargetdescriptor = new RenderTargetDescriptor(i, j, true, 0, this.minecraft.getMainRenderTarget().useStencil);
        PostChain postchain = this.getTransparencyChain();
        if (postchain != null) {
            this.targets.translucent = framegraphbuilder.createInternal("translucent", (ResourceDescriptor)rendertargetdescriptor);
            this.targets.itemEntity = framegraphbuilder.createInternal("item_entity", (ResourceDescriptor)rendertargetdescriptor);
            this.targets.particles = framegraphbuilder.createInternal("particles", (ResourceDescriptor)rendertargetdescriptor);
            this.targets.weather = framegraphbuilder.createInternal("weather", (ResourceDescriptor)rendertargetdescriptor);
            this.targets.clouds = framegraphbuilder.createInternal("clouds", (ResourceDescriptor)rendertargetdescriptor);
        }
        if (this.entityOutlineTarget != null) {
            this.targets.entityOutline = framegraphbuilder.importExternal("entity_outline", (Object)this.entityOutlineTarget);
        }
        FrameGraphSetupEvent setupEvent = ClientHooks.fireFrameGraphSetup((FrameGraphBuilder)framegraphbuilder, (LevelTargetBundle)this.targets, (RenderTargetDescriptor)rendertargetdescriptor, (Frustum)frustum, (Camera)p_109604_, (Matrix4f)p_254120_, (Matrix4f)p_323920_, (DeltaTracker)p_348530_, (ProfilerFiller)profilerfiller);
        flag2 |= setupEvent.isOutlineProcessingEnabled();
        FramePass framepass = framegraphbuilder.addPass("clear");
        this.targets.main = framepass.readsAndWrites(this.targets.main);
        framepass.executes(() -> {
            RenderTarget rendertarget = this.minecraft.getMainRenderTarget();
            RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(rendertarget.getColorTexture(), ARGB.colorFromFloat((float)0.0f, (float)vector4f.x, (float)vector4f.y, (float)vector4f.z), rendertarget.getDepthTexture(), 1.0);
        });
        if (!flag1) {
            this.addSkyPass(framegraphbuilder, p_109604_, f, fogparameters1, p_254120_, p_323920_);
        }
        this.addMainPass(framegraphbuilder, frustum, p_109604_, p_254120_, p_323920_, fogparameters, p_109603_, flag2, p_348530_, profilerfiller);
        PostChain postchain1 = this.minecraft.getShaderManager().getPostChain(ENTITY_OUTLINE_POST_CHAIN_ID, LevelTargetBundle.OUTLINE_TARGETS);
        if (flag2 && postchain1 != null) {
            postchain1.addToFrame(framegraphbuilder, i, j, (PostChain.TargetBundle)this.targets, null);
        }
        this.addParticlesPass(framegraphbuilder, p_109604_, f, fogparameters, frustum, p_254120_, p_323920_);
        CloudStatus cloudstatus = this.minecraft.options.getCloudsType();
        if (cloudstatus != CloudStatus.OFF && !Float.isNaN(f2 = this.level.effects().getCloudHeight())) {
            float f3 = (float)this.ticks + f;
            int k = this.level.getCloudColor(f);
            this.addCloudsPass(framegraphbuilder, cloudstatus, p_109604_.getPosition(), f3, k, f2 + 0.33f);
        }
        this.addWeatherPass(framegraphbuilder, p_109604_.getPosition(), f, fogparameters, p_254120_, p_323920_, p_109604_);
        if (postchain != null) {
            postchain.addToFrame(framegraphbuilder, i, j, (PostChain.TargetBundle)this.targets, null);
        }
        this.addLateDebugPass(framegraphbuilder, vec3, fogparameters);
        profilerfiller.popPush("framegraph");
        framegraphbuilder.execute(p_361796_, new FrameGraphBuilder.Inspector(){

            public void beforeExecutePass(String p_363206_) {
                profilerfiller.push(p_363206_);
            }

            public void afterExecutePass(String p_362054_) {
                profilerfiller.pop();
            }
        });
        this.visibleEntities.clear();
        this.targets.clear();
        matrix4fstack.popMatrix();
        RenderSystem.setShaderFog(FogParameters.NO_FOG);
    }

    private void addMainPass(FrameGraphBuilder p_361593_, Frustum p_366590_, Camera p_363453_, Matrix4f p_362420_, Matrix4f p_361272_, FogParameters p_363661_, boolean p_363964_, boolean p_362137_, DeltaTracker p_360931_, ProfilerFiller p_362234_) {
        FramePass framepass = p_361593_.addPass("main");
        this.targets.main = framepass.readsAndWrites(this.targets.main);
        if (this.targets.translucent != null) {
            this.targets.translucent = framepass.readsAndWrites(this.targets.translucent);
        }
        if (this.targets.itemEntity != null) {
            this.targets.itemEntity = framepass.readsAndWrites(this.targets.itemEntity);
        }
        if (this.targets.weather != null) {
            this.targets.weather = framepass.readsAndWrites(this.targets.weather);
        }
        if (p_362137_ && this.targets.entityOutline != null) {
            this.targets.entityOutline = framepass.readsAndWrites(this.targets.entityOutline);
        }
        ResourceHandle resourcehandle = this.targets.main;
        ResourceHandle resourcehandle1 = this.targets.translucent;
        ResourceHandle resourcehandle2 = this.targets.itemEntity;
        ResourceHandle resourcehandle3 = this.targets.entityOutline;
        framepass.executes(() -> {
            RenderSystem.setShaderFog(p_363661_);
            float f = p_360931_.getGameTimeDeltaPartialTick(false);
            Vec3 vec3 = p_363453_.getPosition();
            double d0 = vec3.x();
            double d1 = vec3.y();
            double d2 = vec3.z();
            p_362234_.push("terrain");
            this.renderSectionLayer(RenderType.solid(), d0, d1, d2, p_362420_, p_361272_);
            this.minecraft.getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS).setBlurMipmap(false, (Integer)this.minecraft.options.mipmapLevels().get() > 0);
            this.renderSectionLayer(RenderType.cutoutMipped(), d0, d1, d2, p_362420_, p_361272_);
            this.minecraft.getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS).restoreLastBlurMipmap();
            this.renderSectionLayer(RenderType.cutout(), d0, d1, d2, p_362420_, p_361272_);
            if (this.level.effects().constantAmbientLight()) {
                Lighting.setupNetherLevel();
            } else {
                Lighting.setupLevel();
            }
            if (resourcehandle2 != null) {
                ((RenderTarget)resourcehandle2.get()).copyDepthFrom(this.minecraft.getMainRenderTarget());
            }
            if (this.shouldShowEntityOutlines() && resourcehandle3 != null) {
                RenderTarget rendertarget = (RenderTarget)resourcehandle3.get();
                RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(rendertarget.getColorTexture(), 0, rendertarget.getDepthTexture(), 1.0);
            }
            PoseStack posestack = new PoseStack();
            MultiBufferSource.BufferSource multibuffersource$buffersource = this.renderBuffers.bufferSource();
            MultiBufferSource.BufferSource multibuffersource$buffersource1 = this.renderBuffers.crumblingBufferSource();
            p_362234_.popPush("entities");
            this.renderEntities(posestack, multibuffersource$buffersource, p_363453_, p_360931_, this.visibleEntities);
            multibuffersource$buffersource.endLastBatch();
            ClientHooks.dispatchRenderStage((RenderLevelStageEvent.Stage)RenderLevelStageEvent.Stage.AFTER_ENTITIES, (Level)this.level, (LevelRenderer)this, (PoseStack)posestack, (Matrix4f)p_362420_, (Matrix4f)p_361272_, (int)this.ticks, (Camera)p_363453_, (Frustum)p_366590_);
            this.checkPoseStack(posestack);
            p_362234_.popPush("blockentities");
            this.renderBlockEntities(posestack, multibuffersource$buffersource, multibuffersource$buffersource1, p_363453_, f);
            multibuffersource$buffersource.endLastBatch();
            this.checkPoseStack(posestack);
            multibuffersource$buffersource.endBatch(RenderType.solid());
            multibuffersource$buffersource.endBatch(RenderType.endPortal());
            multibuffersource$buffersource.endBatch(RenderType.endGateway());
            multibuffersource$buffersource.endBatch(Sheets.solidBlockSheet());
            multibuffersource$buffersource.endBatch(Sheets.cutoutBlockSheet());
            multibuffersource$buffersource.endBatch(Sheets.bedSheet());
            multibuffersource$buffersource.endBatch(Sheets.shulkerBoxSheet());
            multibuffersource$buffersource.endBatch(Sheets.signSheet());
            multibuffersource$buffersource.endBatch(Sheets.hangingSignSheet());
            multibuffersource$buffersource.endBatch(Sheets.chestSheet());
            this.renderBuffers.outlineBufferSource().endOutlineBatch();
            ClientHooks.dispatchRenderStage((RenderLevelStageEvent.Stage)RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES, (Level)this.level, (LevelRenderer)this, (PoseStack)posestack, (Matrix4f)p_362420_, (Matrix4f)p_361272_, (int)this.ticks, (Camera)p_363453_, (Frustum)p_366590_);
            if (p_363964_) {
                this.renderBlockOutline(p_363453_, multibuffersource$buffersource, posestack, false);
            }
            p_362234_.popPush("debug");
            this.minecraft.debugRenderer.render(posestack, p_366590_, multibuffersource$buffersource, d0, d1, d2);
            multibuffersource$buffersource.endLastBatch();
            this.checkPoseStack(posestack);
            multibuffersource$buffersource.endBatch(Sheets.translucentItemSheet());
            multibuffersource$buffersource.endBatch(Sheets.bannerSheet());
            multibuffersource$buffersource.endBatch(Sheets.shieldSheet());
            multibuffersource$buffersource.endBatch(RenderType.armorEntityGlint());
            multibuffersource$buffersource.endBatch(RenderType.glint());
            multibuffersource$buffersource.endBatch(RenderType.glintTranslucent());
            multibuffersource$buffersource.endBatch(RenderType.entityGlint());
            p_362234_.popPush("destroyProgress");
            this.renderBlockDestroyAnimation(posestack, p_363453_, multibuffersource$buffersource1);
            multibuffersource$buffersource1.endBatch();
            this.checkPoseStack(posestack);
            multibuffersource$buffersource.endBatch(RenderType.waterMask());
            if (this.targets.particles == null) {
                p_362234_.popPush("solid_particles");
                this.minecraft.particleEngine.render(p_363453_, f, this.renderBuffers.bufferSource(), p_366590_, type -> !type.translucent());
            }
            multibuffersource$buffersource.endBatch();
            if (resourcehandle1 != null) {
                ((RenderTarget)resourcehandle1.get()).copyDepthFrom((RenderTarget)resourcehandle.get());
            }
            p_362234_.popPush("translucent");
            this.renderSectionLayer(RenderType.translucent(), d0, d1, d2, p_362420_, p_361272_);
            p_362234_.popPush("string");
            this.renderSectionLayer(RenderType.tripwire(), d0, d1, d2, p_362420_, p_361272_);
            if (p_363964_) {
                this.renderBlockOutline(p_363453_, multibuffersource$buffersource, posestack, true);
            }
            multibuffersource$buffersource.endBatch();
            p_362234_.pop();
        });
    }

    @Deprecated
    private void addParticlesPass(FrameGraphBuilder p_363357_, Camera p_365299_, float p_364282_, FogParameters p_362149_) {
        this.addParticlesPass(p_363357_, p_365299_, p_364282_, p_362149_, this.capturedFrustum != null ? this.capturedFrustum : this.cullingFrustum, RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix());
    }

    private void addParticlesPass(FrameGraphBuilder p_363357_, Camera p_365299_, float p_364282_, FogParameters p_362149_, Frustum frustum, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        FramePass framepass = p_363357_.addPass("particles");
        if (this.targets.particles != null) {
            this.targets.particles = framepass.readsAndWrites(this.targets.particles);
            framepass.reads(this.targets.main);
        } else {
            this.targets.main = framepass.readsAndWrites(this.targets.main);
        }
        ResourceHandle resourcehandle = this.targets.main;
        ResourceHandle resourcehandle1 = this.targets.particles;
        framepass.executes(() -> {
            RenderSystem.setShaderFog(p_362149_);
            if (resourcehandle1 != null) {
                ((RenderTarget)resourcehandle1.get()).copyDepthFrom((RenderTarget)resourcehandle.get());
            }
            this.minecraft.particleEngine.render(p_365299_, p_364282_, this.renderBuffers.bufferSource(), frustum, resourcehandle1 == null ? type -> type.translucent() : type -> true);
            ClientHooks.dispatchRenderStage((RenderLevelStageEvent.Stage)RenderLevelStageEvent.Stage.AFTER_PARTICLES, (Level)this.level, (LevelRenderer)this, null, (Matrix4f)modelViewMatrix, (Matrix4f)projectionMatrix, (int)this.ticks, (Camera)p_365299_, (Frustum)this.getFrustum());
        });
    }

    @Deprecated
    private void addCloudsPass(FrameGraphBuilder p_361907_, CloudStatus p_364196_, Vec3 p_362985_, float p_365209_, int p_362342_, float p_362337_) {
        this.addCloudsPass(p_361907_, p_364196_, p_362985_, p_365209_, p_362342_, p_362337_, RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix());
    }

    private void addCloudsPass(FrameGraphBuilder p_361907_, CloudStatus p_364196_, Vec3 p_362985_, float p_365209_, int p_362342_, float p_362337_, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        FramePass framepass = p_361907_.addPass("clouds");
        if (this.targets.clouds != null) {
            this.targets.clouds = framepass.readsAndWrites(this.targets.clouds);
        } else {
            this.targets.main = framepass.readsAndWrites(this.targets.main);
        }
        framepass.executes(() -> {
            if (!this.level.effects().renderClouds(this.level, this.ticks, p_365209_, p_362985_.x, p_362985_.y, p_362985_.z, modelViewMatrix, projectionMatrix)) {
                this.cloudRenderer.render(p_362342_, p_364196_, p_362337_, p_362985_, p_365209_);
            }
        });
    }

    @Deprecated
    private void addWeatherPass(FrameGraphBuilder p_364025_, Vec3 p_360771_, float p_362434_, FogParameters p_360974_) {
        this.addWeatherPass(p_364025_, p_360771_, p_362434_, p_360974_, RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), this.minecraft.gameRenderer.getMainCamera());
    }

    private void addWeatherPass(FrameGraphBuilder p_364025_, Vec3 p_360771_, float p_362434_, FogParameters p_360974_, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, Camera camera) {
        int i = this.minecraft.options.getEffectiveRenderDistance() * 16;
        float f = this.minecraft.gameRenderer.getDepthFar();
        FramePass framepass = p_364025_.addPass("weather");
        if (this.targets.weather != null) {
            this.targets.weather = framepass.readsAndWrites(this.targets.weather);
        } else {
            this.targets.main = framepass.readsAndWrites(this.targets.main);
        }
        framepass.executes(() -> {
            RenderSystem.setShaderFog(p_360974_);
            MultiBufferSource.BufferSource multibuffersource$buffersource = this.renderBuffers.bufferSource();
            this.weatherEffectRenderer.render(this.minecraft.level, (MultiBufferSource)multibuffersource$buffersource, this.ticks, p_362434_, p_360771_);
            ClientHooks.dispatchRenderStage((RenderLevelStageEvent.Stage)RenderLevelStageEvent.Stage.AFTER_WEATHER, (Level)this.level, (LevelRenderer)this, null, (Matrix4f)modelViewMatrix, (Matrix4f)projectionMatrix, (int)this.ticks, (Camera)camera, (Frustum)this.getFrustum());
            this.worldBorderRenderer.render(this.level.getWorldBorder(), p_360771_, (double)i, (double)f);
            multibuffersource$buffersource.endBatch();
        });
    }

    private void addLateDebugPass(FrameGraphBuilder p_361973_, Vec3 p_363812_, FogParameters p_362448_) {
        FramePass framepass = p_361973_.addPass("late_debug");
        this.targets.main = framepass.readsAndWrites(this.targets.main);
        if (this.targets.itemEntity != null) {
            this.targets.itemEntity = framepass.readsAndWrites(this.targets.itemEntity);
        }
        ResourceHandle resourcehandle = this.targets.main;
        framepass.executes(() -> {
            RenderSystem.setShaderFog(p_362448_);
            PoseStack posestack = new PoseStack();
            MultiBufferSource.BufferSource multibuffersource$buffersource = this.renderBuffers.bufferSource();
            this.minecraft.debugRenderer.renderAfterTranslucents(posestack, multibuffersource$buffersource, p_363812_.x, p_363812_.y, p_363812_.z);
            multibuffersource$buffersource.endLastBatch();
            this.checkPoseStack(posestack);
        });
    }

    private boolean collectVisibleEntities(Camera p_363510_, Frustum p_361275_, List<Entity> p_363380_) {
        Vec3 vec3 = p_363510_.getPosition();
        double d0 = vec3.x();
        double d1 = vec3.y();
        double d2 = vec3.z();
        boolean flag = false;
        boolean flag1 = this.shouldShowEntityOutlines();
        Entity.setViewScale(Mth.clamp((double)((double)this.minecraft.options.getEffectiveRenderDistance() / 8.0), (double)1.0, (double)2.5) * (Double)this.minecraft.options.entityDistanceScaling().get());
        for (Entity entity : this.level.entitiesForRendering()) {
            BlockPos blockpos;
            if (!this.entityRenderDispatcher.shouldRender(entity, p_361275_, d0, d1, d2) && !entity.hasIndirectPassenger(this.minecraft.player) || !this.level.isOutsideBuildHeight((blockpos = entity.blockPosition()).getY()) && !this.isSectionCompiled(blockpos) || entity == p_363510_.getEntity() && !p_363510_.isDetached() && (!(p_363510_.getEntity() instanceof LivingEntity) || !((LivingEntity)p_363510_.getEntity()).isSleeping()) || entity instanceof LocalPlayer && p_363510_.getEntity() != entity && (entity != this.minecraft.player || this.minecraft.player.isSpectator())) continue;
            p_363380_.add(entity);
            if (flag1 && this.minecraft.shouldEntityAppearGlowing(entity)) {
                flag = true;
                continue;
            }
            if (!flag1 || !entity.hasCustomOutlineRendering(this.minecraft.player)) continue;
            flag = true;
        }
        return flag;
    }

    private void renderEntities(PoseStack p_363182_, MultiBufferSource.BufferSource p_360990_, Camera p_360717_, DeltaTracker p_362965_, List<Entity> p_362298_) {
        Vec3 vec3 = p_360717_.getPosition();
        double d0 = vec3.x();
        double d1 = vec3.y();
        double d2 = vec3.z();
        TickRateManager tickratemanager = this.minecraft.level.tickRateManager();
        boolean flag = this.shouldShowEntityOutlines();
        for (Entity entity : p_362298_) {
            MultiBufferSource.BufferSource multibuffersource;
            if (entity.tickCount == 0) {
                entity.xOld = entity.getX();
                entity.yOld = entity.getY();
                entity.zOld = entity.getZ();
            }
            if (flag && this.minecraft.shouldEntityAppearGlowing(entity)) {
                OutlineBufferSource outlinebuffersource = this.renderBuffers.outlineBufferSource();
                multibuffersource = outlinebuffersource;
                int i = entity.getTeamColor();
                outlinebuffersource.setColor(ARGB.red((int)i), ARGB.green((int)i), ARGB.blue((int)i), 255);
            } else {
                multibuffersource = p_360990_;
            }
            float f = p_362965_.getGameTimeDeltaPartialTick(!tickratemanager.isEntityFrozen(entity));
            this.renderEntity(entity, d0, d1, d2, f, p_363182_, (MultiBufferSource)multibuffersource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderBlockEntities(PoseStack p_362832_, MultiBufferSource.BufferSource p_363819_, MultiBufferSource.BufferSource p_361830_, Camera p_362042_, float p_362089_) {
        Vec3 vec3 = p_362042_.getPosition();
        double d0 = vec3.x();
        double d1 = vec3.y();
        double d2 = vec3.z();
        Frustum frustum = this.getFrustum();
        for (SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection : this.visibleSections) {
            List<BlockEntity> list = sectionrenderdispatcher$rendersection.getCompiled().getRenderableBlockEntities();
            if (list.isEmpty()) continue;
            for (BlockEntity blockentity : list) {
                int i;
                if (!ClientHooks.isBlockEntityRendererVisible((BlockEntityRenderDispatcher)this.blockEntityRenderDispatcher, (BlockEntity)blockentity, (Frustum)frustum)) continue;
                BlockPos blockpos = blockentity.getBlockPos();
                MultiBufferSource.BufferSource multibuffersource = p_363819_;
                p_362832_.pushPose();
                p_362832_.translate((double)blockpos.getX() - d0, (double)blockpos.getY() - d1, (double)blockpos.getZ() - d2);
                SortedSet sortedset = (SortedSet)this.destructionProgress.get(blockpos.asLong());
                if (sortedset != null && !sortedset.isEmpty() && (i = ((BlockDestructionProgress)sortedset.last()).getProgress()) >= 0) {
                    PoseStack.Pose posestack$pose = p_362832_.last();
                    SheetedDecalTextureGenerator vertexconsumer = new SheetedDecalTextureGenerator(p_361830_.getBuffer(ModelBakery.DESTROY_TYPES.get(i)), posestack$pose, 1.0f);
                    multibuffersource = arg_0 -> LevelRenderer.lambda$renderBlockEntities$9(p_363819_, (VertexConsumer)vertexconsumer, arg_0);
                }
                this.blockEntityRenderDispatcher.render(blockentity, p_362089_, p_362832_, (MultiBufferSource)multibuffersource);
                p_362832_.popPose();
            }
        }
        Object object = this.globalBlockEntities;
        synchronized (object) {
            for (BlockEntity blockentity1 : this.globalBlockEntities) {
                if (!ClientHooks.isBlockEntityRendererVisible((BlockEntityRenderDispatcher)this.blockEntityRenderDispatcher, (BlockEntity)blockentity1, (Frustum)frustum)) continue;
                BlockPos blockpos1 = blockentity1.getBlockPos();
                p_362832_.pushPose();
                p_362832_.translate((double)blockpos1.getX() - d0, (double)blockpos1.getY() - d1, (double)blockpos1.getZ() - d2);
                this.blockEntityRenderDispatcher.render(blockentity1, p_362089_, p_362832_, (MultiBufferSource)p_363819_);
                p_362832_.popPose();
            }
        }
    }

    private void renderBlockDestroyAnimation(PoseStack p_363901_, Camera p_361175_, MultiBufferSource.BufferSource p_365216_) {
        Vec3 vec3 = p_361175_.getPosition();
        double d0 = vec3.x();
        double d1 = vec3.y();
        double d2 = vec3.z();
        for (Long2ObjectMap.Entry entry : this.destructionProgress.long2ObjectEntrySet()) {
            SortedSet sortedset;
            BlockPos blockpos = BlockPos.of((long)entry.getLongKey());
            if (blockpos.distToCenterSqr(d0, d1, d2) > 1024.0 || (sortedset = (SortedSet)entry.getValue()) == null || sortedset.isEmpty()) continue;
            int i = ((BlockDestructionProgress)sortedset.last()).getProgress();
            p_363901_.pushPose();
            p_363901_.translate((double)blockpos.getX() - d0, (double)blockpos.getY() - d1, (double)blockpos.getZ() - d2);
            PoseStack.Pose posestack$pose = p_363901_.last();
            SheetedDecalTextureGenerator vertexconsumer = new SheetedDecalTextureGenerator(p_365216_.getBuffer(ModelBakery.DESTROY_TYPES.get(i)), posestack$pose, 1.0f);
            this.minecraft.getBlockRenderer().renderBreakingTexture(this.level.getBlockState(blockpos), blockpos, (BlockAndTintGetter)((Object)this.level), p_363901_, (VertexConsumer)vertexconsumer);
            p_363901_.popPose();
        }
    }

    private void renderBlockOutline(Camera p_363911_, MultiBufferSource.BufferSource p_362782_, PoseStack p_361893_, boolean p_361698_) {
        BlockHitResult blockhitresult;
        HitResult hitResult = this.minecraft.hitResult;
        if (hitResult instanceof BlockHitResult && (blockhitresult = (BlockHitResult)hitResult).getType() != HitResult.Type.MISS) {
            BlockPos blockpos = blockhitresult.getBlockPos();
            BlockState blockstate = this.level.getBlockState(blockpos);
            if (!ClientHooks.onDrawHighlight((LevelRenderer)this, (Camera)p_363911_, (BlockHitResult)blockhitresult, (DeltaTracker)this.minecraft.getDeltaTracker(), (PoseStack)p_361893_, (MultiBufferSource)p_362782_, (boolean)p_361698_) && !blockstate.isAir() && this.level.getWorldBorder().isWithinBounds(blockpos)) {
                boolean flag = ClientHooks.isInTranslucentBlockOutlinePass((Level)this.level, (BlockPos)blockpos, (BlockState)blockstate);
                if (flag != p_361698_) {
                    return;
                }
                Vec3 vec3 = p_363911_.getPosition();
                Boolean obool = (Boolean)this.minecraft.options.highContrastBlockOutline().get();
                if (obool.booleanValue()) {
                    VertexConsumer vertexconsumer = p_362782_.getBuffer(RenderType.secondaryBlockOutline());
                    this.renderHitOutline(p_361893_, vertexconsumer, p_363911_.getEntity(), vec3.x, vec3.y, vec3.z, blockpos, blockstate, -16777216);
                }
                VertexConsumer vertexconsumer1 = p_362782_.getBuffer(RenderType.lines());
                int i = obool != false ? -11010079 : ARGB.color((int)102, (int)-16777216);
                this.renderHitOutline(p_361893_, vertexconsumer1, p_363911_.getEntity(), vec3.x, vec3.y, vec3.z, blockpos, blockstate, i);
                p_362782_.endLastBatch();
            }
        }
    }

    private void checkPoseStack(PoseStack p_109589_) {
        if (!p_109589_.isEmpty()) {
            throw new IllegalStateException("Pose stack not empty");
        }
    }

    private void renderEntity(Entity p_109518_, double p_109519_, double p_109520_, double p_109521_, float p_109522_, PoseStack p_109523_, MultiBufferSource p_109524_) {
        double d0 = Mth.lerp((double)p_109522_, (double)p_109518_.xOld, (double)p_109518_.getX());
        double d1 = Mth.lerp((double)p_109522_, (double)p_109518_.yOld, (double)p_109518_.getY());
        double d2 = Mth.lerp((double)p_109522_, (double)p_109518_.zOld, (double)p_109518_.getZ());
        this.entityRenderDispatcher.render(p_109518_, d0 - p_109519_, d1 - p_109520_, d2 - p_109521_, p_109522_, p_109523_, p_109524_, this.entityRenderDispatcher.getPackedLightCoords(p_109518_, p_109522_));
    }

    private void scheduleTranslucentSectionResort(Vec3 p_361632_) {
        if (!this.visibleSections.isEmpty()) {
            BlockPos blockpos = BlockPos.containing((Position)p_361632_);
            boolean flag = !blockpos.equals((Object)this.lastTranslucentSortBlockPos);
            Profiler.get().push("translucent_sort");
            SectionRenderDispatcher.TranslucencyPointOfView sectionrenderdispatcher$translucencypointofview = new SectionRenderDispatcher.TranslucencyPointOfView();
            for (SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection : this.nearbyVisibleSections) {
                this.scheduleResort(sectionrenderdispatcher$rendersection, sectionrenderdispatcher$translucencypointofview, p_361632_, flag, true);
            }
            this.translucencyResortIterationIndex %= this.visibleSections.size();
            int i = Math.max(this.visibleSections.size() / 8, 15);
            while (i-- > 0) {
                int j = this.translucencyResortIterationIndex++ % this.visibleSections.size();
                this.scheduleResort((SectionRenderDispatcher.RenderSection)this.visibleSections.get(j), sectionrenderdispatcher$translucencypointofview, p_361632_, flag, false);
            }
            this.lastTranslucentSortBlockPos = blockpos;
            Profiler.get().pop();
        }
    }

    private void scheduleResort(SectionRenderDispatcher.RenderSection p_371775_, SectionRenderDispatcher.TranslucencyPointOfView p_371652_, Vec3 p_371372_, boolean p_371855_, boolean p_371355_) {
        boolean flag1;
        p_371652_.set(p_371372_, p_371775_.getSectionNode());
        boolean flag = !p_371652_.equals(p_371775_.pointOfView.get());
        boolean bl = flag1 = p_371855_ && (p_371652_.isAxisAligned() || p_371355_);
        if ((flag1 || flag) && !p_371775_.transparencyResortingScheduled() && p_371775_.hasTranslucentGeometry()) {
            p_371775_.resortTransparency(this.sectionRenderDispatcher);
        }
    }

    private void renderSectionLayer(RenderType p_294513_, double p_295577_, double p_294761_, double p_294297_, Matrix4f p_294782_, Matrix4f p_324517_) {
        RenderSystem.assertOnRenderThread();
        Zone zone = Profiler.get().zone(() -> "render_" + p_294513_.name);
        zone.addText(() -> ((RenderType)p_294513_).toString());
        boolean flag = p_294513_ != RenderType.translucent();
        ObjectListIterator objectlistiterator = this.visibleSections.listIterator(flag ? 0 : this.visibleSections.size());
        p_294513_.setupRenderState();
        RenderPipeline renderpipeline = p_294513_.getRenderPipeline();
        ArrayList<RenderPass.Draw> arraylist = new ArrayList<RenderPass.Draw>();
        RenderSystem.AutoStorageIndexBuffer rendersystem$autostorageindexbuffer = RenderSystem.getSequentialBuffer(p_294513_.mode());
        int i = 0;
        while (flag ? objectlistiterator.hasNext() : objectlistiterator.hasPrevious()) {
            VertexFormat.IndexType vertexformat$indextype;
            GpuBuffer gpubuffer;
            SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection = flag ? (SectionRenderDispatcher.RenderSection)objectlistiterator.next() : (SectionRenderDispatcher.RenderSection)objectlistiterator.previous();
            SectionRenderDispatcher.SectionBuffers sectionrenderdispatcher$sectionbuffers = sectionrenderdispatcher$rendersection.getBuffers(p_294513_);
            if (sectionrenderdispatcher$rendersection.getCompiled().isEmpty(p_294513_) || sectionrenderdispatcher$sectionbuffers == null) continue;
            if (sectionrenderdispatcher$sectionbuffers.getIndexBuffer() == null) {
                if (sectionrenderdispatcher$sectionbuffers.getIndexCount() > i) {
                    i = sectionrenderdispatcher$sectionbuffers.getIndexCount();
                }
                gpubuffer = null;
                vertexformat$indextype = null;
            } else {
                gpubuffer = sectionrenderdispatcher$sectionbuffers.getIndexBuffer();
                vertexformat$indextype = sectionrenderdispatcher$sectionbuffers.getIndexType();
            }
            BlockPos blockpos = sectionrenderdispatcher$rendersection.getRenderOrigin();
            arraylist.add(new RenderPass.Draw(0, sectionrenderdispatcher$sectionbuffers.getVertexBuffer(), gpubuffer, vertexformat$indextype, 0, sectionrenderdispatcher$sectionbuffers.getIndexCount(), p_409032_ -> p_409032_.upload("ModelOffset", (float)((double)blockpos.getX() - p_295577_), (float)((double)blockpos.getY() - p_294761_), (float)((double)blockpos.getZ() - p_294297_))));
        }
        GpuBuffer gpubuffer1 = i == 0 ? null : rendersystem$autostorageindexbuffer.getBuffer(i);
        VertexFormat.IndexType vertexformat$indextype1 = i == 0 ? null : rendersystem$autostorageindexbuffer.type();
        try (RenderPass renderpass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(p_294513_.getRenderTarget().getColorTexture(), OptionalInt.empty(), p_294513_.getRenderTarget().getDepthTexture(), OptionalDouble.empty());){
            renderpass.setPipeline(renderpipeline);
            for (int j = 0; j < 12; ++j) {
                GpuTexture gputexture = RenderSystem.getShaderTexture(j);
                if (gputexture == null) continue;
                renderpass.bindSampler("Sampler" + j, gputexture);
            }
            renderpass.drawMultipleIndexed(arraylist, gpubuffer1, vertexformat$indextype1);
        }
        zone.close();
        ClientHooks.dispatchRenderStage((RenderType)p_294513_, (Level)this.level, (LevelRenderer)this, (Matrix4f)p_294782_, (Matrix4f)p_324517_, (int)this.ticks, (Camera)this.minecraft.gameRenderer.getMainCamera(), (Frustum)this.getFrustum());
        p_294513_.clearRenderState();
    }

    public void captureFrustum() {
        this.captureFrustum = true;
    }

    public void killFrustum() {
        this.capturedFrustum = null;
    }

    public void tick() {
        if (this.level.tickRateManager().runsNormally()) {
            ++this.ticks;
        }
        if (this.ticks % 20 == 0) {
            ObjectIterator iterator = this.destroyingBlocks.values().iterator();
            while (iterator.hasNext()) {
                BlockDestructionProgress blockdestructionprogress = (BlockDestructionProgress)iterator.next();
                int i = blockdestructionprogress.getUpdatedRenderTick();
                if (this.ticks - i <= 400) continue;
                iterator.remove();
                this.removeProgress(blockdestructionprogress);
            }
        }
    }

    private void removeProgress(BlockDestructionProgress p_109766_) {
        long i = p_109766_.getPos().asLong();
        Set set = (Set)this.destructionProgress.get(i);
        set.remove(p_109766_);
        if (set.isEmpty()) {
            this.destructionProgress.remove(i);
        }
    }

    @Deprecated
    private void addSkyPass(FrameGraphBuilder p_362870_, Camera p_362177_, float p_363799_, FogParameters p_364999_) {
        this.addSkyPass(p_362870_, p_362177_, p_363799_, p_364999_, RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix());
    }

    private void addSkyPass(FrameGraphBuilder p_362870_, Camera p_362177_, float p_363799_, FogParameters p_364999_, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        DimensionSpecialEffects dimensionspecialeffects;
        DimensionSpecialEffects.SkyType dimensionspecialeffects$skytype;
        FogType fogtype = p_362177_.getFluidInCamera();
        if (fogtype != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !this.doesMobEffectBlockSky(p_362177_) && (dimensionspecialeffects$skytype = (dimensionspecialeffects = this.level.effects()).skyType()) != DimensionSpecialEffects.SkyType.NONE) {
            FramePass framepass = p_362870_.addPass("sky");
            this.targets.main = framepass.readsAndWrites(this.targets.main);
            framepass.executes(() -> {
                if (!this.level.effects().renderSky(this.level, this.ticks, p_363799_, modelViewMatrix, p_362177_, projectionMatrix, () -> RenderSystem.setShaderFog(p_364999_))) {
                    RenderSystem.setShaderFog(p_364999_);
                    if (dimensionspecialeffects$skytype == DimensionSpecialEffects.SkyType.END) {
                        this.skyRenderer.renderEndSky();
                    } else {
                        PoseStack posestack = new PoseStack();
                        float f = this.level.getSunAngle(p_363799_);
                        float f1 = this.level.getTimeOfDay(p_363799_);
                        float f2 = 1.0f - this.level.getRainLevel(p_363799_);
                        float f3 = this.level.getStarBrightness(p_363799_) * f2;
                        int i = dimensionspecialeffects.getSunriseOrSunsetColor(f1);
                        int j = this.level.getMoonPhase();
                        int k = this.level.getSkyColor(this.minecraft.gameRenderer.getMainCamera().getPosition(), p_363799_);
                        float f4 = ARGB.redFloat((int)k);
                        float f5 = ARGB.greenFloat((int)k);
                        float f6 = ARGB.blueFloat((int)k);
                        this.skyRenderer.renderSkyDisc(f4, f5, f6);
                        MultiBufferSource.BufferSource multibuffersource$buffersource = this.renderBuffers.bufferSource();
                        if (dimensionspecialeffects.isSunriseOrSunset(f1)) {
                            this.skyRenderer.renderSunriseAndSunset(posestack, multibuffersource$buffersource, f, i);
                        }
                        this.skyRenderer.renderSunMoonAndStars(posestack, multibuffersource$buffersource, f1, j, f2, f3, p_364999_);
                        multibuffersource$buffersource.endBatch();
                        if (this.shouldRenderDarkDisc(p_363799_)) {
                            this.skyRenderer.renderDarkDisc();
                        }
                    }
                }
                ClientHooks.dispatchRenderStage((RenderLevelStageEvent.Stage)RenderLevelStageEvent.Stage.AFTER_SKY, (Level)this.level, (LevelRenderer)this, null, (Matrix4f)modelViewMatrix, (Matrix4f)projectionMatrix, (int)this.ticks, (Camera)p_362177_, (Frustum)this.getFrustum());
            });
        }
    }

    private boolean shouldRenderDarkDisc(float p_362498_) {
        return this.minecraft.player.getEyePosition((float)p_362498_).y - this.level.getLevelData().getHorizonHeight((LevelHeightAccessor)this.level) < 0.0;
    }

    private boolean doesMobEffectBlockSky(Camera p_234311_) {
        boolean bl;
        Entity entity = p_234311_.getEntity();
        if (!(entity instanceof LivingEntity)) {
            bl = false;
        } else {
            LivingEntity livingentity = (LivingEntity)entity;
            bl = livingentity.hasEffect(MobEffects.BLINDNESS) || livingentity.hasEffect(MobEffects.DARKNESS);
        }
        return bl;
    }

    private void compileSections(Camera p_194371_) {
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("populate_sections_to_compile");
        RenderRegionCache renderregioncache = new RenderRegionCache();
        BlockPos blockpos = p_194371_.getBlockPosition();
        ArrayList list = Lists.newArrayList();
        for (SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection : this.visibleSections) {
            if (!sectionrenderdispatcher$rendersection.isDirty() || !sectionrenderdispatcher$rendersection.hasAllNeighbors()) continue;
            boolean flag = false;
            if (this.minecraft.options.prioritizeChunkUpdates().get() == PrioritizeChunkUpdates.NEARBY) {
                BlockPos blockpos1 = SectionPos.of((long)sectionrenderdispatcher$rendersection.getSectionNode()).center();
                flag = blockpos1.distSqr((Vec3i)blockpos) < 768.0 || sectionrenderdispatcher$rendersection.isDirtyFromPlayer();
            } else if (this.minecraft.options.prioritizeChunkUpdates().get() == PrioritizeChunkUpdates.PLAYER_AFFECTED) {
                flag = sectionrenderdispatcher$rendersection.isDirtyFromPlayer();
            }
            if (flag) {
                profilerfiller.push("build_near_sync");
                this.sectionRenderDispatcher.rebuildSectionSync(sectionrenderdispatcher$rendersection, renderregioncache);
                sectionrenderdispatcher$rendersection.setNotDirty();
                profilerfiller.pop();
                continue;
            }
            list.add(sectionrenderdispatcher$rendersection);
        }
        profilerfiller.popPush("upload");
        this.sectionRenderDispatcher.uploadAllPendingUploads();
        profilerfiller.popPush("schedule_async_compile");
        for (SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection1 : list) {
            sectionrenderdispatcher$rendersection1.rebuildSectionAsync(this.sectionRenderDispatcher, renderregioncache);
            sectionrenderdispatcher$rendersection1.setNotDirty();
        }
        profilerfiller.pop();
        this.scheduleTranslucentSectionResort(p_194371_.getPosition());
    }

    private void renderHitOutline(PoseStack p_109638_, VertexConsumer p_109639_, Entity p_109640_, double p_109641_, double p_109642_, double p_109643_, BlockPos p_109644_, BlockState p_109645_, int p_380403_) {
        ShapeRenderer.renderShape((PoseStack)p_109638_, (VertexConsumer)p_109639_, (VoxelShape)p_109645_.getShape((BlockGetter)((Object)this.level), p_109644_, CollisionContext.of((Entity)p_109640_)), (double)((double)p_109644_.getX() - p_109641_), (double)((double)p_109644_.getY() - p_109642_), (double)((double)p_109644_.getZ() - p_109643_), (int)p_380403_);
    }

    public void blockChanged(BlockGetter p_109545_, BlockPos p_109546_, BlockState p_109547_, BlockState p_109548_, int p_109549_) {
        this.setBlockDirty(p_109546_, (p_109549_ & 8) != 0);
    }

    private void setBlockDirty(BlockPos p_109733_, boolean p_109734_) {
        for (int i = p_109733_.getZ() - 1; i <= p_109733_.getZ() + 1; ++i) {
            for (int j = p_109733_.getX() - 1; j <= p_109733_.getX() + 1; ++j) {
                for (int k = p_109733_.getY() - 1; k <= p_109733_.getY() + 1; ++k) {
                    this.setSectionDirty(SectionPos.blockToSectionCoord((int)j), SectionPos.blockToSectionCoord((int)k), SectionPos.blockToSectionCoord((int)i), p_109734_);
                }
            }
        }
    }

    public void setBlocksDirty(int p_109495_, int p_109496_, int p_109497_, int p_109498_, int p_109499_, int p_109500_) {
        for (int i = p_109497_ - 1; i <= p_109500_ + 1; ++i) {
            for (int j = p_109495_ - 1; j <= p_109498_ + 1; ++j) {
                for (int k = p_109496_ - 1; k <= p_109499_ + 1; ++k) {
                    this.setSectionDirty(SectionPos.blockToSectionCoord((int)j), SectionPos.blockToSectionCoord((int)k), SectionPos.blockToSectionCoord((int)i));
                }
            }
        }
    }

    public void setBlockDirty(BlockPos p_109722_, BlockState p_109723_, BlockState p_109724_) {
        if (this.minecraft.getModelManager().requiresRender(p_109723_, p_109724_)) {
            this.setBlocksDirty(p_109722_.getX(), p_109722_.getY(), p_109722_.getZ(), p_109722_.getX(), p_109722_.getY(), p_109722_.getZ());
        }
    }

    public void setSectionDirtyWithNeighbors(int p_109491_, int p_109492_, int p_109493_) {
        this.setSectionRangeDirty(p_109491_ - 1, p_109492_ - 1, p_109493_ - 1, p_109491_ + 1, p_109492_ + 1, p_109493_ + 1);
    }

    public void setSectionRangeDirty(int p_363248_, int p_360721_, int p_360463_, int p_362591_, int p_364598_, int p_365249_) {
        for (int i = p_360463_; i <= p_365249_; ++i) {
            for (int j = p_363248_; j <= p_362591_; ++j) {
                for (int k = p_360721_; k <= p_364598_; ++k) {
                    this.setSectionDirty(j, k, i);
                }
            }
        }
    }

    public void setSectionDirty(int p_109771_, int p_109772_, int p_109773_) {
        this.setSectionDirty(p_109771_, p_109772_, p_109773_, false);
    }

    private void setSectionDirty(int p_109502_, int p_109503_, int p_109504_, boolean p_109505_) {
        this.viewArea.setDirty(p_109502_, p_109503_, p_109504_, p_109505_);
    }

    public void onSectionBecomingNonEmpty(long p_366463_) {
        SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection = this.viewArea.getRenderSection(p_366463_);
        if (sectionrenderdispatcher$rendersection != null) {
            this.sectionOcclusionGraph.schedulePropagationFrom(sectionrenderdispatcher$rendersection);
        }
    }

    public void addParticle(ParticleOptions p_109744_, boolean p_109745_, double p_109746_, double p_109747_, double p_109748_, double p_109749_, double p_109750_, double p_109751_) {
        this.addParticle(p_109744_, p_109745_, false, p_109746_, p_109747_, p_109748_, p_109749_, p_109750_, p_109751_);
    }

    public void addParticle(ParticleOptions p_109753_, boolean p_109754_, boolean p_109755_, double p_109756_, double p_109757_, double p_109758_, double p_109759_, double p_109760_, double p_109761_) {
        try {
            this.addParticleInternal(p_109753_, p_109754_, p_109755_, p_109756_, p_109757_, p_109758_, p_109759_, p_109760_, p_109761_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Exception while adding particle");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Particle being added");
            crashreportcategory.setDetail("ID", BuiltInRegistries.PARTICLE_TYPE.getKey(p_109753_.getType()));
            crashreportcategory.setDetail("Parameters", (CrashReportDetail<String>)((CrashReportDetail)() -> ParticleTypes.CODEC.encodeStart((DynamicOps)this.level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)p_109753_).toString()));
            crashreportcategory.setDetail("Position", (CrashReportDetail<String>)((CrashReportDetail)() -> CrashReportCategory.formatLocation((LevelHeightAccessor)this.level, p_109756_, p_109757_, p_109758_)));
            throw new ReportedException(crashreport);
        }
    }

    public <T extends ParticleOptions> void addParticle(T p_109736_, double p_109737_, double p_109738_, double p_109739_, double p_109740_, double p_109741_, double p_109742_) {
        this.addParticle(p_109736_, p_109736_.getType().getOverrideLimiter(), p_109737_, p_109738_, p_109739_, p_109740_, p_109741_, p_109742_);
    }

    @Nullable
    Particle addParticleInternal(ParticleOptions p_109796_, boolean p_109797_, double p_109798_, double p_109799_, double p_109800_, double p_109801_, double p_109802_, double p_109803_) {
        return this.addParticleInternal(p_109796_, p_109797_, false, p_109798_, p_109799_, p_109800_, p_109801_, p_109802_, p_109803_);
    }

    @Nullable
    private Particle addParticleInternal(ParticleOptions p_109805_, boolean p_109806_, boolean p_109807_, double p_109808_, double p_109809_, double p_109810_, double p_109811_, double p_109812_, double p_109813_) {
        Camera camera = this.minecraft.gameRenderer.getMainCamera();
        ParticleStatus particlestatus = this.calculateParticleLevel(p_109807_);
        if (p_109806_) {
            return this.minecraft.particleEngine.createParticle(p_109805_, p_109808_, p_109809_, p_109810_, p_109811_, p_109812_, p_109813_);
        }
        if (camera.getPosition().distanceToSqr(p_109808_, p_109809_, p_109810_) > 1024.0) {
            return null;
        }
        return particlestatus == ParticleStatus.MINIMAL ? null : this.minecraft.particleEngine.createParticle(p_109805_, p_109808_, p_109809_, p_109810_, p_109811_, p_109812_, p_109813_);
    }

    private ParticleStatus calculateParticleLevel(boolean p_109768_) {
        ParticleStatus particlestatus = (ParticleStatus)this.minecraft.options.particles().get();
        if (p_109768_ && particlestatus == ParticleStatus.MINIMAL && this.level.random.nextInt(10) == 0) {
            particlestatus = ParticleStatus.DECREASED;
        }
        if (particlestatus == ParticleStatus.DECREASED && this.level.random.nextInt(3) == 0) {
            particlestatus = ParticleStatus.MINIMAL;
        }
        return particlestatus;
    }

    public void destroyBlockProgress(int p_109775_, BlockPos p_109776_, int p_109777_) {
        if (p_109777_ >= 0 && p_109777_ < 10) {
            BlockDestructionProgress blockdestructionprogress1 = (BlockDestructionProgress)this.destroyingBlocks.get(p_109775_);
            if (blockdestructionprogress1 != null) {
                this.removeProgress(blockdestructionprogress1);
            }
            if (blockdestructionprogress1 == null || blockdestructionprogress1.getPos().getX() != p_109776_.getX() || blockdestructionprogress1.getPos().getY() != p_109776_.getY() || blockdestructionprogress1.getPos().getZ() != p_109776_.getZ()) {
                blockdestructionprogress1 = new BlockDestructionProgress(p_109775_, p_109776_);
                this.destroyingBlocks.put(p_109775_, (Object)blockdestructionprogress1);
            }
            blockdestructionprogress1.setProgress(p_109777_);
            blockdestructionprogress1.updateTick(this.ticks);
            ((SortedSet)this.destructionProgress.computeIfAbsent(blockdestructionprogress1.getPos().asLong(), p_234254_ -> Sets.newTreeSet())).add(blockdestructionprogress1);
        } else {
            BlockDestructionProgress blockdestructionprogress = (BlockDestructionProgress)this.destroyingBlocks.remove(p_109775_);
            if (blockdestructionprogress != null) {
                this.removeProgress(blockdestructionprogress);
            }
        }
    }

    public boolean hasRenderedAllSections() {
        return this.sectionRenderDispatcher.isQueueEmpty();
    }

    public void onChunkReadyToRender(ChunkPos p_383159_) {
        this.sectionOcclusionGraph.onChunkReadyToRender(p_383159_);
    }

    public void needsUpdate() {
        this.sectionOcclusionGraph.invalidate();
        this.cloudRenderer.markForRebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGlobalBlockEntities(Collection<BlockEntity> p_109763_, Collection<BlockEntity> p_109764_) {
        Set<BlockEntity> set = this.globalBlockEntities;
        synchronized (set) {
            this.globalBlockEntities.removeAll(p_109763_);
            this.globalBlockEntities.addAll(p_109764_);
        }
    }

    public static int getLightColor(BlockAndTintGetter p_109542_, BlockPos p_109543_) {
        return LevelRenderer.getLightColor(BrightnessGetter.DEFAULT, p_109542_, p_109542_.getBlockState(p_109543_), p_109543_);
    }

    public static int getLightColor(BrightnessGetter p_412967_, BlockAndTintGetter p_109538_, BlockState p_109539_, BlockPos p_109540_) {
        int k;
        if (p_109539_.emissiveRendering(p_109538_, p_109540_)) {
            return 0xF000F0;
        }
        int i = p_412967_.packedBrightness(p_109538_, p_109540_);
        int j = LightTexture.block(i);
        if (j < (k = p_109539_.getLightEmission(p_109538_, p_109540_))) {
            int l = LightTexture.sky(i);
            return LightTexture.pack(k, l);
        }
        return i;
    }

    public boolean isSectionCompiled(BlockPos p_295788_) {
        SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection = this.viewArea.getRenderSectionAt(p_295788_);
        return sectionrenderdispatcher$rendersection != null && sectionrenderdispatcher$rendersection.compiled.get() != SectionRenderDispatcher.CompiledSection.UNCOMPILED;
    }

    @Nullable
    public RenderTarget entityOutlineTarget() {
        return this.targets.entityOutline != null ? (RenderTarget)this.targets.entityOutline.get() : null;
    }

    @Nullable
    public RenderTarget getTranslucentTarget() {
        return this.targets.translucent != null ? (RenderTarget)this.targets.translucent.get() : null;
    }

    @Nullable
    public RenderTarget getItemEntityTarget() {
        return this.targets.itemEntity != null ? (RenderTarget)this.targets.itemEntity.get() : null;
    }

    @Nullable
    public RenderTarget getParticlesTarget() {
        return this.targets.particles != null ? (RenderTarget)this.targets.particles.get() : null;
    }

    @Nullable
    public RenderTarget getWeatherTarget() {
        return this.targets.weather != null ? (RenderTarget)this.targets.weather.get() : null;
    }

    @Nullable
    public RenderTarget getCloudsTarget() {
        return this.targets.clouds != null ? (RenderTarget)this.targets.clouds.get() : null;
    }

    @VisibleForDebug
    public ObjectArrayList<SectionRenderDispatcher.RenderSection> getVisibleSections() {
        return this.visibleSections;
    }

    @VisibleForDebug
    public SectionOcclusionGraph getSectionOcclusionGraph() {
        return this.sectionOcclusionGraph;
    }

    @Nullable
    public Frustum getCapturedFrustum() {
        return this.capturedFrustum;
    }

    public CloudRenderer getCloudRenderer() {
        return this.cloudRenderer;
    }

    public Frustum getFrustum() {
        return this.capturedFrustum != null ? this.capturedFrustum : this.cullingFrustum;
    }

    public int getTicks() {
        return this.ticks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateVisibleBlockEntities(Consumer<BlockEntity> blockEntityConsumer) {
        for (SectionRenderDispatcher.RenderSection chunkInfo : this.visibleSections) {
            chunkInfo.getCompiled().getRenderableBlockEntities().forEach(blockEntityConsumer);
        }
        Object object = this.globalBlockEntities;
        synchronized (object) {
            this.globalBlockEntities.forEach(blockEntityConsumer);
        }
    }

    @ApiStatus.Internal
    public Iterable<? extends IRenderableSection> getRenderableSections() {
        return this.visibleSections;
    }

    private static /* synthetic */ VertexConsumer lambda$renderBlockEntities$9(MultiBufferSource.BufferSource p_363819_, VertexConsumer vertexconsumer, RenderType p_234298_) {
        VertexConsumer vertexconsumer1 = p_363819_.getBuffer(p_234298_);
        return p_234298_.affectsCrumbling() ? VertexMultiConsumer.create((VertexConsumer)vertexconsumer, (VertexConsumer)vertexconsumer1) : vertexconsumer1;
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface BrightnessGetter {
        public static final BrightnessGetter DEFAULT = (p_412971_, p_412968_) -> {
            int i = p_412971_.getBrightness(LightLayer.SKY, p_412968_);
            int j = p_412971_.getBrightness(LightLayer.BLOCK, p_412968_);
            return Brightness.pack((int)j, (int)i);
        };

        public int packedBrightness(BlockAndTintGetter var1, BlockPos var2);
    }
}

