/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.EmptyBlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.config.NeoForgeClientConfig;
import net.neoforged.neoforge.client.model.ao.EnhancedAoRenderStorage;

@OnlyIn(value=Dist.CLIENT)
public class ModelBlockRenderer {
    private static final Direction[] DIRECTIONS = Direction.values();
    private final BlockColors blockColors;
    private static final int CACHE_SIZE = 100;
    protected static final ThreadLocal<Cache> CACHE = ThreadLocal.withInitial(Cache::new);

    public ModelBlockRenderer(BlockColors p_110999_) {
        this.blockColors = p_110999_;
    }

    @Deprecated
    public void tesselateBlock(BlockAndTintGetter p_234380_, List<BlockModelPart> p_410025_, BlockState p_234382_, BlockPos p_234383_, PoseStack p_234384_, VertexConsumer p_234385_, boolean p_234386_, int p_234389_) {
        this.tesselateBlock(p_234380_, p_410025_, p_234382_, p_234383_, p_234384_, (RenderType type) -> p_234385_, p_234386_, p_234389_);
    }

    public void tesselateBlock(BlockAndTintGetter p_234380_, List<BlockModelPart> p_410025_, BlockState p_234382_, BlockPos p_234383_, PoseStack p_234384_, Function<RenderType, VertexConsumer> bufferLookup, boolean p_234386_, int p_234389_) {
        block10: {
            boolean bl;
            block13: {
                block11: {
                    block12: {
                        if (p_410025_.isEmpty()) break block10;
                        boolean perPartAO = NeoForgeClientConfig.INSTANCE.handleAmbientOcclusionPerPart.getAsBoolean();
                        if (!Minecraft.useAmbientOcclusion()) break block11;
                        if (perPartAO) break block12;
                        switch (p_410025_.getFirst().ambientOcclusion()) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case TRUE: {
                                break;
                            }
                            case DEFAULT: {
                                if (p_234382_.getLightEmission(p_234380_, p_234383_) == 0) {
                                    break;
                                }
                                break block11;
                            }
                            case FALSE: {
                                break block11;
                            }
                        }
                    }
                    bl = true;
                    break block13;
                }
                bl = false;
            }
            boolean flag = bl;
            p_234384_.translate(p_234382_.getOffset(p_234383_));
            try {
                if (flag) {
                    this.tesselateWithAO(p_234380_, p_410025_, p_234382_, p_234383_, p_234384_, bufferLookup, p_234386_, p_234389_);
                } else {
                    this.tesselateWithoutAO(p_234380_, p_410025_, p_234382_, p_234383_, p_234384_, bufferLookup, p_234386_, p_234389_);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Tesselating block model");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Block model being tesselated");
                CrashReportCategory.populateBlockDetails(crashreportcategory, p_234380_, p_234383_, p_234382_);
                crashreportcategory.setDetail("Using AO", flag);
                throw new ReportedException(crashreport);
            }
        }
    }

    @Deprecated
    private static boolean shouldRenderFace(BlockAndTintGetter p_412640_, BlockState p_412168_, boolean p_412054_, Direction p_412130_, BlockPos p_412608_) {
        if (!p_412054_) {
            return true;
        }
        BlockState blockstate = p_412640_.getBlockState(p_412608_);
        return Block.shouldRenderFace(p_412168_, blockstate, p_412130_);
    }

    protected static boolean shouldRenderFace(BlockAndTintGetter p_412640_, BlockPos pos, BlockState p_412168_, boolean p_412054_, Direction p_412130_, BlockPos p_412608_) {
        if (!p_412054_) {
            return true;
        }
        BlockState blockstate = p_412640_.getBlockState(p_412608_);
        return Block.shouldRenderFace(p_412640_, pos, p_412168_, blockstate, p_412130_);
    }

    @Deprecated
    public void tesselateWithAO(BlockAndTintGetter p_234391_, List<BlockModelPart> p_410478_, BlockState p_234393_, BlockPos p_234394_, PoseStack p_234395_, VertexConsumer p_234396_, boolean p_234397_, int p_234400_) {
        this.tesselateWithAO(p_234391_, p_410478_, p_234393_, p_234394_, p_234395_, (RenderType type) -> p_234396_, p_234397_, p_234400_);
    }

    public void tesselateWithAO(BlockAndTintGetter p_234391_, List<BlockModelPart> p_410478_, BlockState p_234393_, BlockPos p_234394_, PoseStack p_234395_, Function<RenderType, VertexConsumer> bufferLookup, boolean p_234397_, int p_234400_) {
        AmbientOcclusionRenderStorage modelblockrenderer$ambientocclusionrenderstorage = EnhancedAoRenderStorage.newInstance();
        boolean perPartAO = NeoForgeClientConfig.INSTANCE.handleAmbientOcclusionPerPart.getAsBoolean();
        int lightEmission = -1;
        int i = 0;
        int j = 0;
        for (BlockModelPart blockmodelpart : p_410478_) {
            boolean bl;
            VertexConsumer p_234396_;
            block15: {
                block14: {
                    block13: {
                        p_234396_ = bufferLookup.apply(blockmodelpart.getRenderType(p_234393_));
                        if (!perPartAO) break block13;
                        switch (blockmodelpart.ambientOcclusion()) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case TRUE: {
                                break;
                            }
                            case DEFAULT: {
                                if (lightEmission == -1) {
                                    lightEmission = p_234393_.getLightEmission(p_234391_, p_234394_);
                                }
                                if (lightEmission == 0) {
                                    break;
                                }
                                break block14;
                            }
                            case FALSE: {
                                break block14;
                            }
                        }
                    }
                    bl = true;
                    break block15;
                }
                bl = false;
            }
            boolean ao = bl;
            for (Direction direction : DIRECTIONS) {
                List<BakedQuad> list;
                boolean flag1;
                int k = 1 << direction.ordinal();
                boolean flag = (i & k) == 1;
                boolean bl2 = flag1 = (j & k) == 1;
                if (flag && !flag1 || (list = blockmodelpart.getQuads(direction)).isEmpty()) continue;
                if (!flag) {
                    flag1 = ModelBlockRenderer.shouldRenderFace(p_234391_, p_234394_, p_234393_, p_234397_, direction, (BlockPos)modelblockrenderer$ambientocclusionrenderstorage.scratchPos.setWithOffset((Vec3i)p_234394_, direction));
                    i |= k;
                    if (flag1) {
                        j |= k;
                    }
                }
                if (!flag1) continue;
                if (!ao) {
                    int light = modelblockrenderer$ambientocclusionrenderstorage.cache.getLightColor(p_234393_, p_234391_, (BlockPos)modelblockrenderer$ambientocclusionrenderstorage.scratchPos.setWithOffset((Vec3i)p_234394_, direction));
                    this.renderModelFaceFlat(p_234391_, p_234393_, p_234394_, light, p_234400_, false, p_234395_, p_234396_, list, modelblockrenderer$ambientocclusionrenderstorage);
                    continue;
                }
                this.renderModelFaceAO(p_234391_, p_234393_, p_234394_, p_234395_, p_234396_, list, modelblockrenderer$ambientocclusionrenderstorage, p_234400_);
            }
            List<BakedQuad> list1 = blockmodelpart.getQuads(null);
            if (list1.isEmpty()) continue;
            if (!ao) {
                this.renderModelFaceFlat(p_234391_, p_234393_, p_234394_, -1, p_234400_, true, p_234395_, p_234396_, list1, modelblockrenderer$ambientocclusionrenderstorage);
                continue;
            }
            this.renderModelFaceAO(p_234391_, p_234393_, p_234394_, p_234395_, p_234396_, list1, modelblockrenderer$ambientocclusionrenderstorage, p_234400_);
        }
    }

    @Deprecated
    public void tesselateWithoutAO(BlockAndTintGetter p_234402_, List<BlockModelPart> p_410604_, BlockState p_234404_, BlockPos p_234405_, PoseStack p_234406_, VertexConsumer p_234407_, boolean p_234408_, int p_234411_) {
        this.tesselateWithoutAO(p_234402_, p_410604_, p_234404_, p_234405_, p_234406_, (RenderType type) -> p_234407_, p_234408_, p_234411_);
    }

    public void tesselateWithoutAO(BlockAndTintGetter p_234402_, List<BlockModelPart> p_410604_, BlockState p_234404_, BlockPos p_234405_, PoseStack p_234406_, Function<RenderType, VertexConsumer> bufferLookup, boolean p_234408_, int p_234411_) {
        CommonRenderStorage modelblockrenderer$commonrenderstorage = new CommonRenderStorage();
        int i = 0;
        int j = 0;
        for (BlockModelPart blockmodelpart : p_410604_) {
            VertexConsumer p_234407_ = bufferLookup.apply(blockmodelpart.getRenderType(p_234404_));
            for (Direction direction : DIRECTIONS) {
                List<BakedQuad> list;
                boolean flag1;
                int k = 1 << direction.ordinal();
                boolean flag = (i & k) == 1;
                boolean bl = flag1 = (j & k) == 1;
                if (flag && !flag1 || (list = blockmodelpart.getQuads(direction)).isEmpty()) continue;
                BlockPos.MutableBlockPos blockpos = modelblockrenderer$commonrenderstorage.scratchPos.setWithOffset((Vec3i)p_234405_, direction);
                if (!flag) {
                    flag1 = ModelBlockRenderer.shouldRenderFace(p_234402_, p_234405_, p_234404_, p_234408_, direction, (BlockPos)blockpos);
                    i |= k;
                    if (flag1) {
                        j |= k;
                    }
                }
                if (!flag1) continue;
                int l = modelblockrenderer$commonrenderstorage.cache.getLightColor(p_234404_, p_234402_, (BlockPos)blockpos);
                this.renderModelFaceFlat(p_234402_, p_234404_, p_234405_, l, p_234411_, false, p_234406_, p_234407_, list, modelblockrenderer$commonrenderstorage);
            }
            List<BakedQuad> list1 = blockmodelpart.getQuads(null);
            if (list1.isEmpty()) continue;
            this.renderModelFaceFlat(p_234402_, p_234404_, p_234405_, -1, p_234411_, true, p_234406_, p_234407_, list1, modelblockrenderer$commonrenderstorage);
        }
    }

    private void renderModelFaceAO(BlockAndTintGetter p_111013_, BlockState p_111014_, BlockPos p_111015_, PoseStack p_111016_, VertexConsumer p_111017_, List<BakedQuad> p_111018_, AmbientOcclusionRenderStorage p_412172_, int p_111022_) {
        for (BakedQuad bakedquad : p_111018_) {
            if (!bakedquad.hasAmbientOcclusion()) {
                this.renderModelQuadFlat(p_111013_, p_111014_, p_111015_, -1, p_111022_, true, p_111016_, p_111017_, bakedquad, p_412172_);
                continue;
            }
            ModelBlockRenderer.calculateShape(p_111013_, p_111014_, p_111015_, bakedquad.vertices(), bakedquad.direction(), p_412172_);
            p_412172_.captureQuad(bakedquad);
            p_412172_.calculate(p_111013_, p_111014_, p_111015_, bakedquad.direction(), bakedquad.shade());
            this.putQuadData(p_111013_, p_111014_, p_111015_, p_111017_, p_111016_.last(), bakedquad, p_412172_, p_111022_);
        }
    }

    private void putQuadData(BlockAndTintGetter p_111024_, BlockState p_111025_, BlockPos p_111026_, VertexConsumer p_111027_, PoseStack.Pose p_111028_, BakedQuad p_111029_, CommonRenderStorage p_412412_, int p_111034_) {
        float f2;
        float f1;
        float f;
        int i = p_111029_.tintIndex();
        if (i != -1) {
            int j;
            if (p_412412_.tintCacheIndex == i) {
                j = p_412412_.tintCacheValue;
            } else {
                j = this.blockColors.getColor(p_111025_, p_111024_, p_111026_, i);
                p_412412_.tintCacheIndex = i;
                p_412412_.tintCacheValue = j;
            }
            f = ARGB.redFloat((int)j);
            f1 = ARGB.greenFloat((int)j);
            f2 = ARGB.blueFloat((int)j);
        } else {
            f = 1.0f;
            f1 = 1.0f;
            f2 = 1.0f;
        }
        p_111027_.putBulkData(p_111028_, p_111029_, p_412412_.brightness, f, f1, f2, 1.0f, p_412412_.lightmap, p_111034_, true);
    }

    private static void calculateShape(BlockAndTintGetter p_111040_, BlockState p_111041_, BlockPos p_111042_, int[] p_111043_, Direction p_111044_, CommonRenderStorage p_412438_) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(p_111043_[i * 8]);
            float f7 = Float.intBitsToFloat(p_111043_[i * 8 + 1]);
            float f8 = Float.intBitsToFloat(p_111043_[i * 8 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (p_412438_ instanceof AmbientOcclusionRenderStorage) {
            AmbientOcclusionRenderStorage modelblockrenderer$ambientocclusionrenderstorage = (AmbientOcclusionRenderStorage)p_412438_;
            modelblockrenderer$ambientocclusionrenderstorage.faceShape[SizeInfo.WEST.index] = f;
            modelblockrenderer$ambientocclusionrenderstorage.faceShape[SizeInfo.EAST.index] = f3;
            modelblockrenderer$ambientocclusionrenderstorage.faceShape[SizeInfo.DOWN.index] = f1;
            modelblockrenderer$ambientocclusionrenderstorage.faceShape[SizeInfo.UP.index] = f4;
            modelblockrenderer$ambientocclusionrenderstorage.faceShape[SizeInfo.NORTH.index] = f2;
            modelblockrenderer$ambientocclusionrenderstorage.faceShape[SizeInfo.SOUTH.index] = f5;
            modelblockrenderer$ambientocclusionrenderstorage.faceShape[SizeInfo.FLIP_WEST.index] = 1.0f - f;
            modelblockrenderer$ambientocclusionrenderstorage.faceShape[SizeInfo.FLIP_EAST.index] = 1.0f - f3;
            modelblockrenderer$ambientocclusionrenderstorage.faceShape[SizeInfo.FLIP_DOWN.index] = 1.0f - f1;
            modelblockrenderer$ambientocclusionrenderstorage.faceShape[SizeInfo.FLIP_UP.index] = 1.0f - f4;
            modelblockrenderer$ambientocclusionrenderstorage.faceShape[SizeInfo.FLIP_NORTH.index] = 1.0f - f2;
            modelblockrenderer$ambientocclusionrenderstorage.faceShape[SizeInfo.FLIP_SOUTH.index] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        p_412438_.facePartial = switch (p_111044_) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP -> {
                if (f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f) {
                    yield true;
                }
                yield false;
            }
            case Direction.NORTH, Direction.SOUTH -> {
                if (f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST, Direction.EAST -> f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f;
        };
        p_412438_.faceCubic = switch (p_111044_) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> {
                if (f1 == f4 && (f1 < 1.0E-4f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_))) {
                    yield true;
                }
                yield false;
            }
            case Direction.UP -> {
                if (f1 == f4 && (f4 > 0.9999f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_))) {
                    yield true;
                }
                yield false;
            }
            case Direction.NORTH -> {
                if (f2 == f5 && (f2 < 1.0E-4f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_))) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (f2 == f5 && (f5 > 0.9999f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_))) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (f == f3 && (f < 1.0E-4f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_))) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> f == f3 && (f3 > 0.9999f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_));
        };
    }

    private void renderModelFaceFlat(BlockAndTintGetter p_111002_, BlockState p_111003_, BlockPos p_111004_, int p_111005_, int p_111006_, boolean p_111007_, PoseStack p_111008_, VertexConsumer p_111009_, List<BakedQuad> p_111010_, CommonRenderStorage p_412163_) {
        for (BakedQuad bakedquad : p_111010_) {
            this.renderModelQuadFlat(p_111002_, p_111003_, p_111004_, p_111005_, p_111006_, p_111007_, p_111008_, p_111009_, bakedquad, p_412163_);
        }
    }

    private void renderModelQuadFlat(BlockAndTintGetter p_111002_, BlockState p_111003_, BlockPos p_111004_, int p_111005_, int p_111006_, boolean p_111007_, PoseStack p_111008_, VertexConsumer p_111009_, BakedQuad bakedquad, CommonRenderStorage p_412163_) {
        if (p_111007_) {
            ModelBlockRenderer.calculateShape(p_111002_, p_111003_, p_111004_, bakedquad.vertices(), bakedquad.direction(), p_412163_);
            BlockPos blockpos = p_412163_.faceCubic ? p_412163_.scratchPos.setWithOffset((Vec3i)p_111004_, bakedquad.direction()) : p_111004_;
            p_111005_ = p_412163_.cache.getLightColor(p_111003_, p_111002_, blockpos);
        }
        EnhancedAoRenderStorage.applyFlatQuadBrightness((BlockAndTintGetter)p_111002_, (BakedQuad)bakedquad, (CommonRenderStorage)p_412163_);
        p_412163_.lightmap[0] = p_111005_;
        p_412163_.lightmap[1] = p_111005_;
        p_412163_.lightmap[2] = p_111005_;
        p_412163_.lightmap[3] = p_111005_;
        this.putQuadData(p_111002_, p_111003_, p_111004_, p_111009_, p_111008_.last(), bakedquad, p_412163_, p_111006_);
    }

    @Deprecated
    public static void renderModel(PoseStack.Pose p_111068_, VertexConsumer p_111069_, BlockStateModel p_405848_, float p_111072_, float p_111073_, float p_111074_, int p_111075_, int p_111076_) {
        ModelBlockRenderer.renderModel(p_111068_, type -> p_111069_, p_405848_, p_111072_, p_111073_, p_111074_, p_111075_, p_111076_, (BlockAndTintGetter)EmptyBlockAndTintGetter.INSTANCE, BlockPos.ZERO, Blocks.AIR.defaultBlockState());
    }

    public static void renderModel(PoseStack.Pose p_111068_, MultiBufferSource bufferSource, BlockStateModel p_405848_, float p_111072_, float p_111073_, float p_111074_, int p_111075_, int p_111076_, BlockAndTintGetter level, BlockPos pos, BlockState state) {
        for (BlockModelPart blockmodelpart : p_405848_.collectParts(level, pos, state, RandomSource.create((long)42L))) {
            VertexConsumer p_111069_ = bufferSource.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)blockmodelpart.getRenderType(state)));
            for (Direction direction : DIRECTIONS) {
                ModelBlockRenderer.renderQuadList(p_111068_, p_111069_, p_111072_, p_111073_, p_111074_, blockmodelpart.getQuads(direction), p_111075_, p_111076_);
            }
            ModelBlockRenderer.renderQuadList(p_111068_, p_111069_, p_111072_, p_111073_, p_111074_, blockmodelpart.getQuads(null), p_111075_, p_111076_);
        }
    }

    private static void renderQuadList(PoseStack.Pose p_111059_, VertexConsumer p_111060_, float p_111061_, float p_111062_, float p_111063_, List<BakedQuad> p_111064_, int p_111065_, int p_111066_) {
        for (BakedQuad bakedquad : p_111064_) {
            float f2;
            float f1;
            float f;
            if (bakedquad.isTinted()) {
                f = Mth.clamp((float)p_111061_, (float)0.0f, (float)1.0f);
                f1 = Mth.clamp((float)p_111062_, (float)0.0f, (float)1.0f);
                f2 = Mth.clamp((float)p_111063_, (float)0.0f, (float)1.0f);
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            p_111060_.putBulkData(p_111059_, bakedquad, f, f1, f2, 1.0f, p_111065_, p_111066_);
        }
    }

    public static void enableCaching() {
        CACHE.get().enable();
    }

    public static void clearCache() {
        CACHE.get().disable();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AmbientOcclusionRenderStorage
    extends CommonRenderStorage {
        protected final float[] faceShape = new float[SizeInfo.COUNT];

        public void captureQuad(BakedQuad quad) {
        }

        public void calculate(BlockAndTintGetter p_412286_, BlockState p_412102_, BlockPos p_412730_, Direction p_412336_, boolean p_412430_) {
            int l1;
            float f7;
            int k1;
            float f6;
            int j1;
            float f5;
            int i1;
            float f4;
            boolean flag3;
            BlockPos blockpos = this.faceCubic ? p_412730_.relative(p_412336_) : p_412730_;
            AdjacencyInfo modelblockrenderer$adjacencyinfo = AdjacencyInfo.fromFacing(p_412336_);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = this.scratchPos;
            blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, modelblockrenderer$adjacencyinfo.corners[0]);
            BlockState blockstate = p_412286_.getBlockState((BlockPos)blockpos$mutableblockpos);
            int i = this.cache.getLightColor(blockstate, p_412286_, (BlockPos)blockpos$mutableblockpos);
            float f = this.cache.getShadeBrightness(blockstate, p_412286_, (BlockPos)blockpos$mutableblockpos);
            blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, modelblockrenderer$adjacencyinfo.corners[1]);
            BlockState blockstate1 = p_412286_.getBlockState((BlockPos)blockpos$mutableblockpos);
            int j = this.cache.getLightColor(blockstate1, p_412286_, (BlockPos)blockpos$mutableblockpos);
            float f1 = this.cache.getShadeBrightness(blockstate1, p_412286_, (BlockPos)blockpos$mutableblockpos);
            blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, modelblockrenderer$adjacencyinfo.corners[2]);
            BlockState blockstate2 = p_412286_.getBlockState((BlockPos)blockpos$mutableblockpos);
            int k = this.cache.getLightColor(blockstate2, p_412286_, (BlockPos)blockpos$mutableblockpos);
            float f2 = this.cache.getShadeBrightness(blockstate2, p_412286_, (BlockPos)blockpos$mutableblockpos);
            blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, modelblockrenderer$adjacencyinfo.corners[3]);
            BlockState blockstate3 = p_412286_.getBlockState((BlockPos)blockpos$mutableblockpos);
            int l = this.cache.getLightColor(blockstate3, p_412286_, (BlockPos)blockpos$mutableblockpos);
            float f3 = this.cache.getShadeBrightness(blockstate3, p_412286_, (BlockPos)blockpos$mutableblockpos);
            BlockState blockstate4 = p_412286_.getBlockState((BlockPos)blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, modelblockrenderer$adjacencyinfo.corners[0]).move(p_412336_));
            boolean flag = !blockstate4.isViewBlocking(p_412286_, (BlockPos)blockpos$mutableblockpos) || blockstate4.getLightBlock() == 0;
            BlockState blockstate5 = p_412286_.getBlockState((BlockPos)blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, modelblockrenderer$adjacencyinfo.corners[1]).move(p_412336_));
            boolean flag1 = !blockstate5.isViewBlocking(p_412286_, (BlockPos)blockpos$mutableblockpos) || blockstate5.getLightBlock() == 0;
            BlockState blockstate6 = p_412286_.getBlockState((BlockPos)blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, modelblockrenderer$adjacencyinfo.corners[2]).move(p_412336_));
            boolean flag2 = !blockstate6.isViewBlocking(p_412286_, (BlockPos)blockpos$mutableblockpos) || blockstate6.getLightBlock() == 0;
            BlockState blockstate7 = p_412286_.getBlockState((BlockPos)blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, modelblockrenderer$adjacencyinfo.corners[3]).move(p_412336_));
            boolean bl = flag3 = !blockstate7.isViewBlocking(p_412286_, (BlockPos)blockpos$mutableblockpos) || blockstate7.getLightBlock() == 0;
            if (!flag2 && !flag) {
                f4 = f;
                i1 = i;
            } else {
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, modelblockrenderer$adjacencyinfo.corners[0]).move(modelblockrenderer$adjacencyinfo.corners[2]);
                BlockState blockstate8 = p_412286_.getBlockState((BlockPos)blockpos$mutableblockpos);
                f4 = this.cache.getShadeBrightness(blockstate8, p_412286_, (BlockPos)blockpos$mutableblockpos);
                i1 = this.cache.getLightColor(blockstate8, p_412286_, (BlockPos)blockpos$mutableblockpos);
            }
            if (!flag3 && !flag) {
                f5 = f;
                j1 = i;
            } else {
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, modelblockrenderer$adjacencyinfo.corners[0]).move(modelblockrenderer$adjacencyinfo.corners[3]);
                BlockState blockstate10 = p_412286_.getBlockState((BlockPos)blockpos$mutableblockpos);
                f5 = this.cache.getShadeBrightness(blockstate10, p_412286_, (BlockPos)blockpos$mutableblockpos);
                j1 = this.cache.getLightColor(blockstate10, p_412286_, (BlockPos)blockpos$mutableblockpos);
            }
            if (!flag2 && !flag1) {
                f6 = f;
                k1 = i;
            } else {
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, modelblockrenderer$adjacencyinfo.corners[1]).move(modelblockrenderer$adjacencyinfo.corners[2]);
                BlockState blockstate11 = p_412286_.getBlockState((BlockPos)blockpos$mutableblockpos);
                f6 = this.cache.getShadeBrightness(blockstate11, p_412286_, (BlockPos)blockpos$mutableblockpos);
                k1 = this.cache.getLightColor(blockstate11, p_412286_, (BlockPos)blockpos$mutableblockpos);
            }
            if (!flag3 && !flag1) {
                f7 = f;
                l1 = i;
            } else {
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, modelblockrenderer$adjacencyinfo.corners[1]).move(modelblockrenderer$adjacencyinfo.corners[3]);
                BlockState blockstate12 = p_412286_.getBlockState((BlockPos)blockpos$mutableblockpos);
                f7 = this.cache.getShadeBrightness(blockstate12, p_412286_, (BlockPos)blockpos$mutableblockpos);
                l1 = this.cache.getLightColor(blockstate12, p_412286_, (BlockPos)blockpos$mutableblockpos);
            }
            int i3 = this.cache.getLightColor(p_412102_, p_412286_, p_412730_);
            blockpos$mutableblockpos.setWithOffset((Vec3i)p_412730_, p_412336_);
            BlockState blockstate9 = p_412286_.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (this.faceCubic || !blockstate9.isSolidRender()) {
                i3 = this.cache.getLightColor(blockstate9, p_412286_, (BlockPos)blockpos$mutableblockpos);
            }
            float f8 = this.faceCubic ? this.cache.getShadeBrightness(p_412286_.getBlockState(blockpos), p_412286_, blockpos) : this.cache.getShadeBrightness(p_412286_.getBlockState(p_412730_), p_412286_, p_412730_);
            AmbientVertexRemap modelblockrenderer$ambientvertexremap = AmbientVertexRemap.fromFacing(p_412336_);
            if (this.facePartial && modelblockrenderer$adjacencyinfo.doNonCubicWeight) {
                float f29 = (f3 + f + f5 + f8) * 0.25f;
                float f31 = (f2 + f + f4 + f8) * 0.25f;
                float f32 = (f2 + f1 + f6 + f8) * 0.25f;
                float f33 = (f3 + f1 + f7 + f8) * 0.25f;
                float f13 = this.faceShape[modelblockrenderer$adjacencyinfo.vert0Weights[0].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert0Weights[1].index];
                float f14 = this.faceShape[modelblockrenderer$adjacencyinfo.vert0Weights[2].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert0Weights[3].index];
                float f15 = this.faceShape[modelblockrenderer$adjacencyinfo.vert0Weights[4].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert0Weights[5].index];
                float f16 = this.faceShape[modelblockrenderer$adjacencyinfo.vert0Weights[6].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert0Weights[7].index];
                float f17 = this.faceShape[modelblockrenderer$adjacencyinfo.vert1Weights[0].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert1Weights[1].index];
                float f18 = this.faceShape[modelblockrenderer$adjacencyinfo.vert1Weights[2].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert1Weights[3].index];
                float f19 = this.faceShape[modelblockrenderer$adjacencyinfo.vert1Weights[4].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert1Weights[5].index];
                float f20 = this.faceShape[modelblockrenderer$adjacencyinfo.vert1Weights[6].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert1Weights[7].index];
                float f21 = this.faceShape[modelblockrenderer$adjacencyinfo.vert2Weights[0].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert2Weights[1].index];
                float f22 = this.faceShape[modelblockrenderer$adjacencyinfo.vert2Weights[2].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert2Weights[3].index];
                float f23 = this.faceShape[modelblockrenderer$adjacencyinfo.vert2Weights[4].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert2Weights[5].index];
                float f24 = this.faceShape[modelblockrenderer$adjacencyinfo.vert2Weights[6].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert2Weights[7].index];
                float f25 = this.faceShape[modelblockrenderer$adjacencyinfo.vert3Weights[0].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert3Weights[1].index];
                float f26 = this.faceShape[modelblockrenderer$adjacencyinfo.vert3Weights[2].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert3Weights[3].index];
                float f27 = this.faceShape[modelblockrenderer$adjacencyinfo.vert3Weights[4].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert3Weights[5].index];
                float f28 = this.faceShape[modelblockrenderer$adjacencyinfo.vert3Weights[6].index] * this.faceShape[modelblockrenderer$adjacencyinfo.vert3Weights[7].index];
                this.brightness[modelblockrenderer$ambientvertexremap.vert0] = Math.clamp(f29 * f13 + f31 * f14 + f32 * f15 + f33 * f16, 0.0f, 1.0f);
                this.brightness[modelblockrenderer$ambientvertexremap.vert1] = Math.clamp(f29 * f17 + f31 * f18 + f32 * f19 + f33 * f20, 0.0f, 1.0f);
                this.brightness[modelblockrenderer$ambientvertexremap.vert2] = Math.clamp(f29 * f21 + f31 * f22 + f32 * f23 + f33 * f24, 0.0f, 1.0f);
                this.brightness[modelblockrenderer$ambientvertexremap.vert3] = Math.clamp(f29 * f25 + f31 * f26 + f32 * f27 + f33 * f28, 0.0f, 1.0f);
                int i2 = AmbientOcclusionRenderStorage.blend(l, i, j1, i3);
                int j2 = AmbientOcclusionRenderStorage.blend(k, i, i1, i3);
                int k2 = AmbientOcclusionRenderStorage.blend(k, j, k1, i3);
                int l2 = AmbientOcclusionRenderStorage.blend(l, j, l1, i3);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert0] = AmbientOcclusionRenderStorage.blend(i2, j2, k2, l2, f13, f14, f15, f16);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert1] = AmbientOcclusionRenderStorage.blend(i2, j2, k2, l2, f17, f18, f19, f20);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert2] = AmbientOcclusionRenderStorage.blend(i2, j2, k2, l2, f21, f22, f23, f24);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert3] = AmbientOcclusionRenderStorage.blend(i2, j2, k2, l2, f25, f26, f27, f28);
            } else {
                float f9 = (f3 + f + f5 + f8) * 0.25f;
                float f10 = (f2 + f + f4 + f8) * 0.25f;
                float f11 = (f2 + f1 + f6 + f8) * 0.25f;
                float f12 = (f3 + f1 + f7 + f8) * 0.25f;
                this.lightmap[modelblockrenderer$ambientvertexremap.vert0] = AmbientOcclusionRenderStorage.blend(l, i, j1, i3);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert1] = AmbientOcclusionRenderStorage.blend(k, i, i1, i3);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert2] = AmbientOcclusionRenderStorage.blend(k, j, k1, i3);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert3] = AmbientOcclusionRenderStorage.blend(l, j, l1, i3);
                this.brightness[modelblockrenderer$ambientvertexremap.vert0] = f9;
                this.brightness[modelblockrenderer$ambientvertexremap.vert1] = f10;
                this.brightness[modelblockrenderer$ambientvertexremap.vert2] = f11;
                this.brightness[modelblockrenderer$ambientvertexremap.vert3] = f12;
            }
            float f30 = p_412286_.getShade(p_412336_, p_412430_);
            for (int j3 = 0; j3 < this.brightness.length; ++j3) {
                this.brightness[j3] = this.brightness[j3] * f30;
            }
        }

        private static int blend(int p_412676_, int p_412469_, int p_412736_, int p_412253_) {
            if (p_412676_ == 0) {
                p_412676_ = p_412253_;
            }
            if (p_412469_ == 0) {
                p_412469_ = p_412253_;
            }
            if (p_412736_ == 0) {
                p_412736_ = p_412253_;
            }
            return p_412676_ + p_412469_ + p_412736_ + p_412253_ >> 2 & 0xFF00FF;
        }

        protected static int blend(int p_412759_, int p_412518_, int p_412118_, int p_412415_, float p_412783_, float p_412051_, float p_412530_, float p_412587_) {
            int i = (int)((float)(p_412759_ >> 16 & 0xFF) * p_412783_ + (float)(p_412518_ >> 16 & 0xFF) * p_412051_ + (float)(p_412118_ >> 16 & 0xFF) * p_412530_ + (float)(p_412415_ >> 16 & 0xFF) * p_412587_) & 0xFF;
            int j = (int)((float)(p_412759_ & 0xFF) * p_412783_ + (float)(p_412518_ & 0xFF) * p_412051_ + (float)(p_412118_ & 0xFF) * p_412530_ + (float)(p_412415_ & 0xFF) * p_412587_) & 0xFF;
            return i << 16 | j;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Cache {
        private boolean enabled;
        private final Long2IntLinkedOpenHashMap colorCache = Util.make(() -> {
            Long2IntLinkedOpenHashMap long2intlinkedopenhashmap = new Long2IntLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_111238_) {
                }
            };
            long2intlinkedopenhashmap.defaultReturnValue(Integer.MAX_VALUE);
            return long2intlinkedopenhashmap;
        });
        private final Long2FloatLinkedOpenHashMap brightnessCache = Util.make(() -> {
            Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = new Long2FloatLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_111245_) {
                }
            };
            long2floatlinkedopenhashmap.defaultReturnValue(Float.NaN);
            return long2floatlinkedopenhashmap;
        });
        private final LevelRenderer.BrightnessGetter cachedBrightnessGetter = (p_412965_, p_412966_) -> {
            long i = p_412966_.asLong();
            int j = this.colorCache.get(i);
            if (j != Integer.MAX_VALUE) {
                return j;
            }
            int k = LevelRenderer.BrightnessGetter.DEFAULT.packedBrightness(p_412965_, p_412966_);
            if (this.colorCache.size() == 100) {
                this.colorCache.removeFirstInt();
            }
            this.colorCache.put(i, k);
            return k;
        };

        private Cache() {
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
            this.colorCache.clear();
            this.brightnessCache.clear();
        }

        public int getLightColor(BlockState p_111222_, BlockAndTintGetter p_111223_, BlockPos p_111224_) {
            return LevelRenderer.getLightColor(this.enabled ? this.cachedBrightnessGetter : LevelRenderer.BrightnessGetter.DEFAULT, p_111223_, p_111222_, p_111224_);
        }

        public float getShadeBrightness(BlockState p_111227_, BlockAndTintGetter p_111228_, BlockPos p_111229_) {
            float f;
            long i = p_111229_.asLong();
            if (this.enabled && !Float.isNaN(f = this.brightnessCache.get(i))) {
                return f;
            }
            float f1 = p_111227_.getShadeBrightness(p_111228_, p_111229_);
            if (this.enabled) {
                if (this.brightnessCache.size() == 100) {
                    this.brightnessCache.removeFirstFloat();
                }
                this.brightnessCache.put(i, f1);
            }
            return f1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CommonRenderStorage {
        public final BlockPos.MutableBlockPos scratchPos = new BlockPos.MutableBlockPos();
        public boolean faceCubic;
        public boolean facePartial;
        public final float[] brightness = new float[4];
        public final int[] lightmap = new int[4];
        public int tintCacheIndex = -1;
        public int tintCacheValue;
        public final Cache cache = CACHE.get();

        CommonRenderStorage() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum SizeInfo {
        DOWN(0),
        UP(1),
        NORTH(2),
        SOUTH(3),
        WEST(4),
        EAST(5),
        FLIP_DOWN(6),
        FLIP_UP(7),
        FLIP_NORTH(8),
        FLIP_SOUTH(9),
        FLIP_WEST(10),
        FLIP_EAST(11);

        public static final int COUNT;
        public final int index;

        private SizeInfo(int p_412421_) {
            this.index = p_412421_;
        }

        static {
            COUNT = SizeInfo.values().length;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum AmbientVertexRemap {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        final int vert0;
        final int vert1;
        final int vert2;
        final int vert3;
        private static final AmbientVertexRemap[] BY_FACING;

        private AmbientVertexRemap(int p_111195_, int p_111196_, int p_111197_, int p_111198_) {
            this.vert0 = p_111195_;
            this.vert1 = p_111196_;
            this.vert2 = p_111197_;
            this.vert3 = p_111198_;
        }

        public static AmbientVertexRemap fromFacing(Direction p_111202_) {
            return BY_FACING[p_111202_.get3DDataValue()];
        }

        static {
            BY_FACING = Util.make(new AmbientVertexRemap[6], p_111204_ -> {
                p_111204_[Direction.DOWN.get3DDataValue()] = DOWN;
                p_111204_[Direction.UP.get3DDataValue()] = UP;
                p_111204_[Direction.NORTH.get3DDataValue()] = NORTH;
                p_111204_[Direction.SOUTH.get3DDataValue()] = SOUTH;
                p_111204_[Direction.WEST.get3DDataValue()] = WEST;
                p_111204_[Direction.EAST.get3DDataValue()] = EAST;
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum AdjacencyInfo {
        DOWN(new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}, 0.5f, true, new SizeInfo[]{SizeInfo.FLIP_WEST, SizeInfo.SOUTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_SOUTH, SizeInfo.WEST, SizeInfo.FLIP_SOUTH, SizeInfo.WEST, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.FLIP_WEST, SizeInfo.NORTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_NORTH, SizeInfo.WEST, SizeInfo.FLIP_NORTH, SizeInfo.WEST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_EAST, SizeInfo.NORTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_NORTH, SizeInfo.EAST, SizeInfo.FLIP_NORTH, SizeInfo.EAST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_EAST, SizeInfo.SOUTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_SOUTH, SizeInfo.EAST, SizeInfo.FLIP_SOUTH, SizeInfo.EAST, SizeInfo.SOUTH}),
        UP(new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, 1.0f, true, new SizeInfo[]{SizeInfo.EAST, SizeInfo.SOUTH, SizeInfo.EAST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_EAST, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.EAST, SizeInfo.NORTH, SizeInfo.EAST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_EAST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.WEST, SizeInfo.NORTH, SizeInfo.WEST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_WEST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.WEST, SizeInfo.SOUTH, SizeInfo.WEST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_WEST, SizeInfo.SOUTH}),
        NORTH(new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST}, 0.8f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_WEST, SizeInfo.UP, SizeInfo.WEST, SizeInfo.FLIP_UP, SizeInfo.WEST, SizeInfo.FLIP_UP, SizeInfo.FLIP_WEST}, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_EAST, SizeInfo.UP, SizeInfo.EAST, SizeInfo.FLIP_UP, SizeInfo.EAST, SizeInfo.FLIP_UP, SizeInfo.FLIP_EAST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_EAST, SizeInfo.DOWN, SizeInfo.EAST, SizeInfo.FLIP_DOWN, SizeInfo.EAST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_EAST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_WEST, SizeInfo.DOWN, SizeInfo.WEST, SizeInfo.FLIP_DOWN, SizeInfo.WEST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_WEST}),
        SOUTH(new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP}, 0.8f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_WEST, SizeInfo.FLIP_UP, SizeInfo.FLIP_WEST, SizeInfo.FLIP_UP, SizeInfo.WEST, SizeInfo.UP, SizeInfo.WEST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_WEST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_WEST, SizeInfo.FLIP_DOWN, SizeInfo.WEST, SizeInfo.DOWN, SizeInfo.WEST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_EAST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_EAST, SizeInfo.FLIP_DOWN, SizeInfo.EAST, SizeInfo.DOWN, SizeInfo.EAST}, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_EAST, SizeInfo.FLIP_UP, SizeInfo.FLIP_EAST, SizeInfo.FLIP_UP, SizeInfo.EAST, SizeInfo.UP, SizeInfo.EAST}),
        WEST(new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.SOUTH, SizeInfo.UP, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_UP, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.UP, SizeInfo.NORTH, SizeInfo.UP, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_UP, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.NORTH, SizeInfo.DOWN, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_DOWN, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.SOUTH, SizeInfo.DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.SOUTH}),
        EAST(new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new SizeInfo[]{SizeInfo.FLIP_DOWN, SizeInfo.SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.DOWN, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.FLIP_DOWN, SizeInfo.NORTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_NORTH, SizeInfo.DOWN, SizeInfo.FLIP_NORTH, SizeInfo.DOWN, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_UP, SizeInfo.NORTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_NORTH, SizeInfo.UP, SizeInfo.FLIP_NORTH, SizeInfo.UP, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_UP, SizeInfo.SOUTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_SOUTH, SizeInfo.UP, SizeInfo.FLIP_SOUTH, SizeInfo.UP, SizeInfo.SOUTH});

        public final Direction[] corners;
        final boolean doNonCubicWeight;
        final SizeInfo[] vert0Weights;
        final SizeInfo[] vert1Weights;
        final SizeInfo[] vert2Weights;
        final SizeInfo[] vert3Weights;
        private static final AdjacencyInfo[] BY_FACING;

        private AdjacencyInfo(Direction[] p_111122_, float p_111123_, boolean p_111124_, SizeInfo[] p_111125_, SizeInfo[] p_111126_, SizeInfo[] p_111127_, SizeInfo[] p_111128_) {
            this.corners = p_111122_;
            this.doNonCubicWeight = p_111124_;
            this.vert0Weights = p_111125_;
            this.vert1Weights = p_111126_;
            this.vert2Weights = p_111127_;
            this.vert3Weights = p_111128_;
        }

        public static AdjacencyInfo fromFacing(Direction p_111132_) {
            return BY_FACING[p_111132_.get3DDataValue()];
        }

        static {
            BY_FACING = Util.make(new AdjacencyInfo[6], p_111134_ -> {
                p_111134_[Direction.DOWN.get3DDataValue()] = DOWN;
                p_111134_[Direction.UP.get3DDataValue()] = UP;
                p_111134_[Direction.NORTH.get3DDataValue()] = NORTH;
                p_111134_[Direction.SOUTH.get3DDataValue()] = SOUTH;
                p_111134_[Direction.WEST.get3DDataValue()] = WEST;
                p_111134_[Direction.EAST.get3DDataValue()] = EAST;
            });
        }
    }
}

