/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.WeightedVariants;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.BlockStateModelExtension;
import net.neoforged.neoforge.client.model.block.BlockStateModelHooks;
import net.neoforged.neoforge.client.model.block.CustomUnbakedBlockStateModel;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public interface BlockStateModel
extends BlockStateModelExtension {
    @Deprecated
    public void collectParts(RandomSource var1, List<BlockModelPart> var2);

    @Deprecated
    default public List<BlockModelPart> collectParts(RandomSource p_410570_) {
        ObjectArrayList list = new ObjectArrayList();
        this.collectParts(p_410570_, (List<BlockModelPart>)list);
        return list;
    }

    @Deprecated
    public TextureAtlasSprite particleIcon();

    @OnlyIn(value=Dist.CLIENT)
    public static interface UnbakedRoot
    extends ResolvableModel {
        public BlockStateModel bake(BlockState var1, ModelBaker var2);

        public Object visualEqualityGroup(BlockState var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Unbaked
    extends ResolvableModel {
        public static final Codec<Weighted<Variant>> ELEMENT_CODEC = RecordCodecBuilder.create(p_409971_ -> p_409971_.group((App)Variant.MAP_CODEC.forGetter(Weighted::value), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("weight", (Object)1).forGetter(Weighted::weight)).apply((Applicative)p_409971_, Weighted::new));
        @ApiStatus.Internal
        public static final Codec<Either<CustomUnbakedBlockStateModel, SingleVariant.Unbaked>> SINGLE_MODEL_CODEC = BlockStateModelHooks.makeSingleModelCodec().codec();
        @ApiStatus.Internal
        public static final Codec<Weighted<Either<CustomUnbakedBlockStateModel, SingleVariant.Unbaked>>> WEIGHTED_MODEL_CODEC = BlockStateModelHooks.makeElementCodec();
        public static final Codec<WeightedVariants.Unbaked> HARDCODED_WEIGHTED_CODEC = ExtraCodecs.nonEmptyList((Codec)WEIGHTED_MODEL_CODEC.listOf()).flatComapMap(p_409703_ -> new WeightedVariants.Unbaked(WeightedList.of(Lists.transform((List)p_409703_, p_409617_ -> p_409617_.map(either -> (Unbaked)either.map(m -> m, m -> m))))), p_409817_ -> {
            List<Weighted<Unbaked>> list = p_409817_.entries().unwrap();
            ArrayList<Weighted> list1 = new ArrayList<Weighted>(list.size());
            block4: for (Weighted<Unbaked> weighted : list) {
                Unbaked selector0$temp;
                Objects.requireNonNull((Unbaked)weighted.value());
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CustomUnbakedBlockStateModel.class, SingleVariant.Unbaked.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        CustomUnbakedBlockStateModel customModel = (CustomUnbakedBlockStateModel)selector0$temp;
                        list1.add(new Weighted((Object)Either.left((Object)customModel), weighted.weight()));
                        continue block4;
                    }
                    case 1: {
                        SingleVariant.Unbaked singlevariant$unbaked = (SingleVariant.Unbaked)selector0$temp;
                        list1.add(new Weighted((Object)Either.right((Object)new SingleVariant.Unbaked(singlevariant$unbaked.variant())), weighted.weight()));
                        continue block4;
                    }
                }
                return DataResult.error(() -> "Only custom models or single variants are supported");
            }
            return DataResult.success(list1);
        });
        public static final Codec<Unbaked> CODEC = Codec.either(HARDCODED_WEIGHTED_CODEC, SINGLE_MODEL_CODEC).flatComapMap(p_410308_ -> (Unbaked)p_410308_.map(p_410746_ -> p_410746_, p_410169_ -> (Unbaked)p_410169_.map(m -> m, m -> m)), p_410404_ -> {
            Unbaked unbaked = p_410404_;
            Objects.requireNonNull(unbaked);
            Unbaked selector0$temp = unbaked;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CustomUnbakedBlockStateModel.class, SingleVariant.Unbaked.class, WeightedVariants.Unbaked.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    CustomUnbakedBlockStateModel customModel = (CustomUnbakedBlockStateModel)selector0$temp;
                    yield DataResult.success((Object)Either.right((Object)Either.left((Object)customModel)));
                }
                case 1 -> {
                    SingleVariant.Unbaked singlevariant$unbaked = (SingleVariant.Unbaked)selector0$temp;
                    yield DataResult.success((Object)Either.right((Object)Either.right((Object)singlevariant$unbaked)));
                }
                case 2 -> {
                    WeightedVariants.Unbaked weightedvariants$unbaked = (WeightedVariants.Unbaked)selector0$temp;
                    yield DataResult.success((Object)Either.left((Object)weightedvariants$unbaked));
                }
                default -> DataResult.error(() -> "Only a custom model or a single variant or a list of variants are supported");
            };
        });

        public BlockStateModel bake(ModelBaker var1);

        default public UnbakedRoot asRoot() {
            return new SimpleCachedUnbakedRoot(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SimpleCachedUnbakedRoot
    implements UnbakedRoot {
        final Unbaked contents;
        private final ModelBaker.SharedOperationKey<BlockStateModel> bakingKey = new ModelBaker.SharedOperationKey<BlockStateModel>(){

            @Override
            public BlockStateModel compute(ModelBaker p_409856_) {
                return contents.bake(p_409856_);
            }
        };

        public SimpleCachedUnbakedRoot(Unbaked p_410217_) {
            this.contents = p_410217_;
        }

        public void resolveDependencies(ResolvableModel.Resolver p_410344_) {
            this.contents.resolveDependencies(p_410344_);
        }

        @Override
        public BlockStateModel bake(BlockState p_410257_, ModelBaker p_410233_) {
            return p_410233_.compute(this.bakingKey);
        }

        @Override
        public Object visualEqualityGroup(BlockState p_409960_) {
            return this;
        }
    }
}

