/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.math.MatrixUtil;
import com.mojang.math.Quadrant;
import com.mojang.math.Transformation;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.model.ExtraFaceData;
import net.neoforged.neoforge.client.model.QuadTransformers;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@OnlyIn(value=Dist.CLIENT)
public class FaceBakery {
    public static final int VERTEX_INT_SIZE = 8;
    private static final float RESCALE_22_5 = 1.0f / (float)Math.cos(0.3926991f) - 1.0f;
    private static final float RESCALE_45 = 1.0f / (float)Math.cos(0.7853981852531433) - 1.0f;
    public static final int VERTEX_COUNT = 4;
    private static final int COLOR_INDEX = 3;
    public static final int UV_INDEX = 4;

    @VisibleForTesting
    public static BlockElementFace.UVs defaultFaceUV(Vector3fc p_404839_, Vector3fc p_405755_, Direction p_404690_) {
        return switch (p_404690_) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> new BlockElementFace.UVs(p_404839_.x(), 16.0f - p_405755_.z(), p_405755_.x(), 16.0f - p_404839_.z());
            case Direction.UP -> new BlockElementFace.UVs(p_404839_.x(), p_404839_.z(), p_405755_.x(), p_405755_.z());
            case Direction.NORTH -> new BlockElementFace.UVs(16.0f - p_405755_.x(), 16.0f - p_405755_.y(), 16.0f - p_404839_.x(), 16.0f - p_404839_.y());
            case Direction.SOUTH -> new BlockElementFace.UVs(p_404839_.x(), 16.0f - p_405755_.y(), p_405755_.x(), 16.0f - p_404839_.y());
            case Direction.WEST -> new BlockElementFace.UVs(p_404839_.z(), 16.0f - p_405755_.y(), p_405755_.z(), 16.0f - p_404839_.y());
            case Direction.EAST -> new BlockElementFace.UVs(16.0f - p_405755_.z(), 16.0f - p_405755_.y(), 16.0f - p_404839_.z(), 16.0f - p_404839_.y());
        };
    }

    public static BakedQuad bakeQuad(Vector3fc p_404957_, Vector3fc p_405340_, BlockElementFace p_111603_, TextureAtlasSprite p_111604_, Direction p_111605_, ModelState p_111606_, @Nullable BlockElementRotation p_111607_, boolean p_111608_, int p_364857_) {
        BlockElementFace.UVs blockelementface$uvs = p_111603_.uvs();
        if (blockelementface$uvs == null) {
            blockelementface$uvs = FaceBakery.defaultFaceUV(p_404957_, p_405340_, p_111605_);
        }
        blockelementface$uvs = FaceBakery.shrinkUVs(p_111604_, blockelementface$uvs);
        Matrix4fc matrix4fc = p_111606_.inverseFaceTransformation(p_111605_);
        int[] aint = FaceBakery.makeVertices(blockelementface$uvs, p_111603_.rotation(), matrix4fc, p_111604_, p_111605_, FaceBakery.setupShape(p_404957_, p_405340_), p_111606_.transformation(), p_111607_);
        Direction direction = FaceBakery.calculateFacing(aint);
        if (p_111607_ == null) {
            FaceBakery.recalculateWinding(aint, direction);
        }
        ClientHooks.fillNormal((int[])aint);
        ExtraFaceData data = p_111603_.faceData();
        BakedQuad quad = new BakedQuad(aint, p_111603_.tintIndex(), direction, p_111604_, p_111608_, p_364857_, data.ambientOcclusion());
        if (!ExtraFaceData.DEFAULT.equals((Object)data)) {
            QuadTransformers.applyingLightmap((int)data.blockLight(), (int)data.skyLight()).processInPlace(quad);
            QuadTransformers.applyingColor((int)data.color()).processInPlace(quad);
        }
        return quad;
    }

    private static BlockElementFace.UVs shrinkUVs(TextureAtlasSprite p_404992_, BlockElementFace.UVs p_405227_) {
        float f = p_405227_.minU();
        float f1 = p_405227_.minV();
        float f2 = p_405227_.maxU();
        float f3 = p_405227_.maxV();
        float f4 = p_404992_.uvShrinkRatio();
        float f5 = (f + f + f2 + f2) / 4.0f;
        float f6 = (f1 + f1 + f3 + f3) / 4.0f;
        return new BlockElementFace.UVs(Mth.lerp((float)f4, (float)f, (float)f5), Mth.lerp((float)f4, (float)f1, (float)f6), Mth.lerp((float)f4, (float)f2, (float)f5), Mth.lerp((float)f4, (float)f3, (float)f6));
    }

    private static int[] makeVertices(BlockElementFace.UVs p_405062_, Quadrant p_405779_, Matrix4fc p_404746_, TextureAtlasSprite p_111575_, Direction p_111576_, float[] p_111577_, Transformation p_111578_, @Nullable BlockElementRotation p_111579_) {
        FaceInfo faceinfo = FaceInfo.fromFacing((Direction)p_111576_);
        int[] aint = new int[32];
        for (int i = 0; i < 4; ++i) {
            FaceBakery.bakeVertex(aint, i, faceinfo, p_405062_, p_405779_, p_404746_, p_111577_, p_111575_, p_111578_, p_111579_);
        }
        return aint;
    }

    private static float[] setupShape(Vector3fc p_405761_, Vector3fc p_404891_) {
        float[] afloat = new float[Direction.values().length];
        afloat[FaceInfo.Constants.MIN_X] = p_405761_.x() / 16.0f;
        afloat[FaceInfo.Constants.MIN_Y] = p_405761_.y() / 16.0f;
        afloat[FaceInfo.Constants.MIN_Z] = p_405761_.z() / 16.0f;
        afloat[FaceInfo.Constants.MAX_X] = p_404891_.x() / 16.0f;
        afloat[FaceInfo.Constants.MAX_Y] = p_404891_.y() / 16.0f;
        afloat[FaceInfo.Constants.MAX_Z] = p_404891_.z() / 16.0f;
        return afloat;
    }

    private static void bakeVertex(int[] p_111621_, int p_111622_, FaceInfo p_405531_, BlockElementFace.UVs p_405537_, Quadrant p_404831_, Matrix4fc p_405449_, float[] p_111625_, TextureAtlasSprite p_111626_, Transformation p_111627_, @Nullable BlockElementRotation p_111628_) {
        float f2;
        float f3;
        FaceInfo.VertexInfo faceinfo$vertexinfo = p_405531_.getVertexInfo(p_111622_);
        Vector3f vector3f = new Vector3f(p_111625_[faceinfo$vertexinfo.xFace], p_111625_[faceinfo$vertexinfo.yFace], p_111625_[faceinfo$vertexinfo.zFace]);
        FaceBakery.applyElementRotation(vector3f, p_111628_);
        FaceBakery.applyModelRotation(vector3f, p_111627_);
        float f = BlockElementFace.getU(p_405537_, p_404831_, p_111622_);
        float f1 = BlockElementFace.getV(p_405537_, p_404831_, p_111622_);
        if (MatrixUtil.isIdentity((Matrix4fc)p_405449_)) {
            f3 = f;
            f2 = f1;
        } else {
            Vector3f vector3f1 = p_405449_.transformPosition(new Vector3f(FaceBakery.cornerToCenter(f), FaceBakery.cornerToCenter(f1), 0.0f));
            f3 = FaceBakery.centerToCorner(vector3f1.x);
            f2 = FaceBakery.centerToCorner(vector3f1.y);
        }
        FaceBakery.fillVertex(p_111621_, p_111622_, vector3f, p_111626_, f3, f2);
    }

    private static float cornerToCenter(float p_405629_) {
        return p_405629_ - 0.5f;
    }

    private static float centerToCorner(float p_405087_) {
        return p_405087_ + 0.5f;
    }

    private static void fillVertex(int[] p_111615_, int p_111616_, Vector3f p_254291_, TextureAtlasSprite p_111618_, float p_405674_, float p_405591_) {
        int i = p_111616_ * 8;
        p_111615_[i] = Float.floatToRawIntBits(p_254291_.x());
        p_111615_[i + 1] = Float.floatToRawIntBits(p_254291_.y());
        p_111615_[i + 2] = Float.floatToRawIntBits(p_254291_.z());
        p_111615_[i + 3] = -1;
        p_111615_[i + 4] = Float.floatToRawIntBits(p_111618_.getU(p_405674_));
        p_111615_[i + 4 + 1] = Float.floatToRawIntBits(p_111618_.getV(p_405591_));
    }

    private static void applyElementRotation(Vector3f p_254412_, @Nullable BlockElementRotation p_254150_) {
        if (p_254150_ != null) {
            Vector3f vector3f;
            Vector3f vector3f1 = switch (p_254150_.axis()) {
                case Direction.Axis.X -> {
                    vector3f = new Vector3f(1.0f, 0.0f, 0.0f);
                    yield new Vector3f(0.0f, 1.0f, 1.0f);
                }
                case Direction.Axis.Y -> {
                    vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
                    yield new Vector3f(1.0f, 0.0f, 1.0f);
                }
                case Direction.Axis.Z -> {
                    vector3f = new Vector3f(0.0f, 0.0f, 1.0f);
                    yield new Vector3f(1.0f, 1.0f, 0.0f);
                }
                default -> throw new IllegalArgumentException("There are only 3 axes");
            };
            Quaternionf quaternionf = new Quaternionf().rotationAxis(p_254150_.angle() * ((float)Math.PI / 180), (Vector3fc)vector3f);
            if (p_254150_.rescale()) {
                if (Math.abs(p_254150_.angle()) == 22.5f) {
                    vector3f1.mul(RESCALE_22_5);
                } else {
                    vector3f1.mul(RESCALE_45);
                }
                vector3f1.add(1.0f, 1.0f, 1.0f);
            } else {
                vector3f1.set(1.0f, 1.0f, 1.0f);
            }
            FaceBakery.rotateVertexBy(p_254412_, (Vector3fc)new Vector3f((Vector3fc)p_254150_.origin()), (Matrix4fc)new Matrix4f().rotation((Quaternionfc)quaternionf), (Vector3fc)vector3f1);
        }
    }

    private static void applyModelRotation(Vector3f p_254561_, Transformation p_253793_) {
        if (p_253793_ != Transformation.identity()) {
            FaceBakery.rotateVertexBy(p_254561_, (Vector3fc)new Vector3f(0.5f, 0.5f, 0.5f), p_253793_.getMatrix(), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f));
        }
    }

    private static void rotateVertexBy(Vector3f p_404849_, Vector3fc p_404934_, Matrix4fc p_405201_, Vector3fc p_405230_) {
        Vector4f vector4f = p_405201_.transform(new Vector4f(p_404849_.x() - p_404934_.x(), p_404849_.y() - p_404934_.y(), p_404849_.z() - p_404934_.z(), 1.0f));
        vector4f.mul((Vector4fc)new Vector4f(p_405230_, 1.0f));
        p_404849_.set(vector4f.x() + p_404934_.x(), vector4f.y() + p_404934_.y(), vector4f.z() + p_404934_.z());
    }

    private static Direction calculateFacing(int[] p_111613_) {
        Vector3f vector3f = FaceBakery.vectorFromData(p_111613_, 0);
        Vector3f vector3f1 = FaceBakery.vectorFromData(p_111613_, 8);
        Vector3f vector3f2 = FaceBakery.vectorFromData(p_111613_, 16);
        Vector3f vector3f3 = new Vector3f((Vector3fc)vector3f).sub((Vector3fc)vector3f1);
        Vector3f vector3f4 = new Vector3f((Vector3fc)vector3f2).sub((Vector3fc)vector3f1);
        Vector3f vector3f5 = new Vector3f((Vector3fc)vector3f4).cross((Vector3fc)vector3f3).normalize();
        if (!vector3f5.isFinite()) {
            return Direction.UP;
        }
        Direction direction = null;
        float f = 0.0f;
        for (Direction direction1 : Direction.values()) {
            float f1 = vector3f5.dot(direction1.getUnitVec3f());
            if (!(f1 >= 0.0f) || !(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction == null ? Direction.UP : direction;
    }

    private static float xFromData(int[] p_404923_, int p_404736_) {
        return Float.intBitsToFloat(p_404923_[p_404736_]);
    }

    private static float yFromData(int[] p_405832_, int p_405261_) {
        return Float.intBitsToFloat(p_405832_[p_405261_ + 1]);
    }

    private static float zFromData(int[] p_405720_, int p_405821_) {
        return Float.intBitsToFloat(p_405720_[p_405821_ + 2]);
    }

    private static Vector3f vectorFromData(int[] p_405451_, int p_404978_) {
        return new Vector3f(FaceBakery.xFromData(p_405451_, p_404978_), FaceBakery.yFromData(p_405451_, p_404978_), FaceBakery.zFromData(p_405451_, p_404978_));
    }

    private static void recalculateWinding(int[] p_111631_, Direction p_111632_) {
        int[] aint = new int[p_111631_.length];
        System.arraycopy(p_111631_, 0, aint, 0, p_111631_.length);
        float[] afloat = new float[Direction.values().length];
        afloat[FaceInfo.Constants.MIN_X] = 999.0f;
        afloat[FaceInfo.Constants.MIN_Y] = 999.0f;
        afloat[FaceInfo.Constants.MIN_Z] = 999.0f;
        afloat[FaceInfo.Constants.MAX_X] = -999.0f;
        afloat[FaceInfo.Constants.MAX_Y] = -999.0f;
        afloat[FaceInfo.Constants.MAX_Z] = -999.0f;
        for (int i = 0; i < 4; ++i) {
            int j = 8 * i;
            float f = FaceBakery.xFromData(aint, j);
            float f1 = FaceBakery.yFromData(aint, j);
            float f2 = FaceBakery.zFromData(aint, j);
            if (f < afloat[FaceInfo.Constants.MIN_X]) {
                afloat[FaceInfo.Constants.MIN_X] = f;
            }
            if (f1 < afloat[FaceInfo.Constants.MIN_Y]) {
                afloat[FaceInfo.Constants.MIN_Y] = f1;
            }
            if (f2 < afloat[FaceInfo.Constants.MIN_Z]) {
                afloat[FaceInfo.Constants.MIN_Z] = f2;
            }
            if (f > afloat[FaceInfo.Constants.MAX_X]) {
                afloat[FaceInfo.Constants.MAX_X] = f;
            }
            if (f1 > afloat[FaceInfo.Constants.MAX_Y]) {
                afloat[FaceInfo.Constants.MAX_Y] = f1;
            }
            if (!(f2 > afloat[FaceInfo.Constants.MAX_Z])) continue;
            afloat[FaceInfo.Constants.MAX_Z] = f2;
        }
        FaceInfo faceinfo = FaceInfo.fromFacing((Direction)p_111632_);
        for (int i1 = 0; i1 < 4; ++i1) {
            int j1 = 8 * i1;
            FaceInfo.VertexInfo faceinfo$vertexinfo = faceinfo.getVertexInfo(i1);
            float f8 = afloat[faceinfo$vertexinfo.xFace];
            float f3 = afloat[faceinfo$vertexinfo.yFace];
            float f4 = afloat[faceinfo$vertexinfo.zFace];
            p_111631_[j1] = Float.floatToRawIntBits(f8);
            p_111631_[j1 + 1] = Float.floatToRawIntBits(f3);
            p_111631_[j1 + 2] = Float.floatToRawIntBits(f4);
            for (int k = 0; k < 4; ++k) {
                int l = 8 * k;
                float f5 = FaceBakery.xFromData(aint, l);
                float f6 = FaceBakery.yFromData(aint, l);
                float f7 = FaceBakery.zFromData(aint, l);
                if (!Mth.equal((float)f8, (float)f5) || !Mth.equal((float)f3, (float)f6) || !Mth.equal((float)f4, (float)f7)) continue;
                p_111631_[j1 + 4] = aint[l + 4];
                p_111631_[j1 + 4 + 1] = aint[l + 4 + 1];
            }
        }
    }

    public static void extractPositions(int[] p_405530_, Consumer<Vector3f> p_404815_) {
        for (int i = 0; i < 4; ++i) {
            p_404815_.accept(FaceBakery.vectorFromData(p_405530_, 8 * i));
        }
    }
}

