/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BeaconBeamOwner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class BeaconRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation BEAM_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/beacon_beam.png");
    public static final int MAX_RENDER_Y = 2048;
    private static final float BEAM_SCALE_THRESHOLD = 96.0f;
    public static final float SOLID_BEAM_RADIUS = 0.2f;
    public static final float BEAM_GLOW_RADIUS = 0.25f;

    public BeaconRenderer(BlockEntityRendererProvider.Context p_173529_) {
    }

    @Override
    public void render(T p_112149_, float p_112150_, PoseStack p_112151_, MultiBufferSource p_112152_, int p_112153_, int p_112154_, Vec3 p_401093_) {
        long i = ((BlockEntity)((Object)p_112149_)).getLevel().getGameTime();
        float f = (float)p_401093_.subtract(((BlockEntity)((Object)p_112149_)).getBlockPos().getCenter()).horizontalDistance();
        LocalPlayer localplayer = Minecraft.getInstance().player;
        float f1 = localplayer != null && localplayer.isScoping() ? 1.0f : Math.max(1.0f, f / 96.0f);
        List list = ((BeaconBeamOwner)p_112149_).getBeamSections();
        int j = 0;
        for (int k = 0; k < list.size(); ++k) {
            BeaconBeamOwner.Section beaconbeamowner$section = (BeaconBeamOwner.Section)list.get(k);
            BeaconRenderer.renderBeaconBeam(p_112151_, p_112152_, p_112150_, f1, i, j, k == list.size() - 1 ? 2048 : beaconbeamowner$section.getHeight(), beaconbeamowner$section.getColor());
            j += beaconbeamowner$section.getHeight();
        }
    }

    private static void renderBeaconBeam(PoseStack p_112185_, MultiBufferSource p_112186_, float p_112188_, float p_401272_, long p_112190_, int p_112191_, int p_112192_, int p_350457_) {
        BeaconRenderer.renderBeaconBeam(p_112185_, p_112186_, BEAM_LOCATION, p_112188_, 1.0f, p_112190_, p_112191_, p_112192_, p_350457_, 0.2f * p_401272_, 0.25f * p_401272_);
    }

    public static void renderBeaconBeam(PoseStack p_112177_, MultiBufferSource p_112178_, ResourceLocation p_350504_, float p_112179_, float p_350618_, long p_112180_, int p_112181_, int p_112182_, int p_350915_, float p_350604_, float p_350669_) {
        int i = p_112181_ + p_112182_;
        p_112177_.pushPose();
        p_112177_.translate(0.5, 0.0, 0.5);
        float f = (float)Math.floorMod(p_112180_, 40) + p_112179_;
        float f1 = p_112182_ < 0 ? f : -f;
        float f2 = Mth.frac((float)(f1 * 0.2f - (float)Mth.floor((float)(f1 * 0.1f))));
        p_112177_.pushPose();
        p_112177_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f * 2.25f - 45.0f));
        float f3 = 0.0f;
        float f5 = 0.0f;
        float f6 = -p_350604_;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = -p_350604_;
        float f10 = 0.0f;
        float f11 = 1.0f;
        float f12 = -1.0f + f2;
        float f13 = (float)p_112182_ * p_350618_ * (0.5f / p_350604_) + f12;
        BeaconRenderer.renderPart(p_112177_, p_112178_.getBuffer(RenderType.beaconBeam(p_350504_, false)), p_350915_, p_112181_, i, 0.0f, p_350604_, p_350604_, 0.0f, f6, 0.0f, 0.0f, f9, 0.0f, 1.0f, f13, f12);
        p_112177_.popPose();
        f3 = -p_350669_;
        float f4 = -p_350669_;
        f5 = -p_350669_;
        f6 = -p_350669_;
        f10 = 0.0f;
        f11 = 1.0f;
        f12 = -1.0f + f2;
        f13 = (float)p_112182_ * p_350618_ + f12;
        BeaconRenderer.renderPart(p_112177_, p_112178_.getBuffer(RenderType.beaconBeam(p_350504_, true)), ARGB.color((int)32, (int)p_350915_), p_112181_, i, f3, f4, p_350669_, f5, f6, p_350669_, p_350669_, p_350669_, 0.0f, 1.0f, f13, f12);
        p_112177_.popPose();
    }

    private static void renderPart(PoseStack p_112156_, VertexConsumer p_112157_, int p_112162_, int p_112163_, int p_351014_, float p_112158_, float p_112159_, float p_112160_, float p_112161_, float p_112164_, float p_112165_, float p_112166_, float p_112167_, float p_112168_, float p_112169_, float p_112170_, float p_112171_) {
        PoseStack.Pose posestack$pose = p_112156_.last();
        BeaconRenderer.renderQuad(posestack$pose, p_112157_, p_112162_, p_112163_, p_351014_, p_112158_, p_112159_, p_112160_, p_112161_, p_112168_, p_112169_, p_112170_, p_112171_);
        BeaconRenderer.renderQuad(posestack$pose, p_112157_, p_112162_, p_112163_, p_351014_, p_112166_, p_112167_, p_112164_, p_112165_, p_112168_, p_112169_, p_112170_, p_112171_);
        BeaconRenderer.renderQuad(posestack$pose, p_112157_, p_112162_, p_112163_, p_351014_, p_112160_, p_112161_, p_112166_, p_112167_, p_112168_, p_112169_, p_112170_, p_112171_);
        BeaconRenderer.renderQuad(posestack$pose, p_112157_, p_112162_, p_112163_, p_351014_, p_112164_, p_112165_, p_112158_, p_112159_, p_112168_, p_112169_, p_112170_, p_112171_);
    }

    private static void renderQuad(PoseStack.Pose p_323955_, VertexConsumer p_112122_, int p_112127_, int p_112128_, int p_350566_, float p_112123_, float p_112124_, float p_112125_, float p_112126_, float p_112129_, float p_112130_, float p_112131_, float p_112132_) {
        BeaconRenderer.addVertex(p_323955_, p_112122_, p_112127_, p_350566_, p_112123_, p_112124_, p_112130_, p_112131_);
        BeaconRenderer.addVertex(p_323955_, p_112122_, p_112127_, p_112128_, p_112123_, p_112124_, p_112130_, p_112132_);
        BeaconRenderer.addVertex(p_323955_, p_112122_, p_112127_, p_112128_, p_112125_, p_112126_, p_112129_, p_112132_);
        BeaconRenderer.addVertex(p_323955_, p_112122_, p_112127_, p_350566_, p_112125_, p_112126_, p_112129_, p_112131_);
    }

    private static void addVertex(PoseStack.Pose p_324495_, VertexConsumer p_253894_, int p_254357_, int p_350652_, float p_253871_, float p_253841_, float p_254568_, float p_254361_) {
        p_253894_.addVertex(p_324495_, p_253871_, (float)p_350652_, p_253841_).setColor(p_254357_).setUv(p_254568_, p_254361_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(p_324495_, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public boolean shouldRenderOffScreen(T p_112147_) {
        return true;
    }

    @Override
    public int getViewDistance() {
        return Minecraft.getInstance().options.getEffectiveRenderDistance() * 16;
    }

    @Override
    public boolean shouldRender(T p_173534_, Vec3 p_173535_) {
        return Vec3.atCenterOf((Vec3i)((BlockEntity)((Object)p_173534_)).getBlockPos()).multiply(1.0, 0.0, 1.0).closerThan((Position)p_173535_.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }

    public AABB getRenderBoundingBox(T blockEntity) {
        BlockPos pos = ((BlockEntity)((Object)blockEntity)).getBlockPos();
        return new AABB(pos.getX(), pos.getY(), pos.getZ(), (double)pos.getX() + 1.0, 2048.0, (double)pos.getZ() + 1.0);
    }
}

