/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlockEntityWithBoundingBoxRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    public BlockEntityWithBoundingBoxRenderer(BlockEntityRendererProvider.Context p_397760_) {
    }

    @Override
    public void render(T p_397324_, float p_397611_, PoseStack p_397388_, MultiBufferSource p_397625_, int p_397985_, int p_397795_, Vec3 p_401190_) {
        BoundingBoxRenderable.Mode boundingboxrenderable$mode;
        if ((Minecraft.getInstance().player.canUseGameMasterBlocks() || Minecraft.getInstance().player.isSpectator()) && (boundingboxrenderable$mode = ((BoundingBoxRenderable)p_397324_).renderMode()) != BoundingBoxRenderable.Mode.NONE) {
            BoundingBoxRenderable.RenderableBox boundingboxrenderable$renderablebox = ((BoundingBoxRenderable)p_397324_).getRenderableBox();
            BlockPos blockpos = boundingboxrenderable$renderablebox.localPos();
            Vec3i vec3i = boundingboxrenderable$renderablebox.size();
            if (vec3i.getX() >= 1 && vec3i.getY() >= 1 && vec3i.getZ() >= 1) {
                float f = 1.0f;
                float f1 = 0.9f;
                float f2 = 0.5f;
                VertexConsumer vertexconsumer = p_397625_.getBuffer(RenderType.lines());
                BlockPos blockpos1 = blockpos.offset(vec3i);
                ShapeRenderer.renderLineBox((PoseStack)p_397388_, (VertexConsumer)vertexconsumer, (double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), (double)blockpos1.getX(), (double)blockpos1.getY(), (double)blockpos1.getZ(), (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
                if (boundingboxrenderable$mode == BoundingBoxRenderable.Mode.BOX_AND_INVISIBLE_BLOCKS && ((BlockEntity)((Object)p_397324_)).getLevel() != null) {
                    this.renderInvisibleBlocks(p_397324_, (BlockGetter)((Object)((BlockEntity)((Object)p_397324_)).getLevel()), blockpos, vec3i, p_397625_, p_397388_);
                }
            }
        }
    }

    private void renderInvisibleBlocks(T p_397069_, BlockGetter p_397190_, BlockPos p_397106_, Vec3i p_397027_, MultiBufferSource p_397495_, PoseStack p_396990_) {
        VertexConsumer vertexconsumer = p_397495_.getBuffer(RenderType.lines());
        BlockPos blockpos = ((BlockEntity)((Object)p_397069_)).getBlockPos();
        BlockPos blockpos1 = blockpos.offset((Vec3i)p_397106_);
        for (BlockPos blockpos2 : BlockPos.betweenClosed((BlockPos)blockpos1, (BlockPos)blockpos1.offset(p_397027_).offset(-1, -1, -1))) {
            boolean flag4;
            BlockState blockstate = p_397190_.getBlockState(blockpos2);
            boolean flag = blockstate.isAir();
            boolean flag1 = blockstate.is(Blocks.STRUCTURE_VOID);
            boolean flag2 = blockstate.is(Blocks.BARRIER);
            boolean flag3 = blockstate.is(Blocks.LIGHT);
            boolean bl = flag4 = flag1 || flag2 || flag3;
            if (!flag && !flag4) continue;
            float f = flag ? 0.05f : 0.0f;
            double d0 = (float)(blockpos2.getX() - blockpos.getX()) + 0.45f - f;
            double d1 = (float)(blockpos2.getY() - blockpos.getY()) + 0.45f - f;
            double d2 = (float)(blockpos2.getZ() - blockpos.getZ()) + 0.45f - f;
            double d3 = (float)(blockpos2.getX() - blockpos.getX()) + 0.55f + f;
            double d4 = (float)(blockpos2.getY() - blockpos.getY()) + 0.55f + f;
            double d5 = (float)(blockpos2.getZ() - blockpos.getZ()) + 0.55f + f;
            if (flag) {
                ShapeRenderer.renderLineBox((PoseStack)p_396990_, (VertexConsumer)vertexconsumer, (double)d0, (double)d1, (double)d2, (double)d3, (double)d4, (double)d5, (float)0.5f, (float)0.5f, (float)1.0f, (float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
                continue;
            }
            if (flag1) {
                ShapeRenderer.renderLineBox((PoseStack)p_396990_, (VertexConsumer)vertexconsumer, (double)d0, (double)d1, (double)d2, (double)d3, (double)d4, (double)d5, (float)1.0f, (float)0.75f, (float)0.75f, (float)1.0f, (float)1.0f, (float)0.75f, (float)0.75f);
                continue;
            }
            if (flag2) {
                ShapeRenderer.renderLineBox((PoseStack)p_396990_, (VertexConsumer)vertexconsumer, (double)d0, (double)d1, (double)d2, (double)d3, (double)d4, (double)d5, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                continue;
            }
            if (!flag3) continue;
            ShapeRenderer.renderLineBox((PoseStack)p_396990_, (VertexConsumer)vertexconsumer, (double)d0, (double)d1, (double)d2, (double)d3, (double)d4, (double)d5, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void renderStructureVoids(T p_397113_, BlockPos p_397422_, Vec3i p_398022_, VertexConsumer p_397021_, PoseStack p_397646_) {
        Level blockgetter = ((BlockEntity)((Object)p_397113_)).getLevel();
        if (blockgetter != null) {
            BlockPos blockpos = ((BlockEntity)((Object)p_397113_)).getBlockPos();
            BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(p_398022_.getX(), p_398022_.getY(), p_398022_.getZ());
            for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)p_397422_, (BlockPos)p_397422_.offset(p_398022_).offset(-1, -1, -1))) {
                if (!blockgetter.getBlockState(blockpos1).is(Blocks.STRUCTURE_VOID)) continue;
                discretevoxelshape.fill(blockpos1.getX() - p_397422_.getX(), blockpos1.getY() - p_397422_.getY(), blockpos1.getZ() - p_397422_.getZ());
            }
            discretevoxelshape.forAllFaces((p_397952_, p_397448_, p_397536_, p_397862_) -> {
                float f = 0.48f;
                float f1 = (float)(p_397448_ + p_397422_.getX() - blockpos.getX()) + 0.5f - 0.48f;
                float f2 = (float)(p_397536_ + p_397422_.getY() - blockpos.getY()) + 0.5f - 0.48f;
                float f3 = (float)(p_397862_ + p_397422_.getZ() - blockpos.getZ()) + 0.5f - 0.48f;
                float f4 = (float)(p_397448_ + p_397422_.getX() - blockpos.getX()) + 0.5f + 0.48f;
                float f5 = (float)(p_397536_ + p_397422_.getY() - blockpos.getY()) + 0.5f + 0.48f;
                float f6 = (float)(p_397862_ + p_397422_.getZ() - blockpos.getZ()) + 0.5f + 0.48f;
                ShapeRenderer.renderFace((PoseStack)p_397646_, (VertexConsumer)p_397021_, (Direction)p_397952_, (float)f1, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6, (float)0.75f, (float)0.75f, (float)1.0f, (float)0.2f);
            });
        }
    }

    @Override
    public boolean shouldRenderOffScreen(T p_397618_) {
        return true;
    }

    @Override
    public int getViewDistance() {
        return 96;
    }

    public AABB getRenderBoundingBox(BlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

