/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class BrushableBlockRenderer
implements BlockEntityRenderer<BrushableBlockEntity> {
    private final ItemRenderer itemRenderer;

    public BrushableBlockRenderer(BlockEntityRendererProvider.Context p_277899_) {
        this.itemRenderer = p_277899_.getItemRenderer();
    }

    @Override
    public void render(BrushableBlockEntity p_277712_, float p_277981_, PoseStack p_277490_, MultiBufferSource p_278015_, int p_277463_, int p_277346_, Vec3 p_401179_) {
        ItemStack itemstack;
        Direction direction;
        int i;
        if (p_277712_.getLevel() != null && (i = ((Integer)p_277712_.getBlockState().getValue((Property)BlockStateProperties.DUSTED)).intValue()) > 0 && (direction = p_277712_.getHitDirection()) != null && !(itemstack = p_277712_.getItem()).isEmpty()) {
            p_277490_.pushPose();
            p_277490_.translate(0.0f, 0.5f, 0.0f);
            float[] afloat = this.translations(direction, i);
            p_277490_.translate(afloat[0], afloat[1], afloat[2]);
            p_277490_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(75.0f));
            boolean flag = direction == Direction.EAST || direction == Direction.WEST;
            p_277490_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)((flag ? 90 : 0) + 11)));
            p_277490_.scale(0.5f, 0.5f, 0.5f);
            int j = LevelRenderer.getLightColor(LevelRenderer.BrightnessGetter.DEFAULT, (BlockAndTintGetter)((Object)p_277712_.getLevel()), p_277712_.getBlockState(), p_277712_.getBlockPos().relative(direction));
            this.itemRenderer.renderStatic(itemstack, ItemDisplayContext.FIXED, j, OverlayTexture.NO_OVERLAY, p_277490_, p_278015_, p_277712_.getLevel(), 0);
            p_277490_.popPose();
        }
    }

    private float[] translations(Direction p_278030_, int p_277997_) {
        float[] afloat = new float[]{0.5f, 0.0f, 0.5f};
        float f = (float)p_277997_ / 10.0f * 0.75f;
        switch (p_278030_) {
            case EAST: {
                afloat[0] = 0.73f + f;
                break;
            }
            case WEST: {
                afloat[0] = 0.25f - f;
                break;
            }
            case UP: {
                afloat[1] = 0.25f + f;
                break;
            }
            case DOWN: {
                afloat[1] = -0.23f - f;
                break;
            }
            case NORTH: {
                afloat[2] = 0.25f - f;
                break;
            }
            case SOUTH: {
                afloat[2] = 0.73f + f;
            }
        }
        return afloat;
    }

    public AABB getRenderBoundingBox(BrushableBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 0.25, (double)pos.getY() - 0.25, (double)pos.getZ() - 0.25, (double)pos.getX() + 1.25, (double)pos.getY() + 1.25, (double)pos.getZ() + 1.25);
    }
}

