/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class DecoratedPotRenderer
implements BlockEntityRenderer<DecoratedPotBlockEntity> {
    private static final String NECK = "neck";
    private static final String FRONT = "front";
    private static final String BACK = "back";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String TOP = "top";
    private static final String BOTTOM = "bottom";
    private final ModelPart neck;
    private final ModelPart frontSide;
    private final ModelPart backSide;
    private final ModelPart leftSide;
    private final ModelPart rightSide;
    private final ModelPart top;
    private final ModelPart bottom;
    private static final float WOBBLE_AMPLITUDE = 0.125f;

    public DecoratedPotRenderer(BlockEntityRendererProvider.Context p_272872_) {
        this(p_272872_.getModelSet());
    }

    public DecoratedPotRenderer(EntityModelSet p_388225_) {
        ModelPart modelpart = p_388225_.bakeLayer(ModelLayers.DECORATED_POT_BASE);
        this.neck = modelpart.getChild(NECK);
        this.top = modelpart.getChild(TOP);
        this.bottom = modelpart.getChild(BOTTOM);
        ModelPart modelpart1 = p_388225_.bakeLayer(ModelLayers.DECORATED_POT_SIDES);
        this.frontSide = modelpart1.getChild(FRONT);
        this.backSide = modelpart1.getChild(BACK);
        this.leftSide = modelpart1.getChild(LEFT);
        this.rightSide = modelpart1.getChild(RIGHT);
    }

    public static LayerDefinition createBaseLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedeformation = new CubeDeformation(0.2f);
        CubeDeformation cubedeformation1 = new CubeDeformation(-0.1f);
        partdefinition.addOrReplaceChild(NECK, CubeListBuilder.create().texOffs(0, 0).addBox(4.0f, 17.0f, 4.0f, 8.0f, 3.0f, 8.0f, cubedeformation1).texOffs(0, 5).addBox(5.0f, 20.0f, 5.0f, 6.0f, 1.0f, 6.0f, cubedeformation), PartPose.offsetAndRotation((float)0.0f, (float)37.0f, (float)16.0f, (float)((float)Math.PI), (float)0.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(-14, 13).addBox(0.0f, 0.0f, 0.0f, 14.0f, 0.0f, 14.0f);
        partdefinition.addOrReplaceChild(TOP, cubelistbuilder, PartPose.offsetAndRotation((float)1.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(BOTTOM, cubelistbuilder, PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition createSidesLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(1, 0).addBox(0.0f, 0.0f, 0.0f, 14.0f, 16.0f, 0.0f, EnumSet.of(Direction.NORTH));
        partdefinition.addOrReplaceChild(BACK, cubelistbuilder, PartPose.offsetAndRotation((float)15.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        partdefinition.addOrReplaceChild(LEFT, cubelistbuilder, PartPose.offsetAndRotation((float)1.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)-1.5707964f, (float)((float)Math.PI)));
        partdefinition.addOrReplaceChild(RIGHT, cubelistbuilder, PartPose.offsetAndRotation((float)15.0f, (float)16.0f, (float)15.0f, (float)0.0f, (float)1.5707964f, (float)((float)Math.PI)));
        partdefinition.addOrReplaceChild(FRONT, cubelistbuilder, PartPose.offsetAndRotation((float)1.0f, (float)16.0f, (float)15.0f, (float)((float)Math.PI), (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    private static Material getSideMaterial(Optional<Item> p_347523_) {
        Material material;
        if (p_347523_.isPresent() && (material = Sheets.getDecoratedPotMaterial(DecoratedPotPatterns.getPatternFromItem((Item)p_347523_.get()))) != null) {
            return material;
        }
        return Sheets.DECORATED_POT_SIDE;
    }

    @Override
    public void render(DecoratedPotBlockEntity p_273776_, float p_273103_, PoseStack p_273455_, MultiBufferSource p_273010_, int p_273407_, int p_273059_, Vec3 p_401111_) {
        float f;
        p_273455_.pushPose();
        Direction direction = p_273776_.getDirection();
        p_273455_.translate(0.5, 0.0, 0.5);
        p_273455_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - direction.toYRot()));
        p_273455_.translate(-0.5, 0.0, -0.5);
        DecoratedPotBlockEntity.WobbleStyle decoratedpotblockentity$wobblestyle = p_273776_.lastWobbleStyle;
        if (decoratedpotblockentity$wobblestyle != null && p_273776_.getLevel() != null && (f = ((float)(p_273776_.getLevel().getGameTime() - p_273776_.wobbleStartedAtTick) + p_273103_) / (float)decoratedpotblockentity$wobblestyle.duration) >= 0.0f && f <= 1.0f) {
            if (decoratedpotblockentity$wobblestyle == DecoratedPotBlockEntity.WobbleStyle.POSITIVE) {
                float f1 = 0.015625f;
                float f2 = f * ((float)Math.PI * 2);
                float f3 = -1.5f * (Mth.cos((float)f2) + 0.5f) * Mth.sin((float)(f2 / 2.0f));
                p_273455_.rotateAround((Quaternionfc)Axis.XP.rotation(f3 * 0.015625f), 0.5f, 0.0f, 0.5f);
                float f4 = Mth.sin((float)f2);
                p_273455_.rotateAround((Quaternionfc)Axis.ZP.rotation(f4 * 0.015625f), 0.5f, 0.0f, 0.5f);
            } else {
                float f5 = Mth.sin((float)(-f * 3.0f * (float)Math.PI)) * 0.125f;
                float f6 = 1.0f - f;
                p_273455_.rotateAround((Quaternionfc)Axis.YP.rotation(f5 * f6), 0.5f, 0.0f, 0.5f);
            }
        }
        this.render(p_273455_, p_273010_, p_273407_, p_273059_, p_273776_.getDecorations());
        p_273455_.popPose();
    }

    public void renderInHand(PoseStack p_387992_, MultiBufferSource p_388100_, int p_388310_, int p_388706_, PotDecorations p_388823_) {
        this.render(p_387992_, p_388100_, p_388310_, p_388706_, p_388823_);
    }

    private void render(PoseStack p_387832_, MultiBufferSource p_388585_, int p_388442_, int p_388390_, PotDecorations p_388388_) {
        VertexConsumer vertexconsumer = Sheets.DECORATED_POT_BASE.buffer(p_388585_, RenderType::entitySolid);
        this.neck.render(p_387832_, vertexconsumer, p_388442_, p_388390_);
        this.top.render(p_387832_, vertexconsumer, p_388442_, p_388390_);
        this.bottom.render(p_387832_, vertexconsumer, p_388442_, p_388390_);
        this.renderSide(this.frontSide, p_387832_, p_388585_, p_388442_, p_388390_, DecoratedPotRenderer.getSideMaterial(p_388388_.front()));
        this.renderSide(this.backSide, p_387832_, p_388585_, p_388442_, p_388390_, DecoratedPotRenderer.getSideMaterial(p_388388_.back()));
        this.renderSide(this.leftSide, p_387832_, p_388585_, p_388442_, p_388390_, DecoratedPotRenderer.getSideMaterial(p_388388_.left()));
        this.renderSide(this.rightSide, p_387832_, p_388585_, p_388442_, p_388390_, DecoratedPotRenderer.getSideMaterial(p_388388_.right()));
    }

    private void renderSide(ModelPart p_273495_, PoseStack p_272899_, MultiBufferSource p_273582_, int p_273242_, int p_273108_, Material p_273173_) {
        p_273495_.render(p_272899_, p_273173_.buffer(p_273582_, RenderType::entitySolid), p_273242_, p_273108_);
    }

    public AABB getRenderBoundingBox(DecoratedPotBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB(pos.getX(), pos.getY(), pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + 1.3, (double)pos.getZ() + 1.0);
    }
}

