/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.RenderTypeHelper;

@OnlyIn(value=Dist.CLIENT)
public class PistonHeadRenderer
implements BlockEntityRenderer<PistonMovingBlockEntity> {
    private final BlockRenderDispatcher blockRenderer;

    public PistonHeadRenderer(BlockEntityRendererProvider.Context p_173623_) {
        this.blockRenderer = p_173623_.getBlockRenderDispatcher();
    }

    @Override
    public void render(PistonMovingBlockEntity p_112452_, float p_112453_, PoseStack p_112454_, MultiBufferSource p_112455_, int p_112456_, int p_112457_, Vec3 p_401129_) {
        Level level = p_112452_.getLevel();
        if (level != null) {
            BlockPos blockpos = p_112452_.getBlockPos().relative(p_112452_.getMovementDirection().getOpposite());
            BlockState blockstate = p_112452_.getMovedState();
            if (!blockstate.isAir()) {
                ModelBlockRenderer.enableCaching();
                p_112454_.pushPose();
                p_112454_.translate(p_112452_.getXOff(p_112453_), p_112452_.getYOff(p_112453_), p_112452_.getZOff(p_112453_));
                if (blockstate.is(Blocks.PISTON_HEAD) && p_112452_.getProgress(p_112453_) <= 4.0f) {
                    blockstate = (BlockState)((Object)blockstate.setValue((Property)PistonHeadBlock.SHORT, Boolean.valueOf(p_112452_.getProgress(p_112453_) <= 0.5f)));
                    this.renderBlock(blockpos, blockstate, p_112454_, p_112455_, level, false, p_112457_);
                } else if (p_112452_.isSourcePiston() && !p_112452_.isExtending()) {
                    PistonType pistontype = blockstate.is(Blocks.STICKY_PISTON) ? PistonType.STICKY : PistonType.DEFAULT;
                    BlockState blockstate1 = (BlockState)((Object)((BlockState)((Object)Blocks.PISTON_HEAD.defaultBlockState().setValue((Property)PistonHeadBlock.TYPE, (Comparable)pistontype))).setValue((Property)PistonHeadBlock.FACING, (Comparable)((Direction)blockstate.getValue((Property)PistonBaseBlock.FACING))));
                    blockstate1 = (BlockState)((Object)blockstate1.setValue((Property)PistonHeadBlock.SHORT, Boolean.valueOf(p_112452_.getProgress(p_112453_) >= 0.5f)));
                    this.renderBlock(blockpos, blockstate1, p_112454_, p_112455_, level, false, p_112457_);
                    BlockPos blockpos1 = blockpos.relative(p_112452_.getMovementDirection());
                    p_112454_.popPose();
                    p_112454_.pushPose();
                    blockstate = (BlockState)((Object)blockstate.setValue((Property)PistonBaseBlock.EXTENDED, Boolean.valueOf(true)));
                    this.renderBlock(blockpos1, blockstate, p_112454_, p_112455_, level, true, p_112457_);
                } else {
                    this.renderBlock(blockpos, blockstate, p_112454_, p_112455_, level, false, p_112457_);
                }
                p_112454_.popPose();
                ModelBlockRenderer.clearCache();
            }
        }
    }

    private void renderBlock(BlockPos p_112459_, BlockState p_112460_, PoseStack p_112461_, MultiBufferSource p_112462_, Level p_112463_, boolean p_112464_, int p_112465_) {
        Function<RenderType, VertexConsumer> bufferLookup = renderType -> p_112462_.getBuffer(RenderTypeHelper.getMovingBlockRenderType((RenderType)((Object)renderType)));
        List list = this.blockRenderer.getBlockModel(p_112460_).collectParts((BlockAndTintGetter)((Object)p_112463_), p_112459_, p_112460_, RandomSource.create((long)p_112460_.getSeed(p_112459_)));
        this.blockRenderer.getModelRenderer().tesselateBlock((BlockAndTintGetter)((Object)p_112463_), (List<BlockModelPart>)list, p_112460_, p_112459_, p_112461_, bufferLookup, p_112464_, p_112465_);
    }

    @Override
    public int getViewDistance() {
        return 68;
    }

    public AABB getRenderBoundingBox(PistonMovingBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

