/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SpawnerRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TrialSpawnerRenderer
implements BlockEntityRenderer<TrialSpawnerBlockEntity> {
    private final EntityRenderDispatcher entityRenderer;

    public TrialSpawnerRenderer(BlockEntityRendererProvider.Context p_312398_) {
        this.entityRenderer = p_312398_.getEntityRenderer();
    }

    @Override
    public void render(TrialSpawnerBlockEntity p_312217_, float p_312274_, PoseStack p_312684_, MultiBufferSource p_312816_, int p_312320_, int p_312349_, Vec3 p_401133_) {
        TrialSpawner trialspawner;
        TrialSpawnerData trialspawnerdata;
        Entity entity;
        Level level = p_312217_.getLevel();
        if (level != null && (entity = (trialspawnerdata = (trialspawner = p_312217_.getTrialSpawner()).getData()).getOrCreateDisplayEntity(trialspawner, level, trialspawner.getState())) != null) {
            SpawnerRenderer.renderEntityInSpawner(p_312274_, p_312684_, p_312816_, p_312320_, entity, this.entityRenderer, trialspawnerdata.getOSpin(), trialspawnerdata.getSpin());
        }
    }

    public AABB getRenderBoundingBox(TrialSpawnerBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 1.0, (double)pos.getY() - 1.0, (double)pos.getZ() - 1.0, (double)pos.getX() + 2.0, (double)pos.getY() + 2.0, (double)pos.getZ() + 2.0);
    }
}

