/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HitboxRenderState;
import net.minecraft.client.renderer.entity.state.HitboxesRenderState;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.client.renderstate.RenderStateExtensions;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityRenderer<T extends Entity, S extends EntityRenderState> {
    protected static final float NAMETAG_SCALE = 0.025f;
    public static final int LEASH_RENDER_STEPS = 24;
    protected final EntityRenderDispatcher entityRenderDispatcher;
    private final Font font;
    protected float shadowRadius;
    protected float shadowStrength = 1.0f;
    private final S reusedState = this.createRenderState();

    protected EntityRenderer(EntityRendererProvider.Context p_174008_) {
        this.entityRenderDispatcher = p_174008_.getEntityRenderDispatcher();
        this.font = p_174008_.getFont();
    }

    public final int getPackedLightCoords(T p_114506_, float p_114507_) {
        BlockPos blockpos = BlockPos.containing((Position)((Entity)p_114506_).getLightProbePosition(p_114507_));
        return LightTexture.pack(this.getBlockLightLevel(p_114506_, blockpos), this.getSkyLightLevel(p_114506_, blockpos));
    }

    protected int getSkyLightLevel(T p_114509_, BlockPos p_114510_) {
        return ((Entity)p_114509_).level().getBrightness(LightLayer.SKY, p_114510_);
    }

    protected int getBlockLightLevel(T p_114496_, BlockPos p_114497_) {
        return ((Entity)p_114496_).isOnFire() ? 15 : ((Entity)p_114496_).level().getBrightness(LightLayer.BLOCK, p_114497_);
    }

    public boolean shouldRender(T p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        Leashable leashable;
        Entity entity;
        if (!((Entity)p_114491_).shouldRender(p_114493_, p_114494_, p_114495_)) {
            return false;
        }
        if (!this.affectedByCulling(p_114491_)) {
            return true;
        }
        AABB aabb = this.getBoundingBoxForCulling(p_114491_).inflate(0.5);
        if (aabb.hasNaN() || aabb.getSize() == 0.0) {
            aabb = new AABB(((Entity)p_114491_).getX() - 2.0, ((Entity)p_114491_).getY() - 2.0, ((Entity)p_114491_).getZ() - 2.0, ((Entity)p_114491_).getX() + 2.0, ((Entity)p_114491_).getY() + 2.0, ((Entity)p_114491_).getZ() + 2.0);
        }
        if (p_114492_.isVisible(aabb)) {
            return true;
        }
        if (p_114491_ instanceof Leashable && (entity = (leashable = (Leashable)p_114491_).getLeashHolder()) != null) {
            return p_114492_.isVisible(this.entityRenderDispatcher.getRenderer(entity).getBoundingBoxForCulling(entity));
        }
        return false;
    }

    protected AABB getBoundingBoxForCulling(T p_361260_) {
        return ((Entity)p_361260_).getBoundingBox();
    }

    protected boolean affectedByCulling(T p_365169_) {
        return true;
    }

    public Vec3 getRenderOffset(S p_364311_) {
        return ((EntityRenderState)((Object)p_364311_)).passengerOffset != null ? ((EntityRenderState)((Object)p_364311_)).passengerOffset : Vec3.ZERO;
    }

    public void render(S p_364816_, PoseStack p_114488_, MultiBufferSource p_114489_, int p_114490_) {
        RenderNameTagEvent.DoRender event;
        EntityRenderState.LeashState entityrenderstate$leashstate = ((EntityRenderState)((Object)p_364816_)).leashState;
        if (entityrenderstate$leashstate != null) {
            EntityRenderer.renderLeash(p_114488_, p_114489_, entityrenderstate$leashstate);
        }
        if (((EntityRenderState)((Object)p_364816_)).nameTag != null && !((RenderNameTagEvent.DoRender)NeoForge.EVENT_BUS.post((Event)(event = new RenderNameTagEvent.DoRender(p_364816_, ((EntityRenderState)((Object)p_364816_)).nameTag, this, p_114488_, p_114489_, p_114490_, ((EntityRenderState)((Object)p_364816_)).partialTick)))).isCanceled()) {
            this.renderNameTag(p_364816_, ((EntityRenderState)((Object)p_364816_)).nameTag, p_114488_, p_114489_, p_114490_);
        }
    }

    private static void renderLeash(PoseStack p_352205_, MultiBufferSource p_352444_, EntityRenderState.LeashState p_364529_) {
        float f = 0.025f;
        float f1 = (float)(p_364529_.end.x - p_364529_.start.x);
        float f2 = (float)(p_364529_.end.y - p_364529_.start.y);
        float f3 = (float)(p_364529_.end.z - p_364529_.start.z);
        float f4 = Mth.invSqrt((float)(f1 * f1 + f3 * f3)) * 0.025f / 2.0f;
        float f5 = f3 * f4;
        float f6 = f1 * f4;
        p_352205_.pushPose();
        p_352205_.translate(p_364529_.offset);
        VertexConsumer vertexconsumer = p_352444_.getBuffer(RenderType.leash());
        Matrix4f matrix4f = p_352205_.last().pose();
        for (int i = 0; i <= 24; ++i) {
            EntityRenderer.addVertexPair(vertexconsumer, matrix4f, f1, f2, f3, p_364529_.startBlockLight, p_364529_.endBlockLight, p_364529_.startSkyLight, p_364529_.endSkyLight, 0.025f, 0.025f, f5, f6, i, false);
        }
        for (int j = 24; j >= 0; --j) {
            EntityRenderer.addVertexPair(vertexconsumer, matrix4f, f1, f2, f3, p_364529_.startBlockLight, p_364529_.endBlockLight, p_364529_.startSkyLight, p_364529_.endSkyLight, 0.025f, 0.0f, f5, f6, j, true);
        }
        p_352205_.popPose();
    }

    private static void addVertexPair(VertexConsumer p_352095_, Matrix4f p_352142_, float p_352462_, float p_352226_, float p_352086_, int p_352406_, int p_352470_, int p_352371_, int p_352167_, float p_352293_, float p_352138_, float p_352315_, float p_352162_, int p_352291_, boolean p_352079_) {
        float f = (float)p_352291_ / 24.0f;
        int i = (int)Mth.lerp((float)f, (float)p_352406_, (float)p_352470_);
        int j = (int)Mth.lerp((float)f, (float)p_352371_, (float)p_352167_);
        int k = LightTexture.pack(i, j);
        float f1 = p_352291_ % 2 == (p_352079_ ? 1 : 0) ? 0.7f : 1.0f;
        float f2 = 0.5f * f1;
        float f3 = 0.4f * f1;
        float f4 = 0.3f * f1;
        float f5 = p_352462_ * f;
        float f6 = p_352226_ > 0.0f ? p_352226_ * f * f : p_352226_ - p_352226_ * (1.0f - f) * (1.0f - f);
        float f7 = p_352086_ * f;
        p_352095_.addVertex(p_352142_, f5 - p_352315_, f6 + p_352138_, f7 + p_352162_).setColor(f2, f3, f4, 1.0f).setLight(k);
        p_352095_.addVertex(p_352142_, f5 + p_352315_, f6 + p_352293_ - p_352138_, f7 - p_352162_).setColor(f2, f3, f4, 1.0f).setLight(k);
    }

    protected boolean shouldShowName(T p_114504_, double p_361299_) {
        return ((Entity)p_114504_).shouldShowName() || ((Entity)p_114504_).hasCustomName() && p_114504_ == this.entityRenderDispatcher.crosshairPickEntity;
    }

    public Font getFont() {
        return this.font;
    }

    protected void renderNameTag(S p_360768_, Component p_114499_, PoseStack p_114500_, MultiBufferSource p_114501_, int p_114502_) {
        Vec3 vec3 = ((EntityRenderState)((Object)p_360768_)).nameTagAttachment;
        if (vec3 != null) {
            boolean flag = !((EntityRenderState)((Object)p_360768_)).isDiscrete;
            int i = "deadmau5".equals(p_114499_.getString()) ? -10 : 0;
            p_114500_.pushPose();
            p_114500_.translate(vec3.x, vec3.y + 0.5, vec3.z);
            p_114500_.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
            p_114500_.scale(0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = p_114500_.last().pose();
            Font font = this.getFont();
            float f = (float)(-font.width((FormattedText)p_114499_)) / 2.0f;
            int j = (int)(Minecraft.getInstance().options.getBackgroundOpacity(0.25f) * 255.0f) << 24;
            font.drawInBatch(p_114499_, f, (float)i, -2130706433, false, matrix4f, p_114501_, flag ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, p_114502_);
            if (flag) {
                font.drawInBatch(p_114499_, f, (float)i, -1, false, matrix4f, p_114501_, Font.DisplayMode.NORMAL, 0, LightTexture.lightCoordsWithEmission(p_114502_, 2));
            }
            p_114500_.popPose();
        }
    }

    @Nullable
    protected Component getNameTag(T p_364352_) {
        return ((Entity)p_364352_).getDisplayName();
    }

    protected float getShadowRadius(S p_365191_) {
        return this.shadowRadius;
    }

    protected float getShadowStrength(S p_383214_) {
        return this.shadowStrength;
    }

    public abstract S createRenderState();

    public final S createRenderState(T p_361382_, float p_360885_) {
        S s = this.reusedState;
        this.extractRenderState(p_361382_, s, p_360885_);
        RenderStateExtensions.onUpdateEntityRenderState((EntityRenderer)this, p_361382_, s);
        return s;
    }

    public void extractRenderState(T p_362104_, S p_361028_, float p_362204_) {
        Entity entity;
        boolean flag;
        NewMinecartBehavior newminecartbehavior;
        AbstractMinecart abstractminecart;
        Entity entity2;
        ((EntityRenderState)((Object)p_361028_)).entityType = ((Entity)p_362104_).getType();
        ((EntityRenderState)((Object)p_361028_)).x = Mth.lerp((double)p_362204_, (double)((Entity)p_362104_).xOld, (double)((Entity)p_362104_).getX());
        ((EntityRenderState)((Object)p_361028_)).y = Mth.lerp((double)p_362204_, (double)((Entity)p_362104_).yOld, (double)((Entity)p_362104_).getY());
        ((EntityRenderState)((Object)p_361028_)).z = Mth.lerp((double)p_362204_, (double)((Entity)p_362104_).zOld, (double)((Entity)p_362104_).getZ());
        ((EntityRenderState)((Object)p_361028_)).isInvisible = ((Entity)p_362104_).isInvisible();
        ((EntityRenderState)((Object)p_361028_)).ageInTicks = (float)((Entity)p_362104_).tickCount + p_362204_;
        ((EntityRenderState)((Object)p_361028_)).boundingBoxWidth = ((Entity)p_362104_).getBbWidth();
        ((EntityRenderState)((Object)p_361028_)).boundingBoxHeight = ((Entity)p_362104_).getBbHeight();
        ((EntityRenderState)((Object)p_361028_)).eyeHeight = ((Entity)p_362104_).getEyeHeight();
        if (((Entity)p_362104_).isPassenger() && (entity2 = ((Entity)p_362104_).getVehicle()) instanceof AbstractMinecart && (entity2 = (abstractminecart = (AbstractMinecart)((Object)entity2)).getBehavior()) instanceof NewMinecartBehavior && (newminecartbehavior = (NewMinecartBehavior)((Object)entity2)).cartHasPosRotLerp()) {
            double d2 = Mth.lerp((double)p_362204_, (double)abstractminecart.xOld, (double)abstractminecart.getX());
            double d0 = Mth.lerp((double)p_362204_, (double)abstractminecart.yOld, (double)abstractminecart.getY());
            double d1 = Mth.lerp((double)p_362204_, (double)abstractminecart.zOld, (double)abstractminecart.getZ());
            ((EntityRenderState)((Object)p_361028_)).passengerOffset = newminecartbehavior.getCartLerpPosition(p_362204_).subtract(new Vec3(d2, d0, d1));
        } else {
            ((EntityRenderState)((Object)p_361028_)).passengerOffset = null;
        }
        ((EntityRenderState)((Object)p_361028_)).distanceToCameraSq = this.entityRenderDispatcher.distanceToSqr((Entity)p_362104_);
        RenderNameTagEvent.CanRender event = new RenderNameTagEvent.CanRender(p_362104_, p_361028_, this.getNameTag(p_362104_), this, p_362204_);
        NeoForge.EVENT_BUS.post((Event)event);
        boolean bl = flag = event.canRender().isTrue() || event.canRender().isDefault() && ((EntityRenderState)((Object)p_361028_)).distanceToCameraSq < 4096.0 && this.shouldShowName(p_362104_, ((EntityRenderState)((Object)p_361028_)).distanceToCameraSq);
        if (flag) {
            ((EntityRenderState)((Object)p_361028_)).nameTag = event.getContent();
            ((EntityRenderState)((Object)p_361028_)).nameTagAttachment = ((Entity)p_362104_).getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, ((Entity)p_362104_).getYRot(p_362204_));
        } else {
            ((EntityRenderState)((Object)p_361028_)).nameTag = null;
        }
        ((EntityRenderState)((Object)p_361028_)).isDiscrete = ((Entity)p_362104_).isDiscrete();
        if (p_362104_ instanceof Leashable) {
            Leashable leashable = (Leashable)p_362104_;
            v1 = leashable.getLeashHolder();
        } else {
            v1 = entity = null;
        }
        if (entity != null) {
            float f = ((Entity)p_362104_).getPreciseBodyRotation(p_362204_) * ((float)Math.PI / 180);
            Vec3 vec3 = ((Entity)p_362104_).getLeashOffset(p_362204_).yRot(-f);
            BlockPos blockpos1 = BlockPos.containing((Position)((Entity)p_362104_).getEyePosition(p_362204_));
            BlockPos blockpos = BlockPos.containing((Position)entity.getEyePosition(p_362204_));
            if (((EntityRenderState)((Object)p_361028_)).leashState == null) {
                ((EntityRenderState)((Object)p_361028_)).leashState = new EntityRenderState.LeashState();
            }
            EntityRenderState.LeashState entityrenderstate$leashstate = ((EntityRenderState)((Object)p_361028_)).leashState;
            entityrenderstate$leashstate.offset = vec3;
            entityrenderstate$leashstate.start = ((Entity)p_362104_).getPosition(p_362204_).add(vec3);
            entityrenderstate$leashstate.end = entity.getRopeHoldPosition(p_362204_);
            entityrenderstate$leashstate.startBlockLight = this.getBlockLightLevel(p_362104_, blockpos1);
            entityrenderstate$leashstate.endBlockLight = this.entityRenderDispatcher.getRenderer(entity).getBlockLightLevel(entity, blockpos);
            entityrenderstate$leashstate.startSkyLight = ((Entity)p_362104_).level().getBrightness(LightLayer.SKY, blockpos1);
            entityrenderstate$leashstate.endSkyLight = ((Entity)p_362104_).level().getBrightness(LightLayer.SKY, blockpos);
        } else {
            ((EntityRenderState)((Object)p_361028_)).leashState = null;
        }
        ((EntityRenderState)((Object)p_361028_)).displayFireAnimation = ((Entity)p_362104_).displayFireAnimation();
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.getEntityRenderDispatcher().shouldRenderHitBoxes() && !((EntityRenderState)((Object)p_361028_)).isInvisible && !minecraft.showOnlyReducedInfo()) {
            this.extractHitboxes(p_362104_, p_361028_, p_362204_);
        } else {
            ((EntityRenderState)((Object)p_361028_)).hitboxesRenderState = null;
            ((EntityRenderState)((Object)p_361028_)).serverHitboxesRenderState = null;
        }
        ((EntityRenderState)((Object)p_361028_)).partialTick = p_362204_;
    }

    private void extractHitboxes(T p_412316_, S p_412142_, float p_412603_) {
        ((EntityRenderState)((Object)p_412142_)).hitboxesRenderState = this.extractHitboxes(p_412316_, p_412603_, false);
        ((EntityRenderState)((Object)p_412142_)).serverHitboxesRenderState = null;
    }

    private HitboxesRenderState extractHitboxes(T p_412086_, float p_412327_, boolean p_412207_) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        AABB aabb = ((Entity)p_412086_).getBoundingBox();
        HitboxRenderState hitboxrenderstate = p_412207_ ? new HitboxRenderState(aabb.minX - ((Entity)p_412086_).getX(), aabb.minY - ((Entity)p_412086_).getY(), aabb.minZ - ((Entity)p_412086_).getZ(), aabb.maxX - ((Entity)p_412086_).getX(), aabb.maxY - ((Entity)p_412086_).getY(), aabb.maxZ - ((Entity)p_412086_).getZ(), 0.0f, 1.0f, 0.0f) : new HitboxRenderState(aabb.minX - ((Entity)p_412086_).getX(), aabb.minY - ((Entity)p_412086_).getY(), aabb.minZ - ((Entity)p_412086_).getZ(), aabb.maxX - ((Entity)p_412086_).getX(), aabb.maxY - ((Entity)p_412086_).getY(), aabb.maxZ - ((Entity)p_412086_).getZ(), 1.0f, 1.0f, 1.0f);
        builder.add((Object)hitboxrenderstate);
        Entity entity = ((Entity)p_412086_).getVehicle();
        if (entity != null) {
            float f = Math.min(entity.getBbWidth(), ((Entity)p_412086_).getBbWidth()) / 2.0f;
            float f1 = 0.0625f;
            Vec3 vec3 = entity.getPassengerRidingPosition((Entity)p_412086_).subtract(((Entity)p_412086_).position());
            HitboxRenderState hitboxrenderstate1 = new HitboxRenderState(vec3.x - (double)f, vec3.y, vec3.z - (double)f, vec3.x + (double)f, vec3.y + 0.0625, vec3.z + (double)f, 1.0f, 1.0f, 0.0f);
            builder.add((Object)hitboxrenderstate1);
        }
        this.extractAdditionalHitboxes(p_412086_, (ImmutableList.Builder<HitboxRenderState>)builder, p_412327_);
        Vec3 vec31 = ((Entity)p_412086_).getViewVector(p_412327_);
        return new HitboxesRenderState(vec31.x, vec31.y, vec31.z, builder.build());
    }

    protected void extractAdditionalHitboxes(T p_412199_, ImmutableList.Builder<HitboxRenderState> p_412387_, float p_412468_) {
    }

    @Nullable
    private static Entity getServerSideEntity(Entity p_412597_) {
        ServerLevel serverlevel;
        IntegratedServer integratedserver = Minecraft.getInstance().getSingleplayerServer();
        if (integratedserver != null && (serverlevel = integratedserver.getLevel(p_412597_.level().dimension())) != null) {
            return serverlevel.getEntity(p_412597_.getId());
        }
        return null;
    }
}

