/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.FallingBlockRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.RenderTypeHelper;

@OnlyIn(value=Dist.CLIENT)
public class FallingBlockRenderer
extends EntityRenderer<FallingBlockEntity, FallingBlockRenderState> {
    private final BlockRenderDispatcher dispatcher;

    public FallingBlockRenderer(EntityRendererProvider.Context p_174112_) {
        super(p_174112_);
        this.shadowRadius = 0.5f;
        this.dispatcher = p_174112_.getBlockRenderDispatcher();
    }

    @Override
    public boolean shouldRender(FallingBlockEntity p_362415_, Frustum p_364047_, double p_362218_, double p_363427_, double p_361722_) {
        return !super.shouldRender(p_362415_, p_364047_, p_362218_, p_363427_, p_361722_) ? false : p_362415_.getBlockState() != p_362415_.level().getBlockState(p_362415_.blockPosition());
    }

    @Override
    public void render(FallingBlockRenderState p_361300_, PoseStack p_114637_, MultiBufferSource p_114638_, int p_114639_) {
        BlockState blockstate = p_361300_.blockState;
        if (blockstate.getRenderShape() == RenderShape.MODEL) {
            p_114637_.pushPose();
            p_114637_.translate(-0.5, 0.0, -0.5);
            List list = this.dispatcher.getBlockModel(blockstate).collectParts(p_361300_.level, p_361300_.blockPos, blockstate, RandomSource.create((long)blockstate.getSeed(p_361300_.startBlockPos)));
            this.dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)p_361300_, (List<BlockModelPart>)list, blockstate, p_361300_.blockPos, p_114637_, renderType -> p_114638_.getBuffer(RenderTypeHelper.getMovingBlockRenderType((RenderType)((Object)renderType))), false, OverlayTexture.NO_OVERLAY);
            p_114637_.popPose();
            super.render(p_361300_, p_114637_, p_114638_, p_114639_);
        }
    }

    @Override
    public FallingBlockRenderState createRenderState() {
        return new FallingBlockRenderState();
    }

    @Override
    public void extractRenderState(FallingBlockEntity p_364559_, FallingBlockRenderState p_360509_, float p_361019_) {
        super.extractRenderState(p_364559_, p_360509_, p_361019_);
        BlockPos blockpos = BlockPos.containing((double)p_364559_.getX(), (double)p_364559_.getBoundingBox().maxY, (double)p_364559_.getZ());
        p_360509_.startBlockPos = p_364559_.getStartPos();
        p_360509_.blockPos = blockpos;
        p_360509_.blockState = p_364559_.getBlockState();
        p_360509_.biome = p_364559_.level().getBiome(blockpos);
        p_360509_.level = p_364559_.level();
    }
}

