/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

@OnlyIn(value=Dist.CLIENT)
public class EquipmentLayerRenderer {
    private static final int NO_LAYER_COLOR = 0;
    private final EquipmentAssetManager equipmentAssets;
    private final Function<LayerTextureKey, ResourceLocation> layerTextureLookup;
    private final Function<TrimSpriteKey, TextureAtlasSprite> trimSpriteLookup;

    public EquipmentLayerRenderer(EquipmentAssetManager p_388621_, TextureAtlas p_371221_) {
        this.equipmentAssets = p_388621_;
        this.layerTextureLookup = Util.memoize(p_386235_ -> p_386235_.layer.getTextureLocation(p_386235_.layerType));
        this.trimSpriteLookup = Util.memoize(p_399319_ -> p_371221_.getSprite(p_399319_.spriteId()));
    }

    public void renderLayers(EquipmentClientInfo.LayerType p_388694_, ResourceKey<EquipmentAsset> p_386937_, Model p_371498_, ItemStack p_371902_, PoseStack p_371937_, MultiBufferSource p_371457_, int p_371495_) {
        this.renderLayers(p_388694_, p_386937_, p_371498_, p_371902_, p_371937_, p_371457_, p_371495_, null);
    }

    public void renderLayers(EquipmentClientInfo.LayerType p_387484_, ResourceKey<EquipmentAsset> p_387603_, Model p_371731_, ItemStack p_371670_, PoseStack p_371767_, MultiBufferSource p_371286_, int p_371309_, @Nullable ResourceLocation p_371639_) {
        IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)p_371670_);
        p_371731_ = extensions.getGenericArmorModel(p_371670_, p_387484_, p_371731_);
        List list = this.equipmentAssets.get(p_387603_).getLayers(p_387484_);
        if (!list.isEmpty()) {
            int i = extensions.getDefaultDyeColor(p_371670_);
            boolean flag = p_371670_.hasFoil();
            int idx = 0;
            for (EquipmentClientInfo.Layer equipmentclientinfo$layer : list) {
                int j = extensions.getArmorLayerTintColor(p_371670_, equipmentclientinfo$layer, idx, i);
                if (j != 0) {
                    ResourceLocation resourcelocation = equipmentclientinfo$layer.usePlayerTexture() && p_371639_ != null ? p_371639_ : this.layerTextureLookup.apply(new LayerTextureKey(p_387484_, equipmentclientinfo$layer));
                    resourcelocation = ClientHooks.getArmorTexture((ItemStack)p_371670_, (EquipmentClientInfo.LayerType)p_387484_, (EquipmentClientInfo.Layer)equipmentclientinfo$layer, (ResourceLocation)resourcelocation);
                    VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer(p_371286_, RenderType.armorCutoutNoCull(resourcelocation), flag);
                    p_371731_.renderToBuffer(p_371767_, vertexconsumer, p_371309_, OverlayTexture.NO_OVERLAY, j);
                    flag = false;
                }
                ++idx;
            }
            ArmorTrim armortrim = (ArmorTrim)p_371670_.get(DataComponents.TRIM);
            if (armortrim != null) {
                TextureAtlasSprite textureatlassprite = this.trimSpriteLookup.apply(new TrimSpriteKey(armortrim, p_387484_, p_387603_));
                VertexConsumer vertexconsumer1 = textureatlassprite.wrap(p_371286_.getBuffer(Sheets.armorTrimsSheet(((TrimPattern)armortrim.pattern().value()).decal())));
                p_371731_.renderToBuffer(p_371767_, vertexconsumer1, p_371309_, OverlayTexture.NO_OVERLAY);
            }
        }
    }

    public static int getColorForLayer(EquipmentClientInfo.Layer p_386482_, int p_371443_) {
        Optional optional = p_386482_.dyeable();
        if (optional.isPresent()) {
            int i = ((EquipmentClientInfo.Dyeable)optional.get()).colorWhenUndyed().map(ARGB::opaque).orElse(0);
            return p_371443_ != 0 ? p_371443_ : i;
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    record LayerTextureKey(EquipmentClientInfo.LayerType layerType, EquipmentClientInfo.Layer layer) {
    }

    @OnlyIn(value=Dist.CLIENT)
    record TrimSpriteKey(ArmorTrim trim, EquipmentClientInfo.LayerType layerType, ResourceKey<EquipmentAsset> equipmentAssetId) {
        public ResourceLocation spriteId() {
            return this.trim.layerAssetId(this.layerType.trimAssetPrefix(), this.equipmentAssetId);
        }
    }
}

