/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.color.item.ItemTintSources;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.NeoForgeModelProperties;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class BlockModelWrapper
implements ItemModel {
    private final List<ItemTintSource> tints;
    private final List<BakedQuad> quads;
    private final Supplier<Vector3f[]> extents;
    private final ModelRenderProperties properties;
    @Nullable
    private final RenderType renderType;

    public BlockModelWrapper(List<ItemTintSource> p_388185_, List<BakedQuad> p_405671_, ModelRenderProperties p_404871_) {
        this(p_388185_, p_405671_, p_404871_, null);
    }

    public BlockModelWrapper(List<ItemTintSource> p_388185_, List<BakedQuad> p_405671_, ModelRenderProperties p_404871_, @Nullable RenderType renderType) {
        this.tints = p_388185_;
        this.quads = p_405671_;
        this.properties = p_404871_;
        this.extents = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(this.quads));
        this.renderType = renderType;
    }

    public static Vector3f[] computeExtents(List<BakedQuad> p_404655_) {
        HashSet set = new HashSet();
        for (BakedQuad bakedquad : p_404655_) {
            FaceBakery.extractPositions(bakedquad.vertices(), set::add);
        }
        return (Vector3f[])set.toArray(Vector3f[]::new);
    }

    public void update(ItemStackRenderState p_386488_, ItemStack p_386443_, ItemModelResolver p_388726_, ItemDisplayContext p_388231_, @Nullable ClientLevel p_387522_, @Nullable LivingEntity p_387263_, int p_388300_) {
        ItemStackRenderState.LayerRenderState itemstackrenderstate$layerrenderstate = p_386488_.newLayer();
        if (p_386443_.hasFoil()) {
            itemstackrenderstate$layerrenderstate.setFoilType(BlockModelWrapper.hasSpecialAnimatedTexture(p_386443_) ? ItemStackRenderState.FoilType.SPECIAL : ItemStackRenderState.FoilType.STANDARD);
        }
        int i = this.tints.size();
        int[] aint = itemstackrenderstate$layerrenderstate.prepareTintLayers(i);
        for (int j = 0; j < i; ++j) {
            aint[j] = this.tints.get(j).calculate(p_386443_, p_387522_, p_387263_);
        }
        itemstackrenderstate$layerrenderstate.setExtents(this.extents);
        itemstackrenderstate$layerrenderstate.setRenderType(this.renderType != null ? this.renderType : ItemBlockRenderTypes.getRenderType(p_386443_));
        this.properties.applyToLayer(itemstackrenderstate$layerrenderstate, p_388231_);
        itemstackrenderstate$layerrenderstate.prepareQuadList().addAll(this.quads);
    }

    private static boolean hasSpecialAnimatedTexture(ItemStack p_387217_) {
        return p_387217_.is(ItemTags.COMPASSES) || p_387217_.is(Items.CLOCK);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(ResourceLocation model, List<ItemTintSource> tints) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(p_387684_ -> p_387684_.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(Unbaked::model), (App)ItemTintSources.CODEC.listOf().optionalFieldOf("tints", List.of()).forGetter(Unbaked::tints)).apply((Applicative)p_387684_, Unbaked::new));

        public void resolveDependencies(ResolvableModel.Resolver p_387532_) {
            p_387532_.markDependency(this.model);
        }

        public ItemModel bake(ItemModel.BakingContext p_388226_) {
            ModelBaker modelbaker = p_388226_.blockModelBaker();
            ResolvedModel resolvedmodel = modelbaker.getModel(this.model);
            TextureSlots textureslots = resolvedmodel.getTopTextureSlots();
            List<BakedQuad> list = resolvedmodel.bakeTopGeometry(textureslots, modelbaker, (ModelState)BlockModelRotation.X0_Y0).getAll();
            ModelRenderProperties modelrenderproperties = ModelRenderProperties.fromResolvedModel((ModelBaker)modelbaker, (ResolvedModel)resolvedmodel, (TextureSlots)textureslots);
            RenderTypeGroup renderTypeGroup = (RenderTypeGroup)resolvedmodel.getTopAdditionalProperties().getOptional(NeoForgeModelProperties.RENDER_TYPE);
            RenderType renderType = renderTypeGroup == null ? null : renderTypeGroup.entity();
            return new BlockModelWrapper(this.tints, list, modelrenderproperties, renderType);
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

