/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.BundleSelectedItemSpecialRenderer;
import net.minecraft.client.renderer.item.CompositeModel;
import net.minecraft.client.renderer.item.ConditionalItemModel;
import net.minecraft.client.renderer.item.EmptyModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.RangeSelectItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.SpecialModelWrapper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.event.RegisterItemModelsEvent;

@OnlyIn(value=Dist.CLIENT)
public class ItemModels {
    private static final ExtraCodecs.LateBoundIdMapper<ResourceLocation, MapCodec<? extends ItemModel.Unbaked>> ID_MAPPER = new ExtraCodecs.LateBoundIdMapper();
    public static final Codec<ItemModel.Unbaked> CODEC = ID_MAPPER.codec(ResourceLocation.CODEC).dispatch(ItemModel.Unbaked::type, p_387434_ -> p_387434_);

    public static void bootstrap() {
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace("empty"), (Object)EmptyModel.Unbaked.MAP_CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace("model"), BlockModelWrapper.Unbaked.MAP_CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace("range_dispatch"), (Object)RangeSelectItemModel.Unbaked.MAP_CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace("special"), (Object)SpecialModelWrapper.Unbaked.MAP_CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace("composite"), (Object)CompositeModel.Unbaked.MAP_CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace("bundle/selected_item"), (Object)BundleSelectedItemSpecialRenderer.Unbaked.MAP_CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace("select"), (Object)SelectItemModel.Unbaked.MAP_CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace("condition"), (Object)ConditionalItemModel.Unbaked.MAP_CODEC);
        ModLoader.postEvent((Event)new RegisterItemModelsEvent(ID_MAPPER));
    }
}

