/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import javax.annotation.Nullable;
import net.minecraft.util.TriState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractTexture
implements AutoCloseable {
    @Nullable
    protected GpuTexture texture;
    protected boolean defaultBlur;
    protected boolean blur;
    protected boolean mipmap;
    private boolean lastBlur;
    private boolean lastMipmap;

    public void setClamp(boolean p_390364_) {
        if (this.texture == null) {
            throw new IllegalStateException("Texture does not exist, can't change its clamp before something initializes it");
        }
        this.texture.setAddressMode(p_390364_ ? AddressMode.CLAMP_TO_EDGE : AddressMode.REPEAT);
    }

    public void setFilter(TriState p_390393_, boolean p_390413_) {
        this.setFilter(p_390393_.toBoolean(this.defaultBlur), p_390413_);
    }

    public void setFilter(boolean p_117961_, boolean p_117962_) {
        if (this.texture == null) {
            throw new IllegalStateException("Texture does not exist, can't get change its filter before something initializes it");
        }
        this.blur = p_117961_;
        this.mipmap = p_117962_;
        this.texture.setTextureFilter(p_117961_ ? FilterMode.LINEAR : FilterMode.NEAREST, p_117962_);
    }

    @Override
    public void close() {
        if (this.texture != null) {
            this.texture.close();
            this.texture = null;
        }
    }

    public GpuTexture getTexture() {
        if (this.texture == null) {
            throw new IllegalStateException("Texture does not exist, can't get it before something initializes it");
        }
        return this.texture;
    }

    public void setBlurMipmap(boolean blur, boolean mipmap) {
        this.lastBlur = this.blur;
        this.lastMipmap = this.mipmap;
        this.setFilter(blur, mipmap);
    }

    public void restoreLastBlurMipmap() {
        this.setFilter(this.lastBlur, this.lastMipmap);
    }
}

