/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.DirectoryLister;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.client.renderer.texture.atlas.sources.SourceFilter;
import net.minecraft.client.renderer.texture.atlas.sources.Unstitcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.event.RegisterSpriteSourcesEvent;

@OnlyIn(value=Dist.CLIENT)
public class SpriteSources {
    private static final ExtraCodecs.LateBoundIdMapper<ResourceLocation, MapCodec<? extends SpriteSource>> ID_MAPPER = new ExtraCodecs.LateBoundIdMapper();
    public static final Codec<SpriteSource> CODEC = ID_MAPPER.codec(ResourceLocation.CODEC).dispatch(SpriteSource::codec, p_399350_ -> p_399350_);
    public static final Codec<List<SpriteSource>> FILE_CODEC = CODEC.listOf().fieldOf("sources").codec();

    public static void bootstrap() {
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace("single"), (Object)SingleFile.MAP_CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace("directory"), (Object)DirectoryLister.MAP_CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace("filter"), (Object)SourceFilter.MAP_CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace("unstitch"), (Object)Unstitcher.MAP_CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace("paletted_permutations"), (Object)PalettedPermutations.MAP_CODEC);
        ModLoader.postEvent((Event)new RegisterSpriteSourcesEvent(ID_MAPPER));
    }
}

