/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.MissingItemModel;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.ParallelMapTransform;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelLoader;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelBakery {
    public static final Material FIRE_0 = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/fire_0"));
    public static final Material FIRE_1 = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/fire_1"));
    public static final Material LAVA_FLOW = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/lava_flow"));
    public static final Material WATER_FLOW = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/water_flow"));
    public static final Material WATER_OVERLAY = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/water_overlay"));
    public static final Material BANNER_BASE = new Material(Sheets.BANNER_SHEET, ResourceLocation.withDefaultNamespace("entity/banner_base"));
    public static final Material SHIELD_BASE = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace("entity/shield_base"));
    public static final Material NO_PATTERN_SHIELD = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace("entity/shield_base_nopattern"));
    public static final int DESTROY_STAGE_COUNT = 10;
    public static final List<ResourceLocation> DESTROY_STAGES = IntStream.range(0, 10).mapToObj(p_349912_ -> ResourceLocation.withDefaultNamespace("block/destroy_stage_" + p_349912_)).collect(Collectors.toList());
    public static final List<ResourceLocation> BREAKING_LOCATIONS = DESTROY_STAGES.stream().map(p_349910_ -> p_349910_.withPath(p_349911_ -> "textures/" + p_349911_ + ".png")).collect(Collectors.toList());
    public static final List<RenderType> DESTROY_TYPES = BREAKING_LOCATIONS.stream().map(RenderType::crumbling).collect(Collectors.toList());
    static final Logger LOGGER = LogUtils.getLogger();
    private final EntityModelSet entityModelSet;
    private final Map<BlockState, BlockStateModel.UnbakedRoot> unbakedBlockStateModels;
    private final Map<ResourceLocation, ClientItem> clientInfos;
    final Map<ResourceLocation, ResolvedModel> resolvedModels;
    final ResolvedModel missingModel;
    private final StandaloneModelLoader.LoadedModels standaloneModels;

    @Deprecated
    public ModelBakery(EntityModelSet p_388903_, Map<BlockState, BlockStateModel.UnbakedRoot> p_251087_, Map<ResourceLocation, ClientItem> p_250416_, Map<ResourceLocation, ResolvedModel> p_388404_, ResolvedModel p_404940_) {
        this(p_388903_, p_251087_, p_250416_, p_388404_, p_404940_, StandaloneModelLoader.LoadedModels.EMPTY);
    }

    public ModelBakery(EntityModelSet p_388903_, Map<BlockState, BlockStateModel.UnbakedRoot> p_251087_, Map<ResourceLocation, ClientItem> p_250416_, Map<ResourceLocation, ResolvedModel> p_388404_, ResolvedModel p_404940_, StandaloneModelLoader.LoadedModels standaloneModels) {
        this.entityModelSet = p_388903_;
        this.unbakedBlockStateModels = p_251087_;
        this.clientInfos = p_250416_;
        this.resolvedModels = p_388404_;
        this.missingModel = p_404940_;
        this.standaloneModels = standaloneModels;
    }

    public CompletableFuture<BakingResult> bakeModels(SpriteGetter p_404922_, Executor p_405407_) {
        MissingModels modelbakery$missingmodels = MissingModels.bake(this.missingModel, p_404922_);
        ModelBakerImpl modelbakery$modelbakerimpl = new ModelBakerImpl(p_404922_);
        CompletionStage completablefuture = ParallelMapTransform.schedule(this.unbakedBlockStateModels, (p_409109_, p_409110_) -> {
            try {
                return p_409110_.bake((BlockState)((Object)p_409109_), modelbakery$modelbakerimpl);
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to bake model: '{}': {}", (Object)p_409109_, (Object)exception);
                return null;
            }
        }, (Executor)p_405407_);
        CompletableFuture completablefuture1 = ParallelMapTransform.schedule(this.clientInfos, (p_404123_, p_404124_) -> {
            try {
                return p_404124_.model().bake(new ItemModel.BakingContext((ModelBaker)modelbakery$modelbakerimpl, this.entityModelSet, modelbakery$missingmodels.item, p_404124_.registrySwapper()));
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to bake item model: '{}'", p_404123_, (Object)exception);
                return null;
            }
        }, (Executor)p_405407_);
        CompletableFuture standaloneModelsFuture = StandaloneModelLoader.bake((StandaloneModelLoader.LoadedModels)this.standaloneModels, (ModelBaker)modelbakery$modelbakerimpl, (Executor)p_405407_);
        HashMap map = new HashMap(this.clientInfos.size());
        this.clientInfos.forEach((p_404116_, p_404117_) -> {
            ClientItem.Properties clientitem$properties = p_404117_.properties();
            if (!clientitem$properties.equals((Object)ClientItem.Properties.DEFAULT)) {
                map.put(p_404116_, clientitem$properties);
            }
        });
        completablefuture = ((CompletableFuture)completablefuture).thenCombine((CompletionStage)standaloneModelsFuture, (stateModels, standaloneModels) -> stateModels);
        return ((CompletableFuture)completablefuture).thenCombine((CompletionStage)completablefuture1, (p_404127_, p_404128_) -> new BakingResult(modelbakery$missingmodels, (Map<BlockState, BlockStateModel>)p_404127_, (Map<ResourceLocation, ItemModel>)p_404128_, map, (StandaloneModelLoader.BakedModels)standaloneModelsFuture.join()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public record MissingModels(BlockStateModel block, ItemModel item) {
        public static MissingModels bake(ResolvedModel p_405089_, final SpriteGetter p_405847_) {
            ModelBaker modelbaker = new ModelBaker(){

                @Override
                public ResolvedModel getModel(ResourceLocation p_405277_) {
                    throw new IllegalStateException("Missing model can't have dependencies, but asked for " + String.valueOf(p_405277_));
                }

                @Override
                public <T> T compute(ModelBaker.SharedOperationKey<T> p_410289_) {
                    return p_410289_.compute(this);
                }

                @Override
                public SpriteGetter sprites() {
                    return p_405847_;
                }
            };
            TextureSlots textureslots = p_405089_.getTopTextureSlots();
            boolean flag = p_405089_.getTopAmbientOcclusion();
            boolean flag1 = p_405089_.getTopGuiLight().lightLikeBlock();
            ItemTransforms itemtransforms = p_405089_.getTopTransforms();
            QuadCollection quadcollection = p_405089_.bakeTopGeometry(textureslots, modelbaker, (ModelState)BlockModelRotation.X0_Y0);
            TextureAtlasSprite textureatlassprite = p_405089_.resolveParticleSprite(textureslots, modelbaker);
            SingleVariant blockstatemodel = new SingleVariant(new SimpleModelWrapper(quadcollection, flag, textureatlassprite));
            MissingItemModel itemmodel = new MissingItemModel(quadcollection.getAll(), new ModelRenderProperties(flag1, textureatlassprite, itemtransforms));
            return new MissingModels(blockstatemodel, (ItemModel)itemmodel);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class ModelBakerImpl
    implements ModelBaker {
        private final SpriteGetter sprites;
        private final Map<ModelBaker.SharedOperationKey<Object>, Object> operationCache = new ConcurrentHashMap<ModelBaker.SharedOperationKey<Object>, Object>();
        private final Function<ModelBaker.SharedOperationKey<Object>, Object> cacheComputeFunction = p_410129_ -> p_410129_.compute(this);

        ModelBakerImpl(SpriteGetter p_405481_) {
            this.sprites = p_405481_;
        }

        @Override
        public SpriteGetter sprites() {
            return this.sprites;
        }

        @Override
        public ResolvedModel getModel(ResourceLocation p_248568_) {
            ResolvedModel resolvedmodel = ModelBakery.this.resolvedModels.get(p_248568_);
            if (resolvedmodel == null) {
                LOGGER.warn("Requested a model that was not discovered previously: {}", (Object)p_248568_);
                return ModelBakery.this.missingModel;
            }
            return resolvedmodel;
        }

        @Override
        public <T> T compute(ModelBaker.SharedOperationKey<T> p_409780_) {
            return (T)this.operationCache.computeIfAbsent(p_409780_, this.cacheComputeFunction);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record BakingResult(MissingModels missingModels, Map<BlockState, BlockStateModel> blockStateModels, Map<ResourceLocation, ItemModel> itemStackModels, Map<ResourceLocation, ClientItem.Properties> itemProperties, StandaloneModelLoader.BakedModels standaloneModels) {
        @Deprecated
        public BakingResult(MissingModels missingModels, Map<BlockState, BlockStateModel> blockStateModels, Map<ResourceLocation, ItemModel> itemStackModels, Map<ResourceLocation, ClientItem.Properties> itemProperties) {
            this(missingModels, blockStateModels, itemStackModels, itemProperties, StandaloneModelLoader.BakedModels.EMPTY);
        }
    }
}

