/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextMap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.ResolvedModelExtension;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelDiscovery {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Object2ObjectMap<ResourceLocation, ModelWrapper> modelWrappers = new Object2ObjectOpenHashMap();
    private final ModelWrapper missingModel;
    private final Object2ObjectFunction<ResourceLocation, ModelWrapper> uncachedResolver;
    private final ResolvableModel.Resolver resolver;
    private final Queue<ModelWrapper> parentDiscoveryQueue = new ArrayDeque<ModelWrapper>();

    public ModelDiscovery(Map<ResourceLocation, UnbakedModel> p_360750_, UnbakedModel p_365355_) {
        this.missingModel = new ModelWrapper(MissingBlockModel.LOCATION, p_365355_, true);
        this.modelWrappers.put((Object)MissingBlockModel.LOCATION, (Object)this.missingModel);
        this.uncachedResolver = p_404130_ -> {
            ResourceLocation resourcelocation = (ResourceLocation)p_404130_;
            UnbakedModel unbakedmodel = (UnbakedModel)p_360750_.get(resourcelocation);
            if (unbakedmodel == null) {
                LOGGER.warn("Missing block model: {}", (Object)resourcelocation);
                return this.missingModel;
            }
            return this.createAndQueueWrapper(resourcelocation, unbakedmodel);
        };
        this.resolver = this::getOrCreateModel;
    }

    private static boolean isRoot(UnbakedModel p_405616_) {
        return p_405616_.parent() == null;
    }

    private ModelWrapper getOrCreateModel(ResourceLocation p_405299_) {
        ModelWrapper wrapper = (ModelWrapper)this.modelWrappers.get((Object)p_405299_);
        if (wrapper == null) {
            wrapper = (ModelWrapper)this.uncachedResolver.get((Object)p_405299_);
            this.modelWrappers.put((Object)p_405299_, (Object)wrapper);
        }
        return wrapper;
    }

    private ModelWrapper createAndQueueWrapper(ResourceLocation p_405734_, UnbakedModel p_404997_) {
        boolean flag = ModelDiscovery.isRoot(p_404997_);
        ModelWrapper modeldiscovery$modelwrapper = new ModelWrapper(p_405734_, p_404997_, flag);
        if (!flag) {
            this.parentDiscoveryQueue.add(modeldiscovery$modelwrapper);
        }
        p_404997_.resolveDependencies(this.resolver);
        return modeldiscovery$modelwrapper;
    }

    public void addRoot(ResolvableModel p_388596_) {
        p_388596_.resolveDependencies(this.resolver);
    }

    public void addSpecialModel(ResourceLocation p_405447_, UnbakedModel p_405251_) {
        if (!ModelDiscovery.isRoot(p_405251_)) {
            LOGGER.warn("Trying to add non-root special model {}, ignoring", (Object)p_405447_);
        } else {
            ModelWrapper modeldiscovery$modelwrapper = (ModelWrapper)this.modelWrappers.put((Object)p_405447_, (Object)this.createAndQueueWrapper(p_405447_, p_405251_));
            if (modeldiscovery$modelwrapper != null) {
                LOGGER.warn("Duplicate special model {}", (Object)p_405447_);
            }
        }
    }

    public ResolvedModel missingModel() {
        return this.missingModel;
    }

    public Map<ResourceLocation, ResolvedModel> resolve() {
        ArrayList<ModelWrapper> list = new ArrayList<ModelWrapper>();
        this.discoverDependencies(list);
        ModelDiscovery.propagateValidity(list);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.modelWrappers.forEach((p_404132_, p_404133_) -> {
            if (p_404133_.valid) {
                builder.put(p_404132_, p_404133_);
            } else {
                LOGGER.warn("Model {} ignored due to cyclic dependency", p_404132_);
            }
        });
        return builder.build();
    }

    private void discoverDependencies(List<ModelWrapper> p_405689_) {
        ModelWrapper modeldiscovery$modelwrapper;
        while ((modeldiscovery$modelwrapper = this.parentDiscoveryQueue.poll()) != null) {
            ModelWrapper modeldiscovery$modelwrapper1;
            ResourceLocation resourcelocation = Objects.requireNonNull(modeldiscovery$modelwrapper.wrapped.parent());
            modeldiscovery$modelwrapper.parent = modeldiscovery$modelwrapper1 = this.getOrCreateModel(resourcelocation);
            if (modeldiscovery$modelwrapper1.valid) {
                modeldiscovery$modelwrapper.valid = true;
                continue;
            }
            p_405689_.add(modeldiscovery$modelwrapper);
        }
    }

    private static void propagateValidity(List<ModelWrapper> p_405440_) {
        boolean flag = true;
        while (flag) {
            flag = false;
            Iterator<ModelWrapper> iterator = p_405440_.iterator();
            while (iterator.hasNext()) {
                ModelWrapper modeldiscovery$modelwrapper = iterator.next();
                if (!Objects.requireNonNull(modeldiscovery$modelwrapper.parent).valid) continue;
                modeldiscovery$modelwrapper.valid = true;
                iterator.remove();
                flag = true;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ModelWrapper
    implements ResolvedModel {
        private static final Slot<Boolean> KEY_AMBIENT_OCCLUSION = ModelWrapper.slot(0);
        private static final Slot<UnbakedModel.GuiLight> KEY_GUI_LIGHT = ModelWrapper.slot(1);
        private static final Slot<UnbakedGeometry> KEY_GEOMETRY = ModelWrapper.slot(2);
        private static final Slot<ItemTransforms> KEY_TRANSFORMS = ModelWrapper.slot(3);
        private static final Slot<TextureSlots> KEY_TEXTURE_SLOTS = ModelWrapper.slot(4);
        private static final Slot<TextureAtlasSprite> KEY_PARTICLE_SPRITE = ModelWrapper.slot(5);
        private static final Slot<QuadCollection> KEY_DEFAULT_GEOMETRY = ModelWrapper.slot(6);
        private static final Slot<ContextMap> KEY_ADDITIONAL_PROPERTIES = ModelWrapper.slot(7);
        private static final int SLOT_COUNT = 8;
        private final ResourceLocation id;
        boolean valid;
        @Nullable
        ModelWrapper parent;
        final UnbakedModel wrapped;
        private final AtomicReferenceArray<Object> fixedSlots = new AtomicReferenceArray(8);
        private final Map<ModelState, QuadCollection> modelBakeCache = new ConcurrentHashMap<ModelState, QuadCollection>();

        private static <T> Slot<T> slot(int p_405746_) {
            Objects.checkIndex(p_405746_, 8);
            return new Slot(p_405746_);
        }

        ModelWrapper(ResourceLocation p_405048_, UnbakedModel p_404712_, boolean p_404729_) {
            this.id = p_405048_;
            this.wrapped = p_404712_;
            this.valid = p_404729_;
        }

        @Override
        public UnbakedModel wrapped() {
            return this.wrapped;
        }

        @Override
        @Nullable
        public ResolvedModel parent() {
            return this.parent;
        }

        public String debugName() {
            return this.id.toString();
        }

        @Nullable
        private <T> T getSlot(Slot<T> p_405631_) {
            return (T)this.fixedSlots.get(p_405631_.index);
        }

        private <T> T updateSlot(Slot<T> p_404819_, T p_404859_) {
            Object t = this.fixedSlots.compareAndExchange(p_404819_.index, null, p_404859_);
            return (T)(t == null ? p_404859_ : t);
        }

        private <T> T getSimpleProperty(Slot<T> p_405509_, Function<ResolvedModel, T> p_405257_) {
            T t = this.getSlot(p_405509_);
            return t != null ? t : this.updateSlot(p_405509_, p_405257_.apply(this));
        }

        @Override
        public boolean getTopAmbientOcclusion() {
            return this.getSimpleProperty(KEY_AMBIENT_OCCLUSION, ResolvedModel::findTopAmbientOcclusion);
        }

        @Override
        public UnbakedModel.GuiLight getTopGuiLight() {
            return this.getSimpleProperty(KEY_GUI_LIGHT, ResolvedModel::findTopGuiLight);
        }

        @Override
        public ItemTransforms getTopTransforms() {
            return this.getSimpleProperty(KEY_TRANSFORMS, ResolvedModel::findTopTransforms);
        }

        @Override
        public UnbakedGeometry getTopGeometry() {
            return this.getSimpleProperty(KEY_GEOMETRY, ResolvedModel::findTopGeometry);
        }

        @Override
        public TextureSlots getTopTextureSlots() {
            return this.getSimpleProperty(KEY_TEXTURE_SLOTS, ResolvedModel::findTopTextureSlots);
        }

        @Override
        public TextureAtlasSprite resolveParticleSprite(TextureSlots p_405019_, ModelBaker p_405134_) {
            TextureAtlasSprite textureatlassprite = this.getSlot(KEY_PARTICLE_SPRITE);
            return textureatlassprite != null ? textureatlassprite : this.updateSlot(KEY_PARTICLE_SPRITE, ResolvedModel.resolveParticleSprite(p_405019_, p_405134_, this));
        }

        private QuadCollection bakeDefaultState(TextureSlots p_405546_, ModelBaker p_404641_, ModelState p_405363_) {
            QuadCollection quadcollection = this.getSlot(KEY_DEFAULT_GEOMETRY);
            return quadcollection != null ? quadcollection : this.updateSlot(KEY_DEFAULT_GEOMETRY, this.getTopGeometry().bake(p_405546_, p_404641_, p_405363_, this, this.getTopAdditionalProperties()));
        }

        @Override
        public QuadCollection bakeTopGeometry(TextureSlots p_405587_, ModelBaker p_405166_, ModelState p_405646_) {
            return p_405646_ == BlockModelRotation.X0_Y0 ? this.bakeDefaultState(p_405587_, p_405166_, p_405646_) : this.modelBakeCache.computeIfAbsent(p_405646_, p_405723_ -> {
                UnbakedGeometry unbakedgeometry = this.getTopGeometry();
                return unbakedgeometry.bake(p_405587_, p_405166_, (ModelState)p_405723_, this, this.getTopAdditionalProperties());
            });
        }

        public ContextMap getTopAdditionalProperties() {
            return this.getSimpleProperty(KEY_ADDITIONAL_PROPERTIES, ResolvedModelExtension::findTopAdditionalProperties);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record Slot<T>(int index) {
    }
}

