/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SpecialBlockModelRenderer;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.AtlasIds;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ClientItemInfoLoader;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelDiscovery;
import net.minecraft.client.resources.model.ModelGroupCollector;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.Zone;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.model.UnbakedModelParser;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelLoader;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelManager
implements PreparableReloadListener,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter MODEL_LISTER = FileToIdConverter.json("models");
    private static final Map<ResourceLocation, ResourceLocation> VANILLA_ATLASES = Map.of(Sheets.BANNER_SHEET, AtlasIds.BANNER_PATTERNS, Sheets.BED_SHEET, AtlasIds.BEDS, Sheets.CHEST_SHEET, AtlasIds.CHESTS, Sheets.SHIELD_SHEET, AtlasIds.SHIELD_PATTERNS, Sheets.SIGN_SHEET, AtlasIds.SIGNS, Sheets.SHULKER_SHEET, AtlasIds.SHULKER_BOXES, Sheets.ARMOR_TRIMS_SHEET, AtlasIds.ARMOR_TRIMS, Sheets.DECORATED_POT_SHEET, AtlasIds.DECORATED_POT, TextureAtlas.LOCATION_BLOCKS, AtlasIds.BLOCKS);
    private Map<ResourceLocation, ItemModel> bakedItemStackModels = Map.of();
    private Map<ResourceLocation, ClientItem.Properties> itemProperties = Map.of();
    private final AtlasSet atlases;
    private final BlockModelShaper blockModelShaper;
    private final BlockColors blockColors;
    private EntityModelSet entityModelSet = EntityModelSet.EMPTY;
    private SpecialBlockModelRenderer specialBlockModelRenderer = SpecialBlockModelRenderer.EMPTY;
    private int maxMipmapLevels;
    private ModelBakery.MissingModels missingModels;
    private Object2IntMap<BlockState> modelGroups = Object2IntMaps.emptyMap();
    private final AtomicReference<ModelBakery> modelBakery = new AtomicReference<Object>(null);
    private StandaloneModelLoader.BakedModels bakedStandaloneModels;
    private Set<ResourceLocation> reportedMissingItemModels = new HashSet<ResourceLocation>();

    public ModelManager(TextureManager p_119406_, BlockColors p_119407_, int p_119408_) {
        this.blockColors = p_119407_;
        this.maxMipmapLevels = p_119408_;
        this.blockModelShaper = new BlockModelShaper(this);
        Map VANILLA_ATLASES = ClientHooks.gatherMaterialAtlases(ModelManager.VANILLA_ATLASES);
        this.atlases = new AtlasSet(VANILLA_ATLASES, p_119406_);
    }

    public BlockStateModel getMissingBlockStateModel() {
        return this.missingModels.block();
    }

    public ItemModel getItemModel(ResourceLocation p_387691_) {
        ItemModel model = this.bakedItemStackModels.get(p_387691_);
        if (model == null) {
            if (this.reportedMissingItemModels.add(p_387691_)) {
                LOGGER.warn("Missing item model for location {}", (Object)p_387691_);
            }
            return this.missingModels.item();
        }
        return model;
    }

    public ClientItem.Properties getItemProperties(ResourceLocation p_390438_) {
        return this.itemProperties.getOrDefault(p_390438_, ClientItem.Properties.DEFAULT);
    }

    public BlockModelShaper getBlockModelShaper() {
        return this.blockModelShaper;
    }

    public final CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier p_249079_, ResourceManager p_251134_, Executor p_250550_, Executor p_249221_) {
        CompletableFuture<EntityModelSet> completablefuture = CompletableFuture.supplyAsync(EntityModelSet::vanilla, p_250550_);
        CompletionStage completablefuture1 = completablefuture.thenApplyAsync(SpecialBlockModelRenderer::vanilla, p_250550_);
        CompletableFuture<Map<ResourceLocation, UnbakedModel>> completablefuture2 = ModelManager.loadBlockModels(p_251134_, p_250550_);
        CompletableFuture completablefuture3 = BlockStateModelLoader.loadBlockStates((ResourceManager)p_251134_, (Executor)p_250550_);
        CompletableFuture completablefuture4 = ClientItemInfoLoader.scheduleLoad((ResourceManager)p_251134_, (Executor)p_250550_);
        CompletableFuture standaloneModelsFuture = StandaloneModelLoader.load((Executor)p_250550_);
        CompletionStage completablefuture5 = CompletableFuture.allOf(completablefuture2, completablefuture3, completablefuture4, standaloneModelsFuture).thenApplyAsync(p_404152_ -> ModelManager.discoverModelDependencies((Map)completablefuture2.join(), (BlockStateModelLoader.LoadedModels)completablefuture3.join(), (ClientItemInfoLoader.LoadedClientInfos)completablefuture4.join(), (StandaloneModelLoader.LoadedModels)standaloneModelsFuture.join()), p_250550_);
        CompletionStage completablefuture6 = completablefuture3.thenApplyAsync(p_359309_ -> ModelManager.buildModelGroups(this.blockColors, p_359309_), p_250550_);
        Map map = this.atlases.scheduleLoad(p_251134_, this.maxMipmapLevels, p_250550_);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])Stream.concat(map.values().stream(), Stream.of(completablefuture5, completablefuture6, completablefuture3, completablefuture4, completablefuture, completablefuture1, completablefuture2, standaloneModelsFuture)).toArray(CompletableFuture[]::new)).thenComposeAsync(arg_0 -> this.lambda$reload$4(map, (CompletableFuture)completablefuture5, (CompletableFuture)completablefuture6, completablefuture2, completablefuture, completablefuture3, completablefuture4, standaloneModelsFuture, (CompletableFuture)completablefuture1, p_250550_, arg_0), p_250550_)).thenCompose(p_252255_ -> p_252255_.readyForUpload.thenApply(p_251581_ -> p_252255_))).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)p_249079_).wait(arg_0))).thenAcceptAsync(p_372566_ -> this.apply((ReloadState)p_372566_, Profiler.get()), p_249221_);
    }

    private static CompletableFuture<Map<ResourceLocation, UnbakedModel>> loadBlockModels(ResourceManager p_251361_, Executor p_252189_) {
        return CompletableFuture.supplyAsync(() -> MODEL_LISTER.listMatchingResources(p_251361_), p_252189_).thenCompose(p_250597_ -> {
            ArrayList<CompletableFuture<Pair>> list = new ArrayList<CompletableFuture<Pair>>(p_250597_.size());
            for (Map.Entry entry : p_250597_.entrySet()) {
                list.add(CompletableFuture.supplyAsync(() -> {
                    ResourceLocation resourcelocation = MODEL_LISTER.fileToId((ResourceLocation)entry.getKey());
                    try {
                        Pair pair;
                        try (BufferedReader reader = ((Resource)entry.getValue()).openAsReader();){
                            pair = Pair.of((Object)resourcelocation, (Object)UnbakedModelParser.parse((Reader)reader));
                        }
                        return pair;
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to load model {}", entry.getKey(), (Object)exception);
                        return null;
                    }
                }, p_252189_));
            }
            return Util.sequence(list).thenApply(p_250813_ -> p_250813_.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond)));
        });
    }

    @Deprecated
    private static ResolvedModels discoverModelDependencies(Map<ResourceLocation, UnbakedModel> p_363228_, BlockStateModelLoader.LoadedModels p_361624_, ClientItemInfoLoader.LoadedClientInfos p_390496_) {
        return ModelManager.discoverModelDependencies(p_363228_, p_361624_, p_390496_, StandaloneModelLoader.LoadedModels.EMPTY);
    }

    private static ResolvedModels discoverModelDependencies(Map<ResourceLocation, UnbakedModel> p_363228_, BlockStateModelLoader.LoadedModels p_361624_, ClientItemInfoLoader.LoadedClientInfos p_390496_, StandaloneModelLoader.LoadedModels standaloneModels) {
        ResolvedModels modelmanager$resolvedmodels;
        try (Zone zone = Profiler.get().zone("dependencies");){
            ModelDiscovery modeldiscovery = new ModelDiscovery(p_363228_, MissingBlockModel.missingModel());
            modeldiscovery.addSpecialModel(ItemModelGenerator.GENERATED_ITEM_MODEL_ID, new ItemModelGenerator());
            p_361624_.models().values().forEach(modeldiscovery::addRoot);
            p_390496_.contents().values().forEach(p_390109_ -> modeldiscovery.addRoot((ResolvableModel)p_390109_.model()));
            standaloneModels.models().values().forEach(modeldiscovery::addRoot);
            modelmanager$resolvedmodels = new ResolvedModels(modeldiscovery.missingModel(), modeldiscovery.resolve());
        }
        return modelmanager$resolvedmodels;
    }

    private static CompletableFuture<ReloadState> loadModels(final Map<ResourceLocation, AtlasSet.StitchResult> p_250646_, ModelBakery p_248945_, Object2IntMap<BlockState> p_363498_, EntityModelSet p_388110_, SpecialBlockModelRenderer p_387466_, Executor p_405316_) {
        CompletableFuture<Void> completablefuture = CompletableFuture.allOf((CompletableFuture[])p_250646_.values().stream().map(AtlasSet.StitchResult::readyForUpload).toArray(CompletableFuture[]::new));
        final Multimap multimap = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        final Multimap multimap1 = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        return p_248945_.bakeModels(new SpriteGetter(){
            private final TextureAtlasSprite missingSprite;
            {
                this.missingSprite = ((AtlasSet.StitchResult)p_250646_.get(TextureAtlas.LOCATION_BLOCKS)).missing();
            }

            public TextureAtlasSprite get(Material p_388183_, ModelDebugName p_388862_) {
                AtlasSet.StitchResult atlasset$stitchresult = (AtlasSet.StitchResult)p_250646_.get(p_388183_.atlasLocation());
                TextureAtlasSprite textureatlassprite = atlasset$stitchresult.getSprite(p_388183_.texture());
                if (textureatlassprite != null) {
                    return textureatlassprite;
                }
                multimap.put((Object)p_388862_.debugName(), (Object)p_388183_);
                return atlasset$stitchresult.missing();
            }

            public TextureAtlasSprite reportMissingReference(String p_387702_, ModelDebugName p_387819_) {
                multimap1.put((Object)p_387819_.debugName(), (Object)p_387702_);
                return this.missingSprite;
            }
        }, p_405316_).thenApply(p_404163_ -> {
            multimap.asMap().forEach((p_387727_, p_252017_) -> LOGGER.warn("Missing textures in model {}:\n{}", p_387727_, (Object)p_252017_.stream().sorted(Material.COMPARATOR).map(p_339314_ -> "    " + String.valueOf(p_339314_.atlasLocation()) + ":" + String.valueOf(p_339314_.texture())).collect(Collectors.joining("\n"))));
            multimap1.asMap().forEach((p_386266_, p_386267_) -> LOGGER.warn("Missing texture references in model {}:\n{}", p_386266_, (Object)p_386267_.stream().sorted().map(p_386265_ -> "    " + p_386265_).collect(Collectors.joining("\n"))));
            try (Zone ignored = Profiler.get().zone("neoforge_modify_baking_result");){
                ClientHooks.onModifyBakingResult((ModelBakery.BakingResult)p_404163_, (Map)p_250646_, (ModelBakery)p_248945_);
            }
            Map<BlockState, BlockStateModel> map = ModelManager.createBlockStateToModelDispatch(p_404163_.blockStateModels(), p_404163_.missingModels().block());
            return new ReloadState((ModelBakery.BakingResult)p_404163_, p_363498_, map, p_250646_, p_388110_, p_387466_, completablefuture);
        });
    }

    private static Map<BlockState, BlockStateModel> createBlockStateToModelDispatch(Map<BlockState, BlockStateModel> p_386989_, BlockStateModel p_405855_) {
        IdentityHashMap<BlockState, BlockStateModel> object;
        try (Zone zone = Profiler.get().zone("block state dispatch");){
            IdentityHashMap<BlockState, BlockStateModel> map = new IdentityHashMap<BlockState, BlockStateModel>(p_386989_);
            for (Block block : BuiltInRegistries.BLOCK) {
                block.getStateDefinition().getPossibleStates().forEach(p_404155_ -> {
                    if (p_386989_.putIfAbsent((BlockState)((Object)p_404155_), p_405855_) == null) {
                        LOGGER.warn("Missing model for variant: '{}'", (Object)p_404155_);
                    }
                });
            }
            object = map;
        }
        return object;
    }

    private static Object2IntMap<BlockState> buildModelGroups(BlockColors p_362057_, BlockStateModelLoader.LoadedModels p_362559_) {
        Object2IntMap object2intmap;
        try (Zone zone = Profiler.get().zone("block groups");){
            object2intmap = ModelGroupCollector.build((BlockColors)p_362057_, (BlockStateModelLoader.LoadedModels)p_362559_);
        }
        return object2intmap;
    }

    private void apply(ReloadState p_248996_, ProfilerFiller p_251960_) {
        p_251960_.push("upload");
        p_248996_.atlasPreparations.values().forEach(AtlasSet.StitchResult::upload);
        ModelBakery.BakingResult modelbakery$bakingresult = p_248996_.bakedModels;
        this.bakedItemStackModels = modelbakery$bakingresult.itemStackModels();
        this.itemProperties = modelbakery$bakingresult.itemProperties();
        this.modelGroups = p_248996_.modelGroups;
        this.missingModels = modelbakery$bakingresult.missingModels();
        this.bakedStandaloneModels = modelbakery$bakingresult.standaloneModels();
        ClientHooks.onModelBake((ModelManager)this, (ModelBakery.BakingResult)modelbakery$bakingresult, (ModelBakery)this.modelBakery.get());
        this.reportedMissingItemModels = new HashSet<ResourceLocation>();
        for (Item item : BuiltInRegistries.ITEM) {
            ResourceLocation modelId = (ResourceLocation)item.components().get(DataComponents.ITEM_MODEL);
            if (modelId == null || this.bakedItemStackModels.containsKey(modelId)) continue;
            this.reportedMissingItemModels.add(modelId);
            LOGGER.warn("No model loaded for default item model ID {} of {}", (Object)modelId, (Object)item);
        }
        p_251960_.popPush("cache");
        this.blockModelShaper.replaceCache(p_248996_.modelCache);
        this.specialBlockModelRenderer = p_248996_.specialBlockModelRenderer;
        this.entityModelSet = p_248996_.entityModelSet;
        p_251960_.pop();
    }

    public boolean requiresRender(BlockState p_119416_, BlockState p_119417_) {
        int j;
        if (p_119416_ == p_119417_) {
            return false;
        }
        int i = this.modelGroups.getInt((Object)p_119416_);
        if (i != -1 && i == (j = this.modelGroups.getInt((Object)p_119417_))) {
            FluidState fluidstate1;
            FluidState fluidstate = p_119416_.getFluidState();
            return fluidstate != (fluidstate1 = p_119417_.getFluidState());
        }
        return true;
    }

    public TextureAtlas getAtlas(ResourceLocation p_119429_) {
        if (this.atlases == null) {
            throw new RuntimeException("getAtlasTexture called too early!");
        }
        return this.atlases.getAtlas(p_119429_);
    }

    @Override
    public void close() {
        this.atlases.close();
    }

    public void updateMaxMipLevel(int p_119411_) {
        this.maxMipmapLevels = p_119411_;
    }

    public Supplier<SpecialBlockModelRenderer> specialBlockModelRenderer() {
        return () -> this.specialBlockModelRenderer;
    }

    public Supplier<EntityModelSet> entityModels() {
        return () -> this.entityModelSet;
    }

    public ModelBakery getModelBakery() {
        return this.modelBakery.get();
    }

    @Nullable
    public <T> T getStandaloneModel(StandaloneModelKey<T> modelKey) {
        return (T)this.bakedStandaloneModels.get(modelKey);
    }

    private /* synthetic */ CompletionStage lambda$reload$4(Map map, CompletableFuture completablefuture5, CompletableFuture completablefuture6, CompletableFuture completablefuture2, CompletableFuture completablefuture, CompletableFuture completablefuture3, CompletableFuture completablefuture4, CompletableFuture standaloneModelsFuture, CompletableFuture completablefuture1, Executor p_250550_, Void p_404148_) {
        Map<ResourceLocation, AtlasSet.StitchResult> map1 = Util.mapValues(map, CompletableFuture::join);
        ResolvedModels modelmanager$resolvedmodels = (ResolvedModels)completablefuture5.join();
        Object2IntMap object2intmap = (Object2IntMap)completablefuture6.join();
        Sets.SetView set = Sets.difference(((Map)completablefuture2.join()).keySet(), modelmanager$resolvedmodels.models.keySet());
        if (!set.isEmpty()) {
            LOGGER.debug("Unreferenced models: \n{}", (Object)set.stream().sorted().map(p_386272_ -> "\t" + String.valueOf(p_386272_) + "\n").collect(Collectors.joining()));
        }
        ModelBakery modelbakery = new ModelBakery((EntityModelSet)completablefuture.join(), ((BlockStateModelLoader.LoadedModels)completablefuture3.join()).models(), ((ClientItemInfoLoader.LoadedClientInfos)completablefuture4.join()).contents(), modelmanager$resolvedmodels.models(), modelmanager$resolvedmodels.missing(), (StandaloneModelLoader.LoadedModels)standaloneModelsFuture.join());
        this.modelBakery.set(modelbakery);
        return ModelManager.loadModels(map1, modelbakery, (Object2IntMap<BlockState>)object2intmap, (EntityModelSet)completablefuture.join(), (SpecialBlockModelRenderer)completablefuture1.join(), p_250550_);
    }

    @OnlyIn(value=Dist.CLIENT)
    record ResolvedModels(ResolvedModel missing, Map<ResourceLocation, ResolvedModel> models) {
    }

    @OnlyIn(value=Dist.CLIENT)
    record ReloadState(ModelBakery.BakingResult bakedModels, Object2IntMap<BlockState> modelGroups, Map<BlockState, BlockStateModel> modelCache, Map<ResourceLocation, AtlasSet.StitchResult> atlasPreparations, EntityModelSet entityModelSet, SpecialBlockModelRenderer specialBlockModelRenderer, CompletableFuture<Void> readyForUpload) {
    }
}

