/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.QuadCollectionBuilderExtension;

@OnlyIn(value=Dist.CLIENT)
public class QuadCollection {
    public static final QuadCollection EMPTY = new QuadCollection(List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of());
    private final List<BakedQuad> all;
    private final List<BakedQuad> unculled;
    private final List<BakedQuad> north;
    private final List<BakedQuad> south;
    private final List<BakedQuad> east;
    private final List<BakedQuad> west;
    private final List<BakedQuad> up;
    private final List<BakedQuad> down;

    QuadCollection(List<BakedQuad> p_405148_, List<BakedQuad> p_404733_, List<BakedQuad> p_405535_, List<BakedQuad> p_404824_, List<BakedQuad> p_405136_, List<BakedQuad> p_404979_, List<BakedQuad> p_404989_, List<BakedQuad> p_405866_) {
        this.all = p_405148_;
        this.unculled = p_404733_;
        this.north = p_405535_;
        this.south = p_404824_;
        this.east = p_405136_;
        this.west = p_404979_;
        this.up = p_404989_;
        this.down = p_405866_;
    }

    public List<BakedQuad> getQuads(@Nullable Direction p_405514_) {
        Direction direction = p_405514_;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NORTH", "SOUTH", "EAST", "WEST", "UP", "DOWN"}, (Direction)direction, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> this.unculled;
            case 0 -> this.north;
            case 1 -> this.south;
            case 2 -> this.east;
            case 3 -> this.west;
            case 4 -> this.up;
            case 5 -> this.down;
        };
    }

    public List<BakedQuad> getAll() {
        return this.all;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder
    implements QuadCollectionBuilderExtension {
        private final ImmutableList.Builder<BakedQuad> unculledFaces = ImmutableList.builder();
        private final Multimap<Direction, BakedQuad> culledFaces = ArrayListMultimap.create();

        public Builder addCulledFace(Direction p_405416_, BakedQuad p_405678_) {
            this.culledFaces.put((Object)p_405416_, (Object)p_405678_);
            return this;
        }

        public Builder addUnculledFace(BakedQuad p_405329_) {
            this.unculledFaces.add((Object)p_405329_);
            return this;
        }

        private static QuadCollection createFromSublists(List<BakedQuad> p_405742_, int p_405661_, int p_405665_, int p_405121_, int p_405725_, int p_404700_, int p_405215_, int p_404662_) {
            int i = 0;
            int j = i + p_405661_;
            List<BakedQuad> list = p_405742_.subList(i, j);
            i = j + p_405665_;
            List<BakedQuad> list1 = p_405742_.subList(j, i);
            int k = i + p_405121_;
            List<BakedQuad> list2 = p_405742_.subList(i, k);
            i = k + p_405725_;
            List<BakedQuad> list3 = p_405742_.subList(k, i);
            int l = i + p_404700_;
            List<BakedQuad> list4 = p_405742_.subList(i, l);
            i = l + p_405215_;
            List<BakedQuad> list5 = p_405742_.subList(l, i);
            List<BakedQuad> list6 = p_405742_.subList(i, i + p_404662_);
            return new QuadCollection(p_405742_, list, list1, list2, list3, list4, list5, list6);
        }

        public QuadCollection build() {
            ImmutableList immutablelist = this.unculledFaces.build();
            if (this.culledFaces.isEmpty()) {
                return immutablelist.isEmpty() ? EMPTY : new QuadCollection((List<BakedQuad>)immutablelist, (List<BakedQuad>)immutablelist, List.of(), List.of(), List.of(), List.of(), List.of(), List.of());
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)immutablelist);
            Collection collection = this.culledFaces.get((Object)Direction.NORTH);
            builder.addAll((Iterable)collection);
            Collection collection1 = this.culledFaces.get((Object)Direction.SOUTH);
            builder.addAll((Iterable)collection1);
            Collection collection2 = this.culledFaces.get((Object)Direction.EAST);
            builder.addAll((Iterable)collection2);
            Collection collection3 = this.culledFaces.get((Object)Direction.WEST);
            builder.addAll((Iterable)collection3);
            Collection collection4 = this.culledFaces.get((Object)Direction.UP);
            builder.addAll((Iterable)collection4);
            Collection collection5 = this.culledFaces.get((Object)Direction.DOWN);
            builder.addAll((Iterable)collection5);
            return Builder.createFromSublists((List<BakedQuad>)builder.build(), immutablelist.size(), collection.size(), collection1.size(), collection2.size(), collection3.size(), collection4.size(), collection5.size());
        }
    }
}

