/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.ResolvedModelExtension;

@OnlyIn(value=Dist.CLIENT)
public interface ResolvedModel
extends ModelDebugName,
ResolvedModelExtension {
    public static final boolean DEFAULT_AMBIENT_OCCLUSION = true;
    public static final UnbakedModel.GuiLight DEFAULT_GUI_LIGHT = UnbakedModel.GuiLight.SIDE;

    public UnbakedModel wrapped();

    @Nullable
    public ResolvedModel parent();

    public static TextureSlots findTopTextureSlots(ResolvedModel p_405472_) {
        TextureSlots.Resolver textureslots$resolver = new TextureSlots.Resolver();
        for (ResolvedModel resolvedmodel = p_405472_; resolvedmodel != null; resolvedmodel = resolvedmodel.parent()) {
            textureslots$resolver.addLast(resolvedmodel.wrapped().textureSlots());
        }
        return textureslots$resolver.resolve((ModelDebugName)p_405472_);
    }

    default public TextureSlots getTopTextureSlots() {
        return ResolvedModel.findTopTextureSlots(this);
    }

    public static boolean findTopAmbientOcclusion(ResolvedModel p_404692_) {
        while (p_404692_ != null) {
            Boolean obool = p_404692_.wrapped().ambientOcclusion();
            if (obool != null) {
                return obool;
            }
            p_404692_ = p_404692_.parent();
        }
        return true;
    }

    default public boolean getTopAmbientOcclusion() {
        return ResolvedModel.findTopAmbientOcclusion(this);
    }

    public static UnbakedModel.GuiLight findTopGuiLight(ResolvedModel p_405791_) {
        while (p_405791_ != null) {
            UnbakedModel.GuiLight unbakedmodel$guilight = p_405791_.wrapped().guiLight();
            if (unbakedmodel$guilight != null) {
                return unbakedmodel$guilight;
            }
            p_405791_ = p_405791_.parent();
        }
        return DEFAULT_GUI_LIGHT;
    }

    default public UnbakedModel.GuiLight getTopGuiLight() {
        return ResolvedModel.findTopGuiLight(this);
    }

    public static UnbakedGeometry findTopGeometry(ResolvedModel p_405270_) {
        while (p_405270_ != null) {
            UnbakedGeometry unbakedgeometry = p_405270_.wrapped().geometry();
            if (unbakedgeometry != null) {
                return unbakedgeometry;
            }
            p_405270_ = p_405270_.parent();
        }
        return UnbakedGeometry.EMPTY;
    }

    default public UnbakedGeometry getTopGeometry() {
        return ResolvedModel.findTopGeometry(this);
    }

    default public QuadCollection bakeTopGeometry(TextureSlots p_405784_, ModelBaker p_405450_, ModelState p_405844_) {
        return this.getTopGeometry().bake(p_405784_, p_405450_, p_405844_, this, this.getTopAdditionalProperties());
    }

    public static TextureAtlasSprite resolveParticleSprite(TextureSlots p_404698_, ModelBaker p_405533_, ModelDebugName p_405824_) {
        return p_405533_.sprites().resolveSlot(p_404698_, "particle", p_405824_);
    }

    default public TextureAtlasSprite resolveParticleSprite(TextureSlots p_405126_, ModelBaker p_404926_) {
        return ResolvedModel.resolveParticleSprite(p_405126_, p_404926_, this);
    }

    public static ItemTransform findTopTransform(ResolvedModel p_404657_, ItemDisplayContext p_405330_) {
        while (p_404657_ != null) {
            ItemTransform itemtransform;
            ItemTransforms itemtransforms = p_404657_.wrapped().transforms();
            if (itemtransforms != null && (itemtransform = itemtransforms.getTransform(p_405330_)) != ItemTransform.NO_TRANSFORM) {
                return itemtransform;
            }
            p_404657_ = p_404657_.parent();
        }
        return ItemTransform.NO_TRANSFORM;
    }

    public static ItemTransforms findTopTransforms(ResolvedModel p_404681_) {
        ItemTransform itemtransform = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.THIRD_PERSON_LEFT_HAND);
        ItemTransform itemtransform1 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND);
        ItemTransform itemtransform2 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.FIRST_PERSON_LEFT_HAND);
        ItemTransform itemtransform3 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND);
        ItemTransform itemtransform4 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.HEAD);
        ItemTransform itemtransform5 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.GUI);
        ItemTransform itemtransform6 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.GROUND);
        ItemTransform itemtransform7 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.FIXED);
        ImmutableMap.Builder moddedTransforms = ImmutableMap.builder();
        for (ItemDisplayContext context : ItemDisplayContext.values()) {
            ItemTransform transform;
            if (!context.isModded() || (transform = ResolvedModel.findTopTransform(p_404681_, context)) == ItemTransform.NO_TRANSFORM) continue;
            moddedTransforms.put((Object)context, (Object)transform);
        }
        return new ItemTransforms(itemtransform, itemtransform1, itemtransform2, itemtransform3, itemtransform4, itemtransform5, itemtransform6, itemtransform7, (ImmutableMap<ItemDisplayContext, ItemTransform>)moddedTransforms.build());
    }

    default public ItemTransforms getTopTransforms() {
        return ResolvedModel.findTopTransforms(this);
    }
}

