/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sounds;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicInfo;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;

@OnlyIn(value=Dist.CLIENT)
public class MusicManager {
    private static final int STARTING_DELAY = 100;
    private final RandomSource random = RandomSource.create();
    private final Minecraft minecraft;
    @Nullable
    private SoundInstance currentMusic;
    private float currentGain = 1.0f;
    private int nextSongDelay = 100;

    public MusicManager(Minecraft p_120182_) {
        this.minecraft = p_120182_;
    }

    public void tick() {
        boolean flag;
        MusicInfo musicinfo = ClientHooks.selectMusic((MusicInfo)this.minecraft.getSituationalMusic(), (SoundInstance)this.currentMusic);
        if (musicinfo == null) {
            if (this.currentMusic != null) {
                this.stopPlaying();
            }
            this.nextSongDelay = 0;
            return;
        }
        float f = musicinfo.volume();
        if (this.currentMusic != null && this.currentGain != f && !(flag = this.fadePlaying(f))) {
            return;
        }
        Music music = musicinfo.music();
        if (music == null) {
            this.nextSongDelay = Math.max(this.nextSongDelay, 100);
        } else {
            if (this.currentMusic != null) {
                if (musicinfo.canReplace(this.currentMusic)) {
                    this.minecraft.getSoundManager().stop(this.currentMusic);
                    this.nextSongDelay = Mth.nextInt((RandomSource)this.random, (int)0, (int)(music.getMinDelay() / 2));
                }
                if (!this.minecraft.getSoundManager().isActive(this.currentMusic)) {
                    this.currentMusic = null;
                    this.nextSongDelay = Math.min(this.nextSongDelay, Mth.nextInt((RandomSource)this.random, (int)music.getMinDelay(), (int)music.getMaxDelay()));
                }
            }
            this.nextSongDelay = Math.min(this.nextSongDelay, music.getMaxDelay());
            if (this.currentMusic == null && this.nextSongDelay-- <= 0) {
                this.startPlaying(musicinfo);
            }
        }
    }

    public void startPlaying(MusicInfo p_383115_) {
        this.currentMusic = SimpleSoundInstance.forMusic((SoundEvent)((SoundEvent)p_383115_.music().getEvent().value()));
        if (this.currentMusic.getSound() != SoundManager.EMPTY_SOUND) {
            this.minecraft.getSoundManager().play(this.currentMusic);
            this.minecraft.getSoundManager().setVolume(this.currentMusic, p_383115_.volume());
        }
        this.nextSongDelay = Integer.MAX_VALUE;
        this.currentGain = p_383115_.volume();
    }

    public void stopPlaying(Music p_278295_) {
        if (this.isPlayingMusic(p_278295_)) {
            this.stopPlaying();
        }
    }

    public void stopPlaying() {
        if (this.currentMusic != null) {
            this.minecraft.getSoundManager().stop(this.currentMusic);
            this.currentMusic = null;
        }
        this.nextSongDelay += 100;
    }

    private boolean fadePlaying(float p_383118_) {
        if (this.currentMusic == null) {
            return false;
        }
        if (this.currentGain == p_383118_) {
            return true;
        }
        if (this.currentGain < p_383118_) {
            this.currentGain += Mth.clamp((float)this.currentGain, (float)5.0E-4f, (float)0.005f);
            if (this.currentGain > p_383118_) {
                this.currentGain = p_383118_;
            }
        } else {
            this.currentGain = 0.03f * p_383118_ + 0.97f * this.currentGain;
            if (Math.abs(this.currentGain - p_383118_) < 1.0E-4f || this.currentGain < p_383118_) {
                this.currentGain = p_383118_;
            }
        }
        this.currentGain = Mth.clamp((float)this.currentGain, (float)0.0f, (float)1.0f);
        if (this.currentGain <= 1.0E-4f) {
            this.stopPlaying();
            return false;
        }
        this.minecraft.getSoundManager().setVolume(this.currentMusic, this.currentGain);
        return true;
    }

    public boolean isPlayingMusic(Music p_120188_) {
        return this.currentMusic == null ? false : ((SoundEvent)p_120188_.getEvent().value()).location().equals(this.currentMusic.getLocation());
    }
}

